/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.util;

import com.kingdee.bos.qing.dfs.common.util.EnvUtil;
import com.kingdee.bos.qing.dfs.common.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ZKClientUtil {
    private static CuratorFramework client;
    private static volatile String ZKRootPath;

    private static RetryPolicy createRetryPolicy() {
        ExponentialBackoffRetry retryPolicy = null;
        String retryPolicyType = SystemPropertyUtil.getString("qing.zk.retryPolicy", "RetryForever");
        if ("ExponentialBackoffRetry".equals(retryPolicyType)) {
            int baseSleepTimeMs = SystemPropertyUtil.getInt("qing.zk.exponentialBackoffRetry.baseSleepTimeMs", 1000);
            int maxRetries = SystemPropertyUtil.getInt("qing.zk.exponentialBackoffRetry.maxRetries", 1000);
            retryPolicy = new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries);
        } else if ("BoundedExponentialBackoffRetry".equals(retryPolicyType)) {
            int baseSleepTimeMs = SystemPropertyUtil.getInt("qing.zk.boundedExponentialBackoffRetry.baseSleepTimeMs", 1000);
            int maxSleepTimeMs = SystemPropertyUtil.getInt("qing.zk.boundedExponentialBackoffRetry.maxRetries", 1000);
            int maxRetries = SystemPropertyUtil.getInt("qing.zk.boundedExponentialBackoffRetry.maxRetries", 1000);
            retryPolicy = new BoundedExponentialBackoffRetry(baseSleepTimeMs, maxSleepTimeMs, maxRetries);
        } else if ("RetryNTimes".equals(retryPolicyType)) {
            int n = SystemPropertyUtil.getInt("qing.zk.retryNTimes.n", 3);
            int sleepMsBetweenRetries = SystemPropertyUtil.getInt("qing.zk.retryNTimes.sleepMsBetweenRetries", 1000);
            retryPolicy = new RetryNTimes(n, sleepMsBetweenRetries);
        } else if ("RetryOneTime".equals(retryPolicyType)) {
            int sleepMsBetweenRetry = SystemPropertyUtil.getInt("qing.zk.retryOneTime.sleepMsBetweenRetry", 1000);
            retryPolicy = new RetryOneTime(sleepMsBetweenRetry);
        } else if ("RetryUntilElapsed".equals(retryPolicyType)) {
            int maxElapsedTimeMs = SystemPropertyUtil.getInt("qing.zk.retryUntilElapsed.maxElapsedTimeMs", 1000);
            int sleepMsBetweenRetries = SystemPropertyUtil.getInt("qing.zk.retryUntilElapsed.sleepMsBetweenRetries", 1000);
            retryPolicy = new RetryUntilElapsed(maxElapsedTimeMs, sleepMsBetweenRetries);
        } else {
            int retryIntervalMs = SystemPropertyUtil.getInt("qing.zk.retryForever.retryIntervalMs", 1000);
            retryPolicy = new RetryForever(retryIntervalMs);
        }
        return retryPolicy;
    }

    public static synchronized CuratorFramework getClient() {
        if (client == null) {
            String scheme;
            String pass;
            String connectString = System.getenv("QING_ZK_URL");
            if (connectString == null) {
                connectString = SystemPropertyUtil.getString("qing.zk.server.url");
            }
            CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
            int sessionTimeoutMs = SystemPropertyUtil.getInt("qing.zk.session.timeout", 5000);
            int connectionTimeoutMs = SystemPropertyUtil.getInt("qing.zk.connection.timeout", 5000);
            builder.connectString(connectString).sessionTimeoutMs(sessionTimeoutMs).connectionTimeoutMs(connectionTimeoutMs).retryPolicy(ZKClientUtil.createRetryPolicy());
            String user = System.getenv("QING_ZK_USER");
            if (user == null) {
                user = SystemPropertyUtil.getString("qing.zk.user");
            }
            if ((pass = System.getenv("QING_ZK_PASSWORD")) == null) {
                pass = SystemPropertyUtil.getString("qing.zk.password");
            }
            if ((scheme = System.getenv("QING_ZK_SCHEME")) == null) {
                scheme = SystemPropertyUtil.getString("qing.zk.scheme");
            }
            if (user != null && pass != null) {
                final String auth = user + ":" + pass;
                ACLProvider aclProvider = new ACLProvider(){
                    private List<ACL> acl;

                    public List<ACL> getDefaultAcl() {
                        if (this.acl == null) {
                            ArrayList acl = ZooDefs.Ids.CREATOR_ALL_ACL;
                            acl.clear();
                            acl.add(new ACL(31, new Id("auth", auth)));
                            this.acl = acl;
                        }
                        return this.acl;
                    }

                    public List<ACL> getAclForPath(String path) {
                        return this.acl;
                    }
                };
                String aclScheme = scheme == null ? "digest" : scheme;
                builder.authorization(aclScheme, auth.getBytes());
                builder.aclProvider(aclProvider);
            }
            client = builder.build();
            client.start();
        }
        return client;
    }

    public static void destory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getZKRootPath() {
        if (ZKRootPath != null) return ZKRootPath;
        Class<ZKClientUtil> clazz = ZKClientUtil.class;
        synchronized (ZKClientUtil.class) {
            if (ZKRootPath != null) return ZKRootPath;
            String tempPath = "";
            String outerZKPath = System.getenv("QING_ZK_ROOTPATH");
            if (outerZKPath == null) {
                outerZKPath = SystemPropertyUtil.getString("qing.zk.rootpath");
            }
            if (outerZKPath != null && !"".endsWith(outerZKPath)) {
                if (outerZKPath.endsWith("/")) {
                    outerZKPath = outerZKPath.substring(0, outerZKPath.length() - 1);
                }
                tempPath = tempPath + outerZKPath;
            }
            ZKRootPath = tempPath;
            // ** MonitorExit[var0] (shouldn't be in output)
            return ZKRootPath;
        }
    }

    static {
        EnvUtil.init();
    }
}

