/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.writingrecord.dao.impl;

import com.kingdee.bos.qing.dfs.common.db.IDBExcuter;
import com.kingdee.bos.qing.dfs.common.db.ResultHandler;
import com.kingdee.bos.qing.dfs.common.writingrecord.IWritingRecordHandler;
import com.kingdee.bos.qing.dfs.common.writingrecord.dao.WritingRecordDao;
import com.kingdee.bos.qing.dfs.common.writingrecord.model.WritingRecord;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WritingRecordImpl
implements WritingRecordDao {
    private IDBExcuter _dbExcuter;

    public WritingRecordImpl(IDBExcuter dbexcuter) {
        this._dbExcuter = dbexcuter;
    }

    @Override
    public WritingRecord getByFileName(final String fileName) throws SQLException {
        return this._dbExcuter.query("SELECT FFILETYPEINDEX, FGROUPNAME, FBUCKETNAME, FRELATIVEFILEPATH, FLEVEL, FCREATETIME FROM t_qing_dfs_writing_record WHERE FFILENAME=?", new Object[]{fileName}, new ResultHandler<WritingRecord>(){

            @Override
            public WritingRecord handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    WritingRecord record = new WritingRecord();
                    record.setFileName(fileName);
                    record.setFileTypeIndex(rs.getInt("FFILETYPEINDEX"));
                    record.setGroupName(rs.getString("FGROUPNAME"));
                    record.setBucketName(rs.getString("FBUCKETNAME"));
                    record.setRelativeFilePath(rs.getString("FRELATIVEFILEPATH"));
                    record.setLevel(Integer.parseInt(rs.getString("FLEVEL")));
                    return record;
                }
                return null;
            }
        });
    }

    @Override
    public void save(WritingRecord writingRecord) throws SQLException {
        String sql = "INSERT INTO t_qing_dfs_writing_record(FFILENAME,FFILETYPEINDEX, FRELATIVEFILEPATH, FGROUPNAME, FBUCKETNAME, FCREATETIME, FLEVEL) VALUES(?,?,?,?,?,?,?)";
        this._dbExcuter.execute(sql, new Object[]{writingRecord.getFileName(), writingRecord.getFileTypeIndex(), writingRecord.getRelativeFilePath(), writingRecord.getGroupName(), writingRecord.getBucketName(), writingRecord.getCreateTime(), writingRecord.getLevel()});
    }

    @Override
    public void deleteByFileName(String fileName) throws SQLException {
        String sql = "DELETE FROM t_qing_dfs_writing_record WHERE FFILENAME=?";
        this._dbExcuter.execute(sql, new Object[]{fileName});
    }

    @Override
    public void findAndHandleWrittingRecordByGroup(final Integer level, final String groupName, final IWritingRecordHandler handler) throws SQLException {
        this._dbExcuter.query("SELECT FFILENAME, FFILETYPEINDEX, FBUCKETNAME, FRELATIVEFILEPATH  FROM t_qing_dfs_writing_record  WHERE FLEVEL=? AND FGROUPNAME=?  AND DATE_SUB(CURDATE(), INTERVAL 1 DAY) >= date(FCREATETIME)", new Object[]{level + "", groupName}, new ResultHandler<Object>(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    WritingRecord record = new WritingRecord();
                    record.setFileName(rs.getString("FFILENAME"));
                    record.setGroupName(groupName);
                    record.setBucketName(rs.getString("FBUCKETNAME"));
                    record.setFileTypeIndex(rs.getInt("FFILETYPEINDEX"));
                    record.setRelativeFilePath(rs.getString("FRELATIVEFILEPATH"));
                    record.setLevel(level);
                    handler.handle(record);
                }
                return null;
            }
        });
    }
}

