/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.writingrecord.domain;

import com.kingdee.bos.qing.dfs.common.db.impl.DBExcuterImpl;
import com.kingdee.bos.qing.dfs.common.db.impl.TXManageImpl;
import com.kingdee.bos.qing.dfs.common.model.BucketGroupInfo;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.dfs.common.writingrecord.IStorageService;
import com.kingdee.bos.qing.dfs.common.writingrecord.IWritingRecordHandler;
import com.kingdee.bos.qing.dfs.common.writingrecord.dao.WritingRecordDao;
import com.kingdee.bos.qing.dfs.common.writingrecord.dao.impl.WritingRecordImpl;
import com.kingdee.bos.qing.dfs.common.writingrecord.model.FileTypeUtil;
import com.kingdee.bos.qing.dfs.common.writingrecord.model.WritingRecord;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;

public class WritingRecordService {
    private DBExcuterImpl excuter;
    private TXManageImpl tx = new TXManageImpl();
    private WritingRecordDao dao;

    public WritingRecordService() {
        this.excuter = new DBExcuterImpl(this.tx);
        this.dao = new WritingRecordImpl(this.excuter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(WritingRecord writingRecord) {
        writingRecord.setCreateTime(new Date());
        try {
            this.tx.beginRequired();
            this.dao.save(writingRecord);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            LogUtil.error("\u589e\u52a0\u5199\u8bb0\u5f55\u5931\u8d25", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.tx.end();
        }
    }

    public void delete(WritingRecord writingRecord) throws SQLException {
        try {
            this.tx.beginRequired();
            this.dao.deleteByFileName(writingRecord.getFileName());
        }
        catch (SQLException e) {
            this.tx.markRollback();
            LogUtil.error("\u5220\u9664\u5199\u8bb0\u5f55\u5931\u8d25", e);
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void deleteWritingRecordAndDeletedDFSImageBlock(IStorageService storageService, WritingRecord writingRecord) throws Exception {
        try {
            this.tx.beginRequired();
            this.dao.deleteByFileName(writingRecord.getFileName());
            String relativePath = FileTypeUtil.getSubFolderByTypeIndex(writingRecord.getFileTypeIndex()) + writingRecord.getRelativeFilePath();
            storageService.decrementDFSImageBlock(writingRecord.getBucketName(), relativePath);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            LogUtil.error("\u5220\u9664\u5199\u8bb0\u5f55\u5931\u8d25", e);
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            LogUtil.error("\u5220\u9664\u5199\u8bb0\u5f55\u5931\u8d25", e);
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void findAndHandleWritingRecordByGroup(Integer level, String groupName, IWritingRecordHandler handler) {
        try {
            this.dao.findAndHandleWrittingRecordByGroup(level, groupName, handler);
        }
        catch (SQLException e) {
            LogUtil.error("\u83b7\u53d6\u5199\u8bb0\u5f55\u5931\u8d25", e);
        }
    }

    public WritingRecord getByFileName(String fileName) throws SQLException {
        return this.dao.getByFileName(fileName);
    }

    public void clearFile(IStorageService storageService, BucketGroupInfo currentBucketGroupInfo, String fileName) throws SQLException {
        WritingRecord writingRecord = this.dao.getByFileName(fileName);
        if (writingRecord == null) {
            return;
        }
        try {
            this.tx.beginRequired();
            this.dao.deleteByFileName(fileName);
            storageService.decrementDFSImageBlock(writingRecord.getBucketName(), FileTypeUtil.getSubFolderByTypeIndex(writingRecord.getFileTypeIndex()) + writingRecord.getRelativeFilePath());
            String serverFilePath = currentBucketGroupInfo.getServerFilePath();
            String absFilePath = serverFilePath + File.separator + writingRecord.getBucketName() + File.separator + FileTypeUtil.getSubFolderByTypeIndex(writingRecord.getFileTypeIndex()) + writingRecord.getRelativeFilePath() + File.separator + writingRecord.getFileName();
            File file = new File(absFilePath);
            boolean delete = file.delete();
            if (delete) {
                LogUtil.info("deleteJunkFiles success: " + absFilePath);
            } else {
                LogUtil.info("deleteJunkFiles failed: " + absFilePath);
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
            LogUtil.error("\u5220\u9664\u5199\u8bb0\u5f55\u5931\u8d25", e);
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            LogUtil.error("\u5220\u9664\u5199\u8bb0\u5f55\u5931\u8d25", e);
            throw new SQLException(e);
        }
        finally {
            this.tx.end();
        }
    }
}

