/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.xml.impl;

import com.kingdee.bos.qing.dfs.common.xml.IXmlElement;
import com.kingdee.bos.qing.dfs.common.xml.impl.Checker;
import com.kingdee.bos.qing.dfs.common.xml.impl.XmlElement;
import com.kingdee.bos.qing.dfs.common.xml.impl.XmlReadingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Deque;
import java.util.LinkedList;

public class XmlDomReader {
    private CharReader _reader;
    private State _state;
    private int[] _charPosstionRelatedToState = new int[2];
    private StringBuilder _stringCollector;
    private Deque<IXmlElement> _stack;
    private IXmlElement _root;
    private String _attrKey;
    private char _attrValueQuatation;

    public IXmlElement read(InputStream stm) throws IOException, XmlReadingException {
        this._stack = new LinkedList<IXmlElement>();
        this._root = null;
        this._attrKey = null;
        this._attrValueQuatation = '\u0000';
        this._stringCollector = new StringBuilder();
        this._reader = new CharReader(stm);
        this.markStateAs(State.PreElement);
        block11: while (!this._reader.isEOF()) {
            switch (this._state) {
                case PreElement: {
                    this.whenPreElement();
                    continue block11;
                }
                case ElementTag: {
                    this.whenElementTag();
                    continue block11;
                }
                case CDATA: {
                    this.whenCDATA();
                    continue block11;
                }
                case TagName: {
                    this.whenTagName();
                    continue block11;
                }
                case PosteriorName: {
                    this.whenPosteriorName();
                    continue block11;
                }
                case PreAttrKey: {
                    this.whenPreAttrKey();
                    continue block11;
                }
                case AttributeKey: {
                    this.whenAttributeKey();
                    continue block11;
                }
                case PreAttrValue: {
                    this.whenPreAttrValue();
                    continue block11;
                }
                case AttributeValue: {
                    this.whenAttributeValue();
                    continue block11;
                }
            }
            throw new RuntimeException("It must be a new state.");
        }
        if (!this._stack.isEmpty()) {
            throw this.createException("\u8282\u70b9\u672a\u6b63\u5e38\u7ed3\u675f\u3002");
        }
        if (this._root == null) {
            throw this.createException("\u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u6839\u8282\u70b9\u3002");
        }
        return this._root;
    }

    private void markStateAs(State state) {
        this._state = state;
        this._charPosstionRelatedToState[0] = this._reader.getCurrentRowNum();
        this._charPosstionRelatedToState[1] = this._reader.getCurrentColNum();
    }

    private void whenPreElement() throws IOException, XmlReadingException {
        StringBuilder whatRead = new StringBuilder();
        String text = this._reader.readTextTill("<", whatRead);
        if (text == null) {
            if (this.hasElement()) {
                throw this.createExceptionWithNearestState("\u8282\u70b9\u672a\u7ed3\u675f\u3002");
            }
            if (this._root != null && whatRead.toString().trim().length() > 0) {
                throw this.createExceptionWithNearestState("\u4e0d\u7b26\u5408\u8bed\u6cd5\u89c4\u5219\u7684\u5185\u5bb9\u3002");
            }
        } else {
            if (text.length() > 0 && (text = text.trim()).length() > 0) {
                if (this.hasElement()) {
                    this.getElement().addCData(text);
                } else {
                    throw this.createExceptionWithNearestState("\u4e0d\u5408\u6cd5\u7684\u5f00\u5934\u5185\u5bb9\u3002");
                }
            }
            this.markStateAs(State.ElementTag);
        }
    }

    private void whenCDATA() throws IOException, XmlReadingException {
        String content = this._reader.readStringTill("]]>");
        if (content == null) {
            throw this.createExceptionWithNearestState("CDATA\u6ca1\u6709\u7ed3\u675f\u7b26\u3002]]>");
        }
        this.getElement().addCData(content);
        this.markStateAs(State.PreElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void whenElementTag() throws IOException, XmlReadingException {
        char c = this._reader.readOneChar();
        if (c == '?') {
            if (this._reader.readStringTill("?>") == null) {
                throw this.createExceptionWithNearestState("\u58f0\u660e\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed3\u675f\u7b26\u3002<?", 1);
            }
            this.markStateAs(State.PreElement);
            return;
        } else if (c == '!') {
            String two = this._reader.readChars(2);
            if ("--".equals(two)) {
                if (this._reader.readStringTill("-->") == null) {
                    throw this.createExceptionWithNearestState("\u6ce8\u91ca\u6ca1\u6709\u5bf9\u5e94\u7684\u7ed3\u675f\u7b26\u3002 <!--", 3);
                }
                this.markStateAs(State.PreElement);
                return;
            } else {
                if (!"[C".equals(two)) throw this.createExceptionWithNearestState("\u4e0d\u5408\u6cd5\u7684\u6807\u8bb0\u3002<!" + two, 2);
                this.checkOneRoot();
                String five = this._reader.readChars(5);
                if (!"DATA[".equals(five)) throw this.createExceptionWithNearestState("\u4e0d\u5408\u6cd5\u7684\u6807\u8bb0\u3002<![C" + five, 3);
                if (!this.hasElement()) throw this.createExceptionWithNearestState("CDATA\u6ca1\u6709\u7236\u8282\u70b9\u3002");
                this.markStateAs(State.CDATA);
            }
            return;
        } else if (c == '/') {
            this.checkOneRoot();
            this.markStateAs(State.PosteriorName);
            return;
        } else {
            if (!Checker.isValidNameStart(c)) throw this.createException("\u4e0d\u5408\u6cd5\u7684\u8282\u70b9\u540d\u79f0\u3002" + c);
            this.checkOneRoot();
            this.startString();
            this.appendString(c);
            this.markStateAs(State.TagName);
        }
    }

    private void whenPosteriorName() throws IOException, XmlReadingException {
        if (this.hasElement()) {
            String tagName = this.popElement().getName();
            String posteriorName = this._reader.readStringTill(">");
            if (posteriorName == null) {
                throw this.createExceptionWithNearestState("\u8282\u70b9\u7ed3\u675f\u6807\u8bb0\u7f3a\u5c11\u7ed3\u675f\u7b26\u3002>");
            }
            if (!tagName.equals(posteriorName)) {
                throw this.createExceptionWithNearestState("\u8282\u70b9\u7ed3\u675f\u6807\u8bb0\u6ca1\u6709\u76f8\u540c\u540d\u79f0\u7684\u5f00\u59cb\u3002</" + posteriorName + ">");
            }
        } else {
            throw this.createException("\u8282\u70b9\u7ed3\u675f\u6807\u8bb0\u4e0d\u80fd\u4f4d\u4e8e\u5f00\u5934\u3002");
        }
        this.markStateAs(State.PreElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void whenTagName() throws IOException, XmlReadingException {
        char c = this._reader.readOneChar();
        if (c == '>') {
            String name = this.acceptString();
            this.pushElement(name);
            this.markStateAs(State.PreElement);
            return;
        } else if (c == '/') {
            if (this._reader.isEOF()) {
                throw this.createException("\u7f3a\u5c11\u8282\u70b9\u7ed3\u675f\u7684\u7b26\u53f7\u3002>");
            }
            char oneMore = this._reader.readOneChar();
            if (oneMore != '>') throw this.createException("\u8282\u70b9\u6807\u8bb0\u7ed3\u675f\u4e0d\u6b63\u786e\u3002 />");
            String name = this.acceptString();
            this.born(name);
            this.markStateAs(State.PreElement);
            return;
        } else if (CharReader.isSeparater(c)) {
            String name = this.acceptString();
            this.pushElement(name);
            this.markStateAs(State.PreAttrKey);
            return;
        } else {
            if (!Checker.isValidName(c)) throw this.createException("\u4e0d\u5408\u6cd5\u7684\u8282\u70b9\u540d\u79f0\u3002");
            this.appendString(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void whenPreAttrKey() throws IOException, XmlReadingException {
        this._reader.skipSeparater();
        if (this._reader.isEOF()) {
            throw this.createException("\u7f3a\u5c11\u8282\u70b9\u7ed3\u675f\u7684\u7b26\u53f7\u3002>");
        }
        char c = this._reader.readOneChar();
        if (c == '>') {
            this.markStateAs(State.PreElement);
            return;
        } else if (c == '/') {
            if (this._reader.isEOF()) {
                throw this.createException("\u7f3a\u5c11\u8282\u70b9\u7ed3\u675f\u7684\u7b26\u53f7\u3002>");
            }
            char oneMore = this._reader.readOneChar();
            if (oneMore != '>') throw this.createException("\u8282\u70b9\u6807\u8bb0\u7ed3\u675f\u4e0d\u6b63\u786e\u3002 />");
            this.popElement();
            this.markStateAs(State.PreElement);
            return;
        } else {
            if (!Checker.isValidNameStart(c)) throw this.createException("\u4e0d\u5408\u6cd5\u7684\u5c5e\u6027\u540d\u79f0\u5f00\u5934\u3002" + c);
            this.startString();
            this.appendString(c);
            this.markStateAs(State.AttributeKey);
        }
    }

    private void whenAttributeKey() throws IOException, XmlReadingException {
        String ak = this._reader.readStringTill("=");
        if (ak == null) {
            throw this.createExceptionWithNearestState("\u5c5e\u6027\u540d\u79f0\u540e\u627e\u4e0d\u5230\u7b49\u4e8e\u53f7\u3002");
        }
        this.appendString(ak);
        this._attrKey = this.acceptString().trim();
        for (int i = 1; i < this._attrKey.length(); ++i) {
            if (Checker.isValidName(this._attrKey.charAt(i))) continue;
            throw this.createExceptionWithNearestState("\u5c5e\u6027\u540d\u79f0\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002" + this._attrKey, i);
        }
        this.markStateAs(State.PreAttrValue);
    }

    private void whenPreAttrValue() throws IOException, XmlReadingException {
        this._reader.skipSeparater();
        if (this._reader.isEOF()) {
            throw this.createExceptionWithNearestState("\u5c5e\u6027\u540d\u79f0=\"\u5c5e\u6027\u503c\"");
        }
        char c = this._reader.readOneChar();
        if (c != '\"' && c != '\'') {
            throw this.createException("\u5c5e\u6027\u503c\u5fc5\u987b\u52a0\u53cc\u5f15\u53f7\u6216\u5355\u5f15\u53f7\u3002");
        }
        this._attrValueQuatation = c;
        this.markStateAs(State.AttributeValue);
    }

    private void whenAttributeValue() throws IOException, XmlReadingException {
        String attrValue = this._reader.readTextTill(String.valueOf(this._attrValueQuatation), null);
        if (attrValue == null) {
            throw this.createExceptionWithNearestState("\u5c5e\u6027\u503c\u5fc5\u987b\u52a0\u53cc\u5f15\u53f7\u6216\u5355\u5f15\u53f7\u3002");
        }
        if (!Checker.isSpecialKey(this._attrKey)) {
            this.getElement().setAttribute(this._attrKey, attrValue);
        }
        this._attrKey = null;
        this._attrValueQuatation = '\u0000';
        this.markStateAs(State.PreAttrKey);
    }

    private void checkOneRoot() throws XmlReadingException {
        if (this._root != null && this._stack.isEmpty()) {
            throw this.createException("\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u8282\u70b9\u3002");
        }
    }

    private IXmlElement born(String name) throws XmlReadingException {
        XmlElement element = new XmlElement(name);
        if (this._root == null) {
            this._root = element;
        } else {
            this._stack.peek().addChild(element);
        }
        return element;
    }

    private void pushElement(String name) throws XmlReadingException {
        this._stack.push(this.born(name));
    }

    private IXmlElement popElement() {
        return this._stack.pop();
    }

    private boolean hasElement() {
        return !this._stack.isEmpty();
    }

    private IXmlElement getElement() {
        return this._stack.peek();
    }

    private void startString() {
        this._stringCollector.setLength(0);
    }

    private void appendString(char c) {
        this._stringCollector.append(c);
    }

    private void appendString(String str) {
        this._stringCollector.append(str);
    }

    private String acceptString() {
        return this._stringCollector.toString();
    }

    private XmlReadingException createException(String msg) {
        return XmlReadingException.create(msg, this._reader.getCurrentRowNum(), this._reader.getCurrentColNum());
    }

    private XmlReadingException createExceptionWithNearestState(String msg) {
        return XmlReadingException.create(msg, this._charPosstionRelatedToState[0], this._charPosstionRelatedToState[1]);
    }

    private XmlReadingException createExceptionWithNearestState(String msg, int colOffset) {
        return XmlReadingException.create(msg, this._charPosstionRelatedToState[0], this._charPosstionRelatedToState[1] + colOffset);
    }

    private static class CharReader {
        private String _charsetName = "utf-8";
        private InputStreamReader _reader;
        private char[] _next;
        private char _nearestNewLineChar;
        private int _currentRowNum;
        private int _currentColNum;

        public CharReader(InputStream stm) throws IOException {
            this._reader = new InputStreamReader(stm, this._charsetName);
            this._next = new char[1];
            this._currentRowNum = 1;
            this._currentColNum = -1;
            this.readNext();
        }

        private void readNext() throws IOException {
            if (this._reader.read(this._next) == -1) {
                this._next = null;
            }
            ++this._currentColNum;
            if (!this.isEOF()) {
                char c = this.currentChar();
                if (c == '\r' || c == '\n') {
                    if (this._nearestNewLineChar != '\u0000' && this._nearestNewLineChar != c) {
                        this._nearestNewLineChar = '\u0000';
                        --this._currentColNum;
                    } else {
                        this._nearestNewLineChar = c;
                        ++this._currentRowNum;
                        this._currentColNum = -1;
                    }
                } else {
                    this._nearestNewLineChar = '\u0000';
                }
            }
        }

        private char currentChar() {
            return this._next[0];
        }

        public boolean isEOF() {
            return this._next == null;
        }

        public char readOneChar() throws IOException {
            char current = this.currentChar();
            this.readNext();
            return current;
        }

        public String readChars(int times) throws IOException {
            StringBuilder sb = new StringBuilder();
            for (int count = 0; !this.isEOF() && count < times; ++count) {
                char current = this.readOneChar();
                sb.append(current);
            }
            return sb.toString();
        }

        public void skipSeparater() throws IOException {
            while (!this.isEOF() && CharReader.isSeparater(this.currentChar())) {
                this.readNext();
            }
        }

        public String readTextTill(String meet, StringBuilder whatRead) throws IOException, XmlReadingException {
            return this.readTill(meet, whatRead, true);
        }

        public String readStringTill(String meet) throws IOException, XmlReadingException {
            return this.readTill(meet, null, false);
        }

        private String readTill(String meet, StringBuilder whatRead, boolean translating) throws IOException, XmlReadingException {
            StringBuilder amp;
            int meetLen = meet.length();
            char meetLast = meet.charAt(meetLen - 1);
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = amp = translating ? new StringBuilder() : null;
            while (!this.isEOF()) {
                char current = this.readOneChar();
                if (translating) {
                    this.checkAmp(current, amp, sb);
                } else {
                    sb.append(current);
                }
                if (current != meetLast || sb.length() < meetLen) continue;
                int offsetIdx = sb.length() - meetLen;
                boolean matched = true;
                for (int i = meetLen - 2; i >= 0; --i) {
                    if (sb.charAt(offsetIdx + i) == meet.charAt(i)) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                if (translating && amp.length() > 0) {
                    throw this.exception("\u8f6c\u4e49\u6807\u8bc6\u672a\u7ed3\u675f\u3002" + amp.toString(), -meetLen);
                }
                return sb.substring(0, offsetIdx);
            }
            if (whatRead != null) {
                whatRead.setLength(0);
                whatRead.append((CharSequence)sb);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkAmp(char current, StringBuilder amp, StringBuilder sb) throws XmlReadingException {
            if (current == '&') {
                if (amp.length() != 0) throw this.exception("\u4e0a\u4e00\u4e2a\u8f6c\u4e49\u6807\u8bc6\u672a\u7ed3\u675f\u3002&");
                amp.append(current);
                return;
            } else if (amp.length() > 0) {
                if (current == ';') {
                    sb.append(this.acceptAmpWhenSemicolon(amp));
                    amp.setLength(0);
                    return;
                } else {
                    if (amp.length() > 4) {
                        throw this.exception("\u4e0d\u80fd\u8bc6\u522b\u7684\u8f6c\u4e49\u6807\u8bc6\u3002" + amp.toString(), -5);
                    }
                    amp.append(current);
                }
                return;
            } else {
                sb.append(current);
            }
        }

        private char acceptAmpWhenSemicolon(StringBuilder amp) throws XmlReadingException {
            String a = amp.toString();
            if (a.equals("&lt")) {
                return '<';
            }
            if (a.equals("&gt")) {
                return '>';
            }
            if (a.equals("&amp")) {
                return '&';
            }
            if (a.equals("&apos")) {
                return '\'';
            }
            if (a.equals("&quot")) {
                return '\"';
            }
            throw this.exception("\u4e0d\u80fd\u8bc6\u522b\u7684\u8f6c\u4e49\u6807\u8bc6\u3002" + amp.toString() + ";");
        }

        private XmlReadingException exception(String msg) {
            return XmlReadingException.create(msg, this._currentRowNum, this._currentColNum);
        }

        private XmlReadingException exception(String msg, int colOffset) {
            return XmlReadingException.create(msg, this._currentRowNum, this._currentColNum + colOffset);
        }

        public int getCurrentRowNum() {
            return this._currentRowNum;
        }

        public int getCurrentColNum() {
            return this._currentColNum;
        }

        public static boolean isSeparater(char c) {
            return c == ' ' || c == '\r' || c == '\n' || c == '\t';
        }
    }

    private static enum State {
        PreElement,
        ElementTag,
        TagName,
        PosteriorName,
        PreAttrKey,
        AttributeKey,
        PreAttrValue,
        AttributeValue,
        CDATA;

    }
}

