/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.xml.impl;

import com.kingdee.bos.qing.dfs.common.xml.IXmlElement;
import com.kingdee.bos.qing.dfs.common.xml.impl.IXmlElementAuxiliary;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class XmlDomWriter {
    private String _charsetName = "utf-8";
    private boolean _newline = true;
    private String _indent = "\t";
    private OutputStreamWriter _writer;
    private StringBuilder _cache;
    private SubNodeOutputer _subNodeOutputer;
    private String _defaultNamespaceUri;

    public void setDefaultNamespaceUri(String uri) {
        this._defaultNamespaceUri = uri;
    }

    public void setNewline(boolean newLine) {
        this._newline = newLine;
    }

    public void setIndent(String indent) {
        this._indent = indent;
    }

    public void write(IXmlElement element, OutputStream stm) throws IOException {
        this._writer = new OutputStreamWriter(stm, this._charsetName);
        this._cache = new StringBuilder(512);
        this._subNodeOutputer = this.createSubNodeOutputer();
        int level = 0;
        this.writeElement(element, level);
        this._writer.flush();
    }

    protected SubNodeOutputer createSubNodeOutputer() {
        return new SubNodeOutputer();
    }

    private void writeElement(IXmlElement element, int level) throws IOException {
        boolean hasSubs;
        this.writeIndent(level);
        this._cache.append('<');
        this._cache.append(element.getName());
        if (level == 0 && this._defaultNamespaceUri != null) {
            this._subNodeOutputer.outputKeyValue("xmlns", this._defaultNamespaceUri, this._cache);
        }
        IXmlElementAuxiliary aux = (IXmlElementAuxiliary)((Object)element);
        this._subNodeOutputer.outputAttributes(aux, this._cache);
        boolean bl = hasSubs = aux.hasCData() || element.hasChildren();
        if (hasSubs) {
            this._cache.append('>');
            if (aux.hasCData()) {
                this._subNodeOutputer.outputCData(aux, this._cache);
            }
            this.flushCache();
            if (element.hasChildren()) {
                int subLevel = level + 1;
                List<IXmlElement> children = element.getChildren();
                for (IXmlElement child : children) {
                    this.writeNewline();
                    this.writeElement(child, subLevel);
                }
                this.writeNewline();
                this.writeIndent(level);
            }
            this._cache.append("</");
            this._cache.append(element.getName());
            this._cache.append(">");
        } else {
            this._cache.append(" />");
        }
        this.flushCache();
    }

    private void writeIndent(int times) throws IOException {
        if (this._indent != null && !this._indent.isEmpty()) {
            for (int i = 0; i < times; ++i) {
                this._cache.append(this._indent);
            }
        }
    }

    private void writeNewline() throws IOException {
        if (this._newline) {
            this._cache.append('\r');
            this._cache.append('\n');
        }
    }

    private void flushCache() throws IOException {
        this._writer.write(this._cache.toString());
        this._cache.setLength(0);
    }

    protected static class SubNodeOutputer
    implements IXmlElementAuxiliary.ISubNodeVisitor {
        private static final int AMP = 1;
        private static final int LT = 2;
        private static final int GT = 4;
        private static final int APOS = 8;
        private static final int QUOT = 16;
        private static final int ALL = 31;
        private StringBuilder _target;

        protected SubNodeOutputer() {
        }

        public void outputAttributes(IXmlElementAuxiliary element, StringBuilder sb) {
            this._target = sb;
            element.visitAttributes(this);
            this._target = null;
        }

        public void outputCData(IXmlElementAuxiliary element, StringBuilder sb) {
            this._target = sb;
            element.visitCData(this);
            this._target = null;
        }

        public void outputKeyValue(String key, String value, StringBuilder sb) {
            this._target = sb;
            this.eachAttribute(key, value);
            this._target = null;
        }

        @Override
        public void eachAttribute(String key, String value) {
            this._target.append(' ');
            this._target.append(key);
            this._target.append('=');
            this._target.append('\"');
            this._target.append(this.encode(value));
            this._target.append('\"');
        }

        private String encode(String value) {
            int checked = 0;
            int c = value.length();
            for (int i = 0; i < c; ++i) {
                char chr = value.charAt(i);
                if (chr == '&') {
                    checked |= 1;
                } else if (chr == '<') {
                    checked |= 2;
                } else if (chr == '>') {
                    checked |= 4;
                } else if (chr == '\'') {
                    checked |= 8;
                } else if (chr == '\"') {
                    checked |= 0x10;
                }
                if ((checked & 0x1F) == 31) break;
            }
            if (checked & true) {
                value = value.replaceAll("&", "&amp;");
            }
            if ((checked & 2) == 2) {
                value = value.replaceAll("<", "&lt;");
            }
            if ((checked & 4) == 4) {
                value = value.replaceAll(">", "&gt;");
            }
            if ((checked & 8) == 8) {
                value = value.replaceAll("'", "&apos;");
            }
            if ((checked & 0x10) == 16) {
                value = value.replaceAll("\"", "&quot;");
            }
            return value;
        }

        @Override
        public void eachCData(String text) {
            this._target.append("<![CDATA[");
            this._target.append(text);
            this._target.append("]]>");
        }

        protected StringBuilder getOutputTarget() {
            return this._target;
        }
    }
}

