/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.common.xml.impl;

import com.kingdee.bos.qing.dfs.common.xml.IXmlElement;
import com.kingdee.bos.qing.dfs.common.xml.XmlSyntaxException;
import com.kingdee.bos.qing.dfs.common.xml.impl.Checker;
import com.kingdee.bos.qing.dfs.common.xml.impl.IXmlElementAuxiliary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class XmlElement
implements IXmlElement,
IXmlElementAuxiliary {
    private String _name;
    private List<String[]> _attrs;
    private List<IXmlElement> _children;
    private List<String> _cdata;

    public XmlElement(String name) {
        this.setName(name);
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new XmlSyntaxException("\u8282\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!Checker.isValidName(name)) {
            throw new XmlSyntaxException("\u8282\u70b9\u540d\u79f0\u5305\u542b\u4e0d\u5408\u6cd5\u5b57\u7b26\u3002");
        }
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (key == null || key.isEmpty()) {
            throw new XmlSyntaxException("\u5c5e\u6027\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!Checker.isValidName(key) || Checker.isSpecialKey(key)) {
            throw new XmlSyntaxException("\u5c5e\u6027\u952e\u5305\u542b\u4e0d\u5408\u6cd5\u5b57\u7b26\u3002");
        }
        if (this._attrs == null) {
            if (value != null) {
                this._attrs = new ArrayList<String[]>();
                this._attrs.add(new String[]{key, value});
            }
        } else {
            boolean found = false;
            for (int i = 0; i < this._attrs.size(); ++i) {
                String[] kv = this._attrs.get(i);
                if (!key.equals(kv[0])) continue;
                found = true;
                if (value == null) {
                    this._attrs.remove(i);
                    continue;
                }
                kv[1] = value;
            }
            if (!found && value != null) {
                this._attrs.add(new String[]{key, value});
            }
        }
    }

    @Override
    public String getAttribute(String key) {
        if (this._attrs != null) {
            for (String[] kv : this._attrs) {
                if (!key.equals(kv[0])) continue;
                return kv[1];
            }
        }
        return null;
    }

    @Override
    public List<String> getAttributeKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this._attrs != null) {
            for (String[] kv : this._attrs) {
                keys.add(kv[0]);
            }
        }
        return keys;
    }

    @Override
    public void addChild(IXmlElement child) {
        if (child.hasChildren()) {
            LinkedList<IXmlElement> queue = new LinkedList<IXmlElement>();
            queue.add(child);
            while (!queue.isEmpty()) {
                IXmlElement node = (IXmlElement)queue.poll();
                if (node == this) {
                    throw new XmlSyntaxException("\u5b50\u8282\u70b9\u5faa\u73af\u4e86\u3002");
                }
                if (!node.hasChildren()) continue;
                queue.addAll(node.getChildren());
            }
        } else if (child == this) {
            throw new XmlSyntaxException("\u5b50\u8282\u70b9\u5faa\u73af\u4e86\u3002");
        }
        this.getChildren().add(child);
    }

    @Override
    public boolean removeChild(IXmlElement child) {
        if (this._children != null) {
            Iterator<IXmlElement> it = this._children.iterator();
            while (it.hasNext()) {
                if (child != it.next()) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public IXmlElement getChild(String name) {
        if (this._children != null) {
            for (IXmlElement child : this._children) {
                if (!name.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this._children != null && !this._children.isEmpty();
    }

    @Override
    public List<IXmlElement> getChildren() {
        if (this._children == null) {
            this._children = new ArrayList<IXmlElement>();
        }
        return this._children;
    }

    @Override
    public List<IXmlElement> searchChildren(String name) {
        ArrayList<IXmlElement> targets = new ArrayList<IXmlElement>(3);
        if (this._children != null) {
            for (IXmlElement child : this._children) {
                if (!name.equals(child.getName())) continue;
                targets.add(child);
            }
        }
        return targets;
    }

    @Override
    public void addCData(String content) {
        if (content.indexOf("]]>") >= 0) {
            throw new XmlSyntaxException("CDATA\u5185\u5bb9\u4e0d\u80fd\u5e26\u7ed3\u675f\u6807\u8bc6]]>\u3002");
        }
        if (this._cdata == null) {
            this._cdata = new ArrayList<String>();
        }
        this._cdata.add(content);
    }

    @Override
    public String getText() {
        if (this._cdata == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String txt : this._cdata) {
            sb.append(txt);
        }
        return sb.toString();
    }

    @Override
    public boolean hasCData() {
        return this._cdata != null;
    }

    @Override
    public void visitCData(IXmlElementAuxiliary.ISubNodeVisitor visitor) {
        if (this._cdata != null) {
            for (String txt : this._cdata) {
                visitor.eachCData(txt);
            }
        }
    }

    @Override
    public void visitAttributes(IXmlElementAuxiliary.ISubNodeVisitor visitor) {
        if (this._attrs != null) {
            for (String[] kv : this._attrs) {
                visitor.eachAttribute(kv[0], kv[1]);
            }
        }
    }
}

