/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.client.model;

import com.kingdee.bos.qing.dfs.client.listener.IBucketGroupStateListener;
import com.kingdee.bos.qing.dfs.common.model.BucketGroupInfo;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.dfs.common.service.MountServie;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DFSRepository {
    private static Map<String, BucketGroupInfo[]> groups = new ConcurrentHashMap<String, BucketGroupInfo[]>();
    private static Map<String, BucketInfo[]> buckets = new ConcurrentHashMap<String, BucketInfo[]>();
    private static boolean _initialized = false;
    private static ArrayList<BucketInfo> buckets4W = new ArrayList();
    private static List<IBucketGroupStateListener> stateListeners = new ArrayList<IBucketGroupStateListener>();

    public static boolean isInitialized() {
        return _initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStateListener(IBucketGroupStateListener groupStateListener) {
        List<IBucketGroupStateListener> list = stateListeners;
        synchronized (list) {
            stateListeners.add(groupStateListener);
        }
    }

    public static synchronized void initialized() {
        if (_initialized) {
            return;
        }
        Iterator<Map.Entry<String, BucketGroupInfo[]>> groupIterator = groups.entrySet().iterator();
        while (groupIterator.hasNext()) {
            BucketGroupInfo[] groupArray;
            for (BucketGroupInfo groupInfo : groupArray = groups.get(groupIterator.next().getKey())) {
                if (groupInfo == null) continue;
                MountServie.mount((BucketGroupInfo)groupInfo);
            }
        }
        _initialized = true;
    }

    public static synchronized List<BucketGroupInfo> getBucketGroupInfos() {
        ArrayList<BucketGroupInfo> bucketGroupInfos = new ArrayList<BucketGroupInfo>();
        Iterator<Map.Entry<String, BucketGroupInfo[]>> groupIterator = groups.entrySet().iterator();
        while (groupIterator.hasNext()) {
            BucketGroupInfo[] groupArray;
            for (BucketGroupInfo groupInfo : groupArray = groups.get(groupIterator.next().getKey())) {
                if (groupInfo == null) continue;
                bucketGroupInfos.add(groupInfo);
            }
        }
        return bucketGroupInfos;
    }

    public static synchronized void saveOrUpdateGroup(BucketGroupInfo bucketGroupInfo) {
        BucketGroupInfo[] groupArray = new BucketGroupInfo[4];
        BucketGroupInfo[] groupArray2 = groups.putIfAbsent(bucketGroupInfo.getName(), groupArray);
        if (groupArray2 != null) {
            groupArray = groupArray2;
        }
        if (_initialized) {
            MountServie.mount((BucketGroupInfo)bucketGroupInfo);
        }
        groupArray[bucketGroupInfo.getLevel()] = bucketGroupInfo;
        DFSRepository.fireBucketGroupSaved(bucketGroupInfo);
    }

    public static synchronized void saveOrUpdateBucket(BucketInfo bucketInfo) {
        BucketInfo[] bucketArray = new BucketInfo[4];
        BucketInfo[] bucketArray2 = buckets.putIfAbsent(bucketInfo.getName(), bucketArray);
        if (bucketArray2 != null) {
            bucketArray = bucketArray2;
        }
        bucketArray[bucketInfo.getLevel()] = bucketInfo;
        DFSRepository.rebuildBucket4W();
    }

    public static synchronized void removeGroup(BucketGroupInfo bucketGroupInfo) {
        BucketGroupInfo[] groupArray = groups.get(bucketGroupInfo.getName());
        if (groupArray != null && groupArray.length > bucketGroupInfo.getLevel()) {
            MountServie.umount((BucketGroupInfo)groupArray[bucketGroupInfo.getLevel()]);
            groupArray[bucketGroupInfo.getLevel()] = null;
        }
        buckets.remove(bucketGroupInfo.getName());
        boolean hasGroupInstance = false;
        if (groupArray != null) {
            for (BucketGroupInfo groupInfo : groupArray) {
                if (groupInfo == null) continue;
                hasGroupInstance = true;
            }
        }
        if (!hasGroupInstance) {
            groups.remove(bucketGroupInfo.getName());
        }
        DFSRepository.rebuildBucket4W();
        DFSRepository.fireBucketGroupRemoved(bucketGroupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireBucketGroupRemoved(BucketGroupInfo removedBucketGroup) {
        ArrayList<IBucketGroupStateListener> temps = new ArrayList<IBucketGroupStateListener>();
        List<IBucketGroupStateListener> list = stateListeners;
        synchronized (list) {
            temps.addAll(stateListeners);
        }
        for (IBucketGroupStateListener l : temps) {
            l.onRemoved(removedBucketGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireBucketGroupSaved(BucketGroupInfo savedBucketGroup) {
        ArrayList<IBucketGroupStateListener> temps = new ArrayList<IBucketGroupStateListener>();
        List<IBucketGroupStateListener> list = stateListeners;
        synchronized (list) {
            temps.addAll(stateListeners);
        }
        for (IBucketGroupStateListener l : temps) {
            l.onSaved(savedBucketGroup);
        }
    }

    public static synchronized BucketGroupInfo getBucketGroup(String groupName, int level) {
        BucketGroupInfo[] groupArray = groups.get(groupName);
        if (groupArray != null) {
            return groupArray[level];
        }
        return null;
    }

    public static synchronized BucketInfo getBucket(String bucketName, int level) {
        BucketInfo[] bucketArray = buckets.get(bucketName);
        if (bucketArray != null) {
            return bucketArray[level];
        }
        return null;
    }

    public static synchronized void rebuildBucket4W() {
        buckets4W.clear();
        Iterator<Map.Entry<String, BucketInfo[]>> bucketIterator = buckets.entrySet().iterator();
        block0: while (bucketIterator.hasNext()) {
            BucketInfo[] bucketInfos = buckets.get(bucketIterator.next().getKey());
            for (int index = 1; index < bucketInfos.length; ++index) {
                BucketInfo bucketInfo = bucketInfos[index];
                if (bucketInfo == null || !bucketInfo.isUsable()) continue;
                buckets4W.add(bucketInfo);
                continue block0;
            }
        }
    }

    public static synchronized List<BucketInfo> getBuckets4W() {
        return new ArrayList<BucketInfo>(buckets4W);
    }
}

