/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.client.route;

import com.kingdee.bos.qing.dfs.client.DFSClient;
import com.kingdee.bos.qing.dfs.client.model.DFSRepository;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.model.BucketGroupInfo;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.dfs.common.writingrecord.model.FileTypeUtil;
import com.kingdee.bos.qing.filesystem.stream.LocalFileQingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.SeekableInputStream;
import com.kingdee.bos.qing.util.FileUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;

public class DFSBucketRandomRoute4R {
    private static Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Random getRandom() throws NoSuchAlgorithmException {
        if (random != null) {
            return random;
        }
        Class<DFSBucketRandomRoute4R> clazz = DFSBucketRandomRoute4R.class;
        synchronized (DFSBucketRandomRoute4R.class) {
            if (random != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return random;
            }
            try {
                random = SecureRandom.getInstance("NativePRNGNonBlocking");
            }
            catch (NoSuchAlgorithmException nsae) {
                random = new SecureRandom();
            }
            return random;
        }
    }

    public static File getFile(DFSFilePO dfsFilePO) throws IOException {
        String fileType = FileTypeUtil.getSubFolderByTypeIndex((int)dfsFilePO.getFileTypeIndex());
        Set levels = dfsFilePO.getLevels();
        if (levels == null || levels.isEmpty()) {
            throw new FileNotFoundException(dfsFilePO.getBucketName() + File.separator + fileType + dfsFilePO.getRelativeFilePath() + File.separator + dfsFilePO.getFileName());
        }
        int tryTime = 0;
        while (tryTime < 3) {
            try {
                ++tryTime;
                if (!DFSClient.isStart()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ArrayList levelCopy = new ArrayList(levels);
                while (!levelCopy.isEmpty()) {
                    String fullPath;
                    File file;
                    int index = Math.abs(DFSBucketRandomRoute4R.getRandom().nextInt(levelCopy.size()));
                    Integer level = (Integer)levelCopy.remove(index);
                    if (level == null) continue;
                    BucketGroupInfo bucketGroupInfo = DFSRepository.getBucketGroup(dfsFilePO.getGroupName(), level);
                    BucketInfo bucketInfo = DFSRepository.getBucket(dfsFilePO.getBucketName(), level);
                    if (bucketInfo == null || bucketGroupInfo == null || !bucketGroupInfo.isUsable() || !bucketInfo.isUsable() || !(file = FileUtil.newFile((String)(fullPath = bucketGroupInfo.getClientFilePath() + File.separator + dfsFilePO.getBucketName() + File.separator + fileType + dfsFilePO.getRelativeFilePath() + File.separator + dfsFilePO.getFileName()))).exists()) continue;
                    return file;
                }
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        throw new FileNotFoundException(dfsFilePO.getBucketName() + File.separator + fileType + dfsFilePO.getRelativeFilePath() + File.separator + dfsFilePO.getFileName());
    }

    public static QingInputStream getInputStream(DFSFilePO dfsFilePO) throws IOException {
        File file = DFSBucketRandomRoute4R.getFile(dfsFilePO);
        return new QingInputStream(file.length(), (SeekableInputStream)new LocalFileQingInputStream(file));
    }
}

