/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.client.route;

import com.kingdee.bos.qing.dfs.client.model.DFSRepository;
import com.kingdee.bos.qing.dfs.client.route.DFSBucketRandomRoute4R;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.dfs.common.util.ZKClientUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicInteger;
import org.apache.curator.retry.RetryNTimes;

public class DFSBucketRoute4W {
    private static RetryNTimes retryNTimes = new RetryNTimes(3, 1000);
    private static Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Random getRandom() throws NoSuchAlgorithmException {
        if (random != null) {
            return random;
        }
        Class<DFSBucketRandomRoute4R> clazz = DFSBucketRandomRoute4R.class;
        synchronized (DFSBucketRandomRoute4R.class) {
            if (random != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return random;
            }
            try {
                random = SecureRandom.getInstance("NativePRNGNonBlocking");
            }
            catch (NoSuchAlgorithmException nsae) {
                random = new SecureRandom();
            }
            return random;
        }
    }

    public static BucketInfo requestWBucket() throws IOException {
        CuratorFramework client = ZKClientUtil.getClient();
        ArrayList<BucketInfo> selectedBucketInfos = new ArrayList<BucketInfo>();
        BucketInfo selectedBucketInfo = null;
        Random random = null;
        try {
            random = DFSBucketRoute4W.getRandom();
            List<BucketInfo> bucketInfos = DFSRepository.getBuckets4W();
            double value = 0.0;
            HashMap<String, DistributedAtomicInteger> allBucketAtomicValue = new HashMap<String, DistributedAtomicInteger>(bucketInfos.size(), 1.0f);
            for (BucketInfo bucketInfo : bucketInfos) {
                String atomicCountPath = ZKClientUtil.getZKRootPath() + "/AtomicCount/" + bucketInfo.getName();
                DistributedAtomicInteger atomicInteger = new DistributedAtomicInteger(client, atomicCountPath, (RetryPolicy)retryNTimes);
                allBucketAtomicValue.put(bucketInfo.getName(), atomicInteger);
                AtomicValue atomicValue = atomicInteger.get();
                int tryTime = 0;
                while (!atomicValue.succeeded() && tryTime++ < 3) {
                    atomicValue = atomicInteger.get();
                }
                if (!atomicValue.succeeded()) {
                    LogUtil.warn((String)("Try three time to get atomic Value from " + atomicCountPath));
                    continue;
                }
                int countValue = (Integer)atomicValue.preValue();
                if (selectedBucketInfos.isEmpty()) {
                    selectedBucketInfos.add(bucketInfo);
                    value = bucketInfo.getAvailableSize();
                    if (countValue <= 0) continue;
                    value = bucketInfo.getAvailableSize() / countValue;
                    continue;
                }
                double newValue = bucketInfo.getAvailableSize();
                if (countValue > 0) {
                    newValue = bucketInfo.getAvailableSize() / countValue;
                }
                if (newValue > value) {
                    selectedBucketInfos.clear();
                    selectedBucketInfos.add(bucketInfo);
                    continue;
                }
                if (newValue != value) continue;
                selectedBucketInfos.add(bucketInfo);
            }
            if (!selectedBucketInfos.isEmpty()) {
                selectedBucketInfo = selectedBucketInfos.size() > 1 ? (BucketInfo)selectedBucketInfos.get(random.nextInt(selectedBucketInfos.size())) : (BucketInfo)selectedBucketInfos.get(0);
                String selectedBucketName = selectedBucketInfo.getName();
                DistributedAtomicInteger atomicInteger = (DistributedAtomicInteger)allBucketAtomicValue.get(selectedBucketName);
                AtomicValue atomicValue = atomicInteger.increment();
                int tryTime = 0;
                while (!atomicValue.succeeded() && tryTime++ < 3) {
                    atomicValue = atomicInteger.increment();
                }
                if (!atomicValue.succeeded()) {
                    LogUtil.warn((String)("Try three time to increment atomic Value from " + selectedBucketName));
                } else if (LogUtil.isDebugEnabled()) {
                    LogUtil.debug((String)(selectedBucketInfo.getName() + "increment atomicValue preValue :" + atomicValue.postValue() + "postValue:" + atomicValue.postValue()));
                }
            }
        }
        catch (Throwable e) {
            throw new IOException("request bucket failed.", e);
        }
        if (selectedBucketInfo != null) {
            String bucketName = selectedBucketInfo.getName();
            HashSet<Integer> levels = new HashSet<Integer>();
            levels.add(1);
            levels.add(2);
            levels.add(3);
            ArrayList levelCopy = new ArrayList(levels);
            while (!levelCopy.isEmpty()) {
                BucketInfo bucketInfo;
                int index = Math.abs(random.nextInt(levelCopy.size()));
                Integer level = (Integer)levelCopy.remove(index);
                bucketInfo = DFSRepository.getBucket(bucketName, level);
                if (bucketInfo == null || !bucketInfo.isUsable()) continue;
                return bucketInfo;
            }
        }
        throw new IOException("request bucket failed. no bucket to request");
    }

    public static void releaseWBucket(BucketInfo bucketInfo) {
        if (bucketInfo == null) {
            return;
        }
        CuratorFramework client = ZKClientUtil.getClient();
        try {
            DistributedAtomicInteger atomicInteger = new DistributedAtomicInteger(client, ZKClientUtil.getZKRootPath() + "/AtomicCount/" + bucketInfo.getName(), (RetryPolicy)retryNTimes);
            AtomicValue atomicValue = atomicInteger.decrement();
            int tryTime = 0;
            while (!atomicValue.succeeded() && tryTime++ < 3) {
                atomicValue = atomicInteger.decrement();
            }
            if (!atomicValue.succeeded()) {
                LogUtil.warn((String)("Try three time to decrement atomic Value from " + bucketInfo.getName()));
            } else if (LogUtil.isDebugEnabled()) {
                LogUtil.debug((String)(bucketInfo.getName() + " decrement atomicValue preValue :" + atomicValue.postValue() + "postValue:" + atomicValue.postValue()));
            }
        }
        catch (Throwable e) {
            LogUtil.error((String)"request Write Bucket failed.", (Throwable)e);
        }
    }
}

