/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dfs.client.service;

import com.kingdee.bos.qing.dfs.client.model.DFSRepository;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.model.BucketGroupInfo;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.dfs.common.response.AbstractResponseWrap;
import com.kingdee.bos.qing.dfs.common.response.ResponseErrorWrap;
import com.kingdee.bos.qing.dfs.common.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.dfs.common.response.ResponseUtil;
import com.kingdee.bos.qing.dfs.common.util.HttpUtil;
import java.io.IOException;
import java.util.HashMap;

public class DFSClientService {
    private static final String REMOTECALL_URL = "/DFSService";

    public static String getPath(BucketInfo bucketInfo, int fileTypeIndex, String fileName) throws IOException {
        BucketGroupInfo bucketGroupInfo = DFSRepository.getBucketGroup(bucketInfo.getGroupName(), bucketInfo.getLevel());
        if (bucketGroupInfo == null) {
            throw new IOException("DFSClientService get Path fail.");
        }
        String url = bucketGroupInfo.getServerUrl() + REMOTECALL_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("remoteMethod", "getPath");
        params.put("bucketName", bucketInfo.getName());
        params.put("fileTypeIndex", fileTypeIndex + "");
        params.put("fileName", fileName);
        String resultJson = HttpUtil.doPost((String)url, params);
        if (resultJson == null) {
            throw new IOException("DFSClientService get Path fail.");
        }
        AbstractResponseWrap responseWrap = ResponseUtil.fromJson((String)resultJson);
        if (responseWrap instanceof ResponseErrorWrap) {
            ResponseErrorWrap errorWrap = (ResponseErrorWrap)responseWrap;
            throw new RuntimeException("ErrorCode:" + errorWrap.getErrorCode() + " message :" + errorWrap.getErrorMessage());
        }
        ResponseSuccessWrap successWrap = (ResponseSuccessWrap)responseWrap;
        return (String)successWrap.getData();
    }

    public static void flushToDiskSafely(DFSFilePO dfsFilePO, boolean isDelete) throws IOException {
        if (dfsFilePO == null) {
            return;
        }
        Integer level = dfsFilePO.getRandomStoragedLevel();
        BucketInfo bucketInfo = DFSRepository.getBucket(dfsFilePO.getBucketName(), level);
        BucketGroupInfo bucketGroupInfo = DFSRepository.getBucketGroup(bucketInfo.getGroupName(), bucketInfo.getLevel());
        String relativeFilePath = dfsFilePO.getRelativeFilePath();
        String url = bucketGroupInfo.getServerUrl() + REMOTECALL_URL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("remoteMethod", "flushToDiskSafely");
        params.put("bucketName", bucketInfo.getName());
        params.put("fileTypeIndex", dfsFilePO.getFileTypeIndex() + "");
        params.put("fileName", dfsFilePO.getFileName());
        params.put("relativeFilePath", relativeFilePath);
        params.put("isTemp", dfsFilePO.isTemp() + "");
        params.put("isDelete", isDelete + "");
        params.put("logicName", dfsFilePO.getLogicName());
        String resultJson = HttpUtil.doPost((String)url, params);
        if (resultJson == null) {
            throw new IOException("DFSClientService get Path fail.");
        }
        AbstractResponseWrap responseWrap = ResponseUtil.fromJson((String)resultJson);
        if (responseWrap instanceof ResponseErrorWrap) {
            ResponseErrorWrap errorWrap = (ResponseErrorWrap)responseWrap;
            throw new RuntimeException("ErrorCode:" + errorWrap.getErrorCode() + " message :" + errorWrap.getErrorMessage());
        }
    }
}

