/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.dfsimpl;

import com.kingdee.bos.qing.dfs.client.DFSClient;
import com.kingdee.bos.qing.dfs.client.route.DFSBucketRandomRoute4R;
import com.kingdee.bos.qing.dfs.client.service.DFSClientService;
import com.kingdee.bos.qing.dfs.common.filemanager.domain.DFSFileDomain;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.filesystem.manager.AbstractQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.DFSQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;

public abstract class AbstractDFSQingFile
extends AbstractQingFile {
    private DFSFileDomain dfsFileDomain;
    private DFSFilePO _dfsFilePO;

    public static void stop() {
        DFSClient.stop();
    }

    public AbstractDFSQingFile(AbstractQingFileType fileType) {
        super(fileType);
        try {
            while (!DFSClient.isStart()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dfsFileDomain = new DFSFileDomain();
    }

    protected AbstractDFSQingFile(AbstractQingFileType fileType, String name) {
        super(fileType, name);
        try {
            while (!DFSClient.isStart()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e1) {
            LogUtil.error((String)"dfsclient occurs error");
        }
        this.dfsFileDomain = new DFSFileDomain();
        try {
            DFSFilePO dfsFilePO = this.dfsFileDomain.findDFSFile(name);
            if (dfsFilePO != null && !dfsFilePO.isDelete() && dfsFilePO.getFileTypeIndex() == fileType.getTypeIndex()) {
                this._dfsFilePO = dfsFilePO;
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
    }

    public long getLastModifiedTimes() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this._dfsFilePO.getCreateTime().getTime();
    }

    public long getLength() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this._dfsFilePO.getSize();
    }

    public File getLocalFileSystemFile() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return DFSBucketRandomRoute4R.getFile(this._dfsFilePO);
    }

    public String getLocalFullPath() throws IOException {
        return this.getLocalFileSystemFile().getCanonicalPath();
    }

    public boolean exists() {
        return this._dfsFilePO != null;
    }

    public QingInputStream getInputStream() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        QingInputStream inputStream = DFSBucketRandomRoute4R.getInputStream(this._dfsFilePO);
        try {
            this.dfsFileDomain.visitFile(this._dfsFilePO.getFileName());
        }
        catch (SQLException e) {
            CloseUtil.close((Closeable[])new Closeable[]{inputStream});
            inputStream = null;
            throw new IOException(e);
        }
        return inputStream;
    }

    protected IQingFileWriter doCreateWriter() {
        return new DFSQingFileWriter(this._fileResourceService, this._fileResourceInfo, this);
    }

    protected boolean doCreateNewFile() throws IOException {
        IQingFileWriter fileWriter = this.createWriter();
        QingOutputStream outputStream = null;
        try {
            outputStream = fileWriter.getOutputStream();
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{outputStream});
            fileWriter.close(null);
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{outputStream});
        fileWriter.close(null);
        return true;
    }

    protected boolean doDelete() {
        if (this._dfsFilePO != null) {
            int tryTime = 0;
            while (tryTime < 3) {
                try {
                    ++tryTime;
                    if (!DFSClient.isStart()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    DFSClientService.flushToDiskSafely(this._dfsFilePO, true);
                    return true;
                }
                catch (Exception e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            return false;
        }
        this._dfsFilePO = null;
        return true;
    }

    public void setDfsFilePO(DFSFilePO dfsFilePO) {
        this._dfsFilePO = dfsFilePO;
    }

    public DFSFileDomain getDfsFileDomain() {
        return this.dfsFileDomain;
    }

    static {
        try {
            DFSClient.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

