/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.dfsimpl;

import com.kingdee.bos.qing.dfs.client.DFSClient;
import com.kingdee.bos.qing.dfs.client.model.DFSRepository;
import com.kingdee.bos.qing.dfs.client.route.DFSBucketRoute4W;
import com.kingdee.bos.qing.dfs.client.service.DFSClientService;
import com.kingdee.bos.qing.dfs.common.model.BucketGroupInfo;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.FileTypeUtil;
import com.kingdee.bos.qing.util.FileUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DFSOutputStreamGetter {
    private String _fileRelativePath;
    private boolean _fileExists;
    private BucketInfo _bucketInfo;

    public String getFileRelativePath() {
        return this._fileRelativePath;
    }

    public boolean isFileExist() {
        return this._fileExists;
    }

    public BucketInfo getBucketInfo() {
        return this._bucketInfo;
    }

    public BufferedOutputStream get(String fileName, AbstractQingFileType fileType) throws IOException {
        int tryTime = 0;
        while (tryTime < 3) {
            try {
                ++tryTime;
                if (!DFSClient.isStart()) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                BucketInfo bucketInfo = DFSBucketRoute4W.requestWBucket();
                String relativeFilePath = DFSClientService.getPath(bucketInfo, fileType.getTypeIndex(), fileName);
                LogUtil.info((String)("getPath: " + bucketInfo.getGroupName() + bucketInfo.getName() + FileTypeUtil.getSubFolderByTypeIndex((int)fileType.getTypeIndex()) + relativeFilePath + fileName));
                BucketGroupInfo bucketGroupInfo = DFSRepository.getBucketGroup(bucketInfo.getGroupName(), bucketInfo.getLevel());
                String fileFullPath = bucketGroupInfo.getClientFilePath() + File.separator + bucketInfo.getName() + File.separator + FileTypeUtil.getSubFolderByTypeIndex((int)fileType.getTypeIndex()) + relativeFilePath + File.separator + fileName;
                File file = FileUtil.newFile((String)fileFullPath);
                this._fileExists = file.exists();
                this._bucketInfo = bucketInfo;
                if (this._fileExists) {
                    this._fileRelativePath = relativeFilePath;
                    return new BufferedOutputStream(new FileOutputStream(file));
                }
                LogUtil.error((String)(tryTime + " getOutputStream failed, file not exist: " + fileFullPath));
                DFSOutputStreamGetter.list(bucketGroupInfo.getClientFilePath());
                DFSBucketRoute4W.releaseWBucket(bucketInfo);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        throw new IOException("getOutputStream failed.");
    }

    private static void list(String targetFolder) throws IOException {
        File file = FileUtil.newFile((String)targetFolder);
        File[] listFiles = file.listFiles();
        if (listFiles == null) {
            LogUtil.error((String)(targetFolder + " listFiles null"));
            return;
        }
        StringBuilder filePath = new StringBuilder();
        for (File children : listFiles) {
            if (children.isFile()) {
                filePath.append(children.getCanonicalPath());
                filePath.append("\r\n");
                continue;
            }
            DFSOutputStreamGetter.list(children.getCanonicalPath());
        }
        LogUtil.error((String)filePath.toString());
    }
}

