/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.dfsimpl;

import com.kingdee.bos.qing.dfs.client.DFSClient;
import com.kingdee.bos.qing.dfs.client.route.DFSBucketRoute4W;
import com.kingdee.bos.qing.dfs.client.service.DFSClientService;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.filemanager.model.StoragedStatus;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.filesystem.manager.api.IFileResourceService;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.AbstractDFSQingFile;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.DFSOutputStreamGetter;
import com.kingdee.bos.qing.filesystem.manager.model.FileTypeUtil;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class DFSQingFileWriter
implements IQingFileWriter {
    private IFileResourceService _resourceService;
    private AbstractDFSQingFile _dfsQingFile;
    private QingFileResourceInfo _fileResourceInfo;
    private DFSFilePO _dfsFilePO;
    private QingOutputStream _outputStream;
    private BucketInfo _bucketInfo;
    private String _fileRelativePath;
    private boolean _fileExists;

    public DFSQingFileWriter(IFileResourceService resourceService, QingFileResourceInfo fileResourceInfo, AbstractDFSQingFile dfsQingFile) {
        this._resourceService = resourceService;
        this._fileResourceInfo = fileResourceInfo;
        this._dfsQingFile = dfsQingFile;
        this._dfsFilePO = new DFSFilePO();
        this._dfsFilePO.setFileName(this._dfsQingFile.getName());
        this._dfsFilePO.setFileTypeIndex(this._dfsQingFile.getFileTypeIndex());
        this._dfsFilePO.setTemp(this._dfsQingFile.getFileType().isTemp());
    }

    public QingOutputStream getOutputStream() throws IOException {
        if (this._outputStream != null) {
            throw new IOException("not allowed to get outputStream twice.");
        }
        try {
            DFSFilePO dfsFilePO = this._dfsQingFile.getDfsFileDomain().findDFSFile(this._dfsQingFile.getName());
            if (dfsFilePO != null) {
                throw new IOException("Duplicate Key :" + this._dfsQingFile.getName());
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        DFSOutputStreamGetter dfsBOSGetter = new DFSOutputStreamGetter();
        BufferedOutputStream dfsBOS = dfsBOSGetter.get(this._dfsFilePO.getFileName(), this._dfsQingFile.getFileType());
        this._outputStream = new QingOutputStream(this._resourceService, this._fileResourceInfo, (OutputStream)dfsBOS);
        this._fileRelativePath = dfsBOSGetter.getFileRelativePath();
        this._bucketInfo = dfsBOSGetter.getBucketInfo();
        this._fileExists = dfsBOSGetter.isFileExist();
        this._dfsFilePO.setGroupName(this._bucketInfo.getGroupName());
        this._dfsFilePO.setBucketName(this._bucketInfo.getName());
        this._dfsFilePO.setRelativeFilePath(this._fileRelativePath);
        this._dfsFilePO.setLevelStatusByName(this._bucketInfo.getLevel(), StoragedStatus.STORAGED);
        return this._outputStream;
    }

    public void close(Exception exception) {
        try {
            if (this._outputStream == null) {
                return;
            }
            String errorMsg = null;
            int tryTime = 0;
            while (tryTime < 3) {
                try {
                    ++tryTime;
                    if (!DFSClient.isStart()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (exception == null) {
                        if (this._dfsFilePO != null) {
                            if (LogUtil.isDebugEnabled()) {
                                LogUtil.debug((String)("before flushToDisk " + this._bucketInfo.getGroupName() + this._bucketInfo.getName() + FileTypeUtil.getSubFolderByTypeIndex((int)this._dfsFilePO.getFileTypeIndex()) + this._dfsFilePO.getRelativeFilePath() + File.separator + this._dfsFilePO.getFileName() + " ,\u6587\u4ef6exists: " + this._fileExists));
                            }
                            DFSClientService.flushToDiskSafely(this._dfsFilePO, false);
                            this._dfsFilePO = this._dfsQingFile.getDfsFileDomain().findDFSFile(this._dfsFilePO.getFileName());
                        }
                        if (this._dfsFilePO == null) {
                            throw new RuntimeException("flushToDiskSafely failed.");
                        }
                        this._dfsQingFile.setDfsFilePO(this._dfsFilePO);
                    } else {
                        DFSClientService.flushToDiskSafely(this._dfsFilePO, true);
                    }
                    return;
                }
                catch (Exception e) {
                    errorMsg = e.getMessage();
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            throw new RuntimeException("flushToDiskSafely failed. " + errorMsg);
        }
        finally {
            this._outputStream = null;
            DFSBucketRoute4W.releaseWBucket(this._bucketInfo);
        }
    }
}

