/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater;

import com.kingdee.bos.qing.dfs.client.route.DFSBucketRoute4W;
import com.kingdee.bos.qing.dfs.client.service.DFSClientService;
import com.kingdee.bos.qing.dfs.common.filemanager.domain.DFSFileDomain;
import com.kingdee.bos.qing.dfs.common.filemanager.model.DFSFilePO;
import com.kingdee.bos.qing.dfs.common.filemanager.model.StoragedStatus;
import com.kingdee.bos.qing.dfs.common.model.BucketInfo;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.DFSOutputStreamGetter;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater.AbstractUpdater;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.FileUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

class LocalToDFSUpdater
extends AbstractUpdater {
    private boolean success = false;
    private DFSFileDomain dfsFileDomain;
    private static final String PERSISTENTDIR = "QingPersistent";

    LocalToDFSUpdater() {
    }

    @Override
    public void update() {
        this.reset();
        this.localToDFS();
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public void retry() {
        this.localToDFS();
    }

    private DFSFileDomain getDFSFileDomain() {
        if (this.dfsFileDomain == null) {
            this.dfsFileDomain = new DFSFileDomain();
        }
        return this.dfsFileDomain;
    }

    private void reset() {
        this.success = false;
    }

    private void localToDFS() {
        File baseDir = FileUtil.newFile((String)LOCAL_QINGSTORAGE_PATH);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            this.success = true;
            return;
        }
        String persistentDirPath = LOCAL_QINGSTORAGE_PATH + PERSISTENTDIR + File.separator;
        File persistentDir = FileUtil.newFile((String)persistentDirPath);
        if (!persistentDir.exists() || !persistentDir.isDirectory()) {
            this.success = true;
            return;
        }
        int successTypeCount = 0;
        Collection fileTypes = QingPersistentFileType.getAllInstances();
        for (QingPersistentFileType fileType : fileTypes) {
            try {
                String folderPath = persistentDirPath + fileType.getSubFolder();
                boolean allFileFlushToDisk = this.traverseAndCopyFile(folderPath, fileType);
                if (!allFileFlushToDisk) continue;
                ++successTypeCount;
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        this.success = fileTypes.size() == successTypeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverseAndCopyFile(String folderPath, QingPersistentFileType fileType) throws IOException {
        File dir = FileUtil.newFile((String)folderPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return true;
        }
        File[] files = dir.listFiles();
        int fileCount = files.length;
        int successCount = 0;
        byte[] buffer = new byte[1024];
        String backupFullPath = LOCAL_BACKUP_FULLPATH + fileType.getSubFolder() + File.separator;
        for (File file : files) {
            List<File> correctFiles = this.searchAndCorrectOddFile(file, fileType);
            if (correctFiles.size() > 0) {
                fileCount += correctFiles.size() - 1;
            }
            for (File correctFile : correctFiles) {
                boolean flushToDiskSucceed;
                if (correctFile.isDirectory()) {
                    ++successCount;
                    continue;
                }
                BufferedOutputStream dfsOS = null;
                FileInputStream is = null;
                DFSFilePO dfsFilePO = null;
                try {
                    DFSOutputStreamGetter dfsBOSGetter = new DFSOutputStreamGetter();
                    dfsOS = dfsBOSGetter.get(correctFile.getName(), (AbstractQingFileType)fileType);
                    String logicName = correctFile instanceof OddFile ? ((OddFile)correctFile).getDFSLogicName() : null;
                    dfsFilePO = new DFSFilePO();
                    dfsFilePO.setFileName(correctFile.getName());
                    dfsFilePO.setLogicName(logicName);
                    dfsFilePO.setFileTypeIndex(fileType.getTypeIndex());
                    dfsFilePO.setTemp(fileType.isTemp());
                    BucketInfo bucketInfo = dfsBOSGetter.getBucketInfo();
                    dfsFilePO.setGroupName(bucketInfo.getGroupName());
                    dfsFilePO.setBucketName(bucketInfo.getName());
                    dfsFilePO.setRelativeFilePath(dfsBOSGetter.getFileRelativePath());
                    dfsFilePO.setLevelStatusByName(bucketInfo.getLevel(), StoragedStatus.STORAGED);
                    DFSBucketRoute4W.releaseWBucket(bucketInfo);
                }
                catch (IOException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
                if (dfsOS == null) continue;
                boolean errorOccurs = false;
                try {
                    is = new FileInputStream(correctFile);
                    int len = 0;
                    while ((len = ((InputStream)is).read(buffer)) != -1) {
                        dfsOS.write(buffer, 0, len);
                    }
                }
                catch (Exception e) {
                    try {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                        errorOccurs = true;
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{is});
                        CloseUtil.close((Closeable[])new Closeable[]{dfsOS});
                        boolean flushToDiskSucceed2 = this.flushToDiskSafely(errorOccurs, dfsFilePO);
                        if (flushToDiskSucceed2) {
                            ++successCount;
                            this.moveToBackupDir(correctFile, backupFullPath);
                        }
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{is});
                    CloseUtil.close((Closeable[])new Closeable[]{dfsOS});
                    flushToDiskSucceed = this.flushToDiskSafely(errorOccurs, dfsFilePO);
                    if (!flushToDiskSucceed) continue;
                    ++successCount;
                    this.moveToBackupDir(correctFile, backupFullPath);
                    continue;
                }
                CloseUtil.close((Closeable[])new Closeable[]{is});
                CloseUtil.close((Closeable[])new Closeable[]{dfsOS});
                flushToDiskSucceed = this.flushToDiskSafely(errorOccurs, dfsFilePO);
                if (!flushToDiskSucceed) continue;
                ++successCount;
                this.moveToBackupDir(correctFile, backupFullPath);
            }
        }
        return fileCount == successCount;
    }

    private boolean flushToDiskSafely(boolean errorOccurs, DFSFilePO dfsFilePO) {
        int tryTime = 0;
        while (tryTime < 3) {
            try {
                ++tryTime;
                if (!errorOccurs) {
                    String fileName;
                    DFSClientService.flushToDiskSafely(dfsFilePO, false);
                    String string = fileName = dfsFilePO.getLogicName() == null ? dfsFilePO.getFileName() : dfsFilePO.getLogicName();
                    DFSFilePO rs = this.getDFSFileDomain().findDFSFile(fileName);
                    if (rs == null) continue;
                    LogUtil.info((String)("flush to disk succeed, fileName=" + fileName + ", fileType=" + dfsFilePO.getFileTypeIndex()));
                    return true;
                }
                DFSClientService.flushToDiskSafely(dfsFilePO, true);
            }
            catch (Exception e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private List<File> searchAndCorrectOddFile(File file, QingPersistentFileType fileType) throws IOException {
        ArrayList<File> correctFiles = new ArrayList<File>();
        if (fileType.getTypeIndex() != QingPersistentFileType.EMBEDDED_PUB_QS.getTypeIndex() || !file.isDirectory()) {
            correctFiles.add(file);
            return correctFiles;
        }
        String filePrefix = file.getParentFile().getCanonicalPath() + File.separator;
        this.correctAndCollectOddFile(file, correctFiles, filePrefix);
        return correctFiles;
    }

    private void correctAndCollectOddFile(File file, List<File> correctFiles, String filePrefix) throws IOException {
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles.length > 0) {
                for (File childFile : childFiles) {
                    this.correctAndCollectOddFile(childFile, correctFiles, filePrefix);
                }
            } else {
                File oddFile = this.correctOddFile(file, filePrefix);
                correctFiles.add(oddFile);
            }
        } else {
            File oddFile = this.correctOddFile(file, filePrefix);
            correctFiles.add(oddFile);
        }
    }

    private File correctOddFile(File file, String filePrefix) throws IOException {
        String filePath = file.getCanonicalPath();
        String logicName = filePath.substring(filePrefix.length());
        OddFile oddFile = new OddFile(filePath);
        String commonFileName = UUID.randomUUID().toString();
        oddFile.setFileName(commonFileName);
        oddFile.setDFSLogicName(logicName);
        return oddFile;
    }

    private void moveToBackupDir(File file, String backupDirPath) {
        File dir = FileUtil.newFile((String)backupDirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory()) {
            boolean delete = dir.delete();
            if (!delete) {
                LogUtil.info((String)("delete file fail,filename=" + dir.getName()));
            }
            dir.mkdirs();
        }
        String backupFilePath = null;
        backupFilePath = file instanceof OddFile ? backupDirPath + ((OddFile)file).getDFSLogicName() : backupDirPath + file.getName();
        File backup = FileUtil.newFile((String)backupFilePath);
        backup.getParentFile().mkdirs();
        boolean rename = file.renameTo(backup);
        if (!rename) {
            LogUtil.info((String)("file renameTo fail, filename=" + file.getName()));
        }
    }

    private static class OddFile
    extends File {
        private static final long serialVersionUID = 7758842171983719220L;
        private String trueFileName;
        private String logicName;

        public OddFile(String pathname) {
            super(pathname);
        }

        public void setFileName(String fileName) {
            this.trueFileName = fileName;
        }

        @Override
        public String getName() {
            return this.trueFileName;
        }

        public void setDFSLogicName(String logicName) {
            this.logicName = logicName;
        }

        public String getDFSLogicName() {
            return this.logicName;
        }
    }
}

