/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater;

import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater.AbstractUpdater;
import com.kingdee.bos.qing.filesystem.manager.localimpl.DirUtil;
import com.kingdee.bos.qing.util.FileUtil;
import java.io.File;

class TempCleanUpdater
extends AbstractUpdater {
    private boolean success = false;
    private static final String TEMPDIR = "QingTemp";

    TempCleanUpdater() {
    }

    @Override
    public void update() {
        this.reset();
        this.deleteTempFile();
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public void retry() {
        this.deleteTempFile();
    }

    private void reset() {
        this.success = false;
    }

    private void deleteTempFile() {
        File[] childFiles;
        File baseDir = FileUtil.newFile((String)LOCAL_QINGSTORAGE_PATH);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            this.success = true;
            return;
        }
        String tempDirPath = LOCAL_QINGSTORAGE_PATH + TEMPDIR + File.separator;
        File tempDir = FileUtil.newFile((String)tempDirPath);
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            this.success = true;
            return;
        }
        for (File childFile : childFiles = tempDir.listFiles()) {
            if (childFile.isDirectory()) {
                DirUtil.delFolder((String)(tempDirPath + childFile.getName()), null);
                continue;
            }
            boolean delete = childFile.delete();
            if (delete) continue;
            LogUtil.info((String)("childFile delete fail,filename=" + childFile.getName()));
        }
        childFiles = tempDir.listFiles();
        this.success = childFiles.length == 0;
    }
}

