/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater;

import com.kingdee.bos.qing.dfs.common.dfslock.QingInterProcessMutex;
import com.kingdee.bos.qing.dfs.common.util.EnvUtil;
import com.kingdee.bos.qing.dfs.common.util.LogUtil;
import com.kingdee.bos.qing.dfs.common.util.ZKClientUtil;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater.AbstractUpdater;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater.LocalToDFSUpdater;
import com.kingdee.bos.qing.filesystem.manager.dfsimpl.updater.TempCleanUpdater;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;

public class UpdateHelper {
    private static List<AbstractUpdater> updaters = new ArrayList<AbstractUpdater>();
    private static final String ZK_NODE_RIGHT_TO_UPGRADE = "QingUpgrade/right2upgrade";
    private QingInterProcessMutex lock;

    public int update() {
        try {
            LogUtil.info((String)"start to acquire zk lock before upgrade Qing file.");
            this.lock();
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage());
            return 1;
        }
        LogUtil.info((String)"Succeed to acquire zk lock before upgrade Qing file.");
        try {
            Class.forName("com.kingdee.bos.qing.filesystem.manager.localimpl.AbstractLocalQingFile");
        }
        catch (ClassNotFoundException e) {
            LogUtil.error((String)"Upgrade to latest QingStorage failed.", (Throwable)e);
            return 1;
        }
        boolean upgradeSucceed = true;
        long startTime = System.currentTimeMillis();
        for (AbstractUpdater updater : updaters) {
            int retryCount;
            updater.update();
            for (retryCount = 0; !updater.isSuccessful() && retryCount < 1000; ++retryCount) {
                LogUtil.info((String)("Local QingStorage upgrade failed, retry for " + retryCount + "th times"));
                updater.retry();
            }
            if (updater.isSuccessful() || retryCount < 1000) continue;
            upgradeSucceed = false;
            break;
        }
        long endTime = System.currentTimeMillis();
        long cost = (endTime - startTime) / 1000L;
        this.releaseLock();
        if (upgradeSucceed) {
            LogUtil.info((String)("Local QingStorage upgrade to DFS succeed, cost time:" + cost + "s"));
            return 0;
        }
        LogUtil.info((String)"Local QingStorage upgrade failed after 1000 trials");
        return 1;
    }

    private void lock() throws Exception {
        QingInterProcessMutex mutex;
        CuratorFramework client = ZKClientUtil.getClient();
        client.blockUntilConnected();
        this.lock = mutex = new QingInterProcessMutex(client, ZK_NODE_RIGHT_TO_UPGRADE);
        int tryCount = 0;
        while (tryCount < 10) {
            ++tryCount;
            try {
                mutex.acquire();
                return;
            }
            catch (Exception e) {
                LogUtil.error((String)"QingStorage upgrade, Acquire ZK lock failed.", (Throwable)e);
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
        }
        throw new Exception("QingStorage upgrade, cannot get ZK lock after " + tryCount + " trails");
    }

    private void releaseLock() {
        try {
            this.lock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        updaters.add(new LocalToDFSUpdater());
        updaters.add(new TempCleanUpdater());
        EnvUtil.init();
    }
}

