/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.io.IObj2Xml;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedFilter;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedJoin;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedTable;
import com.kingdee.cosmic.ctrl.data.modal.query.design.JoinConstant;

public class QueryExt2Xml
implements IObj2Xml {
    @Override
    public IXmlElement makeXML(Object obj) {
        if (obj instanceof DesignedTable) {
            IXmlElement xml = XmlUtil.createNode((String)"DesignedTable");
            DesignedTable dt = (DesignedTable)obj;
            xml.setAttribute("x", String.valueOf(dt.getX()));
            xml.setAttribute("y", String.valueOf(dt.getY()));
            xml.setAttribute("width", String.valueOf(dt.getWidth()));
            xml.setAttribute("height", String.valueOf(dt.getHeight()));
            return xml;
        }
        if (obj instanceof DesignedJoin) {
            IXmlElement xml = XmlUtil.createNode((String)"DesignedJoin");
            xml.setAttribute("fromField", ((DesignedJoin)obj).getFromField());
            xml.setAttribute("toField", ((DesignedJoin)obj).getToField());
            xml.setAttribute("relation", this.transRelation(((DesignedJoin)obj).getRelation()));
            xml.setAttribute("index", String.valueOf(((DesignedJoin)obj).getIndex()));
            return xml;
        }
        if (obj instanceof DesignedFilterList) {
            IXmlElement xml = XmlUtil.createNode((String)"DesignedFilters");
            for (int i = 0; i < ((DesignedFilterList)obj).getFilterList().size(); ++i) {
                DesignedFilter filter = (DesignedFilter)((DesignedFilterList)obj).getFilterList().get(i);
                IXmlElement child = XmlUtil.createNode((String)"DesignedFilter");
                child.setAttribute("leftBracket", filter.getLeftBracket() == null ? "" : filter.getLeftBracket());
                child.setAttribute("expression", filter.getExpression() == null ? "" : filter.getExpression());
                child.setAttribute("operator", filter.getOperator());
                child.setAttribute("value", filter.getValue());
                child.setAttribute("rightBracket", filter.getRightBracket() == null ? "" : filter.getRightBracket());
                child.setAttribute("logic", filter.getLogic() == null ? "" : filter.getLogic());
                xml.addChild(child);
            }
            return xml;
        }
        return null;
    }

    private String transRelation(int relation) {
        String str = JoinConstant.getRelationString(relation);
        return StringUtil.isEmptyString((String)str) ? "=" : str;
    }
}

