/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.data.modal.DataDef;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.Import;
import com.kingdee.cosmic.ctrl.data.modal.Imports;
import com.kingdee.cosmic.ctrl.data.modal.Outputs;
import com.kingdee.cosmic.ctrl.data.modal.ProcessScript;
import com.kingdee.cosmic.ctrl.data.modal.io.ExecDefIO;
import com.kingdee.cosmic.ctrl.data.modal.io.ParameterIO;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Def;
import com.kingdee.cosmic.ctrl.data.modal.io.XmlTool;
import com.kingdee.cosmic.ctrl.data.modal.types.ScriptType;
import com.kingdee.cosmic.ctrl.data.modal.types.rows.io.Xml2OutputColumns;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class Xml2DataDef {
    private static final Logger log = LogUtil.getPackageLogger(Xml2DataDef.class);
    public static HashMap outputDefRegistry = new HashMap();

    public static DataDef toObject(IXmlElement e) {
        DataDef dataObject = new DataDef();
        Xml2DataDef.toObject(dataObject, e);
        return dataObject;
    }

    public static void toObject(DataDef obj, IXmlElement e) {
        Xml2Def.parseDefObj((IDefObj)obj, (IXmlElement)e);
        IXmlElement child = e.getChild("Imports");
        obj.setImports(child == null ? null : Xml2Imports.toObject(child));
        child = e.getChild("Parameters");
        obj.setParameters(child == null ? new ArrayList() : ParameterIO.parseParameters((IXmlElement)child));
        child = e.getChild("ProccessScript");
        obj.setProcessScript(child == null ? null : Xml2ProcessScript.toObject(child));
        child = e.getChild("Outputs");
        obj.setOutputs(child == null ? null : Xml2Outputs.toObject(child));
        child = e.getChild("DesignInfoes");
        obj.setDesignInfoes(child);
    }

    static {
        outputDefRegistry.put("Columns", Xml2OutputColumns.class);
    }

    public static final class Xml2ProcessScript {
        public static ProcessScript toObject(IXmlElement e) {
            String bStr;
            ScriptType st;
            ProcessScript ps = new ProcessScript();
            String scriptType = e.getAttribute("script-type");
            if (scriptType != null && (st = ScriptType.valueOf(scriptType)) != null) {
                ps.setType(st);
                ps.setScript(e.getText());
            }
            if ((bStr = e.getAttribute("auto-make-calling")) != null) {
                ps.setAutoMakeCalling(Boolean.parseBoolean(bStr));
            }
            Xml2Def.parseDefObj((IDefObj)ps, (IXmlElement)e);
            return ps;
        }
    }

    public static final class Xml2Imports {
        public static Imports toObject(IXmlElement e) {
            Imports imports = new Imports();
            try {
                List c = XmlTool.xml2List(e, "Import", Xml2Import.class);
                imports.addAll(c);
            }
            catch (Exception ex) {
                log.error((Object)"err", (Throwable)ex);
                return null;
            }
            return imports;
        }

        public static final class Xml2Import {
            public static Import toObject(IXmlElement e) {
                IXmlElement xmlArgs;
                Import obj = new Import();
                Xml2Def.parseDefObj((IDefObj)obj, (IXmlElement)e);
                String expr = e.getAttribute("expr");
                if (expr != null) {
                    obj.setExpr(expr);
                }
                if ((xmlArgs = e.getChild("Args")) != null) {
                    obj.setArgs(ExecDefIO.parseArgs(xmlArgs));
                }
                return obj;
            }
        }
    }

    public static final class Xml2Outputs {
        public static Outputs toObject(IXmlElement e) {
            if (e == null) {
                return null;
            }
            Outputs outputs = new Outputs();
            for (IXmlElement output_e : e.getChildren()) {
                Object output = Xml2Outputs.xml2Output(output_e);
                if (output == null) continue;
                outputs.add(output);
            }
            return outputs;
        }

        public static Object xml2Output(IXmlElement e) {
            Class xml2ObjClass = (Class)outputDefRegistry.get(e.getName());
            try {
                Method m = xml2ObjClass.getMethod("toObject", IXmlElement.class);
                return m.invoke(null, e);
            }
            catch (Exception ex) {
                log.error(null, (Throwable)ex);
                return null;
            }
        }
    }
}

