/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.data.modal.io.IXml2Obj;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedFilter;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedJoin;
import com.kingdee.cosmic.ctrl.data.modal.query.design.DesignedTable;
import java.util.List;

public class Xml2QueryExt
implements IXml2Obj {
    @Override
    public Object parseXML(IXmlElement xml) {
        String tagName = xml.getName();
        if ("DesignedTable".equals(tagName)) {
            DesignedTable table = new DesignedTable();
            table.setX(Integer.parseInt(xml.getAttribute("x")));
            table.setY(Integer.parseInt(xml.getAttribute("y")));
            table.setWidth(Integer.parseInt(xml.getAttribute("width")));
            table.setHeight(Integer.parseInt(xml.getAttribute("height")));
            return table;
        }
        if ("DesignedJoin".equals(tagName)) {
            DesignedJoin join = new DesignedJoin();
            join.setFromField(xml.getAttribute("fromField"));
            join.setToField(xml.getAttribute("toField"));
            join.setRelation(this.transRelation(xml.getAttribute("relation")));
            join.setIndex(Integer.parseInt(xml.getAttribute("index")));
            return join;
        }
        if ("DesignedFilters".equals(tagName)) {
            List group = xml.getChildren();
            DesignedFilterList filterlist = new DesignedFilterList();
            for (int i = 0; i < group.size(); ++i) {
                DesignedFilter filter = new DesignedFilter();
                IXmlElement element = (IXmlElement)group.get(i);
                filter.setLeftBracket(element.getAttribute("leftBracket"));
                filter.setExpression(element.getAttribute("expression"));
                filter.setOperator(element.getAttribute("operator"));
                filter.setValue(element.getAttribute("value"));
                filter.setRightBracket(element.getAttribute("rightBracket"));
                filter.setLogic(element.getAttribute("logic"));
                filterlist.getFilterList().add(filter);
            }
            return filterlist;
        }
        return null;
    }

    private int transRelation(String relation) {
        if (StringUtil.isEmptyString((String)relation) || relation.equals("=")) {
            return 16;
        }
        if (relation.equals("<>")) {
            return 32;
        }
        if (relation.equals("<")) {
            return 48;
        }
        if (relation.equals("<=")) {
            return 64;
        }
        if (relation.equals(">")) {
            return 80;
        }
        if (relation.equals(">=")) {
            return 96;
        }
        return 16;
    }
}

