/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.data.modal.query.io;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.DataType;
import com.kingdee.cosmic.ctrl.data.modal.IDefObj;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Def;
import com.kingdee.cosmic.ctrl.data.modal.io.Xml2Ext;
import com.kingdee.cosmic.ctrl.data.modal.query.BasicQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.Column;
import com.kingdee.cosmic.ctrl.data.modal.query.Condition;
import com.kingdee.cosmic.ctrl.data.modal.query.IQuery;
import com.kingdee.cosmic.ctrl.data.modal.query.ITable;
import com.kingdee.cosmic.ctrl.data.modal.query.Join;
import com.kingdee.cosmic.ctrl.data.modal.query.JoinType;
import com.kingdee.cosmic.ctrl.data.modal.query.Order;
import com.kingdee.cosmic.ctrl.data.modal.query.QueryType;
import com.kingdee.cosmic.ctrl.data.modal.query.Table;
import com.kingdee.cosmic.ctrl.data.modal.query.framework.ksql.KsqlQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Xml2Query {
    public static IQuery toObject(IXmlElement e) {
        QueryType qt = QueryType.fromName(e.getAttribute("type"));
        IQuery obj = BasicQuery.createQuery(qt);
        if (obj != null) {
            IXmlElement child;
            Xml2Def.parseDefObj((IDefObj)obj, (IXmlElement)e);
            String s = e.getAttribute("distinct");
            if (s != null) {
                obj.setDistinct(Boolean.parseBoolean(s));
            }
            if ((child = e.getChild("Tables")) != null && obj.getTables() != null) {
                obj.getTables().addAll(Xml2Query.parseTables(child));
            }
            if ((child = e.getChild("Joins")) != null && obj.getJoins() != null) {
                obj.getJoins().addAll(Xml2Query.parseJoins(child));
            }
            if ((child = e.getChild("Columns")) != null) {
                obj.getColumns().addAll(Xml2Query.parseColumns(child));
            }
            if ((child = e.getChild("Orders")) != null && obj.getOrders() != null) {
                obj.getOrders().addAll(Xml2Query.parseOrders(child));
            }
            if ((child = e.getChild("Filter")) != null) {
                obj.setFilter(Xml2Query.parseCondition(child));
            }
            if ((child = e.getChild("Content")) != null) {
                obj.setContent(Xml2Query.parseContent(child));
            }
        }
        return obj;
    }

    public static void parseQueryExt(IQuery qry, IXmlElement xmlQry, Xml2Ext xml2ext) {
        IXmlElement eleFilter;
        List lstJoins;
        IXmlElement eleJoins;
        Iterator objItr;
        Iterator xmlItr;
        List lstTables;
        if (!qry.getQueryType().getCapital().equalsIgnoreCase("sql")) {
            return;
        }
        IXmlElement eleTables = xmlQry.getChild("Tables");
        if (eleTables != null && (lstTables = eleTables.getChildren()) != null) {
            xmlItr = lstTables.iterator();
            objItr = qry.getTables().iterator();
            while (objItr.hasNext()) {
                ITable tbl = (ITable)objItr.next();
                IXmlElement tblXmlNode = (IXmlElement)xmlItr.next();
                tbl.setExtObj(xml2ext.parseExtObj(tblXmlNode));
                if (!(tbl instanceof IQuery)) continue;
                Xml2Query.parseQueryExt((IQuery)((Object)tbl), tblXmlNode, xml2ext);
            }
        }
        if ((eleJoins = xmlQry.getChild("Joins")) != null && (lstJoins = eleJoins.searchChildren("Join")) != null) {
            xmlItr = lstJoins.iterator();
            objItr = qry.getJoins().iterator();
            while (objItr.hasNext()) {
                ((Join)((Object)objItr.next())).getCondition().setExtObj(xml2ext.parseExtObj((IXmlElement)((IXmlElement)xmlItr.next()).getChildren().get(0)));
            }
        }
        if ((eleFilter = xmlQry.getChild("Filter")) != null) {
            qry.getFilter().setExtObj(xml2ext.parseExtObj(eleFilter));
        }
    }

    public static ArrayList parseColumns(IXmlElement xmlCols) {
        ArrayList<Column> cols = new ArrayList<Column>();
        List lst = xmlCols.searchChildren("Column");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            cols.add(Xml2Query.parseColumn((IXmlElement)lst.get(i)));
        }
        return cols;
    }

    public static ArrayList parseTables(IXmlElement xmlTbls) {
        ArrayList<ITable> tbls = new ArrayList<ITable>();
        List lst = xmlTbls.getChildren();
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            tbls.add(Xml2Query.parseTable((IXmlElement)lst.get(i)));
        }
        return tbls;
    }

    public static ArrayList parseJoins(IXmlElement xmlQry) {
        if (xmlQry == null) {
            return null;
        }
        ArrayList<Join> joins = new ArrayList<Join>();
        List lst = xmlQry.searchChildren("Join");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            joins.add(Xml2Query.parseJoin((IXmlElement)lst.get(i)));
        }
        return joins;
    }

    public static ArrayList parseOrders(IXmlElement xmlOrds) {
        if (xmlOrds == null) {
            return null;
        }
        ArrayList<Order> ords = new ArrayList<Order>();
        List lst = xmlOrds.searchChildren("Order");
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            ords.add(Xml2Query.parseOrder((IXmlElement)lst.get(i)));
        }
        return ords;
    }

    public static Column parseColumn(IXmlElement xmlCol) {
        Column col = new Column();
        Xml2Def.parseDefObj((IDefObj)col, (IXmlElement)xmlCol);
        col.setDataType(DataType.fromName((String)xmlCol.getAttribute("dataType")));
        col.setExpr(xmlCol.getAttribute("expr"));
        return col;
    }

    public static ITable parseTable(IXmlElement xmlTbl) {
        if ("Table".equals(xmlTbl.getName())) {
            Table tbl = new Table();
            Xml2Def.parseDefObj((IDefObj)tbl, (IXmlElement)xmlTbl);
            tbl.setExpr(xmlTbl.getAttribute("expr"));
            return tbl;
        }
        if ("Query".equals(xmlTbl.getName())) {
            KsqlQuery subQuery = (KsqlQuery)Xml2Query.toObject(xmlTbl);
            return subQuery;
        }
        return null;
    }

    public static Join parseJoin(IXmlElement xmlJoin) {
        Join join = new Join();
        join.setLeftTable(xmlJoin.getAttribute("leftTable"));
        join.setRightTable(xmlJoin.getAttribute("rightTable"));
        join.setJoinType(JoinType.fromName(xmlJoin.getAttribute("joinType")));
        Condition cnd = Xml2Query.parseCondition((IXmlElement)xmlJoin.getChildren().get(0));
        join.setCondition(cnd);
        return join;
    }

    public static Order parseOrder(IXmlElement xmlOrd) {
        Order ord = new Order();
        Xml2Def.parseDefObj((IDefObj)ord, (IXmlElement)xmlOrd);
        ord.setExpr(xmlOrd.getAttribute("expr"));
        ord.setAscending(!"desc".equals(xmlOrd.getAttribute("orderType")));
        return ord;
    }

    public static Condition parseCondition(IXmlElement xml) {
        if (xml == null) {
            return null;
        }
        Condition cnd = new Condition();
        cnd.setExpr(xml.getText());
        return cnd;
    }

    public static String parseContent(IXmlElement xml) {
        if (xml == null) {
            return null;
        }
        return xml.getText();
    }
}

