/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.config;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public final class BOSConfig {
    private File configFile;
    private IXmlElement root;
    private HashMap infoMap;
    private BOSInfo[] bosis;

    public BOSConfig(String fileName) {
        this.configFile = new File(FilenameUtils.normalize((String)fileName));
        if (!this.configFile.exists()) {
            throw new RuntimeException("Can not find config file: " + fileName);
        }
        this.loadFile();
    }

    private void loadFile() {
        try {
            this.root = XmlUtil.loadRootElement((InputStream)new FileInputStream(this.configFile));
        }
        catch (IOException err) {
            throw new RuntimeException("Failed loading File", err);
        }
        catch (XmlParsingException e) {
            throw new RuntimeException("Failed loading File", e);
        }
        this.infoMap = new HashMap();
        List bosconns = this.root.searchChildren("BOSConnection");
        for (int i = 0; i < bosconns.size(); ++i) {
            IXmlElement ele = (IXmlElement)bosconns.get(i);
            BOSInfo bosi = new BOSInfo();
            bosi.id = ele.getAttribute("id");
            bosi.solution = ele.getChild("Solution").getText();
            bosi.ais = ele.getChild("AIS").getText();
            bosi.locale = ele.getChild("Locale").getText();
            bosi.user = ele.getChild("User").getText();
            bosi.pwd = ele.getChild("Pwd").getText();
            bosi.url = ele.getChild("URL").getText();
            this.infoMap.put(bosi.id, bosi);
        }
    }

    public BOSInfo getBOSInfo(String id) {
        return (BOSInfo)this.infoMap.get(id);
    }

    public BOSInfo getBOSInfo(int idx) {
        if (this.bosis == null) {
            this.bosis = this.infoMap.values().toArray(new BOSInfo[0]);
        }
        if (idx < 0 || idx >= this.bosis.length) {
            return null;
        }
        return this.bosis[idx];
    }

    public int getBOSInfoSize() {
        return this.infoMap.size();
    }

    public static final class BOSInfo {
        public String id;
        public String user;
        public String pwd;
        public String solution;
        public String ais;
        public String locale;
        public String url;
    }
}

