/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.config;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.data.config.DBInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public final class DBConfig {
    private File configFile;
    private IXmlElement root;
    private HashMap infoMap;
    private DBInfo[] dbis;

    public DBConfig(String fileName) {
        this.configFile = new File(FilenameUtils.normalize((String)fileName));
        if (!this.configFile.exists()) {
            throw new RuntimeException("Can not find Config file: " + fileName);
        }
        this.loadFile();
    }

    public DBInfo getDBInfo(String id) {
        return (DBInfo)this.infoMap.get(id);
    }

    public DBInfo getDBInfo(int idx) {
        if (this.dbis == null) {
            this.dbis = this.infoMap.values().toArray(new DBInfo[0]);
        }
        if (idx < 0 || idx >= this.dbis.length) {
            return null;
        }
        return this.dbis[idx];
    }

    public int getDBInfoSize() {
        return this.infoMap.size();
    }

    private void loadFile() {
        try {
            this.root = XmlUtil.loadRootElement((InputStream)new FileInputStream(this.configFile));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed loading file", e);
        }
        catch (XmlParsingException e) {
            throw new RuntimeException("Failed loading file", e);
        }
        this.infoMap = new HashMap();
        List dbconns = this.root.searchChildren("DBConnection");
        if (dbconns.size() > 0) {
            for (int i = 0; i < dbconns.size(); ++i) {
                IXmlElement ele = (IXmlElement)dbconns.get(i);
                DBInfo dbi = new DBInfo();
                dbi.id = ele.getAttribute("id");
                dbi.connection = ele.getChild("Connection").getText();
                dbi.dbType = ele.getChild("DBType").getText();
                dbi.driver = ele.getChild("Driver").getText();
                dbi.user = ele.getChild("User").getText();
                dbi.pwd = ele.getChild("Password").getText();
                this.infoMap.put(dbi.id, dbi);
            }
        } else {
            DBInfo dbi = new DBInfo();
            dbi.id = "default";
            dbi.connection = this.root.getChild("Connection").getText();
            dbi.dbType = this.root.getChild("DBType").getText();
            dbi.driver = this.root.getChild("Driver").getText();
            dbi.user = this.root.getChild("User").getText();
            dbi.pwd = this.root.getChild("Password").getText();
            this.infoMap.put(dbi.id, dbi);
        }
    }
}

