/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.datasource;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import java.util.List;

public final class BOSQueryDataSource
extends DataSource {
    private String source;
    private int type = 1;
    private String name;
    private String packageName;
    private String connectionID;
    private boolean linked = false;
    public static final int TYPE_ENTITY = 0;
    public static final int TYPE_QUERY = 1;

    public BOSQueryDataSource() {
    }

    public BOSQueryDataSource(String id, String pkName, String name) {
        super(id);
        this.packageName = pkName;
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public boolean isLinked() {
        return this.linked;
    }

    @Override
    public Object readFromNode(IXmlElement ele) {
        IXmlElement eleEntity;
        String src;
        this.setID(ele.getAttribute("id").trim());
        this.setUri(ele.getAttribute("uri"));
        IXmlElement dsn = ele.getChild("DesignedDataSource");
        if (dsn != null) {
            this.setUserObject(dsn);
        }
        IXmlElement eleSource = ele.getChild("BosQueryDataSource");
        this.connectionID = eleSource.getAttribute("connection");
        String type = eleSource.getAttribute("type");
        if (type != null) {
            if (type.equalsIgnoreCase("entity")) {
                this.type = 0;
            } else if (type.equalsIgnoreCase("query")) {
                this.type = 1;
            }
        }
        if ((src = (eleEntity = eleSource.getChild("QueryXmlSource")).getAttribute("src")) != null && src.trim().length() > 0) {
            this.linked = true;
            this.setSource(src);
        } else {
            this.setSource(KDFXmlReader.readNodeContentSource(eleEntity));
        }
        this.name = eleEntity.getAttribute("name");
        this.packageName = eleEntity.getAttribute("package");
        this.setParams(this.resolveParamsNode(eleSource));
        return this;
    }

    @Override
    public IXmlElement writeToNode() {
        IXmlElement eleDS = this.createDSNode();
        eleDS.setAttribute("id", this.getID());
        if (this.getUri() != null) {
            eleDS.setAttribute("uri", this.getUri());
        }
        IXmlElement eleSource = XmlUtil.createNode((String)"BosQueryDataSource");
        if (this.connectionID != null) {
            eleSource.setAttribute("connection", this.connectionID);
        }
        switch (this.type) {
            case 0: {
                eleSource.setAttribute("type", "entity");
                break;
            }
            case 1: {
                eleSource.setAttribute("type", "query");
                break;
            }
        }
        eleDS.addChild(eleSource);
        if (this.getUserObject() instanceof IXmlElement) {
            eleDS.addChild((IXmlElement)this.getUserObject());
        }
        IXmlElement eleEntity = XmlUtil.createNode((String)"QueryXmlSource");
        if (this.isLinked()) {
            eleEntity.setAttribute("src", this.source);
        } else {
            eleEntity.addCData(this.source);
        }
        eleEntity.setAttribute("name", this.name);
        eleEntity.setAttribute("package", this.packageName);
        eleSource.addChild(eleEntity);
        eleSource.addChild(this.buildParamsNode());
        return eleDS;
    }

    public void setSortFields(List sorts) {
        this._sorts = sorts;
    }
}

