/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.datasource;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.EntityDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.ObjectDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.ReferencedDataSource;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSource {
    private String ID;
    private ArrayList params;
    private Object userObject;
    private String uri;
    protected List _sorts = new ArrayList();

    public DataSource() {
        this.ID = "";
        this.params = new ArrayList();
    }

    public DataSource(String id) {
        this.ID = id;
        this.params = new ArrayList();
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String strID) {
        this.ID = strID;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public ArrayList getParams() {
        return this.params;
    }

    public void setParams(ArrayList list) {
        this.params = list;
    }

    public void addParam(DSParam param) {
        this.params.add(param);
    }

    public abstract String getSource();

    public abstract void setSource(String var1);

    public abstract boolean isLinked();

    public IXmlElement createDSNode() {
        IXmlElement ds = XmlUtil.createNode((String)"DataSource");
        return ds;
    }

    public abstract Object readFromNode(IXmlElement var1);

    public abstract IXmlElement writeToNode();

    public static DataSource buildFromNode(IXmlElement dsNode, KDF kdf) {
        DataSource ds;
        IXmlElement cNode = (IXmlElement)dsNode.getChildren().get(0);
        if ("Reference".equals(cNode.getName().trim())) {
            ds = new ReferencedDataSource(kdf);
        } else if ("ObjectDataSource".equals(cNode.getName().trim())) {
            ds = new ObjectDataSource();
        } else if ("DBConnectionDataSource".equals(cNode.getName().trim())) {
            ds = new JDBCDataSource();
        } else if ("EntityDataSource".equals(cNode.getName().trim())) {
            ds = new EntityDataSource();
        } else if ("BosQueryDataSource".equals(cNode.getName().trim())) {
            ds = new BOSQueryDataSource();
        } else {
            throw new RuntimeException("Not a valid dataSource node type");
        }
        ((DataSource)ds).readFromNode(dsNode);
        return ds;
    }

    protected IXmlElement buildParamsNode() {
        IXmlElement nodeParams = XmlUtil.createNode((String)"Params");
        for (int i = 0; i < this.params.size(); ++i) {
            DSParam param = (DSParam)this.getParams().get(i);
            IXmlElement node = XmlUtil.createNode((String)"Param");
            node.setAttribute("dataType", param.getDataType());
            node.setAttribute("source", param.getFrom());
            IXmlElement nodeName = XmlUtil.createNode((String)"ColName");
            nodeName.addCData(param.getColName());
            node.addChild(nodeName);
            IXmlElement nodeParent = XmlUtil.createNode((String)"Associate");
            nodeParent.setAttribute("dataSourceID", param.getAssociateSource());
            nodeParent.addCData(param.getAssociateField());
            if ("value".equalsIgnoreCase(param.getFrom())) {
                nodeParent.addCData(param.getValue().toString());
            }
            node.addChild(nodeParent);
            nodeParams.addChild(node);
        }
        return nodeParams;
    }

    protected ArrayList resolveParamsNode(IXmlElement node) {
        ArrayList<DSParam> list = new ArrayList<DSParam>();
        IXmlElement nodeParam = node.getChild("Params");
        List allNodes = nodeParam.getChildren();
        for (int i = 0; i < allNodes.size(); ++i) {
            nodeParam = (IXmlElement)allNodes.get(i);
            DSParam param = new DSParam(nodeParam.getChild("ColName").getText(), nodeParam.getChild("Associate").getAttribute("dataSourceID"), nodeParam.getChild("Associate").getText());
            String from = nodeParam.getAttribute("source");
            String dataType = nodeParam.getAttribute("dataType");
            String value = nodeParam.getChild("Associate").getText();
            param.setFrom(from);
            param.setDataType(dataType);
            if ("value".equalsIgnoreCase(from)) {
                param.setValue(dataType, value);
            }
            list.add(param);
        }
        return list;
    }
}

