/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.datasource;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;

public final class ObjectDataSource
extends DataSource {
    private String objectID;

    public ObjectDataSource() {
    }

    public ObjectDataSource(String id, String objID) {
        super(id);
        this.objectID = objID;
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    @Override
    public String getSource() {
        return this.objectID;
    }

    @Override
    public void setSource(String objectID) {
        this.objectID = objectID;
    }

    @Override
    public Object readFromNode(IXmlElement ele) {
        this.setID(ele.getAttribute("id").trim());
        IXmlElement dsn = ele.getChild("DesignedDataSource");
        if (dsn != null) {
            this.setUserObject(dsn);
        }
        this.objectID = ele.getChild("ObjectDataSource").getAttribute("objectKey");
        this.setParams(this.resolveParamsNode(ele.getChild("ObjectDataSource")));
        return this;
    }

    @Override
    public IXmlElement writeToNode() {
        IXmlElement eleDS = this.createDSNode();
        IXmlElement eleObjDS = XmlUtil.createNode((String)"ObjectDataSource");
        eleObjDS.setAttribute("objectKey", this.objectID == null ? "" : this.objectID);
        eleObjDS.addChild(this.buildParamsNode());
        eleDS.addChild(eleObjDS);
        if (this.getUserObject() instanceof IXmlElement) {
            eleDS.addChild((IXmlElement)this.getUserObject());
        }
        eleDS.setAttribute("id", this.getID());
        return eleDS;
    }
}

