/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.cosmic.ctrl.kdf.data.impl.BOSConnection;
import com.kingdee.cosmic.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.cosmic.ctrl.kdf.data.impl.RowSetVisitor;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class BOSQuerySetVisitor
implements DataSetVisitor {
    private static final Logger log = LogUtil.getLogger(BOSQuerySetVisitor.class);
    private RowSetVisitor rsvisitor;
    private int type = 1;
    private String name;
    private String packageName;
    private String connectionID;
    private BOSQueryDataSource ds;
    private BOSQueryDelegate delegate;

    public BOSQueryDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(BOSQueryDelegate delegate) {
        this.delegate = delegate;
    }

    public BOSQueryDataSource getDs() {
        return this.ds;
    }

    public void setDs(BOSQueryDataSource ds) {
        this.ds = ds;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public BOSQuerySetVisitor(String connectionID) {
        this.connectionID = connectionID;
    }

    @Override
    public boolean execute(String sName, String sQuery) throws DataSetWrapperException {
        IRowSet rs = null;
        try {
            if (this.delegate != null) {
                StringBuilder sbInfo = new StringBuilder("BOSQuery delegate execute. DS's ID:");
                sbInfo.append(this.ds.getID());
                log.info((Object)sbInfo.toString());
                long time = System.currentTimeMillis();
                rs = this.delegate.execute(this.ds);
                time = System.currentTimeMillis() - time;
                sbInfo.insert(0, "After ");
                sbInfo.append(" Used time:");
                sbInfo.append(time);
                log.info((Object)sbInfo.toString());
            } else {
                BOSConnection.instance().getConnection(this.connectionID);
                switch (this.type) {
                    case 0: {
                        IDataProvider prov = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(this.packageName, this.name));
                        EntityViewInfo view = new EntityViewInfo();
                        prov.setObjectView(view);
                        rs = prov.executeQuery();
                        break;
                    }
                    case 1: {
                        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(this.packageName, this.name));
                        exec.option().isAutoTranslateEnum = true;
                        rs = exec.executeQuery();
                        break;
                    }
                }
            }
            if (rs != null) {
                this.rsvisitor = new RowSetVisitor(rs);
                this.rsvisitor.execute(this.name, sQuery);
                return true;
            }
        }
        catch (BOSException e) {
            throw new DataSetWrapperException(e);
        }
        return false;
    }

    @Override
    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        if (this.rsvisitor != null) {
            return this.rsvisitor.next(avOut);
        }
        return false;
    }

    @Override
    public boolean isValidRow() throws DataSetWrapperException {
        if (this.rsvisitor != null) {
            return this.rsvisitor.isValidRow();
        }
        return false;
    }

    @Override
    public int getFieldCount() {
        if (this.rsvisitor != null) {
            return this.rsvisitor.getFieldCount();
        }
        return 0;
    }

    @Override
    public String[] getAllFieldName() {
        if (this.rsvisitor != null) {
            return this.rsvisitor.getAllFieldName();
        }
        return new String[0];
    }

    @Override
    public int getRecordCount() {
        if (this.rsvisitor != null) {
            return this.rsvisitor.getRecordCount();
        }
        return 0;
    }
}

