/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.param;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.cosmic.ctrl.kdf.data.Row;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeDataService;
import com.kingdee.cosmic.ctrl.kdf.formatter.DateParser;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public final class ReportParam
implements Serializable {
    private static final Logger logger = LogUtil.getPackageLogger(ReportParam.class);
    private static final long serialVersionUID = -4400346797214952810L;
    private String id;
    private String label;
    private String dataType = "string";
    private String hint;
    private boolean allowNull = true;
    private boolean allowBlank = true;
    private String defaultDataSourceID;
    private String defaultValueField;
    private String defaultValue;
    private String validDataSourceID;
    private String validValueField;
    private String validLabelField;
    private String[] validValues;
    private String[] validLabels;
    private Variant[] vdVals;
    private String[] vdLabs;
    private Variant defValue;
    private Variant value;
    private boolean inited;
    private static final Variant[] VVO = new Variant[0];
    private static final String[] VLO = new String[0];
    private RuntimeDataService rds;

    public ReportParam(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setRuntimeDataService(RuntimeDataService rds) {
        this.rds = rds;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Variant getValue() {
        if (!this.inited) {
            return this.getRuntimeDefaultValue();
        }
        return this.value;
    }

    public boolean setValue(Variant value) {
        if (this.checkValid(value)) {
            this.value = value;
            this.inited = true;
            return true;
        }
        return false;
    }

    public void reset() {
        this.value = null;
        this.defValue = null;
        this.vdVals = null;
        this.vdLabs = null;
        this.inited = false;
    }

    public Variant getRuntimeDefaultValue() {
        block12: {
            if (this.defValue != null) {
                return this.defValue;
            }
            if (this.defaultValue != null) {
                try {
                    if ("number".equals(this.dataType)) {
                        this.defValue = new Variant((Object)new BigDecimal(this.defaultValue), 10);
                        break block12;
                    }
                    if ("datetime".equals(this.dataType)) {
                        this.defValue = new Variant((Object)DateParser.pasterDate((String)this.defaultValue), 12);
                        break block12;
                    }
                    this.defValue = new Variant((Object)this.defaultValue, 11);
                }
                catch (Exception e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            } else if (this.defaultDataSourceID != null && this.rds != null) {
                DataSetWrapper dsw = this.rds.getDataSet(this.defaultDataSourceID);
                if (dsw.isBOF() && dsw.hasNext()) {
                    dsw.next();
                }
                Row row = dsw.getRow();
                if (this.defaultValueField != null) {
                    this.defValue = row.get(this.defaultValueField);
                } else if (row.getFields().length > 0) {
                    this.defValue = row.get(0);
                }
            }
        }
        return this.defValue;
    }

    private void buildValidVals() {
        if (this.validValues != null) {
            int i;
            this.vdVals = new Variant[this.validValues.length];
            for (i = 0; i < this.validValues.length; ++i) {
                try {
                    if ("number".equals(this.dataType)) {
                        this.vdVals[i] = new Variant((Object)new BigDecimal(this.validValues[i]), 10);
                        continue;
                    }
                    if ("datetime".equals(this.dataType)) {
                        this.vdVals[i] = new Variant((Object)DateParser.pasterDate((String)this.validValues[i]), 12);
                        continue;
                    }
                    this.vdVals[i] = new Variant((Object)this.validValues[i], 11);
                    continue;
                }
                catch (Exception e) {
                    this.vdVals[i] = new Variant();
                    logger.error((Object)"err", (Throwable)e);
                }
            }
            if (this.validLabels != null) {
                if (this.vdVals.length == 0) {
                    this.vdLabs = VLO;
                } else {
                    this.vdLabs = new String[this.vdVals.length];
                    Arrays.fill(this.vdLabs, "");
                    for (i = 0; i < this.validLabels.length && i < this.vdLabs.length; ++i) {
                        this.vdLabs[i] = this.validLabels[i];
                    }
                }
            } else {
                this.vdLabs = this.validValues;
            }
        } else if (this.validDataSourceID != null && this.rds != null) {
            DataSetWrapper dsw = this.rds.getDataSet(this.defaultDataSourceID);
            ArrayList<Variant> alv = new ArrayList<Variant>();
            ArrayList<String> all = new ArrayList<String>();
            while (dsw.hasNext()) {
                dsw.next();
                Row row = dsw.getRow();
                if (this.validValueField == null) continue;
                Variant vval = row.get(this.validValueField);
                alv.add(vval);
                if (this.validLabelField != null) {
                    Variant vlab = row.get(this.validLabelField);
                    all.add(vlab.toString());
                    continue;
                }
                all.add(vval.toString());
            }
            if (alv.size() == 0) {
                this.vdVals = VVO;
                this.vdLabs = VLO;
            } else {
                this.vdVals = alv.toArray(new Variant[0]);
                this.vdLabs = all.toArray(new String[0]);
            }
        } else {
            this.vdVals = VVO;
            this.vdLabs = VLO;
        }
    }

    public Variant[] getRuntimeValidValues() {
        if (this.vdVals == null) {
            this.buildValidVals();
        }
        return this.vdVals;
    }

    public String[] getRuntimeValidLabels() {
        if (this.vdVals == null) {
            this.buildValidVals();
        }
        return this.vdLabs;
    }

    public boolean checkValid(Variant val) {
        if (val == null) {
            throw new AssertionError((Object)"argument [val] can not be null");
        }
        if (this.vdVals == null) {
            this.buildValidVals();
        }
        if (!this.allowNull && val.getValue() == null) {
            return false;
        }
        if (!this.allowBlank && val.getVt() == 11 && val.toString().length() == 0) {
            return false;
        }
        boolean match = this.vdVals.length == 0;
        try {
            for (int i = 0; i < this.vdVals.length; ++i) {
                if (!val.equals(this.vdVals[i])) continue;
                match = true;
                break;
            }
        }
        catch (SyntaxErrorException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return match;
    }

    public boolean isAllowBlank() {
        return this.allowBlank;
    }

    public void setAllowBlank(boolean allowBlank) {
        this.allowBlank = allowBlank;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getDefaultDataSourceID() {
        return this.defaultDataSourceID;
    }

    public void setDefaultDataSourceID(String defaultDataSourceID) {
        this.defaultDataSourceID = defaultDataSourceID;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValueField() {
        return this.defaultValueField;
    }

    public void setDefaultValueField(String defaultValueField) {
        this.defaultValueField = defaultValueField;
    }

    public String getValidDataSourceID() {
        return this.validDataSourceID;
    }

    public void setValidDataSourceID(String validDataSourceID) {
        this.validDataSourceID = validDataSourceID;
    }

    public String getValidLabelField() {
        return this.validLabelField;
    }

    public void setValidLabelField(String validLabelField) {
        this.validLabelField = validLabelField;
    }

    public String[] getValidLabels() {
        return this.validLabels;
    }

    public void setValidLabels(String[] validLabels) {
        this.validLabels = validLabels;
    }

    public String getValidValueField() {
        return this.validValueField;
    }

    public void setValidValueField(String validValueField) {
        this.validValueField = validValueField;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public void setValidValues(String[] validValues) {
        this.validValues = validValues;
    }

    public IXmlElement writeToNode() {
        IXmlElement dvals;
        IXmlElement dsref;
        IXmlElement elm = XmlUtil.createNode((String)"Param");
        elm.setAttribute("id", this.id == null ? "" : this.id);
        if (this.label != null) {
            elm.setAttribute("label", this.label);
        }
        if (this.hint != null) {
            elm.setAttribute("hint", this.hint);
        }
        if (this.dataType != null && !"string".equals(this.dataType)) {
            elm.setAttribute("dataType", this.dataType);
        }
        if (!this.allowNull) {
            elm.setAttribute("allowNull", String.valueOf(this.allowNull));
        }
        if (!this.allowBlank) {
            elm.setAttribute("allowBlank", String.valueOf(this.allowBlank));
        }
        if (this.defaultDataSourceID != null || this.defaultValue != null) {
            IXmlElement delm = XmlUtil.createNode((String)"DefaultValue");
            elm.addChild(delm);
            if (this.defaultDataSourceID != null) {
                dsref = XmlUtil.createNode((String)"DataSourceRef");
                delm.addChild(dsref);
                dsref.setAttribute("dataSourceID", this.defaultDataSourceID);
                dsref.setAttribute("valueField", this.defaultValueField);
            } else {
                dvals = XmlUtil.createNode((String)"DataValues");
                delm.addChild(dvals);
                IXmlElement dval = XmlUtil.createNode((String)"DataValue");
                dvals.addChild(dval);
                dval.addCData(this.defaultValue);
            }
        }
        if (this.validDataSourceID != null || this.validValues != null) {
            IXmlElement velm = XmlUtil.createNode((String)"ValidValues");
            elm.addChild(velm);
            if (this.validDataSourceID != null) {
                dsref = XmlUtil.createNode((String)"DataSourceRef");
                velm.addChild(dsref);
                dsref.setAttribute("dataSourceID", this.validDataSourceID);
                dsref.setAttribute("valueField", this.validValueField);
                if (this.validLabelField != null) {
                    dsref.setAttribute("labelField", this.validLabelField);
                }
            } else {
                dvals = XmlUtil.createNode((String)"DataValues");
                velm.addChild(dvals);
                for (int i = 0; i < this.validValues.length; ++i) {
                    IXmlElement dval = XmlUtil.createNode((String)"DataValue");
                    dvals.addChild(dval);
                    dval.addCData(this.validValues[i]);
                    if (this.validLabels == null) continue;
                    dval.setAttribute("label", this.validLabels[i]);
                }
            }
        }
        return elm;
    }

    public static ReportParam readFromNode(IXmlElement elem) {
        if (elem != null && "Param".equals(elem.getName().trim())) {
            IXmlElement validVals;
            IXmlElement defaultVal;
            ReportParam rp = new ReportParam(elem.getAttribute("id"));
            rp.setHint(elem.getAttribute("hint"));
            rp.setLabel(elem.getAttribute("label"));
            if (elem.getAttribute("dataType") != null) {
                rp.setDataType(elem.getAttribute("dataType"));
            }
            if (elem.getAttribute("allowNull") != null) {
                rp.setAllowNull(Boolean.parseBoolean(elem.getAttribute("allowNull")));
            }
            if (elem.getAttribute("allowBlank") != null) {
                rp.setAllowBlank(Boolean.parseBoolean(elem.getAttribute("allowBlank")));
            }
            if ((defaultVal = elem.getChild("DefaultValue")) != null) {
                IXmlElement defaultDsRef = defaultVal.getChild("DataSourceRef");
                if (defaultDsRef != null) {
                    rp.setDefaultDataSourceID(defaultDsRef.getAttribute("dataSourceID"));
                    rp.setDefaultValueField(defaultDsRef.getAttribute("valueField"));
                } else {
                    IXmlElement data;
                    IXmlElement defaultDatas = defaultVal.getChild("DataValues");
                    if (defaultDatas != null && (data = defaultDatas.getChild("DataValue")) != null) {
                        rp.setDefaultValue(data.getText());
                    }
                }
            }
            if ((validVals = elem.getChild("ValidValues")) != null) {
                IXmlElement validDsRef = validVals.getChild("DataSourceRef");
                if (validDsRef != null) {
                    rp.setValidDataSourceID(validDsRef.getAttribute("dataSourceID"));
                    rp.setValidValueField(validDsRef.getAttribute("valueField"));
                    rp.setValidLabelField(validDsRef.getAttribute("labelField"));
                } else {
                    IXmlElement validDatas = validVals.getChild("DataValues");
                    if (validDatas != null) {
                        List lst = validDatas.searchChildren("DataValue");
                        String[] vds = new String[lst.size()];
                        String[] vls = new String[lst.size()];
                        for (int i = 0; i < lst.size(); ++i) {
                            IXmlElement edm = (IXmlElement)lst.get(i);
                            vds[i] = edm.getText();
                            vls[i] = edm.getAttribute("label");
                        }
                        rp.setValidValues(vds);
                        rp.setValidLabels(vls);
                    }
                }
            }
            return rp;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isHasDefaultValue() {
        Variant v = this.getRuntimeDefaultValue();
        return v != null;
    }

    public boolean isHasValidValues() {
        Variant[] vs = this.getRuntimeValidValues();
        return vs != null && vs.length > 0;
    }
}

