/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.wizard;

import com.kingdee.cosmic.ctrl.common.layout.table.Table;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryFilter;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryJoin;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryTable;
import com.kingdee.cosmic.ctrl.kdf.data.query.SqlType;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentSuperPanel;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.EditorSuperDialog;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataManager;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.SuperFormulaWizard;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class EditorFormula
extends EditorSuperDialog {
    private static final Logger logger = LogUtil.getPackageLogger(EditorFormula.class);
    private static final long serialVersionUID = 2387341999843556042L;
    private DataFormulaWizard panFW;

    public EditorFormula(Dialog owner, int type, Object srcObj, Object srcObjClone, KDQuery note) {
        super(type, srcObj, srcObjClone, owner);
        this.panFW = new DataFormulaWizard(note);
        this.installComponent();
        this.btnFormula.setVisible(false);
    }

    private void installComponent() {
        TableLayout tl = TableLayout.split((int)1, (int)1);
        this.getCenterPanel().setLayout((LayoutManager)tl);
        this.getCenterPanel().add((Component)((Object)this.panFW), tl.cell(0));
    }

    @Override
    protected void btnOK() {
        this.panFW.btnOK();
        super.btnOK();
    }

    private class DataFormulaWizard
    extends SuperFormulaWizard
    implements ActionListener {
        private static final long serialVersionUID = 780232061284182731L;
        private KDQuery note;
        private KDComboBox cmbData;
        private KDComboBox cmbFunc;
        private KDList lstData;
        private KDList lstFunc;
        private KDWorkButton btnData;
        private KDWorkButton btnFunc;
        private Object[] objOper = new Object[]{"(", ")", "'", "\"", "=", "NOT", "AND", "OR", "LIKE", "EXISTS", "*", "/", "%", "+", "-", "<", ">", "<>"};
        private Object[] objNum = new Object[]{"ABS", "ACOS", "ASIN", "ATAN", "ATN2", "CEILING", "COS", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "PI", "POWER", "RADIANS", "RAND", "ROUND", "SIN", "SQRT", "SQUEARE", "TAN"};
        private Object[] objStr = new Object[]{"ASCII", "CHAR", "CHARINDEX", "DIFFERENCE", "LEFT", "LEN", "LOWER", "LTRIM", "NCHAR", "PATINDEX", "QUOTENAME", "REPLACE", "REPLICATE", "REVERSE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "STR", "STUFF", "SUBSTRING", "UNICODE", "UPPER"};
        private Object[] objDate = new Object[]{"DATEADD", "DATEDIFF", "DATENAME", "DATEPART", "DAY", "GETDATE", "MONTH", "YEAR"};

        public DataFormulaWizard(KDQuery note) {
            this.note = note;
            this.initComponent();
            this.installComponent();
            this.installListener();
            this.initDataInCtrl();
        }

        private void initDataInCtrl() {
            switch (EditorFormula.this.getDataType()) {
                case 13: {
                    this.txaFormula.setText(((QueryJoin)EditorFormula.this.getSrcObj()).getFormula());
                    EditorFormula.this.setTitle(this.getMLS("joinFormular", "\u5173\u8054\u516c\u5f0f"));
                    this.cmbType.getLabelContainer().setVisible(false);
                    break;
                }
                case 14: {
                    this.txaFormula.setText(((QueryFilter)EditorFormula.this.getSrcObj()).getFormula());
                    EditorFormula.this.setTitle(this.getMLS("filterFormular", "\u8fc7\u6ee4\u516c\u5f0f"));
                    this.cmbType.getLabelContainer().setVisible(false);
                    break;
                }
                case 12: {
                    this.txaFormula.setText(((QueryColumn)EditorFormula.this.getSrcObj()).getFormula());
                    EditorFormula.this.setTitle(this.getMLS("fieldFormular", "\u5b57\u6bb5\u516c\u5f0f"));
                    this.cmbType.setSelectedItem((Object)((QueryColumn)EditorFormula.this.getSrcObj()).getType());
                    break;
                }
            }
            this.initCmbData(EditorFormula.this.getDataType());
            this.initCmbFunc();
            this.changeLst4ComFunc();
            this.changeLst4ComData();
        }

        private void initCmbFunc() {
            DefaultComboBoxModel modFunc = (DefaultComboBoxModel)this.cmbFunc.getModel();
            modFunc.addElement(this.getMLS("operator", "\u64cd\u4f5c\u7b26"));
            modFunc.addElement(this.getMLS("number", "\u6570\u5b57"));
            modFunc.addElement(this.getMLS("string", "\u5b57\u7b26\u4e32"));
            modFunc.addElement(this.getMLS("date", "\u65e5\u671f"));
        }

        private void initCmbData(int dataType) {
            DefaultComboBoxModel modData = (DefaultComboBoxModel)this.cmbData.getModel();
            Iterator it = null;
            if (dataType == 14) {
                QueryTable qryTab = new QueryTable(KDDataManager.getID("QueryTable", null), this.note, this.note.getName());
                modData.addElement(qryTab);
            }
            if (dataType == 13) {
                modData.addElement(((QueryJoin)EditorFormula.this.getSrcObj()).getFirstTable());
                if (((QueryJoin)EditorFormula.this.getSrcObj()).getSecondTable() != ((QueryJoin)EditorFormula.this.getSrcObj()).getFirstTable()) {
                    modData.addElement(((QueryJoin)EditorFormula.this.getSrcObj()).getSecondTable());
                }
            } else {
                it = this.note.getSubQueryList().iterator();
                while (it.hasNext()) {
                    modData.addElement((QueryTable)it.next());
                }
            }
        }

        private void initComponent() {
            this.cmbData = new KDComboBox();
            this.cmbFunc = new KDComboBox();
            this.lstData = new KDList();
            this.lstFunc = new KDList();
            this.btnData = new KDWorkButton((Icon)ContentSuperPanel.IMG_MOVERIGHT);
            this.btnData.setToolTipText(this.getMLS("select", "\u9009\u7528"));
            this.btnData.setPreferredSize(new Dimension(30, 19));
            this.btnFunc = new KDWorkButton((Icon)ContentSuperPanel.IMG_MOVERIGHT);
            this.btnFunc.setToolTipText(this.getMLS("select", "\u9009\u7528"));
        }

        private void installListener() {
            this.cmbData.addActionListener((ActionListener)this);
            this.cmbFunc.addActionListener((ActionListener)this);
            this.btnData.addActionListener((ActionListener)this);
            this.btnFunc.addActionListener((ActionListener)this);
            this.lstData.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        DataFormulaWizard.this.lstDataDblClk();
                    }
                }
            });
            this.lstFunc.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        DataFormulaWizard.this.lstFuncDblClk();
                    }
                }
            });
        }

        private void installComponent() {
            KDLabelContainer lbcData = new KDLabelContainer((JComponent)this.cmbData);
            lbcData.setBoundLabelText(this.getMLS("data", "\u6570\u636e"));
            lbcData.setBoundLabelLength(60);
            lbcData.setBoundLabelUnderline(true);
            KDLabelContainer lbcFunc = new KDLabelContainer((JComponent)this.cmbFunc);
            lbcFunc.setBoundLabelText(this.getMLS("func", "\u51fd\u6570"));
            lbcFunc.setBoundLabelLength(60);
            lbcFunc.setBoundLabelUnderline(true);
            KDScrollPane scpData = new KDScrollPane((Component)this.lstData);
            KDScrollPane scpFunc = new KDScrollPane((Component)this.lstFunc);
            TableLayout layout = TableLayout.split((int)4, (int)2);
            layout.rowStyle(0).setHeight(20);
            layout.rowStyle(1).setPriY(1);
            layout.rowStyle(2).setHeight(20);
            layout.rowStyle(3).setPriY(1);
            layout.colStyle(0).setPriX(1);
            layout.colStyle(1).setWidth(25);
            layout.rowStyle(0).setMarginBottom(3);
            layout.rowStyle(1).setMarginBottom(8);
            layout.rowStyle(2).setMarginBottom(3);
            layout.colStyle(0).setMarginRight(6);
            KDPanel panSupply = new KDPanel();
            panSupply.setLayout((LayoutManager)layout);
            panSupply.add((Component)lbcData, (Object)layout.cell(0, 0));
            panSupply.add((Component)scpData, (Object)layout.cell(1, 0));
            panSupply.add((Component)lbcFunc, (Object)layout.cell(2, 0));
            panSupply.add((Component)scpFunc, (Object)layout.cell(3, 0));
            Table inner = layout.cell(1, 1).splitRow(3);
            inner.rowStyle(0).setPriY(1);
            inner.rowStyle(1).setHeight(20);
            inner.rowStyle(2).setPriY(1);
            panSupply.add((Component)this.btnData, (Object)inner.cell(1));
            inner = layout.cell(3, 1).splitRow(3);
            inner.rowStyle(0).setPriY(1);
            inner.rowStyle(1).setHeight(20);
            inner.rowStyle(2).setPriY(1);
            panSupply.add((Component)this.btnFunc, (Object)inner.cell(1));
            this.getSupplyPanel().add((Component)panSupply);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cmbFunc) {
                this.changeLst4ComFunc();
                return;
            }
            if (e.getSource() == this.cmbData) {
                this.changeLst4ComData();
                return;
            }
            if (e.getSource() == this.btnData) {
                this.lstDataDblClk();
                return;
            }
            if (e.getSource() == this.btnFunc) {
                this.lstFuncDblClk();
                return;
            }
        }

        private void changeLst4ComFunc() {
            int index = this.cmbFunc.getSelectedIndex();
            this.lstFunc.removeAllElements();
            if (index == 0) {
                for (int i = 0; i < this.objOper.length; ++i) {
                    this.lstFunc.addElement(this.objOper[i]);
                }
            } else if (index == 1) {
                for (int i = 0; i < this.objNum.length; ++i) {
                    this.lstFunc.addElement(this.objNum[i]);
                }
            } else if (index == 2) {
                for (int i = 0; i < this.objStr.length; ++i) {
                    this.lstFunc.addElement(this.objStr[i]);
                }
            } else if (index == 3) {
                for (int i = 0; i < this.objDate.length; ++i) {
                    this.lstFunc.addElement(this.objDate[i]);
                }
            }
            if (this.lstFunc.getElementCount() > 0) {
                this.lstFunc.setSelectedIndex(0);
                this.btnFunc.setEnabled(true);
            } else {
                this.btnFunc.setEnabled(false);
            }
        }

        private void changeLst4ComData() {
            Iterator it = null;
            QueryColumn qryCln2 = null;
            QueryColumn qryClnClone = null;
            QueryTable qryTab = null;
            this.lstData.removeAllElements();
            if (this.cmbData.getSelectedItem() instanceof QueryTable) {
                qryTab = (QueryTable)this.cmbData.getSelectedItem();
            }
            if (qryTab != null && qryTab.getBasicQuery() != null) {
                for (QueryColumn qryCln2 : qryTab.getBasicQuery().getColumnList()) {
                    try {
                        qryClnClone = (QueryColumn)qryCln2.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    if (qryTab.getBasicQuery() instanceof KDQuery) {
                        if (!qryTab.getBasicQuery().equals(this.note) && null != qryClnClone) {
                            qryClnClone.setFormula("[" + qryTab.getName() + "].[" + qryCln2.getName() + "]");
                            qryClnClone.setFormula4Sql("[" + qryTab.getName() + "].[" + qryCln2.getName() + "]");
                        }
                    } else if (null != qryClnClone) {
                        qryClnClone.setFormula("[" + qryTab.getName() + "].[" + qryCln2.getName() + "]");
                        qryClnClone.setFormula4Sql("[" + qryTab.getName() + "].[" + qryCln2.getFormula() + "]");
                    }
                    this.lstData.addElement((Object)qryClnClone);
                }
            }
            if (this.lstData.getModel().getSize() > 0) {
                this.lstData.setSelectedIndex(0);
                this.btnData.setEnabled(true);
            } else {
                this.btnData.setEnabled(false);
            }
        }

        private void lstDataDblClk() {
            if (this.lstData.getSelectedValue() != null) {
                QueryColumn qryCln = (QueryColumn)this.lstData.getSelectedValue();
                this.txaFormula.insert(qryCln.getFormula() + " ", this.txaFormula.getCaretPosition());
            }
        }

        private void lstFuncDblClk() {
            if (this.cmbFunc.getSelectedIndex() > 0) {
                this.txaFormula.insert(this.lstFunc.getSelectedValue().toString() + "(  )", this.txaFormula.getCaretPosition());
                this.txaFormula.setCaretPosition(this.txaFormula.getCaretPosition() - 2);
            } else {
                this.txaFormula.insert(this.lstFunc.getSelectedValue().toString() + " ", this.txaFormula.getCaretPosition());
            }
        }

        private String convert4Sql(String str) {
            HashMap hsCln;
            if (str.trim().length() <= 0) {
                return str;
            }
            HashMap<String, HashMap> hsTab = new HashMap<String, HashMap>();
            for (QueryTable qryTab : this.note.getSubQueryList()) {
                hsCln = new HashMap();
                for (QueryColumn qryCln : qryTab.getBasicQuery().getColumnList()) {
                    if (qryTab.getBasicQuery() instanceof KDQuery) {
                        hsCln.put("[" + qryCln.getName() + "]", qryCln.getName());
                        continue;
                    }
                    hsCln.put("[" + qryCln.getName() + "]", qryCln.getFormula());
                }
                hsTab.put("[" + qryTab.getName() + "]", hsCln);
            }
            StringBuilder sb = new StringBuilder();
            int startPos = 0;
            int matchPos = 0;
            int tempPos = 0;
            while (true) {
                String strTemp = "";
                matchPos = str.indexOf("].[", startPos);
                if (matchPos == -1) break;
                tempPos = str.lastIndexOf(91, matchPos);
                if (tempPos != -1 && tempPos >= startPos) {
                    if (hsTab.containsKey(str.substring(tempPos, matchPos + 1))) {
                        if (tempPos != 0) {
                            strTemp = str.substring(startPos, tempPos);
                        }
                        strTemp = strTemp + str.substring(tempPos, matchPos + 3);
                        hsCln = (HashMap)hsTab.get(str.substring(tempPos, matchPos + 1));
                        tempPos = str.indexOf(93, matchPos + 3);
                        if (tempPos != -1) {
                            if (hsCln.containsKey(str.substring(matchPos + 2, tempPos + 1))) {
                                strTemp = strTemp + (String)hsCln.get(str.substring(matchPos + 2, tempPos + 1)) + "]";
                                sb.append(strTemp);
                                startPos = tempPos + 1;
                                continue;
                            }
                            sb.append(str.substring(startPos, tempPos + 1));
                            startPos = tempPos + 1;
                            continue;
                        }
                        sb.append(str.substring(startPos, matchPos + 3));
                        startPos = matchPos + 3;
                        continue;
                    }
                    sb.append(str.substring(startPos, matchPos + 3));
                    startPos = matchPos + 3;
                    continue;
                }
                sb.append(str.substring(startPos, matchPos + 3));
                startPos = matchPos + 3;
            }
            sb.append(str.substring(startPos, str.length()));
            return sb.toString();
        }

        protected void btnOK() {
            if (EditorFormula.this.getDataType() == 13) {
                ((QueryJoin)EditorFormula.this.getSrcObj()).setFormula(this.txaFormula.getText());
                ((QueryJoin)EditorFormula.this.getSrcObj()).setFormula4Sql(this.convert4Sql(this.txaFormula.getText()));
            } else if (EditorFormula.this.getDataType() == 14) {
                ((QueryFilter)EditorFormula.this.getSrcObj()).setFormula(this.txaFormula.getText());
                ((QueryFilter)EditorFormula.this.getSrcObj()).setFormula4Sql(this.convert4Sql(this.txaFormula.getText()));
            } else if (EditorFormula.this.getDataType() == 12) {
                ((QueryColumn)EditorFormula.this.getSrcObj()).setFormula(this.txaFormula.getText());
                ((QueryColumn)EditorFormula.this.getSrcObj()).setFormula4Sql(this.convert4Sql(this.txaFormula.getText()));
                if (this.cmbType.getSelectedItem() instanceof SqlType) {
                    ((QueryColumn)EditorFormula.this.getSrcObj()).setType((SqlType)this.cmbType.getSelectedItem());
                }
            }
        }
    }
}

