/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.data.wizard;

import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryGroup;
import com.kingdee.cosmic.ctrl.kdf.data.query.QuerySort;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryTable;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentSuperPanel;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.ContentVerticalAlignPanel;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.EditorSuperDialog;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataManager;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.KDDataWizard;
import com.kingdee.cosmic.ctrl.kdf.data.wizard.WizardListCellRenderer;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class EditorSortItem
extends EditorSuperDialog
implements ComponentListener {
    private static final Logger logger = LogUtil.getPackageLogger(EditorSortItem.class);
    private static final long serialVersionUID = 4577119795384162529L;
    private KDQuery note = null;
    private KDTextField txtAlias = null;
    private KDTextField txtComment = null;
    private KDComboBox cmbTabQuery = null;
    private KDList lstAvailable = null;
    private KDList lstSelected = null;
    private KDPanel panSupply;
    private ContentSuperPanel contentPanel = null;
    private boolean bOK = false;
    private ContentVerticalAlignPanel parent;
    MouseListener mouseListener4lstSelected = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                EditorSortItem.this.actionPerformed(new ActionEvent(this, 1001, "btnEdit"));
            }
            EditorSortItem.this.setBtnSync();
        }
    };
    MouseListener mouseListener4lstAvailable = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                EditorSortItem.this.btnMoveLeft(true);
            }
            EditorSortItem.this.setBtnSync();
        }
    };

    public EditorSortItem(int type, Object srcObj, Object srcObjClone, KDQuery note, ContentVerticalAlignPanel parent, boolean isNew) {
        super(type, srcObj, srcObjClone, (Dialog)((Object)parent.getParentObj()), isNew);
        this.note = note;
        this.parent = parent;
        this.initComponent();
    }

    private void initComponent() {
        if (!this.isNew()) {
            this.setTitle(EditorSortItem.getMLS("editSort", "\u7f16\u8f91\u6392\u5e8f"));
        } else {
            this.setTitle(EditorSortItem.getMLS("newSort", "\u65b0\u5efa\u6392\u5e8f"));
        }
        this.txtAlias = new KDTextField();
        this.txtComment = new KDTextField();
        this.txtAlias.setText(((QuerySort)this.getSrcObj()).getName());
        this.txtComment.setText(((QuerySort)this.getSrcObj()).getComment());
        this.contentPanel = new ContentSuperPanel(2, 0, null, null);
        this.contentPanel.getBtnNew().setVisible(false);
        this.lstAvailable = new KDList();
        this.lstAvailable.setCellRenderer((ListCellRenderer)new WizardListCellRenderer());
        this.lstAvailable.setSelectionMode(0);
        this.lstAvailable.addMouseListener(this.mouseListener4lstAvailable);
        this.lstSelected = new KDList();
        this.lstSelected.setCellRenderer((ListCellRenderer)new WizardListCellRenderer());
        this.lstSelected.setSelectionMode(0);
        this.lstSelected.addMouseListener(this.mouseListener4lstSelected);
        this.initComboBox();
        this.contentPanel.getBtnEdit().setToolTipText(EditorSortItem.getMLS("ascDesc", "\u5347\u5e8f/\u9006\u5e8f"));
        this.contentPanel.getBtnEdit().setIcon((Icon)ContentSuperPanel.IMG_ASCDESC);
        KDScrollPane scpAvailable = new KDScrollPane((Component)this.lstAvailable);
        KDScrollPane scpSelected = new KDScrollPane((Component)this.lstSelected);
        KDLabelContainer lbcAlias = new KDLabelContainer((JComponent)this.txtAlias);
        lbcAlias.setBoundLabelText(EditorSortItem.getMLS("name", "\u540d\u79f0"));
        lbcAlias.setBoundLabelLength(60);
        lbcAlias.setBoundLabelUnderline(true);
        KDLabelContainer lbcComment = new KDLabelContainer((JComponent)this.txtComment);
        lbcComment.setBoundLabelText(EditorSortItem.getMLS("comment", "\u6ce8\u91ca"));
        lbcComment.setBoundLabelLength(60);
        lbcComment.setBoundLabelUnderline(true);
        KDLabelContainer lbcSelected = new KDLabelContainer((JComponent)scpSelected);
        lbcSelected.setBoundLabelText(EditorSortItem.getMLS("selectFld", "\u5df2\u9009\u62e9\u5b57\u6bb5"));
        lbcSelected.setBoundLabelLength(20);
        lbcSelected.setBoundLabelAlignment(8);
        KDLabelContainer lbcAvailable = new KDLabelContainer((JComponent)this.cmbTabQuery);
        lbcAvailable.setBoundLabelText(EditorSortItem.getMLS("availableFld", "\u53ef\u9009\u62e9\u5b57\u6bb5"));
        lbcAvailable.setBoundLabelLength(20);
        lbcAvailable.setBoundLabelAlignment(8);
        TableLayout tl = TableLayout.splitRow((int)2);
        tl.rowStyle(0).setHeight(40);
        tl.rowStyle(1).setPriY(1);
        tl.rowStyle(1).setMarginTop(3);
        this.panSupply = new KDPanel();
        this.panSupply.setLayout((LayoutManager)tl);
        this.panSupply.add((Component)lbcAvailable, (Object)tl.cell(0));
        this.panSupply.add((Component)scpAvailable, (Object)tl.cell(1));
        tl = TableLayout.split((int)1, (int)1);
        this.contentPanel.getPanSupply().setLayout((LayoutManager)tl);
        this.contentPanel.getPanSupply().add((Component)this.panSupply, (Object)tl.cell(0));
        tl = TableLayout.split((int)1, (int)1);
        this.contentPanel.getPanSelected().setLayout((LayoutManager)tl);
        this.contentPanel.getPanSelected().add((Component)lbcSelected, (Object)tl.cell(0));
        tl = TableLayout.split((int)3, (int)1);
        tl.rowStyle(0).setHeight(20);
        tl.rowStyle(1).setHeight(20);
        tl.rowStyle(2).setPriY(1);
        tl.rowStyle(0).setMarginBottom(6);
        tl.rowStyle(1).setMarginBottom(6);
        this.getCenterPanel().setLayout((LayoutManager)tl);
        this.getCenterPanel().add((Component)lbcAlias, tl.cell(0));
        this.getCenterPanel().add((Component)lbcComment, tl.cell(1));
        this.getCenterPanel().add((Component)this.contentPanel.getPanelWithoutContainer(), tl.cell(2));
        this.contentPanel.getBtnMoveLeft().addActionListener((ActionListener)this);
        this.contentPanel.getBtnMoveRight().addActionListener((ActionListener)this);
        this.contentPanel.getBtnMoveUp().addActionListener((ActionListener)this);
        this.contentPanel.getBtnMoveDown().addActionListener((ActionListener)this);
        this.contentPanel.getBtnEdit().addActionListener((ActionListener)this);
        this.contentPanel.addComponentListener(this);
        this.getBtnFormula().setVisible(false);
    }

    private void initComboBox() {
        this.cmbTabQuery = new KDComboBox();
        this.cmbTabQuery.setActionCommand("cmbTabQuery");
        this.cmbTabQuery.addActionListener((ActionListener)this);
        DefaultComboBoxModel<QueryTable> cmbModel = new DefaultComboBoxModel<QueryTable>();
        if (this.note instanceof KDQuery) {
            QueryTable tempQryTab = new QueryTable(KDDataManager.getID("QueryTable", null), this.note, this.note.getName());
            cmbModel.addElement(tempQryTab);
            for (QueryTable qryTab : this.note.getSubQueryList()) {
                cmbModel.addElement(qryTab);
            }
        }
        this.cmbTabQuery.setModel(cmbModel);
        DefaultListModel<QuerySort.SortItem> lstModel = new DefaultListModel<QuerySort.SortItem>();
        if (this.getDataType() == 15) {
            for (QuerySort.SortItem sortItem : ((QuerySort)this.getSrcObj()).getItemList()) {
                sortItem.setName(sortItem.getColumn().getFormula());
                lstModel.addElement(sortItem);
            }
            this.lstSelected.setModel(lstModel);
        }
        if (this.cmbTabQuery.getItemCount() > 0) {
            this.filllstAvailable4CmbTabQuery((QueryTable)this.cmbTabQuery.getSelectedItem());
        }
        if (this.lstAvailable.getModel().getSize() > 0) {
            this.lstAvailable.setSelectedIndex(0);
        }
        if (this.lstSelected.getModel().getSize() > 0) {
            this.lstSelected.setSelectedIndex(0);
        }
        this.setBtnSync();
    }

    private void setBtnSync() {
        if (this.lstAvailable.getModel().getSize() > 0 && this.lstAvailable.getSelectedIndex() >= 0) {
            this.contentPanel.getBtnMoveLeft().setEnabled(true);
        } else {
            this.contentPanel.getBtnMoveLeft().setEnabled(false);
        }
        if (this.lstSelected.getModel().getSize() > 0 && this.lstSelected.getSelectedIndex() >= 0) {
            this.contentPanel.getBtnMoveRight().setEnabled(true);
            this.contentPanel.getBtnEdit().setEnabled(true);
            this.contentPanel.getBtnMoveUp().setEnabled(true);
            this.contentPanel.getBtnMoveDown().setEnabled(true);
        } else {
            this.contentPanel.getBtnMoveRight().setEnabled(false);
            this.contentPanel.getBtnEdit().setEnabled(false);
            this.contentPanel.getBtnMoveUp().setEnabled(false);
            this.contentPanel.getBtnMoveDown().setEnabled(false);
        }
    }

    private void filllstAvailable4CmbTabQuery(QueryTable qryTab) {
        Iterator it = null;
        QueryColumn qryCln2 = null;
        QueryColumn qryClnClone = null;
        DefaultListModel<QueryColumn> lstModel = new DefaultListModel<QueryColumn>();
        if (qryTab == null || qryTab.getBasicQuery() == null) {
            return;
        }
        try {
            for (QueryColumn qryCln2 : qryTab.getBasicQuery().getColumnList()) {
                qryClnClone = (QueryColumn)qryCln2.clone();
                if (qryTab.getBasicQuery() instanceof KDQuery) {
                    if (!qryTab.getBasicQuery().equals(this.note)) {
                        qryClnClone.setFormula("[" + qryTab.getName() + "].[" + qryCln2.getName() + "]");
                        qryClnClone.setFormula4Sql("[" + qryTab.getName() + "].[" + qryCln2.getName() + "]");
                    }
                } else {
                    qryClnClone.setFormula("[" + qryTab.getName() + "].[" + qryCln2.getName() + "]");
                    qryClnClone.setFormula4Sql("[" + qryTab.getName() + "].[" + qryCln2.getFormula() + "]");
                }
                lstModel.addElement(qryClnClone);
            }
            this.lstAvailable.setModel(lstModel);
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    private void btnMoveLeft(boolean bIsDoubleClick) {
        int index = this.lstAvailable.getModel().getSize();
        if (index <= 0) {
            return;
        }
        index = this.lstAvailable.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel lstModel = (DefaultListModel)this.lstAvailable.getModel();
        QueryColumn qryCln = (QueryColumn)lstModel.getElementAt(index);
        lstModel.removeElement(qryCln);
        if (this.getDataType() == 15) {
            QuerySort.SortItem qrySortItem = new QuerySort.SortItem(((QueryTable)this.cmbTabQuery.getSelectedItem()).getID() + qryCln.getID(), KDDataWizard.getAIdentiryName(qryCln.getFormula(), this.lstSelected.getModel(), -1), qryCln);
            lstModel = (DefaultListModel)this.lstSelected.getModel();
            lstModel.addElement(qrySortItem);
            ((QuerySort)this.getSrcObjClone()).getItemList().add(qrySortItem);
        }
        if (this.lstAvailable.getModel().getSize() > 0) {
            if (index == this.lstAvailable.getModel().getSize()) {
                this.lstAvailable.setSelectedIndex(this.lstAvailable.getModel().getSize() - 1);
            } else {
                this.lstAvailable.setSelectedIndex(index);
            }
        }
    }

    private void btnMoveRight(boolean bIsDoubleClick) {
        int index = this.lstSelected.getModel().getSize();
        if (index <= 0) {
            return;
        }
        index = this.lstSelected.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel lstModel = (DefaultListModel)this.lstSelected.getModel();
        if (this.getDataType() == 15) {
            QuerySort.SortItem qrySortItem = (QuerySort.SortItem)lstModel.getElementAt(index);
            lstModel.removeElementAt(index);
            ((QuerySort)this.getSrcObjClone()).getItemList().remove(qrySortItem);
            if (KDDataWizard.getItemTabName(qrySortItem.getName()).equals(((QueryTable)this.cmbTabQuery.getSelectedItem()).getName())) {
                lstModel = (DefaultListModel)this.lstAvailable.getModel();
                lstModel.addElement(qrySortItem.getColumn());
            }
        }
        if (this.lstSelected.getModel().getSize() > 0) {
            if (index == this.lstSelected.getModel().getSize()) {
                this.lstSelected.setSelectedIndex(this.lstSelected.getModel().getSize() - 1);
            } else {
                this.lstSelected.setSelectedIndex(index);
            }
        }
    }

    @Override
    protected void runSelfEvent(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("cmbTabQuery")) {
                if (this.cmbTabQuery.getItemCount() > 0) {
                    this.filllstAvailable4CmbTabQuery((QueryTable)this.cmbTabQuery.getSelectedItem());
                }
            } else if (e.getActionCommand().equals("btnMoveRight")) {
                this.btnMoveRight(false);
                this.setBtnSync();
            } else if (e.getActionCommand().equals("btnMoveLeft")) {
                this.btnMoveLeft(false);
                this.setBtnSync();
            } else if (e.getActionCommand().equals("btnMoveUp")) {
                int index = this.lstSelected.getSelectedIndex();
                if (index <= 0) {
                    return;
                }
                DefaultListModel lstModel = (DefaultListModel)this.lstSelected.getModel();
                if (lstModel.getSize() <= 1) {
                    return;
                }
                Object objTemp = lstModel.getElementAt(index);
                lstModel.setElementAt(lstModel.getElementAt(index - 1), index);
                lstModel.setElementAt(objTemp, index - 1);
                this.lstSelected.setSelectedIndex(index - 1);
                if (this.getDataType() == 15) {
                    QuerySort qrySort = (QuerySort)this.getSrcObjClone();
                    objTemp = qrySort.getItemList().get(index);
                    qrySort.getItemList().set(index, qrySort.getItemList().get(index - 1));
                    qrySort.getItemList().set(index - 1, objTemp);
                } else if (this.getDataType() == 17) {
                    QueryGroup qryGroup = (QueryGroup)this.getSrcObjClone();
                    objTemp = qryGroup.getItemList().get(index);
                    qryGroup.getItemList().set(index, qryGroup.getItemList().get(index - 1));
                    qryGroup.getItemList().set(index - 1, objTemp);
                }
            } else if (e.getActionCommand().equals("btnMoveDown")) {
                int index = this.lstSelected.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                DefaultListModel lstModel = (DefaultListModel)this.lstSelected.getModel();
                if (lstModel.getSize() <= 1) {
                    return;
                }
                if (index == lstModel.getSize() - 1) {
                    return;
                }
                Object objTemp = lstModel.getElementAt(index);
                lstModel.setElementAt(lstModel.getElementAt(index + 1), index);
                lstModel.setElementAt(objTemp, index + 1);
                this.lstSelected.setSelectedIndex(index + 1);
                if (this.getDataType() == 15) {
                    QuerySort qrySort = (QuerySort)this.getSrcObjClone();
                    objTemp = qrySort.getItemList().get(index);
                    qrySort.getItemList().set(index, qrySort.getItemList().get(index + 1));
                    qrySort.getItemList().set(index + 1, objTemp);
                } else if (this.getDataType() == 17) {
                    QueryGroup qryGroup = (QueryGroup)this.getSrcObjClone();
                    objTemp = qryGroup.getItemList().get(index);
                    qryGroup.getItemList().set(index, qryGroup.getItemList().get(index + 1));
                    qryGroup.getItemList().set(index + 1, objTemp);
                }
            } else if (e.getActionCommand().equals("btnEdit")) {
                int index = this.lstSelected.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                DefaultListModel lstModel = (DefaultListModel)this.lstSelected.getModel();
                if (this.getDataType() == 15) {
                    QuerySort.SortItem qrySortItem;
                    qrySortItem.setDesc(!(qrySortItem = (QuerySort.SortItem)lstModel.getElementAt(index)).isDesc());
                }
                this.lstSelected.invalidate();
                this.lstSelected.repaint();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    public KDComboBox getCmbTabQuery() {
        return this.cmbTabQuery;
    }

    public KDList getlstAvailable() {
        return this.lstAvailable;
    }

    public KDList getlstSelected() {
        return this.lstSelected;
    }

    @Override
    protected void btnOK() {
        int selfIdx;
        if (this.txtAlias.getText().trim().length() <= 0) {
            KDDataWizard.msgBox((Component)((Object)this), EditorSortItem.getMLS("inputName", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"), EditorSortItem.getMLS("error", "\u9519\u8bef"), -1, 0);
            return;
        }
        if (KDDataWizard.checkInvalidInString(this.txtAlias.getText())) {
            KDDataWizard.msgBox((Component)((Object)this), EditorSortItem.getMLS("blankOrInvaildChar", "\u540d\u79f0\u5305\u542b\u7a7a\u683c\u6216\u8005\u975e\u6cd5\u5b57\u7b26!"), EditorSortItem.getMLS("error", "\u9519\u8bef"), -1, 0);
            return;
        }
        int n = selfIdx = this.isNew() ? -1 : this.parent.getLstParameter().getSelectedIndex();
        if (!KDDataWizard.checkIdentiryName(this.txtAlias.getText(), this.parent.getListModel(), selfIdx)) {
            KDDataWizard.msgBox((Component)((Object)this), EditorSortItem.getMLS("duplicateName", "\u540d\u79f0\u91cd\u590d,\u8bf7\u4fee\u6539!"), EditorSortItem.getMLS("error", "\u9519\u8bef"), -1, 0);
            return;
        }
        this.setIsNew(false);
        this.bOK = true;
        ((QuerySort)this.getSrcObjClone()).setName(this.txtAlias.getText());
        ((QuerySort)this.getSrcObjClone()).setComment(this.txtComment.getText());
        this.setSrcObj(this.getSrcObjClone());
        super.btnOK();
    }

    public boolean isBOK() {
        return this.bOK;
    }

    public void setBOK(boolean bok) {
        this.bOK = bok;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int width = (e.getComponent().getSize().width - 26) / 2;
        this.panSupply.setPreferredSize(new Dimension(width, this.panSupply.getPreferredSize().height));
        this.cmbTabQuery.setPreferredSize(new Dimension(width - 16, this.cmbTabQuery.getPreferredSize().height));
        this.cmbTabQuery.setMinimumSize(new Dimension(width - 16, this.cmbTabQuery.getPreferredSize().height));
        this.panSupply.invalidate();
        this.validate();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

