/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.excel.ui;

import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.CloseHook;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.cosmic.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDProgressBar;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

class ExportProgressPane
extends KDPanel {
    KDProgressBar _progress;
    KDTextField _status;
    KDButton close;
    CloseHook hook;
    String filePath;
    boolean open = true;
    long _sum = 0L;
    Color back = new Color(41, 217, 231, 100);
    Paint paint;

    ExportProgressPane() {
        this._progress = new KDProgressBar();
        this._progress.setIndeterminate(true);
        this._status = new KDTextField();
        this._status.setEditable(false);
        this._status.setEnabled(false);
        this._status.setFocusable(false);
        this.setLayout(null);
        this._progress.setBounds(30, 30, 300, 20);
        this.add((Component)this._progress);
        this.close = new KDButton("open file");
        this.close.setBounds(120, 70, 120, 20);
        this._status.setBounds(30, 70, 300, 20);
        this.add((Component)this._status);
        this.update("start export", "excel2007 file", 0L);
        this.initListener();
    }

    private void initListener() {
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (ExportProgressPane.this.open) {
                        Excel2007ExportController.openFileInExcel(ExportProgressPane.this.filePath);
                    }
                    ExportProgressPane.this._progress.setIndeterminate(true);
                    ExportProgressPane.this._progress.setStringPainted(false);
                    ExportProgressPane.this._progress.setValue(0);
                    ExportProgressPane.this.remove((Component)ExportProgressPane.this.close);
                    ExportProgressPane.this.add((Component)ExportProgressPane.this._status);
                    ExportProgressPane.this.revalidate();
                    ExportProgressPane.this.doLayout();
                    ExportProgressPane.this.repaint();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ExportProgressPane.this.hook.close();
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.drawString(CtrlKDFMessages.getMLS("excelExportProgressDetector", "Excel\u5bfc\u51fa\u8fdb\u5ea6\u68c0\u6d4b\u5668"), 120, 18);
        Rectangle bounds = this.getBounds();
        Graphics2D g2 = (Graphics2D)g;
        Paint p = g2.getPaint();
        if (this.paint == null) {
            this.paint = new GradientPaint(0.0f, 0.0f, this.back, bounds.width, bounds.height, Color.WHITE);
        }
        g2.setPaint(this.paint);
        g.fillRect(0, 0, bounds.width, bounds.height);
        g2.setPaint(p);
    }

    public void update(String stepName, String message, long timeConsuming) {
        this._sum += timeConsuming;
        this._status.setText(stepName + ":" + message);
    }

    public void complete(ExportEvent e) {
        this._progress.setIndeterminate(false);
        this._progress.setStringPainted(true);
        this._progress.setString("export completed" + e._message + "!");
        this._progress.setValue(100);
        this.remove((Component)this._status);
        this.add((Component)this.close);
        this.revalidate();
        this.doLayout();
        this.repaint();
    }
}

