/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.form;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.kdf.form.Area;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.Column;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.EntityInfo;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form.FormBuilder;
import com.kingdee.cosmic.ctrl.kdf.form.FuncImpl;
import com.kingdee.cosmic.ctrl.kdf.form.Layer;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.Panel;
import com.kingdee.cosmic.ctrl.kdf.form.Property;
import com.kingdee.cosmic.ctrl.kdf.form.PropertyCollection;
import com.kingdee.cosmic.ctrl.kdf.form.Row;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeServiceProvider;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeStyleService;
import com.kingdee.cosmic.ctrl.kdf.form.Style;
import com.kingdee.cosmic.ctrl.kdf.form.StyleCollection;
import com.kingdee.cosmic.ctrl.kdf.form.Table;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public final class BaseFormBuilder
implements FormBuilder {
    private HashMap pageBuffer;
    private HashMap styleBuffer;
    private RuntimeStyleService stsvs;
    private boolean snapMode = false;
    private boolean designMode = false;

    @Override
    public Form createForm(RuntimeServiceProvider sp, IXmlElement formElement) {
        this.stsvs = sp.getRuntimeStyleService();
        this.initParse();
        Form fm = this.parseForm(formElement);
        if (fm != null) {
            fm.setRuntimeServiceProvider(sp);
        }
        return fm;
    }

    public Page createPage(RuntimeStyleService rss, IXmlElement pageElement) {
        this.stsvs = rss;
        this.initParse();
        if (pageElement != null) {
            return (Page)this.parsePureElement(null, null, null, pageElement);
        }
        return null;
    }

    public Container createContainer(RuntimeStyleService rss, IXmlElement contElement) {
        this.stsvs = rss;
        this.initParse();
        if (contElement != null) {
            return this.parsePureElement(null, null, null, contElement);
        }
        return null;
    }

    private void initParse() {
        this.pageBuffer = new HashMap();
        this.styleBuffer = new HashMap();
    }

    private void sortChildren(Container parent) {
        if (parent != null) {
            ArrayList srcList = parent.innerList();
            Object[] srcs = srcList.toArray(new Container[0]);
            Arrays.sort(srcs);
            srcList.clear();
            for (int i = 0; i < srcs.length; ++i) {
                srcList.add(srcs[i]);
            }
        }
    }

    private PropertyCollection parsePureProperties(IXmlElement elem) {
        PropertyCollection pc = PropertyCollection.getEmptyPropertyCollection();
        if (elem != null) {
            for (IXmlElement el : elem.getChildren()) {
                String nm;
                if (!el.getName().equalsIgnoreCase("Property") || (nm = el.getAttribute("name")) == null) continue;
                Property pt = new Property(nm, el.getAttribute("type"), el.getText().trim());
                pc = pc.add(pt);
            }
        }
        return pc;
    }

    private Collection[] parseProperties(IXmlElement elem) {
        PropertyCollection pc = PropertyCollection.getEmptyPropertyCollection();
        StyleCollection sc = StyleCollection.getEmptyStyleCollection();
        if (elem != null) {
            for (IXmlElement el : elem.getChildren()) {
                String nm;
                if (!el.getName().equalsIgnoreCase("Property") || (nm = el.getAttribute("name")) == null) continue;
                String tp = el.getAttribute("type");
                if (tp != null && tp.equalsIgnoreCase("style")) {
                    sc = sc.add(new Style(nm, el.getText().trim()));
                    continue;
                }
                pc = pc.add(new Property(nm, el.getAttribute("type"), el.getText().trim()));
            }
        }
        return new Collection[]{sc, pc};
    }

    private Form parseForm(IXmlElement elem) {
        Form fom = null;
        if (elem.getName().equalsIgnoreCase("Form")) {
            fom = new Form();
            fom.setId(elem.getAttribute("id"));
            fom.setUserAlias(elem.getAttribute("alias"));
            fom.setHeaderID(elem.getAttribute("headerID"));
            fom.setFooterID(elem.getAttribute("footerID"));
            IXmlElement dsn = elem.getChild("DesignedForm");
            if (dsn != null) {
                fom.setUserObject(dsn);
            }
            for (IXmlElement el : elem.getChildren()) {
                if (el.getName().equalsIgnoreCase("page")) {
                    this.parsePureElement(fom, null, null, el);
                    continue;
                }
                if (el.getName().equalsIgnoreCase("Layers")) {
                    for (IXmlElement lel : el.getChildren()) {
                        if (!lel.getName().equalsIgnoreCase("Layer")) continue;
                        Layer lay = new Layer();
                        lay.setId(lel.getAttribute("id"));
                        lay.setAlias(lel.getAttribute("alias"));
                        lay.setCategory(lel.getAttribute("category"));
                        lay.setStyleID(lel.getAttribute("styleID"));
                        fom.getLayers().add(lay);
                    }
                    continue;
                }
                if (!el.getName().equalsIgnoreCase("Properties")) continue;
                fom.setProperties(this.parsePureProperties(el));
            }
        } else {
            throw new AssertionError((Object)"Not a valid form element");
        }
        return fom;
    }

    private Container parsePureElement(Form currentForm, Container currentParent, Page currentPage, IXmlElement elem) {
        ShareStyleAttributes ssa;
        String attr;
        IXmlElement cdsn;
        if (elem.getName().equalsIgnoreCase("Properties")) {
            Collection[] colls = this.parseProperties(elem);
            if (currentParent != null) {
                currentParent.setCustomStyles((StyleCollection)colls[0]);
                currentParent.setProperties((PropertyCollection)colls[1]);
            }
            return null;
        }
        if (elem.getName().equalsIgnoreCase("page") || elem.getName().equalsIgnoreCase("Header") || elem.getName().equalsIgnoreCase("Footer")) {
            Page pg;
            if (this.pageBuffer.containsKey(elem.getAttribute("id"))) {
                pg = (Page)this.pageBuffer.remove(elem.getAttribute("id"));
            } else {
                pg = new Page();
                pg.setId(elem.getAttribute("id"));
            }
            pg.setUserAlias(elem.getAttribute("alias"));
            cdsn = elem.getChild("DesignedPage");
            if (cdsn != null) {
                pg.setUserObject(cdsn);
            } else {
                cdsn = elem.getChild("DesignedHeader");
                if (cdsn != null) {
                    pg.setUserObject(cdsn);
                } else {
                    cdsn = elem.getChild("DesignedFooter");
                    if (cdsn != null) {
                        pg.setUserObject(cdsn);
                    }
                }
            }
            pg.getLeft().setString(elem.getAttribute("left"));
            pg.getRight().setString(elem.getAttribute("right"));
            pg.getTop().setString(elem.getAttribute("top"));
            pg.getBottom().setString(elem.getAttribute("bottom"));
            pg.syncOriginString();
            pg.group().setDataSource(elem.getAttribute("dataSourceID"));
            pg.setVisibility(new EntityInfo(elem.getAttribute("visible")));
            pg.setHoldPlace(new EntityInfo(elem.getAttribute("holdPlace")));
            pg.setPreSteps(elem.getAttribute("preMacro"));
            pg.setPostSteps(elem.getAttribute("postMacro"));
            pg.setAnchor(elem.getAttribute("anchor"));
            pg.setHint(elem.getAttribute("hint"));
            attr = elem.getAttribute("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                pg.setStyles(ssa);
            }
            if ((attr = elem.getAttribute("repeat")) != null) {
                pg.setRepeat(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttribute("layerID")) != null) {
                pg.setLayer(attr);
            }
            pg.setParent(pg);
            if (pg.getId() != null) {
                pg.getIdTable().put(pg.getId(), pg);
            }
            currentPage = pg;
            currentParent = pg;
            if (currentForm != null) {
                currentForm.getPages().add(pg);
                pg.setForm(currentForm);
            }
        } else if (elem.getName().equalsIgnoreCase("Area")) {
            String nt;
            Area ara;
            if (currentPage != null && currentPage.getIdTable().containsKey(elem.getAttribute("id"))) {
                ara = (Area)currentPage.getIdTable().get(elem.getAttribute("id"));
            } else {
                ara = new Area();
                ara.setId(elem.getAttribute("id"));
                if (ara.getId() != null && currentPage != null) {
                    currentPage.getIdTable().put(ara.getId(), ara);
                }
            }
            ara.setUserAlias(elem.getAttribute("alias"));
            cdsn = elem.getChild("DesignedArea");
            if (cdsn != null) {
                ara.setUserObject(cdsn);
            }
            ara.getLeft().setString(elem.getAttribute("left"));
            ara.getRight().setString(elem.getAttribute("right"));
            ara.getTop().setString(elem.getAttribute("top"));
            ara.getBottom().setString(elem.getAttribute("bottom"));
            ara.syncOriginString();
            ara.setVisibility(new EntityInfo(elem.getAttribute("visible")));
            ara.setHoldPlace(new EntityInfo(elem.getAttribute("holdPlace")));
            ara.setPreSteps(elem.getAttribute("preMacro"));
            ara.setPostSteps(elem.getAttribute("postMacro"));
            ara.setAnchor(elem.getAttribute("anchor"));
            ara.setHint(elem.getAttribute("hint"));
            attr = elem.getAttribute("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                ara.setStyles(ssa);
            }
            if ((attr = elem.getAttribute("layerID")) != null) {
                ara.setLayer(attr);
            }
            if ((attr = elem.getAttribute("priority")) != null && FuncImpl.isInteger(attr)) {
                ara.setPriority(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttribute("minLoopCount")) != null && FuncImpl.isInteger(attr)) {
                ara.setMinLoopCount(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttribute("maxLoopCount")) != null && FuncImpl.isInteger(attr)) {
                ara.setMaxLoopCount(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttribute("verticalSpacing")) != null) {
                ara.setVerticalSpacing(attr);
            } else {
                ara.setVerticalSpacing("0");
            }
            attr = elem.getAttribute("horizontalSpacing");
            if (attr != null) {
                ara.setHorizontalSpacing(attr);
            } else {
                ara.setHorizontalSpacing("0");
            }
            if (currentParent != null) {
                currentParent.addChild(ara);
                ara.setParent(currentParent);
            }
            if (!this.snapMode && (nt = elem.getAttribute("nextAreaID")) != null && currentPage != null) {
                Area arb = null;
                if (nt.indexOf(46) == -1) {
                    if (currentPage.getIdTable().containsKey(nt)) {
                        arb = (Area)currentPage.getIdTable().get(nt);
                    } else {
                        arb = new Area();
                        arb.setId(nt);
                        currentPage.getIdTable().put(nt, arb);
                    }
                } else if (currentForm != null) {
                    int temp = nt.indexOf(46);
                    String pName = nt.substring(0, temp);
                    String aName = nt.substring(temp + 1);
                    Page pg = currentForm.getPages().get(pName);
                    if (pg != null) {
                        if (pg.getIdTable().containsKey(aName)) {
                            arb = (Area)pg.getIdTable().get(aName);
                        } else {
                            arb = new Area();
                            arb.setId(aName);
                            if (aName != null) {
                                pg.getIdTable().put(aName, arb);
                            }
                        }
                    } else if (this.pageBuffer.containsKey(pName)) {
                        pg = (Page)this.pageBuffer.get(pName);
                        if (pg.getIdTable().containsKey(aName)) {
                            arb = (Area)pg.getIdTable().get(aName);
                        } else {
                            arb = new Area();
                            arb.setId(aName);
                            if (aName != null) {
                                pg.getIdTable().put(aName, arb);
                            }
                        }
                    } else {
                        pg = new Page();
                        pg.setId(pName);
                        this.pageBuffer.put(pName, pg);
                        arb = new Area();
                        arb.setId(aName);
                        if (aName != null) {
                            pg.getIdTable().put(aName, arb);
                        }
                    }
                }
                if (ara != null && null != arb) {
                    ara.setNext(arb);
                    arb.setPrevious(ara);
                }
            }
            currentParent = ara;
        } else if (elem.getName().equalsIgnoreCase("Panel")) {
            Panel pnl = new Panel();
            pnl.setId(elem.getAttribute("id"));
            pnl.setUserAlias(elem.getAttribute("alias"));
            cdsn = elem.getChild("DesignedPanel");
            if (cdsn != null) {
                pnl.setUserObject(cdsn);
            }
            pnl.group().setDataSource(elem.getAttribute("dataSourceID"));
            pnl.group().setField(elem.getAttribute("groupField"));
            if (!(this.snapMode || this.designMode || !(currentParent instanceof Area) || pnl.group().getDataSource() != null && pnl.group().getDataSource().length() != 0)) {
                return null;
            }
            pnl.getLeft().setString(elem.getAttribute("left"));
            pnl.getRight().setString(elem.getAttribute("right"));
            pnl.getTop().setString(elem.getAttribute("top"));
            pnl.getBottom().setString(elem.getAttribute("bottom"));
            pnl.syncOriginString();
            pnl.setVisibility(new EntityInfo(elem.getAttribute("visible")));
            pnl.setHoldPlace(new EntityInfo(elem.getAttribute("holdPlace")));
            pnl.setPreSteps(elem.getAttribute("preMacro"));
            pnl.setPostSteps(elem.getAttribute("postMacro"));
            pnl.setAnchor(elem.getAttribute("anchor"));
            pnl.setHint(elem.getAttribute("hint"));
            attr = elem.getAttribute("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                pnl.setStyles(ssa);
            }
            if ((attr = elem.getAttribute("layerID")) != null) {
                pnl.setLayer(attr);
            }
            if ((attr = elem.getAttribute("priority")) != null && FuncImpl.isInteger(attr)) {
                pnl.setPriority(Integer.parseInt(attr));
            }
            if (currentParent != null) {
                currentParent.addChild(pnl);
                pnl.setParent(currentParent);
            }
            if (pnl.getId() != null && currentPage != null) {
                currentPage.getIdTable().put(pnl.getId(), pnl);
            }
            currentParent = pnl;
        } else if (elem.getName().equalsIgnoreCase("Table")) {
            Table tab = new Table();
            tab.setId(elem.getAttribute("id"));
            tab.setUserAlias(elem.getAttribute("alias"));
            cdsn = elem.getChild("DesignedTable");
            if (cdsn != null) {
                tab.setUserObject(cdsn);
            }
            tab.group().setDataSource(elem.getAttribute("dataSourceID"));
            tab.group().setField(elem.getAttribute("groupField"));
            if (!(this.snapMode || this.designMode || !(currentParent instanceof Area) || tab.group().getDataSource() != null && tab.group().getDataSource().length() != 0)) {
                return null;
            }
            tab.getLeft().setString(elem.getAttribute("left"));
            tab.getRight().setString(elem.getAttribute("right"));
            tab.getTop().setString(elem.getAttribute("top"));
            tab.getBottom().setString(elem.getAttribute("bottom"));
            tab.syncOriginString();
            tab.setVisibility(new EntityInfo(elem.getAttribute("visible")));
            tab.setHoldPlace(new EntityInfo(elem.getAttribute("holdPlace")));
            tab.setPreSteps(elem.getAttribute("preMacro"));
            tab.setPostSteps(elem.getAttribute("postMacro"));
            tab.setAnchor(elem.getAttribute("anchor"));
            tab.setHint(elem.getAttribute("hint"));
            attr = elem.getAttribute("styleID");
            if (attr != null) {
                ssa = null;
                if (this.styleBuffer.containsKey(attr)) {
                    ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                } else {
                    ssa = this.stsvs.getStyleAttributes(attr);
                    this.styleBuffer.put(attr, ssa);
                }
                tab.setStyles(ssa);
            }
            if ((attr = elem.getAttribute("layerID")) != null) {
                tab.setLayer(attr);
            }
            if ((attr = elem.getAttribute("priority")) != null && FuncImpl.isInteger(attr)) {
                tab.setPriority(Integer.parseInt(attr));
            }
            if ((attr = elem.getAttribute("layout")) != null) {
                if (attr.equalsIgnoreCase("auto") || attr.equals("0")) {
                    tab.setLayoutMode(0);
                } else {
                    tab.setLayoutMode(1);
                }
            }
            if (currentParent != null) {
                currentParent.addChild(tab);
                tab.setParent(currentParent);
            }
            if (tab.getId() != null && currentPage != null) {
                currentPage.getIdTable().put(tab.getId(), tab);
            }
            currentParent = tab;
        } else {
            if (elem.getName().equalsIgnoreCase("Row")) {
                if (currentParent instanceof Table) {
                    String attr2;
                    Row row = new Row();
                    Table tab = (Table)currentParent;
                    tab.getRows().add(row);
                    if (tab.getLayoutMode() > 0) {
                        row.getHeight().setString(elem.getAttribute("height"));
                        row.getHeight().setOriginString(row.getHeight().getString());
                    }
                    if ((attr2 = elem.getAttribute("styleID")) != null) {
                        ShareStyleAttributes ssa2 = null;
                        if (this.styleBuffer.containsKey(attr2)) {
                            ssa2 = (ShareStyleAttributes)this.styleBuffer.get(attr2);
                        } else {
                            ssa2 = this.stsvs.getStyleAttributes(attr2);
                            this.styleBuffer.put(attr2, ssa2);
                        }
                        row.setStyles(ssa2);
                    }
                }
                return null;
            }
            if (elem.getName().equalsIgnoreCase("Column")) {
                if (currentParent instanceof Table) {
                    String attr3;
                    Column col = new Column();
                    Table tab = (Table)currentParent;
                    tab.getCols().add(col);
                    if (tab.getLayoutMode() > 0) {
                        col.getWidth().setString(elem.getAttribute("width"));
                        col.getWidth().setOriginString(col.getWidth().getString());
                    }
                    if ((attr3 = elem.getAttribute("styleID")) != null) {
                        ShareStyleAttributes ssa3 = null;
                        if (this.styleBuffer.containsKey(attr3)) {
                            ssa3 = (ShareStyleAttributes)this.styleBuffer.get(attr3);
                        } else {
                            ssa3 = this.stsvs.getStyleAttributes(attr3);
                            this.styleBuffer.put(attr3, ssa3);
                        }
                        col.setStyles(ssa3);
                    }
                }
                return null;
            }
            if (elem.getName().equalsIgnoreCase("Cell")) {
                Cell cel = new Cell();
                cel.setId(elem.getAttribute("id"));
                cel.setUserAlias(elem.getAttribute("alias"));
                cdsn = elem.getChild("DesignedCell");
                if (cdsn != null) {
                    cel.setUserObject(cdsn);
                }
                cel.setClipContent(elem.getAttribute("clip"));
                cel.getLeft().setString(elem.getAttribute("left"));
                cel.getRight().setString(elem.getAttribute("right"));
                cel.getTop().setString(elem.getAttribute("top"));
                cel.getBottom().setString(elem.getAttribute("bottom"));
                cel.syncOriginString();
                cel.setVisibility(new EntityInfo(elem.getAttribute("visible")));
                cel.setHoldPlace(new EntityInfo(elem.getAttribute("holdPlace")));
                cel.setPreSteps(elem.getAttribute("preMacro"));
                cel.setPostSteps(elem.getAttribute("postMacro"));
                cel.setAnchor(elem.getAttribute("anchor"));
                cel.setHint(elem.getAttribute("hint"));
                cel.setType(elem.getAttribute("type"));
                cel.setDataFormat(elem.getAttribute("format"));
                attr = elem.getAttribute("styleID");
                if (attr != null) {
                    ssa = null;
                    if (this.styleBuffer.containsKey(attr)) {
                        ssa = (ShareStyleAttributes)this.styleBuffer.get(attr);
                    } else {
                        ssa = this.stsvs.getStyleAttributes(attr);
                        this.styleBuffer.put(attr, ssa);
                    }
                    cel.setStyles(ssa);
                }
                if ((attr = elem.getAttribute("layerID")) != null) {
                    cel.setLayer(attr);
                }
                if ((attr = elem.getAttribute("priority")) != null && FuncImpl.isInteger(attr)) {
                    cel.setPriority(Integer.parseInt(attr));
                }
                if (currentParent != null) {
                    currentParent.addChild(cel);
                    cel.setParent(currentParent);
                }
                if (cel.getId() != null && currentPage != null) {
                    currentPage.getIdTable().put(cel.getId(), cel);
                }
                DivideCharacter dc = DivideCharacter.load(elem);
                cel.setDivideCharacter(dc);
                currentParent = cel;
            } else if (elem.getName().equalsIgnoreCase("Data")) {
                if (currentParent instanceof Cell) {
                    Data data = new Data();
                    data.setType(elem.getAttribute("type"));
                    data.setFormat(elem.getText().trim());
                    Cell cel = (Cell)currentParent;
                    cel.setData(data);
                }
                return null;
            }
        }
        for (IXmlElement el : elem.getChildren()) {
            this.parsePureElement(currentForm, currentParent, currentPage, el);
        }
        this.sortChildren(currentParent);
        return currentParent;
    }

    public void setSnapMode(boolean snapMode) {
        this.snapMode = snapMode;
    }

    public void setDesignMode(boolean designMode) {
        this.designMode = designMode;
    }
}

