/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.form;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.data.Row;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.DataListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ChartData
implements Serializable {
    private static final Logger logger = LogUtil.getPackageLogger(ChartData.class);
    private static final long serialVersionUID = 3010597909450045851L;
    private String charType;
    private String title;
    private String[] seriesKeys;
    private String[] groupKeys;
    private double[][] values;
    private static final ChartData TRIVIAL_VALUE = new ChartData();

    public String getCharType() {
        return this.charType;
    }

    public void setCharType(String charType) {
        this.charType = charType;
    }

    public String[] getGroupKeys() {
        return this.groupKeys;
    }

    public void setGroupKeys(String[] groupKeys) {
        this.groupKeys = groupKeys;
    }

    public String[] getSeriesKeys() {
        return this.seriesKeys;
    }

    public void setSeriesKeys(String[] seriesKeys) {
        this.seriesKeys = seriesKeys;
    }

    public double[][] getValues() {
        return this.values;
    }

    public void setValues(double[][] values) {
        this.values = values;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.charType).append('|');
        if (this.title != null) {
            sb.append(this.title.replaceAll("\\|", ";#x7c;"));
        }
        sb.append('|');
        if (this.seriesKeys != null && this.seriesKeys.length > 0) {
            sb.append("CV:").append(this.seriesKeys[0]);
            for (i = 1; i < this.seriesKeys.length; ++i) {
                sb.append(',').append(this.seriesKeys[i]);
            }
        }
        sb.append('|');
        if (this.groupKeys != null && this.groupKeys.length > 0) {
            sb.append("CV:").append(this.groupKeys[0]);
            for (i = 1; i < this.groupKeys.length; ++i) {
                sb.append(',').append(this.groupKeys[i]);
            }
        }
        sb.append('|');
        if (this.values != null && this.values.length > 0) {
            sb.append("CV:");
            if (this.values[0].length > 0) {
                sb.append(this.values[0][0]);
            }
            for (i = 1; i < this.values[0].length; ++i) {
                sb.append(',').append(this.values[0][i]);
            }
            for (i = 1; i < this.values.length; ++i) {
                sb.append(':');
                if (this.values[i].length > 0) {
                    sb.append(this.values[i][0]);
                }
                for (int k = 1; k < this.values[i].length; ++k) {
                    sb.append(',').append(this.values[i][k]);
                }
            }
        }
        return sb.toString();
    }

    public static ChartData valueOf(String src, DataListener dataListener) {
        String[] ss;
        if (src != null && src.length() > 0 && (ss = src.split("\\|")).length > 0) {
            boolean hasValues;
            String seriesSource = null;
            String seriesField = null;
            String groupsSource = null;
            String groupsField = null;
            String valueSource = null;
            String[] valueFields = null;
            ChartData data = new ChartData();
            data.setCharType(ss[0]);
            if (ss.length > 1) {
                data.setTitle(ss[1]);
                if (ss.length > 2) {
                    String[] series;
                    if (ss[2].startsWith("CV:")) {
                        series = ss[2].substring(3).split("\\,");
                        data.setSeriesKeys(series);
                    } else if (ss[2].startsWith("DV:") && (series = ss[2].substring(3).split("\\:")).length > 0) {
                        seriesSource = series[0];
                        if (series.length > 1) {
                            seriesField = series[1];
                        }
                    }
                    if (ss.length > 3) {
                        String[] groups;
                        if (ss[3].startsWith("CV:")) {
                            groups = ss[3].substring(3).split("\\,");
                            data.setGroupKeys(groups);
                        } else if (ss[3].startsWith("DV:") && (groups = ss[3].substring(3).split("\\:")).length > 0) {
                            groupsSource = groups[0];
                            if (groups.length > 1) {
                                groupsField = groups[1];
                            }
                        }
                        if (ss.length > 4) {
                            String[] values;
                            if (ss[4].startsWith("CV:")) {
                                String[] ds = ss[4].substring(3).split("\\:");
                                if (ds.length > 0) {
                                    int i;
                                    String[] dd = ds[0].split("\\,");
                                    int size = dd.length;
                                    double[][] vals = new double[ds.length][size];
                                    for (i = 0; i < ds.length; ++i) {
                                        Arrays.fill(vals[i], 0.0);
                                    }
                                    for (i = 0; i < size; ++i) {
                                        vals[0][i] = Double.parseDouble(dd[i]);
                                    }
                                    for (i = 1; i < ds.length; ++i) {
                                        dd = ds[i].split("\\,");
                                        int msize = Math.max(size, dd.length);
                                        for (int k = 0; k < msize; ++k) {
                                            vals[i][k] = Double.parseDouble(dd[k]);
                                        }
                                    }
                                    data.setValues(vals);
                                }
                            } else if (ss[4].startsWith("DV:") && (values = ss[4].substring(3).split("\\:")).length > 0) {
                                valueSource = values[0];
                                if (values.length > 1) {
                                    String fieldsValue = values[1];
                                    valueFields = fieldsValue.split("\\,");
                                }
                            }
                        }
                    }
                }
            }
            boolean hasSeries = seriesSource != null && seriesField != null;
            boolean hasGroups = groupsSource != null && groupsField != null;
            boolean bl = hasValues = valueSource != null;
            if ((hasSeries || hasGroups || hasValues) && dataListener != null) {
                int i;
                boolean syncGroup = false;
                boolean syncValue = false;
                if (hasSeries) {
                    if (hasGroups && seriesSource.equals(groupsSource)) {
                        syncGroup = true;
                    }
                    if (hasValues && valueSource.equals(seriesSource)) {
                        syncValue = true;
                    }
                    ArrayList<String> serieList = new ArrayList<String>();
                    ArrayList<String> groupList = new ArrayList<String>();
                    ArrayList<double[]> valueList = new ArrayList<double[]>();
                    try {
                        int fsize = -1;
                        while (dataListener.hasNext(seriesSource)) {
                            dataListener.next(seriesSource);
                            Data dt = dataListener.getFieldData(seriesSource, seriesField);
                            serieList.add(((Variant)dt.getValue()).toString());
                            if (syncGroup) {
                                dt = dataListener.getFieldData(seriesSource, groupsField);
                                groupList.add(((Variant)dt.getValue()).toString());
                            }
                            if (!syncValue) continue;
                            if (valueFields != null) {
                                fsize = valueFields.length;
                                double[] dvalue = new double[fsize];
                                for (i = 0; i < fsize; ++i) {
                                    dt = dataListener.getFieldData(seriesSource, valueFields[i]);
                                    dvalue[i] = ((Variant)dt.getValue()).doubleValue();
                                }
                                valueList.add(dvalue);
                                continue;
                            }
                            Row drow = dataListener.getRow(seriesSource);
                            if (fsize < 0) {
                                fsize = drow.getFields().length;
                            }
                            double[] dvalue = new double[fsize];
                            for (int i2 = 0; i2 < fsize; ++i2) {
                                Variant vt = drow.get(i2);
                                dvalue[i2] = vt.doubleValue();
                            }
                            valueList.add(dvalue);
                        }
                    }
                    catch (SyntaxErrorException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    data.setSeriesKeys(serieList.toArray(new String[0]));
                    if (syncGroup) {
                        data.setGroupKeys(groupList.toArray(new String[0]));
                    }
                    if (syncValue) {
                        double[][] vals = (double[][])valueList.toArray((T[])new double[0][0]);
                        data.setValues(vals);
                    }
                }
                if (hasGroups && !syncGroup) {
                    if (hasValues && !syncValue && valueSource.equals(groupsSource)) {
                        syncValue = true;
                    }
                    ArrayList<String> groupList = new ArrayList<String>();
                    ArrayList<double[]> valueList = new ArrayList<double[]>();
                    try {
                        int fsize = -1;
                        while (dataListener.hasNext(groupsSource)) {
                            dataListener.next(groupsSource);
                            Data dt = dataListener.getFieldData(groupsSource, groupsField);
                            groupList.add(((Variant)dt.getValue()).toString());
                            if (!syncValue) continue;
                            if (valueFields != null) {
                                fsize = valueFields.length;
                                double[] dvalue = new double[fsize];
                                for (int i3 = 0; i3 < fsize; ++i3) {
                                    dt = dataListener.getFieldData(groupsSource, (String)valueFields[i3]);
                                    dvalue[i3] = ((Variant)dt.getValue()).doubleValue();
                                }
                                valueList.add(dvalue);
                                continue;
                            }
                            Row drow = dataListener.getRow(groupsSource);
                            if (fsize < 0) {
                                fsize = drow.getFields().length;
                            }
                            double[] dvalue = new double[fsize];
                            for (i = 0; i < fsize; ++i) {
                                Variant vt = drow.get(i);
                                dvalue[i] = vt.doubleValue();
                            }
                            valueList.add(dvalue);
                        }
                    }
                    catch (SyntaxErrorException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    data.setGroupKeys(groupList.toArray(new String[0]));
                    if (syncValue) {
                        double[][] vals = (double[][])valueList.toArray((T[])new double[0][0]);
                        data.setValues(vals);
                    }
                }
                if (hasValues && !syncValue) {
                    ArrayList<double[]> valueList = new ArrayList<double[]>();
                    try {
                        int fsize = -1;
                        while (dataListener.hasNext(valueSource)) {
                            dataListener.next(valueSource);
                            if (valueFields != null) {
                                fsize = valueFields.length;
                                double[] dvalue = new double[fsize];
                                for (int i4 = 0; i4 < fsize; ++i4) {
                                    Data dt = dataListener.getFieldData(valueSource, (String)valueFields[i4]);
                                    dvalue[i4] = ((Variant)dt.getValue()).doubleValue();
                                }
                                valueList.add(dvalue);
                                continue;
                            }
                            Row drow = dataListener.getRow(valueSource);
                            if (fsize < 0) {
                                fsize = drow.getFields().length;
                            }
                            double[] dvalue = new double[fsize];
                            for (int i5 = 0; i5 < fsize; ++i5) {
                                Variant vt = drow.get(i5);
                                dvalue[i5] = vt.doubleValue();
                            }
                            valueList.add(dvalue);
                        }
                    }
                    catch (SyntaxErrorException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    double[][] vals = (double[][])valueList.toArray((T[])new double[0][0]);
                    data.setValues(vals);
                }
            }
            return data;
        }
        return TRIVIAL_VALUE;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title != null ? title.replaceAll(";#x7c;", "|") : title;
    }
}

