/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.form;

import com.kingdee.cosmic.ctrl.common.digitalstyle.Formats;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.Dependents;
import com.kingdee.cosmic.ctrl.kdf.expr.Macro;
import com.kingdee.cosmic.ctrl.kdf.expr.MacroHelperListener;
import com.kingdee.cosmic.ctrl.kdf.expr.Parser;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.form.Area;
import com.kingdee.cosmic.ctrl.kdf.form.AreaContinueInfo;
import com.kingdee.cosmic.ctrl.kdf.form.BaseDataListener;
import com.kingdee.cosmic.ctrl.kdf.form.CachedDataListenerDecorator;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.ChartData;
import com.kingdee.cosmic.ctrl.kdf.form.Column;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.DataListener;
import com.kingdee.cosmic.ctrl.kdf.form.EventListener;
import com.kingdee.cosmic.ctrl.kdf.form.FormExt;
import com.kingdee.cosmic.ctrl.kdf.form.FormXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.form.FuncImpl;
import com.kingdee.cosmic.ctrl.kdf.form.Group;
import com.kingdee.cosmic.ctrl.kdf.form.LayerCollection;
import com.kingdee.cosmic.ctrl.kdf.form.NullEventListener;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.PageCollection;
import com.kingdee.cosmic.ctrl.kdf.form.PageInfo;
import com.kingdee.cosmic.ctrl.kdf.form.PaginationInfo;
import com.kingdee.cosmic.ctrl.kdf.form.Panel;
import com.kingdee.cosmic.ctrl.kdf.form.Property;
import com.kingdee.cosmic.ctrl.kdf.form.PropertyCollection;
import com.kingdee.cosmic.ctrl.kdf.form.Row;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeServiceProvider;
import com.kingdee.cosmic.ctrl.kdf.form.Table;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.AbstractNotePrint;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.FormPageProvider;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.cosmic.ctrl.kdf.util.render.util.Tools;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public final class Form
implements MacroHelperListener,
Serializable {
    private static final Logger log = LogUtil.getLogger(Form.class);
    private static final long serialVersionUID = 427230245L;
    private String id;
    private String userAlias;
    private String headerID;
    private String footerID;
    private PageCollection pages = new PageCollection();
    private PageCollection outPages = new PageCollection();
    private ArrayList tempOutPages = new ArrayList();
    private PropertyCollection properties;
    private LayerCollection layers;
    private Object userObject;
    private transient RuntimeServiceProvider rsp;
    private transient DataListener dataListener;
    private transient BaseDataListener baseDataListener;
    private transient EventListener eventListener;
    private transient HashMap groupCountTable;
    private transient HashMap groupFieldValueTable;
    private transient HashMap groupLevelCountTable;
    private transient HashMap groupEndTokenMap;
    private transient HashMap pageNumberAtGroup;
    private transient HashMap cellsWaitToFill;
    private transient HashMap groupHasNextMap;
    private transient HashMap areaSubTotalMap;
    private transient HashMap groupSubTotalMap;
    private transient HashMap groupSubTotalFieldCache;
    private transient HashMap namedOutputComponentMap;
    private transient HashMap currentLoopCountMap;
    private transient ArrayList trashListForNextCopy;
    private transient int repeatToken;
    private transient int newPageCount;
    private transient boolean createNew;
    private transient Dependents formulaEngine;
    private transient Dependents funcEngine;
    private transient Macro macroEngine;
    private transient FontRenderContext frc;
    private transient FuncImpl funcImplObj;
    private transient String currentDataSource;
    private transient String currentGroupField;
    private transient Variant rvarResult;
    private transient ArrayList userFuncs = new ArrayList();
    private static final int PAGINATION_AREACONTINUE_MODE = 0;
    private static final int PAGINATION_FORCEBREAK_MODE = 1;
    private static final int PAGINATION_MIXED_MODE = 2;
    protected static final String DUMMY_ID = ".";
    private boolean _forceStop = false;

    public Form() {
        this.properties = PropertyCollection.getEmptyPropertyCollection();
        this.layers = new LayerCollection();
    }

    public Form(String ID) {
        this();
        this.setId(ID);
    }

    public void registerUserFuncProvider(Object provider) {
        if (provider != null) {
            this.userFuncs.add(provider);
        }
    }

    public ArrayList getUserFuncProviders() {
        return this.userFuncs;
    }

    public void removeUserFuncProvider(Object provider) {
        this.userFuncs.remove(provider);
    }

    public int initOutput(EventListener elistener, DataListener dlistener, PageInfo info) {
        int pyb;
        int pxr;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Page info:" + info.getWidth() + "x" + info.getHeight()));
        }
        this.baseDataListener = new BaseDataListener(this.rsp.getRuntimeDataService());
        this.eventListener = elistener != null ? elistener : NullEventListener.instance();
        this.dataListener = dlistener == null ? this.baseDataListener : dlistener;
        this.dataListener = new CachedDataListenerDecorator(this.dataListener);
        this.funcImplObj = new FuncImpl(this);
        this.funcEngine = new Dependents();
        this.funcEngine.addMacroRelationsListener((MacroHelperListener)this);
        this.funcEngine.setCalculateThrough(true);
        this.funcEngine.setDefaultFunctionProvider((Object)this.funcImplObj);
        this.macroEngine = new Macro();
        this.macroEngine.addMacroRelationsListener((MacroHelperListener)this);
        this.macroEngine.setDefaultFunctionProvider((Object)this.funcImplObj);
        this.outPages = new PageCollection();
        this.tempOutPages = new ArrayList();
        this.groupCountTable = new HashMap();
        this.groupFieldValueTable = new HashMap();
        this.groupLevelCountTable = new HashMap();
        this.groupEndTokenMap = new HashMap();
        this.pageNumberAtGroup = new HashMap();
        this.cellsWaitToFill = new HashMap();
        this.groupHasNextMap = new HashMap();
        this.areaSubTotalMap = new HashMap();
        this.groupSubTotalMap = new HashMap();
        this.groupSubTotalFieldCache = new HashMap();
        this.namedOutputComponentMap = new HashMap();
        this.currentLoopCountMap = new HashMap();
        this.trashListForNextCopy = new ArrayList();
        this.rvarResult = new Variant();
        this.newPageCount = 0;
        this.createNew = false;
        int pyt = 0;
        int pxl = 0;
        if (info != null) {
            pxr = info.getWidth();
            pyb = info.getHeight();
            this.frc = info.getFrc();
            if (pxr < 0) {
                pxr = Integer.MAX_VALUE;
            }
            if (pyb < 0) {
                pyb = Integer.MAX_VALUE;
            }
        } else {
            pyb = 0;
            pxr = 0;
        }
        Container oldPage = null;
        this.eventListener.beginFormOutput(this.getId());
        AuxParam param = new AuxParam();
        Iterator itr = this.pages.iterator();
        int maxPagesLimit = AbstractNotePrint.getMaxPagesLimit();
        while (itr.hasNext()) {
            Page currentPage = (Page)itr.next();
            this.initPageSize(currentPage, info);
            this.repeatToken = -1;
            HashMap<Area, Container> trashTable = new HashMap<Area, Container>(16);
            for (int pageIndex = 0; pageIndex < currentPage.getRepeat() || currentPage.getRepeat() == -1 && (this.repeatToken == -1 || this.repeatToken > 0); ++pageIndex) {
                if (this._forceStop || Thread.currentThread().isInterrupted() || this.newPageCount >= maxPagesLimit) {
                    this.funcEngine = null;
                    this.macroEngine = null;
                    this.formulaEngine = null;
                    this.funcImplObj = null;
                    this.groupCountTable = null;
                    this.groupFieldValueTable = null;
                    this.groupLevelCountTable = null;
                    this.groupEndTokenMap = null;
                    this.pageNumberAtGroup = null;
                    this.cellsWaitToFill = null;
                    this.groupHasNextMap = null;
                    this.areaSubTotalMap = null;
                    this.groupSubTotalMap = null;
                    this.groupSubTotalFieldCache = null;
                    this.trashListForNextCopy = null;
                    this.namedOutputComponentMap = null;
                    this.currentLoopCountMap = null;
                    this.eventListener.endFormOutput(this.getId());
                    return this.outPages.size();
                }
                int pew = 0;
                int peh = 0;
                this.repeatToken = 0;
                this.formulaEngine = new Dependents();
                this.formulaEngine.addMacroRelationsListener((MacroHelperListener)currentPage);
                this.formulaEngine.setCalculateThrough(true);
                this.formulaEngine.setDefaultFunctionProvider((Object)this.funcImplObj);
                Page currentOutPage = new Page(currentPage.getId());
                currentOutPage.setAnchor(currentPage.getAnchor());
                currentOutPage.setHint(currentPage.getHint());
                currentOutPage.setStyles(currentPage.getStyles());
                currentOutPage.copyCustomStyles(currentPage.getCustomStyles());
                currentOutPage.copyProperties(currentPage.getProperties());
                this.initPageSize(currentOutPage, info);
                currentOutPage.setSource(currentPage);
                currentOutPage.setForm(this);
                currentOutPage.setIndex(this.newPageCount++);
                this.tempOutPages.add(currentOutPage);
                Object currentGroup = null;
                Page currentParent = currentOutPage;
                this.eventListener.beginPageOutput(currentOutPage.getId(), this.newPageCount - 1);
                Group gp = this.getParentFieldGroup(currentPage);
                Group dsgp = this.getParentDataSourceGroup(currentPage);
                String srckey = dsgp == null ? null : dsgp.getDataSource();
                String gfd = gp == null ? null : gp.getField();
                this.currentDataSource = srckey;
                this.currentGroupField = gfd;
                if (oldPage != null) {
                    PaginationInfo pi;
                    if (oldPage.getId() == currentPage.getId()) {
                        currentPage.restoreOriginString();
                        this.initPageSize(currentPage, info);
                    }
                    if ((pi = ((Page)oldPage).getPaginationInfo()).getActive()) {
                        PaginationInfo cpi = currentOutPage.getPaginationInfo();
                        int mode = pi.getMode();
                        if (mode == 0 || mode == 2) {
                            for (AreaContinueInfo aci : pi.getAreaContinueInfos()) {
                                if (!aci.isActive()) continue;
                                Area ara = (Area)currentPage.getObjectByName(aci.getAreaName());
                                if (ara != null) {
                                    Container gcont = aci.getGroup();
                                    if (gcont == null) continue;
                                    Container ocont = currentPage.getObjectByName(gcont.getAliasName());
                                    if (ocont == null) {
                                        Container ncont = gcont.copyTo(ara, false);
                                        ncont.setAliasName(ncont.getFullName());
                                        ara.addChild(ncont);
                                        trashTable.put(ara, ncont);
                                        Form.updateIdTable(true, ncont, currentPage);
                                    } else if (ocont.parent != null) {
                                        ocont.parent.restoreOriginString();
                                    } else {
                                        ocont.restoreOriginString();
                                    }
                                    aci.setActive(false);
                                    continue;
                                }
                                if (!cpi.getActive()) {
                                    cpi.setActive(true);
                                    cpi.setMode(0);
                                } else if (cpi.getMode() == 1) {
                                    cpi.setMode(2);
                                }
                                cpi.getAreaContinueInfos().add(aci);
                            }
                        }
                    } else {
                        this.createNew = false;
                    }
                    pi.getAreaContinueInfos().clear();
                    pi.getComponents().clear();
                }
                if (!this.createNew) {
                    Iterator cpitr = currentPage.iterator();
                    while (cpitr.hasNext()) {
                        Container cont;
                        param.cont = cont = (Container)cpitr.next();
                        param.currentGroup = currentGroup;
                        param.currentParent = currentParent;
                        param.currentOutPage = currentOutPage;
                        param.currentPage = currentPage;
                        param.xl = pxl;
                        param.xr = pxr;
                        param.yt = pyt;
                        param.yb = pyb;
                        param.isDataNext = true;
                        param.parentArea = null;
                        Container rcon = this.outputComponent(param);
                        if (rcon == null) continue;
                        if (currentOutPage.getRight().getInteger() < 0 && rcon.getRight().getInteger() > pew) {
                            pew = rcon.getRight().getInteger();
                        }
                        if (currentOutPage.getBottom().getInteger() >= 0 || rcon.getBottom().getInteger() <= peh) continue;
                        peh = rcon.getBottom().getInteger();
                    }
                }
                if (trashTable.size() > 0) {
                    for (Map.Entry entry : trashTable.entrySet()) {
                        Container tcont = (Container)entry.getValue();
                        ((Area)entry.getKey()).deleteChild(tcont);
                        Form.updateIdTable(false, tcont, currentPage);
                    }
                    trashTable.clear();
                }
                if (this.trashListForNextCopy.size() > 0) {
                    for (Container cpcont : this.trashListForNextCopy) {
                        Form.updateIdTable(false, cpcont, currentPage);
                    }
                    this.trashListForNextCopy.clear();
                }
                if (currentOutPage.getRight().getInteger() < 0) {
                    currentOutPage.getRight().setString(null);
                    currentOutPage.getRight().setInteger(pew);
                }
                if (currentOutPage.getBottom().getInteger() < 0) {
                    currentOutPage.getBottom().setString(null);
                    currentOutPage.getBottom().setInteger(peh);
                }
                oldPage = currentOutPage;
                this.realOutputPage();
            }
        }
        this.eventListener.endFormOutput(this.getId());
        this.funcEngine = null;
        this.macroEngine = null;
        this.formulaEngine = null;
        this.funcImplObj = null;
        this.groupCountTable = null;
        this.groupFieldValueTable = null;
        this.groupLevelCountTable = null;
        this.groupEndTokenMap = null;
        this.pageNumberAtGroup = null;
        this.cellsWaitToFill = null;
        this.groupHasNextMap = null;
        this.areaSubTotalMap = null;
        this.groupSubTotalMap = null;
        this.groupSubTotalFieldCache = null;
        this.trashListForNextCopy = null;
        this.namedOutputComponentMap = null;
        this.currentLoopCountMap = null;
        return this.outPages.size();
    }

    private Container outputComponent(AuxParam param) {
        String srckey;
        Group dsgp;
        if (param.cont instanceof Cell) {
            return this.outputCell(param);
        }
        if (param.parentArea != null && 0 == param.parentArea.getMinLoopCount() && (dsgp = this.getParentDataSourceGroup(param.cont)) != null && !this.dataListener.hasNext(srckey = dsgp.getDataSource()) && -1 == this.dataListener.getCurrentRecordNumber(srckey)) {
            return null;
        }
        Container cnt = this.outputContainer(param);
        if (log.isDebugEnabled() && cnt != null) {
            FormExt.deubgContainer(cnt);
        }
        return cnt;
    }

    Container outputCell(AuxParam param) {
        int temp;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        Cell cel = (Cell)param.cont;
        Data nData = null;
        this.handlePreExpression(cel, cel.getPreSteps());
        if (cel.getType().equalsIgnoreCase("groupTotal")) {
            String srckey;
            String gfd;
            String aname = cel.getAliasName();
            if (!this.groupSubTotalFieldCache.containsKey(aname)) {
                Container pcont = this.getParentInNearestArea(cel);
                if (pcont != null) {
                    Iterator itr = pcont.iterator();
                    while (itr.hasNext()) {
                        Iterator aitr;
                        Container tcont = (Container)itr.next();
                        if (!(tcont instanceof Area) || !(aitr = tcont.iterator()).hasNext()) continue;
                        Container gcont = (Container)aitr.next();
                        gfd = gcont.group().getField();
                        this.groupSubTotalFieldCache.put(aname, gfd);
                        break;
                    }
                }
                if (!this.groupSubTotalFieldCache.containsKey(aname)) {
                    return null;
                }
            }
            gfd = (String)this.groupSubTotalFieldCache.get(aname);
            Group group = this.getParentDataSourceGroup(cel);
            String string = srckey = group != null ? group.getDataSource() : null;
            if (!this.groupEndTokenMap.containsKey(srckey)) {
                return null;
            }
            HashMap fdMap = (HashMap)this.groupEndTokenMap.get(srckey);
            if (fdMap.containsKey(gfd)) {
                return null;
            }
        }
        int epc = 0;
        try {
            temp = this.rvarResult.intValue();
            if (cel.getLeft().getString() != null && this.formulaEngine.calculate(DUMMY_ID, cel.getLeft().getString(), this.rvarResult)) {
                cel.getLeft().setInteger(temp);
                ++epc;
            }
            if (cel.getRight().getString() != null && this.formulaEngine.calculate(DUMMY_ID, cel.getRight().getString(), this.rvarResult)) {
                cel.getRight().setInteger(temp);
                ++epc;
            }
            if (cel.getTop().getString() != null && this.formulaEngine.calculate(DUMMY_ID, cel.getTop().getString(), this.rvarResult)) {
                cel.getTop().setInteger(temp);
                ++epc;
            }
            if (cel.getBottom().getString() != null && this.formulaEngine.calculate(DUMMY_ID, cel.getBottom().getString(), this.rvarResult)) {
                cel.getBottom().setInteger(temp);
                ++epc;
            }
            if (epc < 4) {
                if (cel.getData() == null) {
                    throw new AssertionError((Object)("Cannot calculate drawing size of null data: " + cel));
                }
                nData = new Data();
                this.getData(nData, cel, null);
                Style stl = Form.getDrawStyle(cel);
                Dimension dSize = new Dimension(0, 0);
                if (Data.isImageType(nData.getType())) {
                    Image img = FormPageProvider.loadFormCellImage2(nData);
                    if (img != null) {
                        dSize.setSize((double)img.getWidth(null) * 254.0 / 72.0, (double)img.getHeight(null) * 254.0 / 72.0);
                    }
                } else {
                    String val = nData.getValue().toString();
                    if (val == null || val.length() == 0) {
                        val = " ";
                    }
                    dSize = cel.getLeft().getString() != null && cel.getRight().getString() != null ? Tools.getBreakedTextAreaSize((int)(cel.getRight().getInteger() - cel.getLeft().getInteger()), (String)val, (Style)stl, (FontRenderContext)this.frc) : Tools.getBreakedTextAreaSize((String)val, (Style)stl, (FontRenderContext)this.frc);
                }
                if (epc == 3) {
                    if (cel.getLeft().getString() == null) {
                        cel.getLeft().setInteger(cel.getRight().getInteger() - dSize.width);
                        cel.getLeft().setString(String.valueOf(cel.getLeft().getInteger()));
                    } else if (cel.getRight().getString() == null) {
                        cel.getRight().setInteger(cel.getLeft().getInteger() + dSize.width);
                        cel.getRight().setString(String.valueOf(cel.getRight().getInteger()));
                    } else if (cel.getTop().getString() == null) {
                        cel.getTop().setInteger(cel.getBottom().getInteger() - dSize.height);
                        cel.getTop().setString(String.valueOf(cel.getTop().getInteger()));
                    } else if (cel.getBottom().getString() == null) {
                        cel.getBottom().setInteger(cel.getTop().getInteger() + dSize.height);
                        cel.getBottom().setString(String.valueOf(cel.getBottom().getInteger()));
                    }
                } else if (epc == 2) {
                    if (cel.getTop().getString() == null && cel.getBottom().getString() == null) {
                        if (stl.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE) {
                            int t = (param.yb - param.yt - dSize.height) / 2;
                            int b = t + dSize.height;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.TOP) {
                            int t = param.yt;
                            int b = t + dSize.height;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.BOTTOM) {
                            int t = param.yb - dSize.height;
                            int b = param.yb;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        }
                    } else if (cel.getLeft().getString() == null && cel.getRight().getString() == null) {
                        if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                            int l = (param.xr - param.xl - dSize.width) / 2;
                            int r = l + dSize.width;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT) {
                            int l = param.xl;
                            int r = l + dSize.width;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                            int l = param.xr - dSize.width;
                            int r = param.xr;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        }
                    } else if (cel.getLeft().getString() == null && cel.getTop().getString() == null) {
                        int l = cel.getRight().getInteger() - dSize.width;
                        int t = cel.getBottom().getInteger() - dSize.height;
                        cel.getLeft().setInteger(l);
                        cel.getLeft().setString(String.valueOf(l));
                        cel.getTop().setInteger(t);
                        cel.getTop().setString(String.valueOf(t));
                    } else if (cel.getRight().getString() == null && cel.getTop().getString() == null) {
                        int r = cel.getLeft().getInteger() + dSize.width;
                        int t = cel.getBottom().getInteger() - dSize.height;
                        cel.getRight().setInteger(r);
                        cel.getRight().setString(String.valueOf(r));
                        cel.getTop().setInteger(t);
                        cel.getTop().setString(String.valueOf(t));
                    } else if (cel.getLeft().getString() == null && cel.getBottom().getString() == null) {
                        int l = cel.getRight().getInteger() - dSize.width;
                        int b = cel.getTop().getInteger() + dSize.height;
                        cel.getLeft().setInteger(l);
                        cel.getLeft().setString(String.valueOf(l));
                        cel.getBottom().setInteger(b);
                        cel.getBottom().setString(String.valueOf(b));
                    } else if (cel.getRight().getString() == null && cel.getBottom().getString() == null) {
                        int r = cel.getLeft().getInteger() + dSize.width;
                        int b = cel.getTop().getInteger() + dSize.height;
                        cel.getRight().setInteger(r);
                        cel.getRight().setString(String.valueOf(r));
                        cel.getBottom().setInteger(b);
                        cel.getBottom().setString(String.valueOf(b));
                    }
                } else if (epc == 1) {
                    if (cel.getLeft().getString() != null || cel.getRight().getString() != null) {
                        int t;
                        if (cel.getLeft().getString() != null) {
                            int r = cel.getLeft().getInteger() + dSize.width;
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        } else {
                            int l = cel.getRight().getInteger() - dSize.width;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                        }
                        if (stl.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE) {
                            t = (param.yb - param.yt - dSize.height) / 2;
                            int b = t + dSize.height;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.TOP) {
                            t = param.yt;
                            int b = t + dSize.height;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.BOTTOM) {
                            t = param.yb - dSize.height;
                            int b = param.yb;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        }
                    } else {
                        int l;
                        if (cel.getTop().getString() != null) {
                            int b = cel.getTop().getInteger() + dSize.height;
                            cel.getBottom().setInteger(b);
                            cel.getBottom().setString(String.valueOf(b));
                        } else {
                            int t = cel.getBottom().getInteger() - dSize.height;
                            cel.getTop().setInteger(t);
                            cel.getTop().setString(String.valueOf(t));
                        }
                        if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                            l = (param.xr - param.xl - dSize.width) / 2;
                            int r = l + dSize.width;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT) {
                            l = param.xl;
                            int r = l + dSize.width;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                            l = param.xr - dSize.width;
                            int r = param.xr;
                            cel.getLeft().setInteger(l);
                            cel.getLeft().setString(String.valueOf(l));
                            cel.getRight().setInteger(r);
                            cel.getRight().setString(String.valueOf(r));
                        }
                    }
                } else {
                    if (stl.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE) {
                        int t = (param.yb - param.yt - dSize.height) / 2;
                        int b = t + dSize.height;
                        cel.getTop().setInteger(t);
                        cel.getTop().setString(String.valueOf(t));
                        cel.getBottom().setInteger(b);
                        cel.getBottom().setString(String.valueOf(b));
                    } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.TOP) {
                        int t = param.yt;
                        int b = t + dSize.height;
                        cel.getTop().setInteger(t);
                        cel.getTop().setString(String.valueOf(t));
                        cel.getBottom().setInteger(b);
                        cel.getBottom().setString(String.valueOf(b));
                    } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.BOTTOM) {
                        int t = param.yb - dSize.height;
                        int b = param.yb;
                        cel.getTop().setInteger(t);
                        cel.getTop().setString(String.valueOf(t));
                        cel.getBottom().setInteger(b);
                        cel.getBottom().setString(String.valueOf(b));
                    }
                    if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                        int l = (param.xr - param.xl - dSize.width) / 2;
                        int r = l + dSize.width;
                        cel.getLeft().setInteger(l);
                        cel.getLeft().setString(String.valueOf(l));
                        cel.getRight().setInteger(r);
                        cel.getRight().setString(String.valueOf(r));
                    } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT) {
                        int l = param.xl;
                        int r = l + dSize.width;
                        cel.getLeft().setInteger(l);
                        cel.getLeft().setString(String.valueOf(l));
                        cel.getRight().setInteger(r);
                        cel.getRight().setString(String.valueOf(r));
                    } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                        int l = param.xr - dSize.width;
                        int r = param.xr;
                        cel.getLeft().setInteger(l);
                        cel.getLeft().setString(String.valueOf(l));
                        cel.getRight().setInteger(r);
                        cel.getRight().setString(String.valueOf(r));
                    }
                }
            }
        }
        catch (SyntaxErrorException e) {
            throw new AssertionError((Object)("position formula parse error in cell: " + param.cont));
        }
        if (cel.getParent() instanceof Table) {
            if (epc < 4) {
                throw new AssertionError((Object)("Must have full four edge info when in a Table: " + cel));
            }
            this.calculatePositionInTable(cel);
        }
        if (cel.getVisibility().getString() == null || cel.getVisibility().getString().length() == 0) {
            cel.getVisibility().setInteger(1);
            cel.getHoldPlace().setInteger(1);
        } else {
            try {
                temp = this.rvarResult.intValue();
                if (this.formulaEngine.calculate(DUMMY_ID, cel.getVisibility().getString(), this.rvarResult)) {
                    cel.getVisibility().setInteger(temp);
                    if (cel.getVisibility().getInteger() == 0) {
                        if (cel.getHoldPlace().getString() != null) {
                            if (this.formulaEngine.calculate(DUMMY_ID, cel.getHoldPlace().getString(), this.rvarResult)) {
                                cel.getHoldPlace().setInteger(temp);
                                if (cel.getHoldPlace().getInteger() == 0) {
                                    cel.getRight().setInteger(cel.getLeft().getInteger());
                                    cel.getRight().setString(String.valueOf(cel.getRight().getInteger()));
                                    cel.getBottom().setInteger(cel.getTop().getInteger());
                                    cel.getBottom().setString(String.valueOf(cel.getBottom().getInteger()));
                                }
                            }
                        } else {
                            cel.getHoldPlace().setInteger(1);
                        }
                        nData = null;
                        return null;
                    }
                }
            }
            catch (SyntaxErrorException e1) {
                log.error((Object)"err", (Throwable)e1);
            }
        }
        if (cel.getTop().getInteger() < param.yt || cel.getTop().getInteger() >= param.yb || cel.getBottom().getInteger() > param.yb || cel.getBottom().getInteger() <= param.yt || cel.getLeft().getInteger() < param.xl || cel.getLeft().getInteger() >= param.xr || cel.getRight().getInteger() > param.xr || cel.getRight().getInteger() < param.xl) {
            nData = null;
            return null;
        }
        Cell nCel = new Cell();
        nCel.copyOriginString(cel);
        nCel.copyInteger(cel);
        nCel.setSource(cel.getSource());
        nCel.setLayer(cel.getLayer());
        nCel.setAnchor(cel.getAnchor());
        nCel.setHint(cel.getHint());
        nCel.setStyles(cel.getStyles());
        nCel.copyCustomStyles(cel.getCustomStyles());
        nCel.copyProperties(cel.getProperties());
        nCel.setDivideCharacter(cel.getDivideCharacter());
        param.currentParent.addChild(nCel);
        nCel.setParent(param.currentParent);
        this.namedOutputComponentMap.put(cel.getId(), nCel);
        if (nData == null) {
            nData = new Data();
            nCel.setData(nData);
            this.getData(nData, cel, nCel);
        } else {
            nCel.setData(nData);
        }
        if (cel.getType().equalsIgnoreCase("groupTotal")) {
            if (this.groupSubTotalMap.containsKey(cel)) {
                AuxGroupTotal agt = (AuxGroupTotal)this.groupSubTotalMap.get(cel);
                agt.newCell = nCel;
            }
        } else if (cel.getType().equalsIgnoreCase("areaTotal") && this.areaSubTotalMap.containsKey(cel)) {
            AuxAreaTotal aat = (AuxAreaTotal)this.areaSubTotalMap.get(cel);
            aat.newCell = nCel;
        }
        this.handlePostExpression(cel, nCel, cel.getPostSteps());
        return nCel;
    }

    private void calculatePositionInTable(Container cont) throws AssertionError {
        int i;
        Table pTab = (Table)cont.getParent();
        int mrc = pTab.getRows().size();
        int mcc = pTab.getCols().size();
        if (cont.getLeft().getInteger() < 1 || cont.getLeft().getInteger() > mcc || cont.getRight().getInteger() < 1 || cont.getRight().getInteger() > mcc || cont.getTop().getInteger() < 1 || cont.getTop().getInteger() > mrc || cont.getBottom().getInteger() < 1 || cont.getBottom().getInteger() > mrc) {
            throw new AssertionError((Object)("Cell coordinate exceed table scope: " + cont));
        }
        int nb = 0;
        int nt = 0;
        int nr = 0;
        int nl = 0;
        for (i = 1; i < cont.getLeft().getInteger(); ++i) {
            nl += pTab.getCols().get(i - 1).getWidth().getInteger();
        }
        for (i = 0; i < cont.getRight().getInteger(); ++i) {
            nr += pTab.getCols().get(i).getWidth().getInteger();
        }
        for (i = 1; i < cont.getTop().getInteger(); ++i) {
            nt += pTab.getRows().get(i - 1).getHeight().getInteger();
        }
        for (i = 0; i < cont.getBottom().getInteger(); ++i) {
            nb += pTab.getRows().get(i).getHeight().getInteger();
        }
        cont.getLeft().setInteger(pTab.getLeft().getInteger() + nl);
        cont.getLeft().setString(String.valueOf(cont.getLeft().getInteger()));
        cont.getRight().setInteger(pTab.getLeft().getInteger() + nr);
        cont.getRight().setString(String.valueOf(cont.getRight().getInteger()));
        cont.getTop().setInteger(pTab.getTop().getInteger() + nt);
        cont.getTop().setString(String.valueOf(cont.getTop().getInteger()));
        cont.getBottom().setInteger(pTab.getTop().getInteger() + nb);
        cont.getBottom().setString(String.valueOf(cont.getBottom().getInteger()));
    }

    private Container outputContainer(AuxParam param) {
        String srckey;
        Group dsgp;
        Group gp;
        int eb;
        int er;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        int xl = param.xl;
        int xr = param.xr;
        int yt = param.yt;
        int yb = param.yb;
        this.handlePreExpression(param.cont, param.cont.getPreSteps());
        int epc = 0;
        int eps = (param.cont.getLeft().getString() == null ? 8 : 0) + (param.cont.getRight().getString() == null ? 4 : 0) + (param.cont.getTop().getString() == null ? 2 : 0) + (param.cont.getBottom().getString() == null ? 1 : 0);
        try {
            int temp = this.rvarResult.intValue();
            if (param.cont.getLeft().getString() != null && this.formulaEngine.calculate(DUMMY_ID, param.cont.getLeft().getString(), this.rvarResult)) {
                param.cont.getLeft().setInteger(temp);
                ++epc;
            }
            if (param.cont.getRight().getString() != null && this.formulaEngine.calculate(DUMMY_ID, param.cont.getRight().getString(), this.rvarResult)) {
                param.cont.getRight().setInteger(temp);
                ++epc;
            }
            if (param.cont.getTop().getString() != null && this.formulaEngine.calculate(DUMMY_ID, param.cont.getTop().getString(), this.rvarResult)) {
                param.cont.getTop().setInteger(temp);
                ++epc;
            }
            if (param.cont.getBottom().getString() != null && this.formulaEngine.calculate(DUMMY_ID, param.cont.getBottom().getString(), this.rvarResult)) {
                param.cont.getBottom().setInteger(temp);
                ++epc;
            }
            if (param.cont.getParent() instanceof Table) {
                if (epc < 4) {
                    throw new AssertionError((Object)("Must have full four edge info when in a Table: " + param.cont));
                }
                this.calculatePositionInTable(param.cont);
            }
            if (param.cont.getLeft().getString() != null && param.cont.getLeft().getInteger() > xl) {
                xl = param.cont.getLeft().getInteger();
            }
            if (param.cont.getRight().getString() != null && param.cont.getRight().getInteger() < xr) {
                xr = param.cont.getRight().getInteger();
            }
            if (param.cont.getTop().getString() != null && param.cont.getTop().getInteger() > yt) {
                yt = param.cont.getTop().getInteger();
            }
            if (param.cont.getBottom().getString() != null && param.cont.getBottom().getInteger() < yb) {
                yb = param.cont.getBottom().getInteger();
            }
            if (epc < 4) {
                int yboff = 0;
                int ybtemp = yb;
                if (epc == 3) {
                    Iterator bitr = param.cont.parent.iterator();
                    while (bitr.hasNext()) {
                        Cell cel;
                        Container cont = (Container)bitr.next();
                        if (cont == param.cont || cont instanceof Cell && (cel = (Cell)cont).getType().equalsIgnoreCase("groupTotal") || param.cont.getBottom().getString() != null || cont.getTop().getString() == null) continue;
                        if (this.formulaEngine.calculate(DUMMY_ID, cont.getTop().getString(), this.rvarResult)) {
                            cont.getTop().setInteger(temp);
                        }
                        if (cont.getTop().getInteger() < param.cont.getTop().getInteger() || cont.getLeft().getString() == null && cont.getRight().getString() == null) continue;
                        if (cont.getLeft().getString() == null) {
                            if (this.formulaEngine.calculate(DUMMY_ID, cont.getRight().getString(), this.rvarResult)) {
                                cont.getRight().setInteger(temp);
                            }
                            if (cont.getRight().getInteger() <= param.cont.getLeft().getInteger()) {
                                continue;
                            }
                        } else if (cont.getRight().getString() == null) {
                            if (this.formulaEngine.calculate(DUMMY_ID, cont.getLeft().getString(), this.rvarResult)) {
                                cont.getLeft().setInteger(temp);
                            }
                            if (cont.getLeft().getInteger() >= param.cont.getRight().getInteger()) {
                                continue;
                            }
                        } else {
                            if (this.formulaEngine.calculate(DUMMY_ID, cont.getRight().getString(), this.rvarResult)) {
                                cont.getRight().setInteger(temp);
                            }
                            if (this.formulaEngine.calculate(DUMMY_ID, cont.getLeft().getString(), this.rvarResult)) {
                                cont.getLeft().setInteger(temp);
                            }
                            if (cont.getLeft().getInteger() >= param.cont.getRight().getInteger() || cont.getRight().getInteger() <= param.cont.getLeft().getInteger()) continue;
                        }
                        String deper = cont.getId() + ".top";
                        String depee = param.cont.getId() + ".bottom";
                        this.formulaEngine.removeAll();
                        this.formulaEngine.add(deper, cont.getTop().getString());
                        this.formulaEngine.add(depee, depee);
                        this.formulaEngine.calcQueue();
                        if (this.formulaEngine.isDependent(deper, depee)) {
                            boolean calculate;
                            if (this.formulaEngine.calculate(DUMMY_ID, Page.getUsableBottom(cont), this.rvarResult)) {
                                cont.getBottom().setInteger(temp);
                            }
                            if (!(calculate = this.formulaEngine.calculate(DUMMY_ID, Page.getUsableBottom(param.cont), this.rvarResult)) || yboff >= cont.getBottom().getInteger() - temp) continue;
                            yboff = cont.getBottom().getInteger() - temp;
                            continue;
                        }
                        if (this.formulaEngine.calculate(DUMMY_ID, Page.getUsableTop(cont), this.rvarResult)) {
                            cont.getTop().setInteger(temp);
                        }
                        if (ybtemp <= cont.getTop().getInteger()) continue;
                        ybtemp = cont.getTop().getInteger();
                    }
                } else if (epc == 2 || epc == 1) {
                    // empty if block
                }
                yb = yb - yboff < ybtemp ? (yb -= yboff) : ybtemp;
            }
        }
        catch (SyntaxErrorException e) {
            throw new AssertionError((Object)("position formula parse error in container: " + param.cont));
        }
        int el = er = xl;
        int et = eb = yt;
        if (param.cont instanceof Panel) {
            gp = this.getParentFieldGroup(param.cont);
            dsgp = this.getParentDataSourceGroup(param.cont);
            srckey = dsgp == null ? null : dsgp.getDataSource();
            String gfd = gp == null ? null : gp.getField();
            this.currentDataSource = srckey;
            this.currentGroupField = gfd;
            if (param.parentArea != null) {
                this.updateGroupLevelAndEndToken(srckey, gfd);
                this.markGroupStart4PageTotalAtGroup(srckey, gfd);
            }
            PaginationInfo pi = param.currentOutPage.getPaginationInfo();
            this.calculateVisibilityInfo(param);
            if ((param.cont.getTop().getString() != null && param.cont.getTop().getInteger() >= param.yt && param.cont.getTop().getInteger() < param.yb || param.cont.getTop().getString() == null) && (param.cont.getBottom().getString() != null && param.cont.getBottom().getInteger() <= param.yb && param.cont.getBottom().getInteger() > param.yt || param.cont.getBottom().getString() == null) && (param.cont.getLeft().getString() != null && param.cont.getLeft().getInteger() >= param.xl && param.cont.getLeft().getInteger() < param.xr || param.cont.getLeft().getString() == null) && (param.cont.getRight().getString() != null && param.cont.getRight().getInteger() <= param.xr && param.cont.getRight().getInteger() > param.xl || param.cont.getRight().getString() == null)) {
                if (param.cont.getBottom().getString() == null && FormExt.contentOutofContainer(this, param, xl, yt, xr, yb)) {
                    if (param.parentArea != null && param.isDataNext) {
                        this.updatePaginationInfo(param.cont, pi, srckey, gfd, true);
                    }
                    param.isDataNext = true;
                    return null;
                }
            } else {
                if (param.parentArea != null && param.isDataNext) {
                    this.updatePaginationInfo(param.cont, pi, srckey, gfd, true);
                }
                param.isDataNext = true;
                return null;
            }
            this.updateGroupTotalList(param.cont, param.cont);
            String oldAcField = null;
            Object oldAcValue = null;
            HashMap<String, Object> oldFieldValue = null;
            if (param.parentArea != null) {
                this.dataListener.syncDataSet(srckey);
                AuxCounter ac = new AuxCounter();
                if (this.groupCountTable.containsKey(srckey)) {
                    AuxCounter oac = (AuxCounter)this.groupCountTable.get(srckey);
                    if (gfd != null && !gfd.equals(oac.field)) {
                        oac.field = gfd;
                        Data tData = this.dataListener.getFieldData(srckey, gfd);
                        oac.value = tData.getValue();
                    }
                    ac.field = oac.field;
                    ac.value = oac.value;
                } else {
                    ac.field = gfd;
                    if (gfd != null) {
                        Data ttData = this.dataListener.getFieldData(srckey, gfd);
                        ac.value = ttData.getValue();
                    }
                }
                this.groupCountTable.put(srckey, ac);
                oldAcField = ac.field;
                oldAcValue = ac.value;
                HashMap<String, Object> thm = null;
                if (this.groupFieldValueTable.containsKey(srckey)) {
                    HashMap<String, Object> ohm = (HashMap<String, Object>)this.groupFieldValueTable.get(srckey);
                    if (gfd != null) {
                        Data tData = this.dataListener.getFieldData(srckey, gfd);
                        ohm.put(gfd, tData.getValue());
                    }
                    thm = ohm;
                } else {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    if (gfd != null) {
                        Data ttData = this.dataListener.getFieldData(srckey, gfd);
                        hm.put(gfd, ttData.getValue());
                    }
                    this.groupFieldValueTable.put(srckey, hm);
                    thm = hm;
                }
                if (this.groupEndTokenMap.containsKey(srckey)) {
                    HashMap fdMap = (HashMap)this.groupEndTokenMap.get(srckey);
                    for (Object o : fdMap.keySet()) {
                        if (o == null) continue;
                        Data tData = this.dataListener.getFieldData(srckey, (String)o);
                        thm.put((String)o, tData.getValue());
                    }
                }
                oldFieldValue = new HashMap<String, Object>();
                oldFieldValue.putAll(thm);
            }
            Panel nPanel = new Panel();
            nPanel.copyOriginString(param.cont);
            nPanel.copyInteger(param.cont);
            nPanel.setSource(param.cont.getSource());
            nPanel.setLayer(param.cont.getLayer());
            nPanel.setAnchor(param.cont.getAnchor());
            nPanel.setHint(param.cont.getHint());
            nPanel.setStyles(param.cont.getStyles());
            nPanel.copyCustomStyles(param.cont.getCustomStyles());
            nPanel.copyProperties(param.cont.getProperties());
            param.currentParent.addChild(nPanel);
            nPanel.setParent(param.currentParent);
            param.currentParent = nPanel;
            this.namedOutputComponentMap.put(param.cont.getId(), nPanel);
            Area oldArea = param.parentArea;
            Container oldCont = param.cont;
            int oldXl = param.xl;
            int oldXr = param.xr;
            int oldYt = param.yt;
            int oldYb = param.yb;
            Iterator itr = param.cont.iterator();
            while (itr.hasNext()) {
                Container cont;
                param.cont = cont = (Container)itr.next();
                param.parentArea = null;
                param.xl = xl;
                param.xr = xr;
                param.yt = yt;
                param.yb = yb;
                Container con = this.outputComponent(param);
                if (con == null) continue;
                if ((eps & 8) == 8 && el > con.getLeft().getInteger()) {
                    el = con.getLeft().getInteger();
                }
                if ((eps & 4) == 4 && er < con.getRight().getInteger()) {
                    er = con.getRight().getInteger();
                }
                if ((eps & 2) == 2 && et > con.getTop().getInteger()) {
                    et = con.getTop().getInteger();
                }
                if ((eps & 1) != 1 || eb >= con.getBottom().getInteger()) continue;
                eb = con.getBottom().getInteger();
            }
            param.currentParent = nPanel.getParent();
            param.parentArea = oldArea;
            param.cont = oldCont;
            param.xl = oldXl;
            param.xr = oldXr;
            param.yt = oldYt;
            param.yb = oldYb;
            if ((eps & 8) == 8) {
                nPanel.getLeft().setInteger(el);
                oldCont.getLeft().setInteger(el);
                oldCont.getLeft().setString(String.valueOf(el));
            }
            if ((eps & 4) == 4) {
                nPanel.getRight().setInteger(er);
                oldCont.getRight().setInteger(er);
                oldCont.getRight().setString(String.valueOf(er));
            }
            if ((eps & 2) == 2) {
                nPanel.getTop().setInteger(et);
                oldCont.getTop().setInteger(et);
                oldCont.getTop().setString(String.valueOf(et));
            }
            if ((eps & 1) == 1) {
                nPanel.getBottom().setInteger(eb);
                oldCont.getBottom().setInteger(eb);
                oldCont.getBottom().setString(String.valueOf(eb));
            }
            if (param.cont.getVisibility().getInteger() == 0) {
                nPanel.getParent().deleteChild(nPanel);
                if (param.cont.getHoldPlace().getInteger() == 0) {
                    nPanel.getBottom().setInteger(nPanel.getTop().getInteger());
                    nPanel.getRight().setInteger(nPanel.getLeft().getInteger());
                }
            } else {
                this.handlePostExpression(oldCont, nPanel, oldCont.getPostSteps());
            }
            if (param.parentArea != null) {
                boolean shouldMove;
                boolean hasNext;
                AuxCounter ac = new AuxCounter();
                boolean isDeepest = this.isDeepestGroup(param.cont);
                ac.field = oldAcField;
                ac.value = oldAcValue;
                if (this.groupFieldValueTable.containsKey(srckey)) {
                    HashMap hm = (HashMap)this.groupFieldValueTable.get(srckey);
                    hm.putAll(oldFieldValue);
                }
                if (isDeepest && param.cont.getVisibility().getInteger() > 0) {
                    this.calculateTotalInfo(param, srckey);
                }
                this.groupCountTable.put(srckey, ac);
                int currentLoopCount = (Integer)this.currentLoopCountMap.get(param.parentArea.getId()) + 1;
                this.currentLoopCountMap.put(param.parentArea.getId(), currentLoopCount);
                int minlc = param.parentArea.getMinLoopCount();
                int maxlc = param.parentArea.getMaxLoopCount();
                if (this.groupHasNextMap.containsKey(srckey)) {
                    hasNext = true;
                    this.groupHasNextMap.remove(srckey);
                } else {
                    hasNext = this.dataListener.hasNext(srckey);
                }
                boolean bl = shouldMove = currentLoopCount < minlc || maxlc < 0 && hasNext || maxlc > -1 && currentLoopCount < maxlc && hasNext;
                if (shouldMove) {
                    if (isDeepest) {
                        this.dataListener.blockDataSet(srckey);
                        this.dataListener.next(srckey);
                    }
                    if (gfd != null && !this.updateGroupFieldInfo(param, srckey, gfd, ac)) {
                        if (hasNext) {
                            this.groupHasNextMap.put(srckey, null);
                        }
                        this.refillGroupTotalObject(oldCont);
                        boolean bl2 = param.isLoop = currentLoopCount < minlc;
                        if (param.isLoop) {
                            param.loopCount = currentLoopCount;
                            param.loopMin = minlc;
                            param.loopObj = nPanel;
                        }
                        return nPanel;
                    }
                    Container giahn = this.getParentGroupInAreaHasNext(null, param.cont);
                    if (giahn != null && this.checkChildAci(giahn.getAliasName(), pi)) {
                        this.refillGroupTotalObject(oldCont);
                        return nPanel;
                    }
                    int ht = nPanel.getBottom().getInteger() - nPanel.getTop().getInteger();
                    if (ht == 0) {
                        this.updatePaginationInfo(param.cont, pi, srckey, gfd, true);
                        this.refillGroupTotalObject(oldCont);
                        return nPanel;
                    }
                    param.yt += ht;
                    Panel pnl = (Panel)param.cont.nextCopy();
                    this.trashListForNextCopy.add(pnl);
                    Form.updateIdTable(true, pnl, param.currentPage);
                    if (param.cont.getVisibility().getInteger() == 0 && param.cont.getHoldPlace().getInteger() == 0) {
                        pnl.getTop().setString(String.valueOf(param.cont.getTop().getInteger()));
                        if (param.cont.getBottom().getOriginString() != null) {
                            pnl.getBottom().setString(String.valueOf(param.cont.getBottom().getInteger()));
                        }
                    }
                    param.cont = pnl;
                    if (!hasNext) {
                        param.isDataNext = false;
                    }
                    Container cont = this.outputContainer(param);
                    this.refillGroupTotalObject(oldCont);
                    if (cont != null) {
                        return cont;
                    }
                    return nPanel;
                }
                if (hasNext && isDeepest) {
                    this.dataListener.blockDataSet(srckey);
                    this.dataListener.next(srckey);
                }
                if (hasNext) {
                    if (gfd != null) {
                        this.updateGroupFieldInfo(param, srckey, gfd, ac);
                    }
                    this.updatePaginationInfo(param.cont, pi, srckey, gfd, true);
                } else {
                    this.setGroupEndToken(param, srckey, gfd);
                }
                param.isDataNext = true;
            }
            this.refillGroupTotalObject(oldCont);
            return nPanel;
        }
        if (param.cont instanceof Table) {
            Table aTab;
            if (epc < 4) {
                throw new AssertionError((Object)("Table must have full four edge info: " + param.cont));
            }
            gp = this.getParentFieldGroup(param.cont);
            dsgp = this.getParentDataSourceGroup(param.cont);
            srckey = dsgp == null ? null : dsgp.getDataSource();
            String gfd = gp == null ? null : gp.getField();
            this.currentDataSource = srckey;
            this.currentGroupField = gfd;
            if (param.parentArea != null) {
                this.updateGroupLevelAndEndToken(srckey, gfd);
                this.markGroupStart4PageTotalAtGroup(srckey, gfd);
            }
            PaginationInfo pi = param.currentOutPage.getPaginationInfo();
            this.calculateVisibilityInfo(param);
            if (param.cont.getTop().getInteger() < param.yt || param.cont.getTop().getInteger() >= param.yb || param.cont.getBottom().getInteger() > param.yb || param.cont.getBottom().getInteger() <= param.yt || param.cont.getLeft().getInteger() < param.xl || param.cont.getLeft().getInteger() >= param.xr || param.cont.getRight().getInteger() > param.xr || param.cont.getRight().getInteger() <= param.xl) {
                if (param.parentArea != null && param.isDataNext) {
                    this.updatePaginationInfo(param.cont, pi, srckey, gfd, true);
                }
                param.isDataNext = true;
                return null;
            }
            this.updateGroupTotalList(param.cont, param.cont);
            String oldAcField = null;
            Object oldAcValue = null;
            HashMap<String, Object> oldFieldValue = null;
            if (param.parentArea != null) {
                this.dataListener.syncDataSet(srckey);
                AuxCounter ac = new AuxCounter();
                if (this.groupCountTable.containsKey(srckey)) {
                    AuxCounter oac = (AuxCounter)this.groupCountTable.get(srckey);
                    if (gfd != null && !gfd.equals(oac.field)) {
                        oac.field = gfd;
                        Data tData = this.dataListener.getFieldData(srckey, gfd);
                        oac.value = tData.getValue();
                    }
                    ac.field = oac.field;
                    ac.value = oac.value;
                } else {
                    ac.field = gfd;
                    if (gfd != null) {
                        Data ttData = this.dataListener.getFieldData(srckey, gfd);
                        ac.value = ttData.getValue();
                    }
                }
                this.groupCountTable.put(srckey, ac);
                oldAcField = ac.field;
                oldAcValue = ac.value;
                HashMap<String, Object> thm = null;
                if (this.groupFieldValueTable.containsKey(srckey)) {
                    HashMap<String, Object> ohm = (HashMap<String, Object>)this.groupFieldValueTable.get(srckey);
                    if (gfd != null) {
                        Data tData = this.dataListener.getFieldData(srckey, gfd);
                        ohm.put(gfd, tData.getValue());
                    }
                    thm = ohm;
                } else {
                    HashMap<String, Object> hm = new HashMap<String, Object>();
                    if (gfd != null) {
                        Data ttData = this.dataListener.getFieldData(srckey, gfd);
                        hm.put(gfd, ttData.getValue());
                    }
                    this.groupFieldValueTable.put(srckey, hm);
                    thm = hm;
                }
                if (this.groupEndTokenMap.containsKey(srckey)) {
                    HashMap fdMap = (HashMap)this.groupEndTokenMap.get(srckey);
                    for (Object o : fdMap.keySet()) {
                        if (o == null) continue;
                        Data tData = this.dataListener.getFieldData(srckey, (String)o);
                        thm.put((String)o, tData.getValue());
                    }
                }
                oldFieldValue = new HashMap<String, Object>();
                oldFieldValue.putAll(thm);
            }
            Table nTable = new Table();
            nTable.copyOriginString(param.cont);
            nTable.copyInteger(param.cont);
            nTable.setLayoutMode(1);
            nTable.setSource(param.cont.getSource());
            nTable.setLayer(param.cont.getLayer());
            nTable.setAnchor(param.cont.getAnchor());
            nTable.setHint(param.cont.getHint());
            nTable.setStyles(param.cont.getStyles());
            nTable.copyCustomStyles(param.cont.getCustomStyles());
            nTable.copyProperties(param.cont.getProperties());
            param.currentParent.addChild(nTable);
            nTable.setParent(param.currentParent);
            param.currentParent = nTable;
            this.namedOutputComponentMap.put(param.cont.getId(), nTable);
            if (((Table)param.cont).getLayoutMode() == 0) {
                int i;
                aTab = (Table)param.cont;
                int ah = (aTab.getBottom().getInteger() - aTab.getTop().getInteger()) / (aTab.getRows().size() == 0 ? 1 : aTab.getRows().size());
                int aw = (aTab.getRight().getInteger() - aTab.getLeft().getInteger()) / (aTab.getCols().size() == 0 ? 1 : aTab.getCols().size());
                int xh = aTab.getBottom().getInteger() - aTab.getTop().getInteger() - ah * (aTab.getRows().size() == 0 ? 1 : aTab.getRows().size());
                int xw = aTab.getRight().getInteger() - aTab.getLeft().getInteger() - aw * (aTab.getCols().size() == 0 ? 1 : aTab.getCols().size());
                for (i = 0; i < aTab.getRows().size(); ++i) {
                    aTab.getRows().get(i).getHeight().setInteger(ah);
                    aTab.getRows().get(i).getHeight().setString(String.valueOf(ah));
                }
                for (i = 0; i < aTab.getCols().size(); ++i) {
                    aTab.getCols().get(i).getWidth().setInteger(aw);
                    aTab.getCols().get(i).getWidth().setString(String.valueOf(aw));
                }
                if (xh > 0 && aTab.getRows().size() > 0) {
                    Row iRow = aTab.getRows().get(aTab.getRows().size() - 1);
                    iRow.getHeight().setInteger(iRow.getHeight().getInteger() + xh);
                    iRow.getHeight().setString(String.valueOf(iRow.getHeight().getInteger()));
                }
                if (xw > 0 && aTab.getCols().size() > 0) {
                    Column iCol = aTab.getCols().get(aTab.getCols().size() - 1);
                    iCol.getWidth().setInteger(iCol.getWidth().getInteger() + xw);
                    iCol.getWidth().setString(String.valueOf(iCol.getWidth().getInteger()));
                }
            } else {
                aTab = (Table)param.cont;
                int sh = 0;
                int sw = 0;
                int ch = 0;
                int cw = 0;
                int ih = -1;
                int iw = -1;
                try {
                    String ss;
                    int i;
                    int temp = this.rvarResult.intValue();
                    for (i = 0; i < aTab.getRows().size(); ++i) {
                        ss = aTab.getRows().get(i).getHeight().getString();
                        if (ss == null || ss.equals("*")) {
                            ++ch;
                            ih = i;
                            continue;
                        }
                        if (!this.formulaEngine.calculate(DUMMY_ID, ss, this.rvarResult)) continue;
                        aTab.getRows().get(i).getHeight().setInteger(temp);
                        aTab.getRows().get(i).getHeight().setString(String.valueOf(temp));
                        sh += temp;
                    }
                    if (ch > 0) {
                        int ah = (aTab.getBottom().getInteger() - aTab.getTop().getInteger() - sh) / ch;
                        int xh = 0;
                        if (ah < 0) {
                            ah = 0;
                        }
                        if (ah > 0) {
                            xh = aTab.getBottom().getInteger() - aTab.getTop().getInteger() - sh - ch * ah;
                        }
                        for (int i2 = 0; i2 < aTab.getRows().size(); ++i2) {
                            ss = aTab.getRows().get(i2).getHeight().getString();
                            if (ss != null && !ss.equals("*")) continue;
                            aTab.getRows().get(i2).getHeight().setInteger(ah);
                            aTab.getRows().get(i2).getHeight().setString(String.valueOf(ah));
                        }
                        if (xh > 0 && ah > 0 && ih >= 0) {
                            Row iRow = aTab.getRows().get(ih);
                            iRow.getHeight().setInteger(iRow.getHeight().getInteger() + xh);
                            iRow.getHeight().setString(String.valueOf(iRow.getHeight().getInteger()));
                        }
                    }
                    for (i = 0; i < aTab.getCols().size(); ++i) {
                        ss = aTab.getCols().get(i).getWidth().getString();
                        if (ss == null || ss.equals("*")) {
                            ++cw;
                            iw = i;
                            continue;
                        }
                        if (!this.formulaEngine.calculate(DUMMY_ID, ss, this.rvarResult)) continue;
                        aTab.getCols().get(i).getWidth().setInteger(temp);
                        aTab.getCols().get(i).getWidth().setString(String.valueOf(temp));
                        sw += temp;
                    }
                    if (cw > 0) {
                        int aw = (aTab.getRight().getInteger() - aTab.getLeft().getInteger() - sw) / cw;
                        int xw = 0;
                        if (aw < 0) {
                            aw = 0;
                        }
                        if (aw > 0) {
                            xw = aTab.getRight().getInteger() - aTab.getLeft().getInteger() - sw - cw * aw;
                        }
                        for (int i3 = 0; i3 < aTab.getCols().size(); ++i3) {
                            ss = aTab.getCols().get(i3).getWidth().getString();
                            if (ss != null && !ss.equals("*")) continue;
                            aTab.getCols().get(i3).getWidth().setInteger(aw);
                            aTab.getCols().get(i3).getWidth().setString(String.valueOf(aw));
                        }
                        if (xw > 0 && aw > 0 && iw >= 0) {
                            Column iCol = aTab.getCols().get(iw);
                            iCol.getWidth().setInteger(iCol.getWidth().getInteger() + xw);
                            iCol.getWidth().setString(String.valueOf(iCol.getWidth().getInteger()));
                        }
                    }
                }
                catch (SyntaxErrorException e1) {
                    log.error((Object)"err", (Throwable)e1);
                }
            }
            nTable.setCols(((Table)param.cont).getCols().copy());
            nTable.setRows(((Table)param.cont).getRows().copy());
            Iterator itr = param.cont.iterator();
            Area oldArea = param.parentArea;
            Container oldCont = param.cont;
            int oldXl = param.xl;
            int oldXr = param.xr;
            int oldYt = param.yt;
            int oldYb = param.yb;
            while (itr.hasNext()) {
                Container cont;
                param.cont = cont = (Container)itr.next();
                param.parentArea = null;
                param.xl = xl;
                param.xr = xr;
                param.yt = yt;
                param.yb = yb;
                this.outputComponent(param);
            }
            param.currentParent = nTable.getParent();
            param.parentArea = oldArea;
            param.cont = oldCont;
            param.xl = oldXl;
            param.xr = oldXr;
            param.yt = oldYt;
            param.yb = oldYb;
            if (param.cont.getVisibility().getInteger() == 0) {
                nTable.getParent().deleteChild(nTable);
                if (param.cont.getHoldPlace().getInteger() == 0) {
                    nTable.getBottom().setInteger(nTable.getTop().getInteger());
                    nTable.getRight().setInteger(nTable.getLeft().getInteger());
                }
            } else {
                this.handlePostExpression(oldCont, nTable, oldCont.getPostSteps());
            }
            if (param.parentArea != null) {
                boolean shouldMove;
                boolean hasNext;
                AuxCounter ac = new AuxCounter();
                boolean isDeepest = this.isDeepestGroup(param.cont);
                ac.field = oldAcField;
                ac.value = oldAcValue;
                if (this.groupFieldValueTable.containsKey(srckey)) {
                    HashMap hm = (HashMap)this.groupFieldValueTable.get(srckey);
                    hm.putAll(oldFieldValue);
                }
                if (isDeepest && param.cont.getVisibility().getInteger() > 0) {
                    this.calculateTotalInfo(param, srckey);
                }
                this.groupCountTable.put(srckey, ac);
                int currentLoopCount = (Integer)this.currentLoopCountMap.get(param.parentArea.getId()) + 1;
                this.currentLoopCountMap.put(param.parentArea.getId(), currentLoopCount);
                int minlc = param.parentArea.getMinLoopCount();
                int maxlc = param.parentArea.getMaxLoopCount();
                if (this.groupHasNextMap.containsKey(srckey)) {
                    hasNext = true;
                    this.groupHasNextMap.remove(srckey);
                } else {
                    hasNext = this.dataListener.hasNext(srckey);
                }
                boolean bl = shouldMove = currentLoopCount < minlc || maxlc < 0 && hasNext || maxlc > -1 && currentLoopCount < maxlc && hasNext;
                if (shouldMove) {
                    if (isDeepest) {
                        this.dataListener.blockDataSet(srckey);
                        this.dataListener.next(srckey);
                    }
                    if (gfd != null && !this.updateGroupFieldInfo(param, srckey, gfd, ac)) {
                        if (hasNext) {
                            this.groupHasNextMap.put(srckey, null);
                        }
                        this.refillGroupTotalObject(oldCont);
                        boolean bl3 = param.isLoop = currentLoopCount < minlc;
                        if (param.isLoop) {
                            param.loopCount = currentLoopCount;
                            param.loopMin = minlc;
                            param.loopObj = nTable;
                        }
                        return nTable;
                    }
                    Container giahn = this.getParentGroupInAreaHasNext(null, param.cont);
                    if (giahn != null && this.checkChildAci(giahn.getAliasName(), pi)) {
                        this.refillGroupTotalObject(oldCont);
                        return nTable;
                    }
                    Table tab = (Table)param.cont.nextCopy();
                    this.adjustNextCopyProperties(param.cont, tab, nTable);
                    this.trashListForNextCopy.add(tab);
                    Form.updateIdTable(true, tab, param.currentPage);
                    int ht = nTable.getBottom().getInteger() - nTable.getTop().getInteger();
                    param.yt += ht;
                    if (param.cont.getVisibility().getInteger() == 0 && param.cont.getHoldPlace().getInteger() == 0) {
                        tab.getTop().setString(String.valueOf(param.cont.getTop().getInteger()));
                        if (param.cont.getBottom().getOriginString() != null) {
                            tab.getBottom().setString(String.valueOf(param.cont.getBottom().getInteger()));
                        }
                    }
                    param.cont = tab;
                    if (!hasNext) {
                        param.isDataNext = false;
                    }
                    Container cont = this.outputContainer(param);
                    FormExt.deubgContainer(cont);
                    this.refillGroupTotalObject(oldCont);
                    if (cont != null) {
                        return cont;
                    }
                    return nTable;
                }
                if (hasNext && isDeepest) {
                    this.dataListener.blockDataSet(srckey);
                    this.dataListener.next(srckey);
                }
                if (hasNext) {
                    if (gfd != null) {
                        this.updateGroupFieldInfo(param, srckey, gfd, ac);
                    }
                    this.updatePaginationInfo(param.cont, pi, srckey, gfd, true);
                } else {
                    this.setGroupEndToken(param, srckey, gfd);
                }
                param.isDataNext = true;
            }
            this.refillGroupTotalObject(oldCont);
            return nTable;
        }
        if (param.cont instanceof Area) {
            ArrayList<Container> innerTrashList = new ArrayList<Container>();
            PaginationInfo pi = param.currentOutPage.getPaginationInfo();
            if (pi.getActive() && (pi.getMode() == 0 || pi.getMode() == 2)) {
                for (AreaContinueInfo aci : pi.getAreaContinueInfos()) {
                    Container gcont;
                    if (!aci.isActive() || param.cont.getId() != aci.getAreaName() || (gcont = aci.getGroup()) == null) continue;
                    Container ncont = gcont.copyTo(param.cont, false);
                    param.cont.addChild(ncont);
                    innerTrashList.add(ncont);
                    Form.updateIdTable(true, ncont, param.currentPage);
                    aci.setActive(false);
                    --this.repeatToken;
                }
            }
            if (param.cont.getVisibility().getString() == null || param.cont.getVisibility().getString().length() == 0) {
                param.cont.getVisibility().setInteger(1);
                param.cont.getHoldPlace().setInteger(1);
            } else {
                try {
                    int temp = this.rvarResult.intValue();
                    if (this.formulaEngine.calculate(DUMMY_ID, param.cont.getVisibility().getString(), this.rvarResult)) {
                        param.cont.getVisibility().setInteger(temp);
                        if (param.cont.getVisibility().getInteger() == 0) {
                            if (param.cont.getHoldPlace().getString() != null) {
                                if (this.formulaEngine.calculate(DUMMY_ID, param.cont.getHoldPlace().getString(), this.rvarResult)) {
                                    param.cont.getHoldPlace().setInteger(temp);
                                    if (param.cont.getHoldPlace().getInteger() == 0) {
                                        param.cont.getRight().setInteger(param.cont.getLeft().getInteger());
                                        param.cont.getRight().setString(String.valueOf(param.cont.getRight().getInteger()));
                                        param.cont.getBottom().setInteger(param.cont.getTop().getInteger());
                                        param.cont.getBottom().setString(String.valueOf(param.cont.getBottom().getInteger()));
                                    }
                                }
                            } else {
                                param.cont.getHoldPlace().setInteger(1);
                            }
                            return null;
                        }
                    }
                }
                catch (SyntaxErrorException e1) {
                    log.error((Object)"err", (Throwable)e1);
                }
            }
            if ((param.cont.getTop().getString() == null || param.cont.getTop().getInteger() < param.yt || param.cont.getTop().getInteger() >= param.yb) && param.cont.getTop().getString() != null || (param.cont.getBottom().getString() == null || param.cont.getBottom().getInteger() > param.yb || param.cont.getBottom().getInteger() <= param.yt) && param.cont.getBottom().getString() != null || (param.cont.getLeft().getString() == null || param.cont.getLeft().getInteger() < param.xl || param.cont.getLeft().getInteger() >= param.xr) && param.cont.getLeft().getString() != null || (param.cont.getRight().getString() == null || param.cont.getRight().getInteger() > param.xr || param.cont.getRight().getInteger() <= param.xl) && param.cont.getRight().getString() != null) {
                return null;
            }
            Area nArea = new Area();
            nArea.copyOriginString(param.cont);
            nArea.copyInteger(param.cont);
            nArea.setSource(param.cont.getSource());
            nArea.setLayer(param.cont.getLayer());
            nArea.setAnchor(param.cont.getAnchor());
            nArea.setHint(param.cont.getHint());
            nArea.setStyles(param.cont.getStyles());
            nArea.copyCustomStyles(param.cont.getCustomStyles());
            nArea.copyProperties(param.cont.getProperties());
            param.currentParent.addChild(nArea);
            nArea.setParent(param.currentParent);
            param.currentParent = nArea;
            this.namedOutputComponentMap.put(param.cont.getId(), nArea);
            Container oldCont = param.cont;
            this.currentLoopCountMap.put(oldCont.getId(), 0);
            Iterator itr = param.cont.iterator();
            while (itr.hasNext()) {
                Container cont;
                param.cont = cont = (Container)itr.next();
                param.parentArea = (Area)oldCont;
                param.xl = xl;
                param.xr = xr;
                param.yt = yt;
                param.yb = yb;
                Container con = this.outputComponent(param);
                if (con == null) continue;
                if ((eps & 8) == 8 && con.getLeft().getInteger() < el) {
                    el = con.getLeft().getInteger();
                }
                if ((eps & 4) == 4 && con.getRight().getInteger() > er) {
                    er = con.getRight().getInteger();
                }
                if ((eps & 2) == 2 && con.getTop().getInteger() < et) {
                    et = con.getTop().getInteger();
                }
                if ((eps & 1) != 1 || con.getBottom().getInteger() <= eb) continue;
                eb = con.getBottom().getInteger();
            }
            this.currentLoopCountMap.remove(oldCont.getId());
            param.currentParent = nArea.getParent();
            if ((eps & 8) == 8) {
                nArea.getLeft().setInteger(el);
                oldCont.getLeft().setInteger(el);
                oldCont.getLeft().setString(String.valueOf(el));
            }
            if ((eps & 4) == 4) {
                nArea.getRight().setInteger(er);
                oldCont.getRight().setInteger(er);
                oldCont.getRight().setString(String.valueOf(er));
            }
            if ((eps & 2) == 2) {
                nArea.getTop().setInteger(et);
                oldCont.getTop().setInteger(et);
                oldCont.getTop().setString(String.valueOf(et));
            }
            if ((eps & 1) == 1) {
                nArea.getBottom().setInteger(eb);
                oldCont.getBottom().setInteger(eb);
                oldCont.getBottom().setString(String.valueOf(eb));
            }
            this.handlePostExpression(oldCont, nArea, oldCont.getPostSteps());
            if (innerTrashList.size() > 0) {
                for (Container tcont : innerTrashList) {
                    oldCont.deleteChild(tcont);
                    Form.updateIdTable(false, tcont, param.currentPage);
                }
                innerTrashList.clear();
            }
            if (param.isLoop) {
                param.isLoop = false;
                FormExt.loopContinue(param.loopCount, param.loopMin, param.loopObj, nArea);
            }
            return nArea;
        }
        return null;
    }

    private void adjustNextCopyProperties(Container origined, Container copyed, Container newed) {
        String spacing = copyed.parent != null && copyed.parent instanceof Area ? ((Area)copyed.parent).getVerticalSpacing() : "0";
        copyed.getTop().setString("(" + String.valueOf(newed.getBottom().getInteger()) + ")+(" + spacing + ")");
        copyed.getBottom().setString(String.valueOf(origined.getBottom().getInteger() - origined.getTop().getInteger()) + "+" + copyed.getTop().getString());
    }

    private boolean updateGroupFieldInfo(AuxParam param, String srckey, String gfd, AuxCounter ac) {
        HashMap fdmap = (HashMap)this.groupEndTokenMap.get(srckey);
        HashMap fvmap = (HashMap)this.groupFieldValueTable.get(srckey);
        if (fdmap != null && fvmap != null) {
            for (Object o : fdmap.keySet()) {
                if (o == null) continue;
                Data pData = this.dataListener.getFieldData(srckey, (String)o);
                Object v = fvmap.get((String)o);
                if (pData.getValue().equals(v)) continue;
                fvmap.put((String)o, pData.getValue());
                this.setGroupEndToken(param, srckey, gfd);
                return false;
            }
        }
        return true;
    }

    private void calculateTotalInfo(AuxParam param, String srckey) {
        Variant vt;
        Object value;
        Data tData;
        Container pgroup = this.getParentInNearestArea(param.cont);
        for (AuxAreaTotal aat : this.areaSubTotalMap.values()) {
            if (!this.isAinB(pgroup, aat.group) || aat.oldCell == null) continue;
            tData = this.dataListener.getFieldData(srckey, aat.oldCell.getData().getFormat());
            value = tData.getValue();
            if (value instanceof Variant) {
                value = ((Variant)value).getValue();
            }
            if (value instanceof String) {
                if (((String)value).length() <= 0) continue;
                try {
                    aat.total += Double.parseDouble((String)value);
                }
                catch (NumberFormatException ex) {
                    log.error((Object)"String2Double format exception. ", (Throwable)ex);
                    aat.total = 0.0;
                }
                continue;
            }
            if (value == null) continue;
            vt = new Variant(value);
            try {
                aat.total += vt.doubleValue();
            }
            catch (SyntaxErrorException e1) {
                log.error((Object)"Variant parse exception. ", (Throwable)e1);
                aat.total = 0.0;
            }
        }
        for (AuxGroupTotal agt : this.groupSubTotalMap.values()) {
            if (!this.isAinB(pgroup, agt.group) || agt.oldCell == null) continue;
            tData = this.dataListener.getFieldData(srckey, agt.field);
            value = tData.getValue();
            if (value instanceof Variant) {
                value = ((Variant)value).getValue();
            }
            if (value instanceof String) {
                if (((String)value).length() <= 0) continue;
                try {
                    agt.total += Double.parseDouble((String)value);
                }
                catch (NumberFormatException ex) {
                    log.error((Object)"String2Double format exception. ", (Throwable)ex);
                    agt.total = 0.0;
                }
                continue;
            }
            if (value == null) continue;
            vt = new Variant(value);
            try {
                agt.total += vt.doubleValue();
            }
            catch (SyntaxErrorException e1) {
                log.error((Object)"Variant parse exception. ", (Throwable)e1);
                agt.total = 0.0;
            }
        }
    }

    private void calculateVisibilityInfo(AuxParam param) {
        if (param.cont.getVisibility().getString() == null || param.cont.getVisibility().getString().length() == 0) {
            param.cont.getVisibility().setInteger(1);
            param.cont.getHoldPlace().setInteger(1);
        } else {
            try {
                int temp = this.rvarResult.intValue();
                if (this.formulaEngine.calculate(DUMMY_ID, param.cont.getVisibility().getString(), this.rvarResult)) {
                    param.cont.getVisibility().setInteger(temp);
                    if (param.cont.getVisibility().getInteger() == 0 && param.cont.getHoldPlace().getString() != null) {
                        if (this.formulaEngine.calculate(DUMMY_ID, param.cont.getHoldPlace().getString(), this.rvarResult)) {
                            param.cont.getHoldPlace().setInteger(temp);
                        }
                    } else {
                        param.cont.getHoldPlace().setInteger(1);
                    }
                }
            }
            catch (SyntaxErrorException e1) {
                log.error((Object)"err", (Throwable)e1);
            }
        }
    }

    private void updateGroupLevelAndEndToken(String srckey, String gfd) {
        HashMap fdMap;
        HashMap gpMap;
        if (!this.groupLevelCountTable.containsKey(srckey)) {
            gpMap = new HashMap();
            AuxGroupLevelCount glc = new AuxGroupLevelCount();
            glc.field = gfd;
            glc.count = 0;
            gpMap.put(gfd, glc);
            this.groupLevelCountTable.put(srckey, gpMap);
        } else {
            gpMap = (HashMap)this.groupLevelCountTable.get(srckey);
            if (gpMap.containsKey(gfd)) {
                AuxGroupLevelCount glc = (AuxGroupLevelCount)gpMap.get(gfd);
                ++glc.count;
            } else {
                AuxGroupLevelCount glc = new AuxGroupLevelCount();
                glc.field = gfd;
                glc.count = 0;
                gpMap.put(gfd, glc);
            }
        }
        if (this.groupEndTokenMap.containsKey(srckey)) {
            fdMap = (HashMap)this.groupEndTokenMap.get(srckey);
            if (!fdMap.containsKey(gfd)) {
                fdMap.put(gfd, 0);
            }
        } else {
            fdMap = new HashMap();
            fdMap.put(gfd, 0);
            this.groupEndTokenMap.put(srckey, fdMap);
        }
    }

    private void setGroupEndToken(AuxParam param, String srckey, String gfd) {
        HashMap gpMap;
        this.markGroupEnd4PageTotalAtGroup(srckey, gfd);
        HashMap fdMap = (HashMap)this.groupEndTokenMap.get(srckey);
        fdMap.remove(gfd);
        HashMap gfvMap = (HashMap)this.groupFieldValueTable.get(srckey);
        gfvMap.remove(gfd);
        if (param.parentArea != null && this.groupLevelCountTable.containsKey(srckey) && (gpMap = (HashMap)this.groupLevelCountTable.get(srckey)).containsKey(gfd)) {
            gpMap.remove(gfd);
        }
    }

    public Page getOutputPage(int index) {
        if (this.outPages != null) {
            return this.outPages.set(index, null);
        }
        return null;
    }

    public String getXml() {
        FormXmlTrans fxt = new FormXmlTrans();
        return KDFXmlReader.readNodeSource(fxt.writeToNode(this, this.rsp.getRuntimeStyleService()));
    }

    public Container getObjectByName(String name) {
        if (name.indexOf(46) == -1) {
            for (Page pg : this.pages) {
                Container cont = pg.getObjectByName(name);
                if (cont == null) continue;
                return cont;
            }
        } else {
            int temp = name.indexOf(46);
            String pName = name.substring(0, temp);
            String cName = name.substring(temp + 1);
            Page pg = this.pages.get(pName);
            if (pg != null) {
                return pg.getObjectByName(cName);
            }
        }
        return null;
    }

    protected static Style getDrawStyle(Container cont) {
        ArrayList<ShareStyleAttributes> ssaList = new ArrayList<ShareStyleAttributes>();
        for (Container ct = cont; ct != null; ct = ct.getParent()) {
            ssaList.add(ct.getCustomStyles().getStyleAttributes());
            ssaList.add(ct.getStyles());
        }
        ShareStyleAttributes[] ssas = ssaList.toArray(new ShareStyleAttributes[0]);
        return Styles.getStyle((ShareStyleAttributes[])ssas);
    }

    private boolean startWith(String src, String des, int len) {
        if (len > src.length()) {
            return false;
        }
        return src.substring(0, len).equalsIgnoreCase(des);
    }

    private String getFormattedData(String format, Object data, Container srcObj) {
        Object value;
        if (data == null) {
            return null;
        }
        if (format == null || format.length() == 0) {
            return data.toString();
        }
        if (data instanceof Variant && ((Variant)data).getValue() == null) {
            return null;
        }
        if (data instanceof Variant && (value = ((Variant)data).getValue()) instanceof String && StringUtil.isEmptyString((String)((String)value))) {
            return null;
        }
        this.funcImplObj.setCurrentSrcObj(srcObj);
        boolean isNewFormat = format.charAt(0) != '\"';
        String formattedValue = null;
        if (isNewFormat || this.funcEngine.calculate(DUMMY_ID, format, this.rvarResult)) {
            String nFormat;
            String string = nFormat = isNewFormat ? format : this.rvarResult.toString();
            if (nFormat.startsWith("%")) {
                formattedValue = com.kingdee.cosmic.ctrl.kdf.util.Tools.format((String)nFormat, (Object)data);
            }
            if (formattedValue == null) {
                com.kingdee.cosmic.ctrl.common.variant.Variant vData = null;
                vData = data instanceof Variant ? new com.kingdee.cosmic.ctrl.common.variant.Variant(((Variant)data).getValue()) : new com.kingdee.cosmic.ctrl.common.variant.Variant(data);
                formattedValue = Formats.getFormat((String)nFormat).format(vData).toString();
            }
        }
        this.funcImplObj.setCurrentSrcObj(null);
        return formattedValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getData(Data nData, Cell cel, Cell nCell) {
        Data oData = cel.getData();
        if (cel.getType().equalsIgnoreCase("constant")) {
            Property pt = cel.getProperties().get("contentType");
            if (pt != null && pt.getFormat() != null) {
                nData.setType(pt.getFormat());
            } else if (oData != null) {
                nData.setType(oData.getType());
            } else {
                nData.setType("unknown");
            }
            if (oData != null) {
                if ("chart".equalsIgnoreCase(nData.getType())) {
                    ChartData dt = ChartData.valueOf(oData.getFormat(), this.dataListener);
                    nData.setValue(new Variant((Object)dt));
                    nData.setFormat("<<Chart>>");
                    return;
                } else {
                    nData.setFormat(oData.getFormat());
                    nData.setValue(new Variant((Object)oData.getFormat(), 11));
                }
                return;
            } else {
                nData.setFormat("");
                nData.setValue(Variant.nullVariant);
            }
            return;
        } else {
            if (cel.getType().equalsIgnoreCase("field") || cel.getType().equalsIgnoreCase("groupField")) {
                Group dsgp = this.getParentDataSourceGroup(cel);
                if (dsgp == null || this.dataListener == null || oData == null) throw new AssertionError((Object)("Data Source or Listener or Field Name Required: " + cel));
                String srckey = dsgp.getDataSource();
                if (!this.groupCountTable.containsKey(srckey) && srckey != null) {
                    this.dataListener.syncDataSet(srckey);
                    AuxCounter ac = new AuxCounter();
                    this.groupCountTable.put(srckey, ac);
                }
                Data tData = this.dataListener.getFieldData(srckey, oData.getFormat());
                Property pt = cel.getProperties().get("contentType");
                if (pt != null && pt.getFormat() != null) {
                    nData.setType(pt.getFormat());
                } else {
                    nData.setType(tData.getType());
                }
                nData.setValue(tData.getValue());
                nData.setFormat(this.getFormattedData(cel.getDataFormat(), nData.getValue(), cel));
                return;
            }
            if (cel.getType().equalsIgnoreCase("formula")) {
                Variant rvar = new Variant();
                this.funcImplObj.setCurrentSrcObj(cel);
                Property pt = cel.getProperties().get("contentType");
                if (pt != null && pt.getFormat() != null) {
                    nData.setType(pt.getFormat());
                } else {
                    nData.setType("unknown");
                }
                if (nCell != null && oData != null && this.startWith(oData.getFormat(), "$PAGECOUNT(\"", 12)) {
                    Group group;
                    Iterator children;
                    String areaId;
                    Container obj;
                    String formula = oData.getFormat();
                    int idxOfParamEndMark = formula.indexOf("\")");
                    if (idxOfParamEndMark > 12 && (obj = this.findObject(areaId = formula.substring(12, idxOfParamEndMark).trim(), cel.getPage())) instanceof Area && (children = ((Area)obj).iterator()).hasNext() && (group = this.getParentFieldGroup((Container)children.next())) != null) {
                        ArrayList cells;
                        String key = group.getDataSource() + "$" + group.getField();
                        if (this.cellsWaitToFill.containsKey(key)) {
                            cells = (ArrayList)this.cellsWaitToFill.get(key);
                        } else {
                            cells = new ArrayList();
                            this.cellsWaitToFill.put(key, cells);
                        }
                        cells.add(nCell);
                        nCell.getPage().unsureIncrease();
                    }
                } else if (oData != null && this.funcEngine.calculate(DUMMY_ID, oData.getFormat(), rvar)) {
                    nData.setValue(rvar);
                } else {
                    nData.setValue(Variant.nullVariant);
                }
                this.funcImplObj.setCurrentSrcObj(null);
                nData.setFormat(this.getFormattedData(cel.getDataFormat(), nData.getValue(), cel));
                return;
            } else if (cel.getType().equalsIgnoreCase("variant")) {
                if (oData != null) {
                    Data tData = this.eventListener.requestVarData(oData.getFormat());
                    Property pt = cel.getProperties().get("contentType");
                    if (pt != null && pt.getFormat() != null) {
                        nData.setType(pt.getFormat());
                    } else if (tData != null) {
                        nData.setType(tData.getType());
                    } else {
                        nData.setType("unknown");
                    }
                    if (tData != null) {
                        nData.setValue(tData.getValue());
                    } else {
                        nData.setValue(Variant.nullVariant);
                    }
                } else {
                    nData.setType("unknown");
                    nData.setValue(Variant.nullVariant);
                }
                nData.setFormat(this.getFormattedData(cel.getDataFormat(), nData.getValue(), cel));
                return;
            } else if (cel.getType().equalsIgnoreCase("chart")) {
                if (oData != null) {
                    ChartData dt = ChartData.valueOf(oData.getFormat(), this.dataListener);
                    nData.setType("chart");
                    nData.setValue(new Variant((Object)dt));
                    nData.setFormat("<<Chart>>");
                    return;
                } else {
                    nData.setType("unknown");
                    nData.setValue(Variant.nullVariant);
                    nData.setFormat("");
                }
                return;
            } else if (!cel.getType().equalsIgnoreCase("groupTotal") && !cel.getType().equalsIgnoreCase("areaTotal")) return;
        }
    }

    private void updatePaginationInfo(Container gcont, PaginationInfo pi, String srckey, String gfd, boolean isGroup) {
        HashMap gpMap;
        Area ahn = this.getParentAreaHasNext(gcont);
        Container giahn = this.getParentGroupInAreaHasNext(ahn, gcont);
        giahn = this.getOriginSourceGroup(giahn);
        AreaContinueInfo aci = new AreaContinueInfo();
        if (ahn == null) {
            return;
        }
        Area nextArea = ahn.getNext();
        nextArea.setAliasName(ahn.getAliasName());
        aci.setAreaName(nextArea.getId());
        aci.setGroup(giahn);
        if (this.checkAciDup(pi, aci)) {
            return;
        }
        if (pi != null && !pi.getActive()) {
            pi.setActive(true);
            pi.setMode(0);
        }
        if (null != pi) {
            pi.getAreaContinueInfos().add(aci);
        }
        if (isGroup && (gpMap = (HashMap)this.groupLevelCountTable.get(srckey)).containsKey(gfd)) {
            AuxGroupLevelCount glc = (AuxGroupLevelCount)gpMap.get(gfd);
            --glc.count;
        }
        if (gcont.getPage().getRepeat() == -1) {
            ++this.repeatToken;
        }
    }

    private void updateGroupTotalList(Container cont, Container topCont) {
        if (cont != null) {
            Iterator itr = cont.iterator();
            while (itr.hasNext()) {
                Container ncont = (Container)itr.next();
                if (ncont instanceof Area) continue;
                if (ncont instanceof Cell) {
                    Cell cel = (Cell)ncont;
                    if (cel.getType().equalsIgnoreCase("groupTotal")) {
                        if (this.groupSubTotalMap.containsKey(cel)) continue;
                        Group dsgp = this.getParentDataSourceGroup(cel);
                        boolean replaced = false;
                        for (AuxGroupTotal agt : this.groupSubTotalMap.values()) {
                            if (agt.newCell != null || !agt.oldCell.getAliasName().equals(cel.getAliasName())) continue;
                            agt.group = topCont;
                            agt.oldCell = cel;
                            replaced = true;
                        }
                        if (replaced) continue;
                        AuxGroupTotal nagt = new AuxGroupTotal();
                        nagt.group = topCont;
                        nagt.oldCell = cel;
                        nagt.field = cel.getData().getFormat();
                        if (dsgp != null) {
                            nagt.dataSource = dsgp.getDataSource();
                        }
                        this.groupSubTotalMap.put(cel, nagt);
                        continue;
                    }
                    if (!cel.getType().equalsIgnoreCase("areaTotal") || this.areaSubTotalMap.containsKey(cel)) continue;
                    AuxAreaTotal naat = new AuxAreaTotal();
                    naat.group = topCont;
                    naat.oldCell = cel;
                    this.areaSubTotalMap.put(cel, naat);
                    continue;
                }
                this.updateGroupTotalList(ncont, topCont);
            }
        }
    }

    private void refillGroupTotalObject(Container cont) {
        if (cont != null) {
            HashMap<Cell, AuxAreaTotal> natMap = new HashMap<Cell, AuxAreaTotal>();
            HashMap<Cell, AuxGroupTotal> ngtMap = new HashMap<Cell, AuxGroupTotal>();
            for (AuxAreaTotal aat : this.areaSubTotalMap.values()) {
                if (aat.group == cont && aat.newCell != null) {
                    aat.newCell.getData().setType("number");
                    aat.newCell.getData().setFormat(this.getFormattedData(aat.oldCell.getDataFormat(), new Double(aat.total), aat.oldCell));
                    aat.newCell.getData().setValue(new Double(aat.total));
                    continue;
                }
                natMap.put(aat.oldCell, aat);
            }
            for (AuxGroupTotal agt : this.groupSubTotalMap.values()) {
                if (agt.group == cont && agt.newCell != null) {
                    agt.newCell.getData().setType("number");
                    agt.newCell.getData().setFormat(this.getFormattedData(agt.oldCell.getDataFormat(), new Double(agt.total), agt.oldCell));
                    agt.newCell.getData().setValue(new Double(agt.total));
                    continue;
                }
                ngtMap.put(agt.oldCell, agt);
            }
            this.areaSubTotalMap = natMap;
            this.groupSubTotalMap = ngtMap;
        }
    }

    private boolean isDeepestGroup(Container cont) {
        if (cont != null) {
            Group dsgp = this.getParentDataSourceGroup(cont);
            if (dsgp == null) {
                return true;
            }
            return this.innerIsDeepest(cont, dsgp.getDataSource());
        }
        return true;
    }

    private boolean innerIsDeepest(Container cont, String dsName) {
        if (cont != null) {
            Iterator itr = cont.iterator();
            while (itr.hasNext()) {
                Container acont;
                Iterator aitr;
                Container tcont = (Container)itr.next();
                if (tcont instanceof Area && (aitr = tcont.iterator()).hasNext() && dsName.equals((acont = (Container)aitr.next()).group().getDataSource())) {
                    return false;
                }
                if (this.innerIsDeepest(tcont, dsName)) continue;
                return false;
            }
        }
        return true;
    }

    private Container getOriginSourceGroup(Container cont) {
        if (cont != null) {
            return cont.getPage().getObjectByName(cont.getAliasName());
        }
        return null;
    }

    private boolean checkChildAci(String aliasName, PaginationInfo pi) {
        if (pi != null && aliasName != null) {
            for (AreaContinueInfo aci : pi.getAreaContinueInfos()) {
                if (!aci.isActive() || !aci.getGroup().getAliasName().equals(aliasName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAciDup(PaginationInfo pi, AreaContinueInfo aci) {
        if (pi != null && aci != null && pi.getActive() && (pi.getMode() == 0 || pi.getMode() == 2)) {
            for (AreaContinueInfo eaci : pi.getAreaContinueInfos()) {
                if (eaci.getAreaName() != aci.getAreaName() || eaci.getGroup() == null || aci.getGroup() == null || !eaci.getGroup().getAliasName().equals(aci.getGroup().getAliasName()) && !eaci.getGroup().getId().equals(aci.getGroup().getId())) continue;
                if (!eaci.isActive()) {
                    eaci.setActive(true);
                }
                return true;
            }
        }
        return false;
    }

    private void initPageSize(Page pg, PageInfo info) {
        pg.getLeft().setString("0");
        pg.getLeft().setInteger(0);
        pg.getTop().setString("0");
        pg.getTop().setInteger(0);
        if (info != null) {
            pg.getRight().setString(String.valueOf(info.getWidth()));
            pg.getRight().setInteger(info.getWidth());
            pg.getBottom().setString(String.valueOf(info.getHeight()));
            pg.getBottom().setInteger(info.getHeight());
        } else {
            pg.getRight().setString("0");
            pg.getRight().setInteger(0);
            pg.getBottom().setString("0");
            pg.getBottom().setInteger(0);
        }
    }

    protected static void updateIdTable(boolean add, Container cont, Page pg) {
        if (pg != null) {
            HashMap idTab = pg.getIdTable();
            if (add) {
                if (idTab.containsKey(cont.getId())) {
                    throw new AssertionError((Object)("duplicate id found: " + cont));
                }
                idTab.put(cont.getId(), cont);
            } else {
                idTab.remove(cont.getId());
            }
            Iterator itr = cont.iterator();
            while (itr.hasNext()) {
                Container scont = (Container)itr.next();
                Form.updateIdTable(add, scont, pg);
            }
        } else {
            throw new AssertionError((Object)"null page on updating idTable");
        }
    }

    private boolean isAinB(Container a, Container b) {
        if (b != null) {
            while (a != null) {
                if (a == b) {
                    return true;
                }
                a = a.getParent();
            }
        }
        return false;
    }

    private Group getParentFieldGroup(Container cont) {
        while (cont != null) {
            if (cont.group() != null && (cont.group().getField() != null || cont.group().getDataSource() != null)) {
                return cont.group();
            }
            cont = cont.getParent();
        }
        return null;
    }

    protected Group getParentDataSourceGroup(Container cont) {
        while (cont != null) {
            if (cont.group() != null && cont.group().getDataSource() != null) {
                return cont.group();
            }
            cont = cont.getParent();
        }
        return null;
    }

    private Area getParentAreaHasNext(Container cont) {
        while (cont != null) {
            if (cont instanceof Area && ((Area)cont).getNext() != null) {
                return (Area)cont;
            }
            cont = cont.getParent();
        }
        return null;
    }

    private Container getParentInNearestArea(Container cont) {
        if (cont != null) {
            while (cont.getParent() != null) {
                if (cont.getParent() instanceof Area) {
                    return cont;
                }
                cont = cont.getParent();
            }
        }
        return null;
    }

    private Container getParentGroupInAreaHasNext(Area areaHasNext, Container cont) {
        Iterator itr;
        Area ahn = areaHasNext;
        if (ahn == null) {
            ahn = this.getParentAreaHasNext(cont);
        }
        if (ahn != null && (itr = ahn.iterator()).hasNext()) {
            return (Container)itr.next();
        }
        return null;
    }

    private void handlePreExpression(Container srcObj, String expr) {
        if (expr == null || expr.length() == 0) {
            return;
        }
        this.funcImplObj.setCurrentSrcObj(srcObj);
        this.macroEngine.setFormula(expr);
        this.macroEngine.execute();
        this.funcImplObj.setCurrentSrcObj(null);
    }

    private void handlePostExpression(Container srcObj, Container destObj, String expr) {
        if (expr == null || expr.length() == 0) {
            return;
        }
        this.funcImplObj.setCurrentSrcObj(srcObj);
        this.funcImplObj.setCurrentDestObj(destObj);
        this.macroEngine.setFormula(expr);
        this.macroEngine.execute();
        this.funcImplObj.setCurrentSrcObj(null);
        this.funcImplObj.setCurrentDestObj(null);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String val) {
        this.id = val;
    }

    public PageCollection getPages() {
        return this.pages;
    }

    public PageCollection getOutputPages() {
        return this.outPages;
    }

    public void syncSnapshotOutput() {
        this.outPages.clear();
        for (Page pg : this.pages) {
            pg.syncDataForSnap();
            this.outPages.add(pg);
        }
    }

    public void syncTemplatePageFromOutput() {
        this.pages.clear();
        for (Page pg : this.outPages) {
            pg.syncOriginStringFromInt();
            this.pages.add(pg);
        }
    }

    public void restoreOriginState() {
        for (Page pg : this.pages) {
            pg.restoreOriginString();
        }
    }

    public RuntimeServiceProvider getRuntimeServiceProvider() {
        return this.rsp;
    }

    public void setRuntimeServiceProvider(RuntimeServiceProvider rsp) {
        this.rsp = rsp;
    }

    private Object getProperArg(Variant var, Class cls) {
        Object obj = var.getValue();
        try {
            Variant varNumber;
            if (var.isNumber()) {
                if (cls.equals(Integer.TYPE)) {
                    obj = var.intValue();
                } else if (cls.equals(Long.TYPE)) {
                    obj = var.longValue();
                } else if (cls.equals(Float.TYPE)) {
                    obj = Float.valueOf(var.floatValue());
                } else if (cls.equals(Double.TYPE)) {
                    obj = var.doubleValue();
                } else if (cls.equals(Character.TYPE)) {
                    obj = Character.valueOf(var.charValue());
                } else if (cls.equals(Byte.TYPE)) {
                    obj = var.byteValue();
                } else if (cls.equals(Integer.class)) {
                    obj = var.intValue();
                } else if (cls.equals(Character.class)) {
                    obj = Character.valueOf(var.charValue());
                } else if (cls.equals(Short.class)) {
                    obj = var.shortValue();
                } else if (cls.equals(Variant.class)) {
                    obj = var;
                }
            } else if (var.getVt() == 11 && (cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Float.TYPE) || cls.equals(Double.TYPE) || cls.equals(Character.TYPE) || cls.equals(Byte.TYPE) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(Short.class) || cls.equals(Variant.class)) && var.isNumeric(varNumber = Variant.getNewEmptyVariant())) {
                return this.getProperArg(varNumber, cls);
            }
        }
        catch (SyntaxErrorException e) {
            log.error((Object)"err", (Throwable)e);
        }
        return obj;
    }

    public boolean externalMethod(Parser psr, String funcName, ArrayList params, Variant rvarResult) {
        for (Object objOwner : this.userFuncs) {
            if (objOwner == null) continue;
            Class<?> objCls = objOwner.getClass();
            Method method = null;
            Class<?>[] argTypes = null;
            Method[] methods = objCls.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equalsIgnoreCase(funcName)) continue;
                argTypes = methods[i].getParameterTypes();
                if ((params != null || argTypes.length != 0) && (params == null || argTypes.length != params.size())) continue;
                method = methods[i];
                break;
            }
            if (method == null) continue;
            Object[] args = null;
            if (params != null) {
                args = new Object[argTypes.length];
                for (int i = 0; i < argTypes.length; ++i) {
                    args[i] = this.getProperArg((Variant)params.get(i), argTypes[i]);
                }
            }
            try {
                rvarResult.setObject(method.invoke(objOwner, args));
                return true;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"err", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"err", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"err", (Throwable)e);
            }
        }
        return false;
    }

    public boolean queryVariable(Parser psr, String variableName, Variant varFormula, Variant rvarResult) throws SyntaxErrorException {
        if (variableName != null) {
            if (variableName.equalsIgnoreCase("$PAGENO")) {
                rvarResult.setObject((Object)this.newPageCount);
                return true;
            }
            if (variableName.equalsIgnoreCase("$ROWNO")) {
                rvarResult.setObject((Object)(this.dataListener.getCurrentRecordNumber(this.currentDataSource) + 1));
                return true;
            }
            if (variableName.equalsIgnoreCase("$GROUPROWNO")) {
                HashMap gpMap;
                int c = 0;
                if (this.groupLevelCountTable != null && this.groupLevelCountTable.containsKey(this.currentDataSource) && (gpMap = (HashMap)this.groupLevelCountTable.get(this.currentDataSource)).containsKey(this.currentGroupField)) {
                    AuxGroupLevelCount glc = (AuxGroupLevelCount)gpMap.get(this.currentGroupField);
                    c = glc.count;
                }
                rvarResult.setObject((Object)(c + 1));
                return true;
            }
            throw new SyntaxErrorException(512L, (Object)variableName);
        }
        return false;
    }

    public boolean queryObjectInstance(Parser psr, String objectName, Variant varInstance) {
        return false;
    }

    public boolean queryCell(Parser psr, RelationsListener listener, int row, int col, Variant rvarResult) throws SyntaxErrorException {
        return false;
    }

    public String getMethodName(String methodName) {
        return methodName;
    }

    public LayerCollection getLayers() {
        return this.layers;
    }

    protected FontRenderContext getFrc() {
        return this.frc;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    public void copyProperties(PropertyCollection collection) {
        this.properties = this.properties.clone(collection);
    }

    public void addProperty(Property prop) {
        this.properties = this.properties.add(prop);
    }

    public void removeProperty(Property prop) {
        this.properties = this.properties.remove(prop);
    }

    protected void setProperties(PropertyCollection collection) {
        this.properties = collection;
    }

    protected HashMap getNamedOutputComponentMap() {
        return this.namedOutputComponentMap;
    }

    public String getUserAlias() {
        return this.userAlias;
    }

    public void setUserAlias(String string) {
        this.userAlias = string;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    protected DataListener getDataListener() {
        return this.dataListener;
    }

    public String getFooterID() {
        return this.footerID;
    }

    public void setFooterID(String footerID) {
        this.footerID = footerID;
    }

    public String getHeaderID() {
        return this.headerID;
    }

    public void setHeaderID(String headerID) {
        this.headerID = headerID;
    }

    private void markGroupStart4PageTotalAtGroup(String srckey, String gfd) {
        if (this.pageNumberAtGroup.containsKey(srckey)) {
            HashMap fdMap = (HashMap)this.pageNumberAtGroup.get(srckey);
            if (!fdMap.containsKey(gfd)) {
                fdMap.put(gfd, this.newPageCount);
            } else {
                Object mark = fdMap.get(gfd);
                if (mark instanceof Float) {
                    fdMap.put(gfd, this.newPageCount);
                }
            }
        } else {
            HashMap<String, Integer> fdMap = new HashMap<String, Integer>();
            fdMap.put(gfd, this.newPageCount);
            this.pageNumberAtGroup.put(srckey, fdMap);
        }
    }

    private void markGroupEnd4PageTotalAtGroup(String srckey, String gfd) {
        HashMap fdMap;
        if (this.pageNumberAtGroup.containsKey(srckey) && (fdMap = (HashMap)this.pageNumberAtGroup.get(srckey)).containsKey(gfd)) {
            Object lastMark = fdMap.get(gfd);
            int lastPageCount = 0;
            if (lastMark instanceof Integer) {
                lastPageCount = (Integer)lastMark;
            } else if (lastMark instanceof Float) {
                lastPageCount = ((Float)lastMark).intValue();
            }
            int pageCount = this.newPageCount - lastPageCount + 1;
            fdMap.put(gfd, new Float(this.newPageCount));
            String key = srckey + "$" + gfd;
            ArrayList cells = (ArrayList)this.cellsWaitToFill.get(key);
            if (cells != null) {
                for (int i = cells.size() - 1; i >= 0; --i) {
                    Cell nCell = (Cell)cells.remove(i);
                    Cell cell = (Cell)nCell.getSource();
                    Data nData = nCell.getData();
                    nData.setValue(new Variant(pageCount));
                    nData.setFormat(this.getFormattedData(cell.getDataFormat(), nData.getValue(), cell));
                    nCell.getPage().unsureReduce();
                }
            }
        }
    }

    int getPageAtGroup(Container sourceCell, String areaId) {
        Group group;
        Iterator children;
        int lastPageCount = 1;
        Container obj = this.findObject(areaId, sourceCell.getPage());
        if (obj instanceof Area && (children = ((Area)obj).iterator()).hasNext() && (group = this.getParentFieldGroup((Container)children.next())) != null) {
            HashMap fdMap;
            String srckey = group.getDataSource();
            String gfd = group.getField();
            if (this.pageNumberAtGroup.containsKey(srckey) && (fdMap = (HashMap)this.pageNumberAtGroup.get(srckey)).containsKey(gfd)) {
                Object lastMark = fdMap.get(gfd);
                lastPageCount = lastMark instanceof Float ? ((Float)lastMark).intValue() + 1 : (Integer)lastMark;
            }
        }
        int pageNumber = this.newPageCount - lastPageCount + 1;
        return pageNumber;
    }

    private Container findObject(String id, Container cont) {
        Iterator it = cont.iterator();
        while (it.hasNext()) {
            Container child = (Container)it.next();
            if (StringUtil.equals((String)id, (String)child.getId())) {
                return child;
            }
            Container target = this.findObject(id, child);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    private void realOutputPage() {
        Page page;
        int index;
        int c = this.tempOutPages.size();
        for (index = 0; index < c && !(page = (Page)this.tempOutPages.get(index)).isUnsure(); ++index) {
            this.outPages.add(page);
            this.eventListener.endPageOutput(page.getId(), page.getIndex());
        }
        for (int i = 0; i < index; ++i) {
            this.tempOutPages.remove(0);
        }
    }

    public void forceStop() {
        this._forceStop = true;
    }

    static final class AuxGroupTotal
    extends AuxAreaTotal {
        public String dataSource;
        public String field;

        AuxGroupTotal() {
        }
    }

    static class AuxAreaTotal {
        public Container group;
        public Cell oldCell;
        public Cell newCell;
        public double total;

        AuxAreaTotal() {
        }
    }

    static final class AuxGroupLevelCount {
        public String field;
        public int count;

        AuxGroupLevelCount() {
        }
    }

    static final class AuxCounter {
        public String field;
        public Object value;

        AuxCounter() {
        }
    }

    static final class AuxParam {
        public Container cont;
        public Container currentParent;
        public Group currentGroup;
        public Page currentOutPage;
        public Page currentPage;
        public int xl;
        public int xr;
        public int yt;
        public int yb;
        public Area parentArea;
        public boolean isDataNext;
        public boolean isLoop = false;
        public Container loopObj;
        public int loopCount;
        public int loopMin;

        AuxParam() {
        }
    }
}

