/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.form;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.form.Area;
import com.kingdee.cosmic.ctrl.kdf.form.BaseFormBuilder;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.ChartData;
import com.kingdee.cosmic.ctrl.kdf.form.Column;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form.Layer;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.Panel;
import com.kingdee.cosmic.ctrl.kdf.form.Property;
import com.kingdee.cosmic.ctrl.kdf.form.Row;
import com.kingdee.cosmic.ctrl.kdf.form.RuntimeStyleService;
import com.kingdee.cosmic.ctrl.kdf.form.Table;
import com.kingdee.cosmic.ctrl.kdf.form2.ui.DivideCharacter;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import com.kingdee.cosmic.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.Iterator;
import java.util.List;

public final class FormXmlTrans
implements IXmlTrans {
    private static float version = 3.1f;
    private RuntimeStyleService stsvs;
    private boolean snapMode = false;
    private boolean designMode = false;
    private static final byte[] ZEROBYTE = new byte[0];

    @Override
    public IXmlElement writeToNode(Object obj, KDF kdf) {
        return this.writeToNode((Form)obj, (RuntimeStyleService)kdf);
    }

    public IXmlElement writeToCustomNode(String name, Container cont, RuntimeStyleService stsvs) {
        if (cont != null) {
            this.stsvs = stsvs;
            IXmlElement elem = this.innerWriteToNode(cont);
            if (name != null) {
                elem.setName(name);
            }
            return elem;
        }
        return null;
    }

    public IXmlElement writeToNode(Container cont, RuntimeStyleService stsvs) {
        if (cont != null) {
            this.stsvs = stsvs;
            IXmlElement elem = this.innerWriteToNode(cont);
            return elem;
        }
        return null;
    }

    protected IXmlElement writeToNode(Form fom, RuntimeStyleService stsvs) {
        if (fom != null) {
            Form fm = fom;
            this.stsvs = stsvs;
            IXmlElement efm = XmlUtil.createNode((String)"Form");
            efm.setAttribute("id", fm.getId());
            if (fm.getUserAlias() != null) {
                efm.setAttribute("alias", fm.getUserAlias());
            }
            if (fm.getHeaderID() != null) {
                efm.setAttribute("headerID", fm.getHeaderID());
            }
            if (fm.getFooterID() != null) {
                efm.setAttribute("footerID", fm.getFooterID());
            }
            efm.setAttribute("version", Float.toString(version));
            if (fm.getUserObject() instanceof IXmlElement) {
                efm.addChild((IXmlElement)fm.getUserObject());
            }
            if (fm.getProperties().size() > 0) {
                IXmlElement eprops = XmlUtil.createNode((String)"Properties");
                efm.addChild(eprops);
                for (Property prop : fm.getProperties()) {
                    IXmlElement eprop = XmlUtil.createNode((String)"Property");
                    eprop.setAttribute("name", prop.getName());
                    if (prop.getType() != null) {
                        eprop.setAttribute("type", prop.getType());
                    }
                    eprop.addCData(prop.getFormat());
                    eprops.addChild(eprop);
                }
            }
            if (fm.getLayers().size() > 0) {
                IXmlElement elays = XmlUtil.createNode((String)"Layers");
                efm.addChild(elays);
                for (Layer lay : fm.getLayers()) {
                    if (lay.getId() == null) continue;
                    IXmlElement elay = XmlUtil.createNode((String)"Layer");
                    elay.setAttribute("id", lay.getId());
                    if (lay.getAlias() != null) {
                        elay.setAttribute("alias", lay.getAlias());
                    }
                    if (lay.getCategory() != null) {
                        elay.setAttribute("category", lay.getCategory());
                    }
                    if (lay.getStyleID() != null) {
                        elay.setAttribute("styleID", lay.getStyleID());
                    }
                    elays.addChild(elay);
                }
            }
            for (Page pg : fm.getPages()) {
                IXmlElement epg = this.innerWriteToNode(pg);
                efm.addChild(epg);
            }
            return efm;
        }
        return null;
    }

    private IXmlElement innerWriteToNode(Container cont) {
        String ss = cont.getClass().getName();
        int dot = ss.lastIndexOf(46);
        if (dot > -1) {
            ss = ss.substring(dot + 1);
        }
        IXmlElement ele = XmlUtil.createNode((String)ss);
        if (cont.getId() != null) {
            ele.setAttribute("id", cont.getId());
        }
        if (cont.getUserAlias() != null) {
            ele.setAttribute("alias", cont.getUserAlias());
        }
        if (cont.getUserObject() instanceof IXmlElement) {
            ele.addChild((IXmlElement)cont.getUserObject());
        }
        if (this.stsvs != null && !cont.getStyles().equals((Object)Styles.getEmptySSA())) {
            ele.setAttribute("styleID", this.stsvs.addStyleAttributes(cont.getStyles()));
        }
        if (cont.getLeft().getOriginString() != null) {
            ele.setAttribute("left", cont.getLeft().getOriginString());
        }
        if (cont.getRight().getOriginString() != null) {
            ele.setAttribute("right", cont.getRight().getOriginString());
        }
        if (cont.getTop().getOriginString() != null) {
            ele.setAttribute("top", cont.getTop().getOriginString());
        }
        if (cont.getBottom().getOriginString() != null) {
            ele.setAttribute("bottom", cont.getBottom().getOriginString());
        }
        if (cont.getLayer() != null) {
            ele.setAttribute("layerID", cont.getLayer());
        }
        if (cont.getVisibility().getOriginString() != null) {
            ele.setAttribute("visible", cont.getVisibility().getOriginString());
        }
        if (cont.getHoldPlace().getOriginString() != null) {
            ele.setAttribute("holdPlace", cont.getHoldPlace().getOriginString());
        }
        if (cont.getPreSteps() != null) {
            ele.setAttribute("preMacro", cont.getPreSteps());
        }
        if (cont.getPostSteps() != null) {
            ele.setAttribute("postMacro", cont.getPostSteps());
        }
        if (cont.getAnchor() != null) {
            ele.setAttribute("anchor", cont.getAnchor());
        }
        if (cont.getHint() != null) {
            ele.setAttribute("hint", cont.getHint());
        }
        if (cont.getPriority() != 0) {
            ele.setAttribute("priority", String.valueOf(cont.getPriority()));
        }
        if (cont.getProperties().size() > 0 || cont.getCustomStyles().size() > 0) {
            IXmlElement eprop;
            IXmlElement eprops = XmlUtil.createNode((String)"Properties");
            ele.addChild(eprops);
            for (Property prop : cont.getProperties()) {
                eprop = XmlUtil.createNode((String)"Property");
                eprop.setAttribute("name", prop.getName());
                if (prop.getType() != null) {
                    eprop.setAttribute("type", prop.getType());
                }
                eprop.addCData(prop.getFormat());
                eprops.addChild(eprop);
            }
            for (Property prop : cont.getCustomStyles()) {
                eprop = XmlUtil.createNode((String)"Property");
                eprop.setAttribute("name", prop.getName());
                eprop.setAttribute("type", "style");
                eprop.addCData(prop.getFormat());
                eprops.addChild(eprop);
            }
        }
        if (cont instanceof Page) {
            if (((Page)cont).getRepeat() != 1) {
                ele.setAttribute("repeat", String.valueOf(((Page)cont).getRepeat()));
            }
            if (cont.group().getDataSource() != null) {
                ele.setAttribute("dataSourceID", cont.group().getDataSource());
            }
            if (cont.group().getField() != null) {
                ele.setAttribute("groupField", cont.group().getField());
            }
        } else if (cont instanceof Area) {
            Area ara = (Area)cont;
            if (ara.getMinLoopCount() != 0) {
                ele.setAttribute("minLoopCount", String.valueOf(ara.getMinLoopCount()));
            }
            if (ara.getMaxLoopCount() != -1) {
                ele.setAttribute("maxLoopCount", String.valueOf(ara.getMaxLoopCount()));
            }
            if (ara.getVerticalSpacing() != null && !ara.getVerticalSpacing().equals("0")) {
                ele.setAttribute("verticalSpacing", ara.getVerticalSpacing());
            }
            if (ara.getHorizontalSpacing() != null && !ara.getHorizontalSpacing().equals("0")) {
                ele.setAttribute("horizontalSpacing", ara.getHorizontalSpacing());
            }
            if (ara.getNext() != null) {
                ele.setAttribute("nextAreaID", ara.getNext().getFullName());
            }
        } else if (cont instanceof Panel) {
            if (cont.group().getDataSource() != null) {
                ele.setAttribute("dataSourceID", cont.group().getDataSource());
            }
            if (cont.group().getField() != null) {
                ele.setAttribute("groupField", cont.group().getField());
            }
        } else {
            if (cont instanceof Table) {
                Table tab;
                if (cont.group().getDataSource() != null) {
                    ele.setAttribute("dataSourceID", cont.group().getDataSource());
                }
                if (cont.group().getField() != null) {
                    ele.setAttribute("groupField", cont.group().getField());
                }
                if ((tab = (Table)cont).getLayoutMode() != 0) {
                    ele.setAttribute("layout", String.valueOf(tab.getLayoutMode()));
                }
                IXmlElement rge = XmlUtil.createNode((String)"Rows");
                for (Row row : tab.getRows()) {
                    IXmlElement re = XmlUtil.createNode((String)"Row");
                    if (tab.getLayoutMode() != 0 && row.getHeight().getOriginString() != null) {
                        re.setAttribute("height", row.getHeight().getOriginString());
                    }
                    if (this.stsvs != null && !row.getStyles().equals((Object)Styles.getEmptySSA())) {
                        re.setAttribute("styleID", this.stsvs.addStyleAttributes(row.getStyles()));
                    }
                    rge.addChild(re);
                }
                ele.addChild(rge);
                IXmlElement cge = XmlUtil.createNode((String)"Columns");
                for (Column col : tab.getCols()) {
                    IXmlElement ce = XmlUtil.createNode((String)"Column");
                    if (tab.getLayoutMode() != 0 && col.getWidth().getOriginString() != null) {
                        ce.setAttribute("width", col.getWidth().getOriginString());
                    }
                    if (this.stsvs != null && !col.getStyles().equals((Object)Styles.getEmptySSA())) {
                        ce.setAttribute("styleID", this.stsvs.addStyleAttributes(col.getStyles()));
                    }
                    cge.addChild(ce);
                }
                ele.addChild(cge);
                IXmlElement be = XmlUtil.createNode((String)"Body");
                Iterator bitr = tab.iterator();
                while (bitr.hasNext()) {
                    Container tcont = (Container)bitr.next();
                    IXmlElement te = this.innerWriteToNode(tcont);
                    be.addChild(te);
                }
                ele.addChild(be);
                return ele;
            }
            if (cont instanceof Cell) {
                DivideCharacter dc;
                Cell cel = (Cell)cont;
                ele.setAttribute("type", cel.getType());
                if (cel.getClipContent() != null) {
                    ele.setAttribute("clip", cel.getClipContent());
                }
                if (cel.getDataFormat() != null && cel.getDataFormat().length() > 0) {
                    ele.setAttribute("format", cel.getDataFormat());
                }
                if (cel.getData() != null) {
                    IXmlElement de = XmlUtil.createNode((String)"Data");
                    if ("image".equals(cel.getData().getType())) {
                        byte[] imageData;
                        IXmlElement eps = ele.getChild("Properties");
                        if (eps != null) {
                            List epl = eps.searchChildren("Property");
                            boolean fd = false;
                            for (IXmlElement ep : epl) {
                                if (!"contentType".equals(ep.getAttribute("name"))) continue;
                                ep.addCData("embeddedImage");
                                fd = true;
                                break;
                            }
                            if (!fd) {
                                IXmlElement ep;
                                ep = XmlUtil.createNode((String)"Property");
                                ep.setAttribute("name", "contentType");
                                ep.addCData("embeddedImage");
                                eps.addChild(ep);
                            }
                        }
                        if ((imageData = (byte[])((Variant)cel.getData().getValue()).getValue()) != null) {
                            de.setAttribute("type", "embeddedImage");
                            de.addCData(Base64.encodeBytes((byte[])imageData));
                        } else {
                            de.setAttribute("type", "embeddedImage");
                            de.addCData(Base64.encodeBytes((byte[])ZEROBYTE));
                        }
                    } else if ("chart".equals(cel.getData().getType())) {
                        ChartData cd = (ChartData)((Variant)cel.getData().getValue()).getValue();
                        if (cd != null) {
                            de.setAttribute("type", "chart");
                            de.addCData(cd.toString());
                        } else {
                            de.setAttribute("type", "string");
                            de.addCData("");
                        }
                    } else {
                        de.setAttribute("type", cel.getData().getType());
                        de.addCData(cel.getData().getFormat());
                    }
                    ele.addChild(de);
                }
                if ((dc = cel.getDivideCharacter()) != null) {
                    DivideCharacter.save(ele, dc);
                }
            }
        }
        Iterator itr = cont.iterator();
        while (itr.hasNext()) {
            Container tcont = (Container)itr.next();
            IXmlElement el = this.innerWriteToNode(tcont);
            ele.addChild(el);
        }
        return ele;
    }

    @Override
    public Object readFromNode(IXmlElement ele, KDF kdf) {
        BaseFormBuilder builder = new BaseFormBuilder();
        builder.setSnapMode(this.snapMode);
        builder.setDesignMode(this.designMode);
        return builder.createForm(kdf, ele);
    }

    public Container readFromNode(IXmlElement ele, RuntimeStyleService rss) {
        BaseFormBuilder builder = new BaseFormBuilder();
        builder.setSnapMode(this.snapMode);
        builder.setDesignMode(this.designMode);
        return builder.createContainer(rss, ele);
    }

    public void setSnapMode(boolean snapMode) {
        this.snapMode = snapMode;
    }

    public void setDesignMode(boolean designMode) {
        this.designMode = designMode;
    }
}

