/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions.BrowserInitializableAction;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.cosmic.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.BaseComponent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.log4j.Logger;

public class SwapViewModeAction
extends AbstractAction
implements CompositableAction,
BrowserInitializableAction {
    private static final long serialVersionUID = -6624818510341711467L;
    private static Logger logger = LogUtil.getPackageLogger(SwapViewModeAction.class);
    transient KDPrintService printServ;
    private transient ClientCore clientCore;

    public SwapViewModeAction() {
        this.putValue("Name", BaseComponent.resources.getString("action.print.name"));
        this.putValue("ShortDescription", BaseComponent.resources.getString("action.print.description"));
        this.putValue("MnemonicKey", BaseComponent.resources.getObject("action.print.mnemonic"));
        this.putValue("ICON24", BaseComponent.resources.getObject("action.print.icon"));
        this.putValue("DEFAULT_ENABLE", Boolean.TRUE);
        this.putValue("ENABLE_UNTIL_DATACOMPLETED", Boolean.TRUE);
        this.putValue("MENU_COMMANDS", "virtualpage;physicalpage");
    }

    @Override
    public void setClientCore(ClientCore clientCore) {
        this.clientCore = clientCore;
    }

    @Override
    public void setCompContainer(PrintCompContainer container) {
        try {
            this.printServ = (KDPrintService)container.getManager().lookup("KDPrintService");
        }
        catch (ServiceException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if ("virtualpage".equals(event.getActionCommand())) {
            this.clientCore.getContextOfBrowser().setViewMode(0);
        } else if ("physicalpage".equals(event.getActionCommand())) {
            this.clientCore.getContextOfBrowser().setViewMode(1);
        }
    }
}

