/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class KDFWapper {
    private static Logger logger = LogUtil.getPackageLogger(KDFWapper.class);
    public KDF kdf;
    private byte[] kdfdata;

    public KDFWapper(KDF kdf) {
        this.kdf = kdf;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        kdf.save(baos);
        this.kdfdata = baos.toByteArray();
    }

    public KDFWapper(InputStream is, int limit) {
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            bis.mark(limit);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] context = new byte[1024];
            int len = 0;
            while ((len = bis.read(context)) != -1) {
                baos.write(context, 0, len);
            }
            this.kdfdata = baos.toByteArray();
            bis.reset();
            this.kdf = new KDF(bis);
        }
        catch (IOException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
        catch (KDFException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
    }

    public KDF getKDF() {
        return this.kdf;
    }

    public byte[] getKDFData() {
        return this.kdfdata;
    }
}

