/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.dialogs;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.FormPainter;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.LayerManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.clientcore.VisibleManager;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class ConfigFilterDialog
extends KDDialog {
    private static final long serialVersionUID = -5433817062717855663L;
    private LayerManager layermgr;
    boolean isOK = false;
    private TypePane filterPane;
    private TypePane typePane;
    private Hashtable result;
    private Hashtable types;
    KDButton cancelButton = new KDButton(Resources.LOCAL_STR("cancel"));
    public KDButton okButton = new KDButton(Resources.LOCAL_STR("approve", "OK"));

    public ConfigFilterDialog(Frame frame, ClientCore clientCore) {
        super(frame);
        this.layermgr = clientCore.getLayerManager();
        this.setTitle(Resources.LOCAL_STR("filter-output", "Filter Output"));
        this.getContentPane().setLayout(new BorderLayout());
        KDTabbedPane tabbedPane = new KDTabbedPane();
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel cmdPane = new JPanel();
        cmdPane.setLayout(new FlowLayout(2));
        cmdPane.add((Component)this.okButton);
        cmdPane.add((Component)this.cancelButton);
        this.getContentPane().add((Component)cmdPane, "South");
        ((JPanel)this.getContentPane()).setPreferredSize(new Dimension(300, 250));
        this.setDefaultCloseOperation(2);
        Hashtable<String, Boolean> state = new Hashtable<String, Boolean>();
        this.layermgr.storeState(state);
        state.put(Resources.LOCAL_STR("default-layer", "Default Layer"), Boolean.TRUE);
        this.filterPane = new TypePane();
        this.filterPane.setItems(state);
        tabbedPane.addTab(Resources.LOCAL_STR("default-layer", "Select Layer"), (Component)this.filterPane);
        VisibleManager vm = clientCore.getVisibleManager();
        this.types = new Hashtable();
        Iterator itr = vm.getFormTypesSet().iterator();
        while (itr.hasNext()) {
            String clsName = ((Class)itr.next()).getName();
            clsName = clsName.substring(clsName.lastIndexOf(46) + 1);
            this.types.put(Resources.LOCAL_STR(clsName), vm.isFormObjectVisible(Resources.LOCAL_STR(clsName)));
        }
        this.typePane = new TypePane();
        this.typePane.setItems(this.types);
        tabbedPane.addTab(Resources.LOCAL_STR("select-object-type", "Object Type"), (Component)this.typePane);
        final GraphicsEltSyncer elementSyncer = new GraphicsEltSyncer(clientCore.getFormPainter());
        final TypePane selElementsPane = new TypePane();
        selElementsPane.setItems(elementSyncer.syncFromFormPainter());
        tabbedPane.addTab(Resources.LOCAL_STR("select-graphics-type", "Graphics Type"), (Component)selElementsPane);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigFilterDialog.this.result = new Hashtable();
                ConfigFilterDialog.this.filterPane.getItems(ConfigFilterDialog.this.result);
                ConfigFilterDialog.this.isOK = true;
                ConfigFilterDialog.this.setVisible(false);
                ConfigFilterDialog.this.typePane.getItems(ConfigFilterDialog.this.types);
                Hashtable selElements = new Hashtable();
                selElementsPane.getItems(selElements);
                elementSyncer.syncToFormPainter(selElements);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConfigFilterDialog.this.isOK = false;
                ConfigFilterDialog.this.setVisible(false);
            }
        });
    }

    public boolean isOK() {
        return this.isOK;
    }

    public Hashtable getLayerResult() {
        return this.result;
    }

    public Hashtable getSelTypeResult() {
        return this.types;
    }

    public static class TypePane
    extends JPanel {
        private static final long serialVersionUID = -5661566083170594514L;
        private KDCheckBox[] itemBoxs = new KDCheckBox[0];
        private KDScrollPane scrollPane = new KDScrollPane(20, 30);

        public void setItems(Hashtable items) {
            Object[] objs = items.keySet().toArray();
            String[] itemStrs = new String[objs.length];
            this.itemBoxs = new KDCheckBox[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                itemStrs[i] = (String)objs[i];
                this.itemBoxs[i] = new KDCheckBox((String)objs[i]);
            }
            boolean[] itemVals = new boolean[itemStrs.length];
            for (int i = 0; i < itemStrs.length; ++i) {
                itemVals[i] = (Boolean)items.get(itemStrs[i]);
                this.itemBoxs[i].setSelected(((Boolean)items.get(itemStrs[i])).booleanValue());
            }
            JPanel listpane = new JPanel();
            listpane.setLayout(new BoxLayout(listpane, 1));
            for (int i = 0; i < this.itemBoxs.length; ++i) {
                Box box = Box.createHorizontalBox();
                box.add((Component)this.itemBoxs[i]);
                box.add(Box.createGlue());
                if (itemStrs[i].equals(Resources.LOCAL_STR("default-layer", "Default Layer"))) {
                    this.itemBoxs[i].setEnabled(false);
                }
                listpane.add(box);
            }
            this.scrollPane.getViewport().setView(listpane);
        }

        public void getItems(Hashtable result) {
            for (int i = 0; i < this.itemBoxs.length; ++i) {
                result.put(this.itemBoxs[i].getText(), this.itemBoxs[i].isSelected());
            }
        }

        public TypePane() {
            this.add((Component)this.scrollPane);
        }
    }

    public static class ListPane
    extends JPanel {
        private static final long serialVersionUID = 7180882450160827633L;

        public void setItems(Hashtable items) {
            Object[] objs = items.keySet().toArray();
            String[] itemStrs = new String[objs.length];
            KDCheckBox[] itemBoxs = new KDCheckBox[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                itemStrs[i] = (String)objs[i];
                itemBoxs[i] = new KDCheckBox((String)objs[i]);
            }
            boolean[] itemVals = new boolean[itemStrs.length];
            for (int i = 0; i < itemStrs.length; ++i) {
                itemVals[i] = (Boolean)items.get(itemStrs[i]);
                itemBoxs[i].setSelected(((Boolean)items.get(itemStrs[i])).booleanValue());
            }
        }

        public boolean isItemsSelected(int i) {
            return false;
        }
    }

    private static class GraphicsEltSyncer {
        FormPainter formPainter;

        public GraphicsEltSyncer(FormPainter formPainter) {
            this.formPainter = formPainter;
        }

        public Hashtable syncFromFormPainter() {
            Hashtable<String, Boolean> elements = new Hashtable<String, Boolean>();
            elements.put(Resources.LOCAL_STR("background"), this.formPainter.isEnableBackground());
            elements.put(Resources.LOCAL_STR("frontground"), this.formPainter.isEnableForeground());
            elements.put(Resources.LOCAL_STR("content"), this.formPainter.isEnableContent());
            elements.put(Resources.LOCAL_STR("border"), this.formPainter.isEnableBorder());
            return elements;
        }

        public static String LOCAL_STR(String key) {
            return LanguageManager.getLangMessage((String)key, Resources.class, (String)key);
        }

        public void syncToFormPainter(Hashtable selElts) {
            this.formPainter.setEnableBackground((Boolean)selElts.get(Resources.LOCAL_STR("background")));
            this.formPainter.setEnableForeground((Boolean)selElts.get(Resources.LOCAL_STR("frontground")));
            this.formPainter.setEnableContent((Boolean)selElts.get(Resources.LOCAL_STR("content")));
            this.formPainter.setEnableBorder((Boolean)selElts.get(Resources.LOCAL_STR("border")));
        }
    }
}

