/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.dialogs;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.cosmic.ctrl.kdf.printprovider.util.ExtensionFilter;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class InputUrlDlg
extends KDDialog {
    private static final long serialVersionUID = 9165024806380765681L;
    private static Logger logger = LogUtil.getPackageLogger(InputUrlDlg.class);
    private KDTextField pathBox;
    boolean isDone = false;
    private String[][] expTypes = new String[][]{{"GIF" + Resources.LOCAL_STR("File"), ".gif"}, {"PNG " + Resources.LOCAL_STR("File"), ".png"}, {"JPG " + Resources.LOCAL_STR("File"), ".jpg"}, {"BMP " + Resources.LOCAL_STR("File"), ".bmp"}};
    KDFileChooser chooser = new KDFileChooser();
    private KDButton okButton;

    public InputUrlDlg(Frame frame) {
        super(frame);
        this.chooser.setDialogTitle(Resources.LOCAL_STR("exprot2file-name", "Export To File"));
        String subfix = this.expTypes[0][1];
        String[] exts = subfix.split("\\|");
        FileFilter[] filters = new FileFilter[]{new ExtensionFilter(this.expTypes[0][0], exts), new ExtensionFilter(this.expTypes[1][0], this.expTypes[1][1].split("\\1")), new ExtensionFilter(this.expTypes[2][0], this.expTypes[2][1].split("\\1")), new ExtensionFilter(this.expTypes[3][0], this.expTypes[3][1].split("\\1"))};
        this.chooser.addChoosableFileFilter(filters[0]);
        this.chooser.addChoosableFileFilter(filters[1]);
        this.chooser.addChoosableFileFilter(filters[2]);
        this.chooser.addChoosableFileFilter(filters[3]);
        this.chooser.setFileFilter(filters[0]);
        this.okButton = new KDButton(Resources.LOCAL_STR("approve", "OK"));
        this.init();
        this.setModal(true);
        this.setDefaultCloseOperation(1);
    }

    public void init() {
        this.setTitle(Resources.LOCAL_STR("InputUrlDlg.title", "Input URL"));
        JPanel filePane = new JPanel();
        JPanel cmdPane = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)filePane, "Center");
        this.getContentPane().add((Component)cmdPane, "South");
        this.pathBox = new KDTextField();
        this.pathBox.setPreferredSize(new Dimension(320, 30));
        this.pathBox.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.pathBox.setText("http://");
        this.pathBox.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (InputUrlDlg.this.pathBox.getText().startsWith("http", 0)) {
                    InputUrlDlg.this.okButton.setEnabled(true);
                } else if (!InputUrlDlg.this.pathBox.getText().startsWith("file://", 0)) {
                    InputUrlDlg.this.pathBox.setText("file://" + InputUrlDlg.this.pathBox.getText());
                }
            }
        });
        KDButton pathButton = new KDButton("...");
        pathButton.setPreferredSize(new Dimension(50, 30));
        filePane.setLayout(new BorderLayout());
        filePane.add((Component)this.pathBox, "West");
        filePane.add((Component)pathButton, "East");
        filePane.setBorder(new EmptyBorder(10, 0, 10, 0));
        filePane.setPreferredSize(new Dimension(400, 40));
        pathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String path = InputUrlDlg.this.getSelectedPath();
                if (path != null) {
                    InputUrlDlg.this.pathBox.setText("file://" + path);
                    InputUrlDlg.this.okButton.setEnabled(true);
                } else if (InputUrlDlg.this.pathBox.getText() == null) {
                    InputUrlDlg.this.okButton.setEnabled(false);
                }
            }
        });
        KDButton cancelButton = new KDButton(Resources.LOCAL_STR("cancel"));
        this.okButton.setEnabled(false);
        JPanel cmdPane1 = new JPanel();
        JPanel cmdPane2 = new JPanel();
        cmdPane1.setBorder(BorderFactory.createEtchedBorder());
        cmdPane1.setPreferredSize(new Dimension(400, 2));
        cmdPane.setLayout(new BorderLayout());
        cmdPane.add(cmdPane1);
        cmdPane.add(cmdPane2);
        cmdPane2.setLayout(new FlowLayout(2));
        cmdPane2.add((Component)this.okButton);
        cmdPane2.add((Component)cancelButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputUrlDlg.this.isDone = true;
                InputUrlDlg.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputUrlDlg.this.isDone = false;
                InputUrlDlg.this.setVisible(false);
            }
        });
    }

    public String getSelectedPath() {
        this.chooser.showSaveDialog((Component)((Object)this));
        File selectedFile = this.chooser.getSelectedFile();
        return selectedFile == null ? null : selectedFile.getPath();
    }

    public URL getUrl() {
        try {
            return new URL(this.pathBox.getText());
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
            return null;
        }
    }

    public boolean isDone() {
        return this.isDone;
    }
}

