/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.formbrowser2.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects.ImageObject;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.formobjects.LineObject;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;

public class CellImageCreator {
    public static Image getImageOf(Cell cont) {
        Variant value;
        assert (cont != null);
        int xpos = (int)((double)cont.getLeft().getInteger() * 0.28346456692913385);
        int ypos = (int)((double)cont.getTop().getInteger() * 0.28346456692913385);
        double cellwidth = (double)cont.getRight().getInteger() * 0.28346456692913385 - (double)xpos;
        double cellheight = (double)cont.getBottom().getInteger() * 0.28346456692913385 - (double)ypos;
        FormContainerObject parent = null;
        FormObject theObject = null;
        String dataType = cont.getData().getType();
        if (dataType.equalsIgnoreCase("line")) {
            theObject = new LineObject(xpos, ypos, (int)cellwidth, (int)cellheight, cont, parent);
        } else if (dataType.equalsIgnoreCase("image")) {
            value = (Variant)cont.getData().getValue();
            if (value != null && value.getValue() != null) {
                theObject = new ImageObject(xpos, ypos, (int)cellwidth, (int)cellheight, (byte[])value.getValue(), (Container)cont, parent);
            }
        } else if (dataType.equalsIgnoreCase("embeddedImage")) {
            value = (Variant)cont.getData().getValue();
            if (value != null && value.getValue() != null) {
                String base64val = (String)value.getValue();
                byte[] data = Base64.decode((String)base64val);
                theObject = new ImageObject(xpos, ypos, (int)cellwidth, (int)cellheight, data, (Container)cont, parent);
            }
        } else if (dataType.equalsIgnoreCase("linkedImage") && (value = (Variant)cont.getData().getValue()) != null && value.getValue() != null) {
            try {
                String urlVal = (String)value.getValue();
                URL url = new URL(urlVal);
                theObject = new ImageObject(xpos, ypos, (int)cellwidth, (int)cellheight, url, (Container)cont, parent);
            }
            catch (MalformedURLException e) {
                LogUtil.getLogger((String)CellImageCreator.class.getClass().getName()).error((Object)"errmsg", (Throwable)e);
            }
        }
        if (theObject != null) {
            if (theObject instanceof ImageObject) {
                ShareStyleAttributes[] ssas = new ShareStyleAttributes[]{cont.getCustomStyles().getStyleAttributes(), cont.getStyles()};
                Style stl = Styles.getStyle((ShareStyleAttributes[])ssas);
                Image img = ((ImageObject)theObject).getImage();
                int iw = (int)((double)img.getWidth(null) * 0.75);
                int ih = (int)((double)img.getHeight(null) * 0.75);
                int cw = Math.min(iw, (int)cellwidth);
                int ch = Math.min(ih, (int)cellheight);
                int cx = 0;
                int cy = 0;
                if ((int)cellwidth == cw) {
                    if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                        cx = iw - cw;
                    } else if (stl.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                        cx = (iw - cw) / 2;
                    }
                }
                if ((int)cellheight == ch) {
                    if (stl.getVerticalAlign() == Styles.VerticalAlignment.BOTTOM) {
                        cy = ih - ch;
                    } else if (stl.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE) {
                        cy = (ih - ch) / 2;
                    }
                }
                BufferedImage bi = new BufferedImage((int)((double)cw / 0.75), (int)((double)ch / 0.75), 2);
                bi.getGraphics().drawImage(img, 0, 0, (int)((double)cw / 0.75), (int)((double)ch / 0.75), (int)((double)cx / 0.75), (int)((double)cy / 0.75), (int)((double)(cx + cw) / 0.75), (int)((double)(cy + ch) / 0.75), null);
                return bi;
            }
            if (theObject instanceof LineObject) {
                int cw = (int)Math.abs(cellwidth);
                int ch = (int)Math.abs(cellheight);
                if (cw == 0 || ch == 0) {
                    return null;
                }
                BufferedImage bi = new BufferedImage((int)((double)cw / 0.75), (int)((double)ch / 0.75), 2);
                Style stl = theObject.getStyle();
                if (stl.isNullBorder(Styles.Position.LEFT)) {
                    Graphics2D gg = (Graphics2D)bi.getGraphics();
                    gg.setColor(new Color(~stl.getBorderColor(Styles.Position.LEFT).getRed()));
                    gg.fillRect(0, 0, bi.getWidth(), bi.getHeight());
                    for (int i = 0; i < bi.getWidth(); ++i) {
                        for (int j = 0; j < bi.getHeight(); ++j) {
                            bi.setRGB(i, j, 0xFFFFFF & bi.getRGB(i, j));
                        }
                    }
                    gg.setStroke(stl.getStroke(Styles.Position.LEFT));
                    gg.setColor(stl.getBorderColor(Styles.Position.LEFT));
                    int x0 = theObject.getZoomedDim(theObject.x);
                    int y0 = theObject.getZoomedDim(theObject.y);
                    int x1 = theObject.getZoomedDim(theObject.x) + theObject.getZoomedDim(theObject.width);
                    int y1 = theObject.getZoomedDim(theObject.y) + theObject.getZoomedDim(theObject.height);
                    int biasX = Math.min(x0, x1);
                    int biasY = Math.min(y0, y1);
                    gg.drawLine((int)((double)(x0 - biasX) / 0.75), (int)((double)(y0 - biasY) / 0.75), (int)((double)(x1 - biasX) / 0.75), (int)((double)(y1 - biasY) / 0.75));
                    gg.dispose();
                } else {
                    for (int i = 0; i < bi.getWidth(); ++i) {
                        for (int j = 0; j < bi.getHeight(); ++j) {
                            bi.setRGB(i, j, 0xFFFFFF & bi.getRGB(i, j));
                        }
                    }
                }
                return bi;
            }
        }
        return null;
    }
}

