/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider;

import com.kingdee.cosmic.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.cosmic.ctrl.kdf.printprovider.DefaultPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IHeaderFooterPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IPainter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.BaseComponent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.DefaultPreviewPane;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class PrintCompContainer
implements Initializable,
Disposable {
    private static final Logger logger = Logger.getLogger(PrintCompContainer.class);
    private PrintCompManager manager = new PrintCompManager();
    private BaseComponent baseComponent;
    private ContextOfPreview previewContext;
    protected PrinterAttrManager printerAttrMgr;
    private IPainter painter;
    private IHeaderFooterPainter hfPainter;

    public void initialize() throws IOException, ServiceException {
        if (this.baseComponent != null) {
            return;
        }
        SimpleLayout layout = new SimpleLayout();
        logger.setLevel(Level.OFF);
        this.previewContext = new ContextOfPreview();
        this.painter = new DefaultPainter();
        this.manager.put("BasePreviewContext", this.previewContext);
        this.manager.put("Painter", this.getPainter());
        ContainerUtil.service((Object)this.previewContext, (ServiceManager)this.manager);
        ContainerUtil.service((Object)this.getPainter(), (ServiceManager)this.manager);
    }

    public void dispose() {
    }

    public BaseComponent getBaseComponent() {
        if (this.baseComponent == null) {
            this.baseComponent = new BaseComponent(this);
            try {
                this.baseComponent.initialize();
                DefaultPreviewPane ppane = new DefaultPreviewPane(this.printerAttrMgr, this.painter, this.hfPainter, this.previewContext);
                this.baseComponent.setPreviewPane(ppane);
            }
            catch (ServiceException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return this.baseComponent;
    }

    public BaseComponent innerGetBaseComponent() {
        return this.baseComponent;
    }

    public void innerSetBaseComponent(BaseComponent bc) {
        this.baseComponent = bc;
    }

    public ContextOfPreview getPreviewContext() {
        return this.previewContext;
    }

    public void setPreviewContext(ContextOfPreview previewContext) {
        this.previewContext = previewContext;
    }

    public void setPrinterAttrmgr(PrinterAttrManager mgr) {
        this.printerAttrMgr = mgr;
    }

    public void setPainter(IPainter painter) {
        this.painter = painter;
        this.manager.put("Painter", painter);
    }

    public IPainter getPainter() {
        return this.painter;
    }

    public void setHeaderFooterPainter(IHeaderFooterPainter hfPainter, int hHeader, int hFooter) {
        this.hfPainter = hfPainter;
        this.manager.put("HeaderFooterPainter", hfPainter);
        if (this.baseComponent != null) {
            this.baseComponent.getPreviewPane().setHeaderFooterPainter(hfPainter);
        }
        this.getPrinterAttrManager().setHeaderMargin(hHeader * 72 / 254);
        this.getPrinterAttrManager().setFooterMargin(hFooter * 72 / 254);
    }

    public void setHeaderFooterPainter(IHeaderFooterPainter hfPainter, int hHeader, int hFooter, KDF kdf) {
        this.setHeaderFooterPainter(hfPainter, hHeader, hFooter);
    }

    public IHeaderFooterPainter getHeaderFooterPainter() {
        return this.hfPainter;
    }

    public PrinterAttrManager getPrinterAttrManager() {
        if (this.printerAttrMgr == null) {
            this.printerAttrMgr = new PrinterAttrManager();
            this.manager.put("PrinterAttrMgr", this.printerAttrMgr);
            try {
                ContainerUtil.service((Object)this.printerAttrMgr, (ServiceManager)this.manager);
            }
            catch (ServiceException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return this.printerAttrMgr;
    }

    public PrintCompManager getManager() {
        return this.manager;
    }

    public void clear() {
    }
}

