/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.printprovider.MyMediaSize;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintInfo;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintInfoParsingException;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintRequestAttrSetAdapter;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.cosmic.ctrl.kdf.printprovider.ScaleFactor;
import com.kingdee.cosmic.ctrl.kdf.printprovider.TextCoding;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.BodySizeChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.MediaSizeChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.OrientChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.PrintableAreaChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.PrinterAttributeListener;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobImpressions;
import javax.print.attribute.standard.JobKOctets;
import javax.print.attribute.standard.JobMediaSheets;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PresentationDirection;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class PrinterAttrManager
implements Cloneable {
    private static final Logger logger = LogUtil.getPackageLogger(PrinterAttrManager.class);
    public static boolean NotifyUserThatPrinterNotExist = true;
    public static String textCoding;
    private MyPRAttibuteSet myAttrSet;
    private PrintInfo myPrintInfo = new PrintInfo();
    private DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
    private PrintService[] myServices;
    private PrintService currentService = null;
    public float screenMapRatio = 1.0f;
    private boolean isDirty = true;
    private float header = 10.0f;
    private float footer = 10.0f;
    private int unit = 25400;
    private EventListenerList listenerList = null;
    public boolean disableSpy = false;
    public OrientationRequested orient = this.myPrintInfo.getOrientation().equalsIgnoreCase("PORTRAIT") ? OrientationRequested.PORTRAIT : (this.myPrintInfo.getOrientation().equalsIgnoreCase("LANDSCAPE") ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
    private MediaSize mediaSize;
    public MediaPrintableArea area;
    public PageRanges pageRanges;
    static final Attribute[] defaultRequestAttrs;

    public Object clone() {
        PrinterAttrManager newOne = null;
        try {
            newOne = (PrinterAttrManager)super.clone();
            newOne.myAttrSet = new MyPRAttibuteSet();
            if (this.myAttrSet != null) {
                Attribute[] atts = this.myAttrSet.toArray();
                for (int i = 0; i < atts.length; ++i) {
                    newOne.myAttrSet.attrset.add(atts[i]);
                }
            }
            if (this.myPrintInfo != null) {
                newOne.myPrintInfo = (PrintInfo)this.myPrintInfo.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return newOne;
    }

    private OrientationRequested String2Orient(String str) {
        OrientationRequested ori = null;
        ori = str.equalsIgnoreCase("PORTRAIT") ? OrientationRequested.PORTRAIT : (str.equalsIgnoreCase("LANDSCAPE") ? OrientationRequested.LANDSCAPE : OrientationRequested.PORTRAIT);
        return ori;
    }

    public MediaSize getMediaSize() {
        return this.mediaSize;
    }

    public PrintInfo getMyPrintInfo() {
        return this.myPrintInfo;
    }

    public void setMediaPrintableArea(MediaPrintableArea areaNew) {
        PrintableAreaChangedEvent event = new PrintableAreaChangedEvent(this, areaNew, this.area);
        this.area = areaNew;
        this.isDirty = true;
        this.firePrintableAreaChanged(event);
    }

    public MediaPrintableArea setMediaSize(MediaSize sizeNew) {
        float right = this.getRight();
        float bottom = this.getBottom();
        if (right < 0.0f) {
            right = (float)((double)this.myPrintInfo.getRightMargin() * 0.1 / 25.4 * (double)(72.0f * this.screenMapRatio));
        }
        if (bottom < 0.0f) {
            bottom = (float)((double)this.myPrintInfo.getBottomMargin() * 0.1 / 25.4 * (double)(72.0f * this.screenMapRatio));
        }
        MediaPrintableArea mpa = this.isPortrait() ? new MediaPrintableArea(this.area.getX(this.unit), this.area.getY(this.unit), sizeNew.getX(this.unit) - right / (72.0f * this.screenMapRatio) - this.area.getX(this.unit), sizeNew.getY(this.unit) - bottom / (72.0f * this.screenMapRatio) - this.area.getY(this.unit), this.unit) : new MediaPrintableArea(this.area.getX(this.unit), this.area.getY(this.unit), sizeNew.getY(this.unit) - right / (72.0f * this.screenMapRatio) - this.area.getX(this.unit), sizeNew.getX(this.unit) - bottom / (72.0f * this.screenMapRatio) - this.area.getY(this.unit), this.unit);
        this.setMediaPrintableArea(mpa);
        MediaSizeChangedEvent event = new MediaSizeChangedEvent(this, sizeNew, this.mediaSize);
        this.mediaSize = sizeNew;
        this.isDirty = true;
        this.fireMediaSizeChanged(event);
        return mpa;
    }

    public boolean isPortrait() {
        return this.orient.equals(OrientationRequested.PORTRAIT);
    }

    public void setOrient(OrientationRequested orient) {
        if (orient.equals(this.orient)) {
            return;
        }
        float right = this.getRight();
        float bottom = this.getBottom();
        MediaPrintableArea printable = !this.isPortrait() ? new MediaPrintableArea(this.area.getX(this.unit), this.area.getY(this.unit), (this.getPaperWidth() - right) / (72.0f * this.screenMapRatio) - this.area.getX(this.unit), (this.getPaperHeight() - bottom) / (72.0f * this.screenMapRatio) - this.area.getY(this.unit), this.unit) : new MediaPrintableArea(this.area.getX(this.unit), this.area.getY(this.unit), (this.getPaperHeight() - right) / (72.0f * this.screenMapRatio) - this.area.getX(this.unit), (this.getPaperWidth() - bottom) / (72.0f * this.screenMapRatio) - this.area.getY(this.unit), this.unit);
        OrientationRequested old = this.orient;
        this.orient = orient;
        OrientChangedEvent oce = new OrientChangedEvent(this, orient, old);
        this.setMediaPrintableArea(printable);
        this.fireOrientChanged(oce);
    }

    public void setHeaderMargin(int hh) {
        this.header = hh;
        this.myPrintInfo.headerMargin = (int)((float)(hh * 254) / (72.0f * this.screenMapRatio));
    }

    public void setFooterMargin(int fh) {
        this.footer = fh;
        this.myPrintInfo.footerMargin = (int)((float)(fh * 254) / (72.0f * this.screenMapRatio));
    }

    public int getHeaderPreferHeight() {
        return this.myPrintInfo.getHeaderPreferHeight();
    }

    public int getFooterPreferHeight() {
        return this.myPrintInfo.getFooterPreferHeight();
    }

    public float getBodyH() {
        return this.area.getHeight(this.unit) * (72.0f * this.screenMapRatio) / this.getScaleFactor();
    }

    public float getBodyW() {
        return this.area.getWidth(this.unit) * (72.0f * this.screenMapRatio) / this.getScaleFactor();
    }

    public float getBodyX() {
        return this.getLeft() / this.getScaleFactor();
    }

    public float getBodyY() {
        return this.getTop() / this.getScaleFactor();
    }

    public float getOriginBodyH() {
        return this.area.getHeight(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getOriginBodyW() {
        return this.area.getWidth(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getOriginBodyX() {
        return this.getLeft();
    }

    public float getOriginBodyY() {
        return this.getTop();
    }

    public void setBodyTopMargin(float y) {
        this.setMediaPrintableArea(new MediaPrintableArea(this.area.getX(1000), 0.1f * y, this.area.getWidth(1000), this.area.getHeight(1000) - (0.1f * y - this.area.getY(1000)), 1000));
    }

    public void setBodyBottomMargin(float bm) {
        this.setMediaPrintableArea(new MediaPrintableArea(this.area.getX(1000), this.area.getY(1000), this.area.getWidth(1000), this.mediaSize.getY(1000) - 0.1f * bm - this.area.getY(1000), 1000));
    }

    public float getHeaderMargin() {
        return this.header / this.getScaleFactor();
    }

    public float getFooterMargin() {
        return this.footer;
    }

    public PrinterAttrManager() {
        MediaSizeName msn = null;
        if (this.myPrintInfo.getNamedPaperSize() != null && (msn = PrintInfo.String2MediaSizeName(this.myPrintInfo.getNamedPaperSize())) != null) {
            this.mediaSize = MediaSize.getMediaSizeForName(msn);
        }
        if (this.myPrintInfo.getNamedPaperSize() == null || this.myPrintInfo.getNamedPaperSize() != null && msn == null) {
            this.mediaSize = new MediaSize(this.myPrintInfo.getCustomizePaperWidth(), this.myPrintInfo.getCustomizePaperHeight(), 1000);
        }
        double left = (double)this.myPrintInfo.getLeftMargin() * 0.1;
        double right = (double)this.myPrintInfo.getRightMargin() * 0.1;
        double top = (float)((double)this.myPrintInfo.getTopMargin() * 0.1);
        double bottom = (float)((double)this.myPrintInfo.getBottomMargin() * 0.1);
        this.area = new MediaPrintableArea((float)left, (float)top, (float)((double)this.mediaSize.getX(1000) - (right + left)), (float)((double)this.mediaSize.getY(1000) - (top + bottom)), 1000);
        this.pageRanges = new PageRanges(1, Integer.MAX_VALUE);
    }

    public PrintRequestAttributeSet getRequestAttrSet() {
        if (this.myAttrSet == null) {
            this.myAttrSet = new MyPRAttibuteSet();
            this.myAttrSet.attrset.add(this.area);
            if (this.mediaSize.getMediaSizeName() != null) {
                this.myAttrSet.attrset.add(this.mediaSize.getMediaSizeName());
            }
            this.myAttrSet.attrset.add(this.orient);
            this.myAttrSet.attrset.add(this.pageRanges);
        } else if (this.isDirty) {
            Attribute media;
            this.myAttrSet.attrset.add(this.area);
            if (this.mediaSize.getMediaSizeName() != null && !((media = this.myAttrSet.attrset.get(Media.class)) instanceof MediaTray)) {
                this.myAttrSet.attrset.add(this.mediaSize.getMediaSizeName());
            }
            this.myAttrSet.attrset.add(this.orient);
            this.myAttrSet.attrset.add(this.pageRanges);
            this.isDirty = false;
        }
        return this.myAttrSet;
    }

    public PrintService[] getPrintServices() throws PrinterNotFoundException {
        if (this.myServices == null) {
            this.myServices = PrintServiceLookup.lookupPrintServices(this.flavor, null);
            if (this.myServices.length == 0) {
                throw new PrinterNotFoundException();
            }
        }
        return this.myServices;
    }

    public PrintService getCurrentService() throws PrinterNotFoundException {
        if (this.currentService == null) {
            this.currentService = PrintServiceLookup.lookupDefaultPrintService();
            if (this.currentService == null) {
                throw new PrinterNotFoundException();
            }
        }
        return this.currentService;
    }

    public void setCurrentService(PrintService serv) {
        this.currentService = serv;
    }

    public float getPaperHeight() {
        if (this.orient == OrientationRequested.PORTRAIT) {
            return this.mediaSize.getY(this.unit) * (72.0f * this.screenMapRatio);
        }
        return this.mediaSize.getX(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getPaperWidth() {
        if (this.orient == OrientationRequested.PORTRAIT) {
            return this.mediaSize.getX(this.unit) * (72.0f * this.screenMapRatio);
        }
        return this.mediaSize.getY(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getLeft() {
        return this.area.getX(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getTop() {
        return this.area.getY(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getRight() {
        return (float)(((double)(this.orient == OrientationRequested.PORTRAIT ? this.mediaSize.getX(this.unit) : this.mediaSize.getY(this.unit)) - (double)this.area.getWidth(this.unit) - (double)this.area.getX(this.unit)) * (double)(72.0f * this.screenMapRatio));
    }

    public float getBottom() {
        return (float)(((double)(this.orient == OrientationRequested.PORTRAIT ? this.mediaSize.getY(this.unit) : this.mediaSize.getX(this.unit)) - (double)this.area.getHeight(this.unit) - (double)this.area.getY(this.unit)) * (double)(72.0f * this.screenMapRatio));
    }

    public float getPrintableW() {
        if (this.orient == OrientationRequested.PORTRAIT) {
            return this.area.getWidth(this.unit) * (72.0f * this.screenMapRatio);
        }
        return this.area.getHeight(this.unit) * (72.0f * this.screenMapRatio);
    }

    public float getPrintableH() {
        if (this.orient == OrientationRequested.PORTRAIT) {
            return this.area.getHeight(this.unit) * (72.0f * this.screenMapRatio);
        }
        return this.area.getWidth(this.unit) * (72.0f * this.screenMapRatio);
    }

    public MediaSize getFitMediaSize(MediaSize ms) {
        if (this.currentService != null) {
            MediaSize msDefault = MediaSize.getMediaSizeForName((MediaSizeName)this.currentService.getDefaultAttributeValue(Media.class));
            if (ms.getX(1000) > msDefault.getX(1000) || ms.getY(1000) > msDefault.getY(1000)) {
                return msDefault;
            }
        }
        return ms;
    }

    public void restore(PrintInfo pi) throws PrintInfoParsingException, PrinterNotFoundException {
        MediaPrintableArea mpa;
        PrinterResolution r;
        this.myPrintInfo = pi;
        this.header = (float)this.myPrintInfo.getHeaderMargin() * (72.0f * this.screenMapRatio) / 254.0f;
        this.footer = (float)this.myPrintInfo.getFooterMargin() * (72.0f * this.screenMapRatio) / 254.0f;
        AttributeSet asNew = this.myPrintInfo.getAttrSet();
        if (asNew == null) {
            asNew = new HashPrintRequestAttributeSet();
        }
        if ((r = (PrinterResolution)this.getCurrentService().getDefaultAttributeValue(PrinterResolution.class)) != null) {
            asNew.add(r);
        }
        if ((mpa = this.myPrintInfo.getMediaPrintableArea(this.getCurrentService())) != null) {
            asNew.add(mpa);
            this.area = mpa;
        }
        if (this.myPrintInfo.isCustomizedPaperSize()) {
            MediaSize ms;
            int cpHeight = this.myPrintInfo.customizePaperHeight;
            int cpWidth = this.myPrintInfo.customizePaperWidth;
            MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)this.currentService.getDefaultAttributeValue(Media.class));
            if (cpHeight == -1) {
                cpHeight = (int)mediaSize.getY(1000) * 10;
            }
            if (cpWidth == -1) {
                cpWidth = (int)mediaSize.getX(1000) * 10;
            }
            if (cpWidth > cpHeight) {
                ms = new MediaSize(cpHeight / 10, cpWidth / 10, 1000);
                this.mediaSize = OrientationRequested.LANDSCAPE.equals(this.orient) ? ms : new MyMediaSize(cpWidth / 10, cpHeight / 10, 1000);
                this.setOrient(OrientationRequested.LANDSCAPE);
            } else {
                ms = new MediaSize(cpWidth / 10, cpHeight / 10, 1000);
                this.setOrient(OrientationRequested.PORTRAIT);
            }
            ms = this.getFitMediaSize(ms);
            asNew.add(this.orient);
            asNew.add(this.setMediaSize(ms));
        } else {
            MediaSizeName msn;
            if (this.myPrintInfo.getNamedPaperSize() != null && (msn = PrintInfo.String2MediaSizeName(this.myPrintInfo.getNamedPaperSize())) != null) {
                asNew.add(msn);
            }
            if (this.myPrintInfo.getOrientation() != null) {
                OrientationRequested oOld = this.orient;
                this.orient = this.String2Orient(this.myPrintInfo.getOrientation());
                this.fireOrientChanged(new OrientChangedEvent(this, this.orient, oOld));
                asNew.add(this.orient);
            }
        }
        this.getRequestAttrSet().addAll(asNew);
    }

    public void store(PrintInfo pi) {
        AttributeSet asNew = pi.getAttrSet();
        asNew.add(this.area);
        pi.setLeftMargin((int)(this.getLeft() * 254.0f / (72.0f * this.screenMapRatio)));
        pi.setRightMargin((int)(this.getRight() * 254.0f / (72.0f * this.screenMapRatio)));
        pi.setTopMargin((int)(this.getTop() * 254.0f / (72.0f * this.screenMapRatio)));
        pi.setBottomMargin((int)(this.getBottom() * 254.0f / (72.0f * this.screenMapRatio)));
        pi.setHeaderMargin((int)(this.getHeaderMargin() * 254.0f / (72.0f * this.screenMapRatio)));
        pi.setFooterMargin((int)(this.getFooterMargin() * 254.0f / (72.0f * this.screenMapRatio)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrinterAttrManager : \r\n\t media printable area :" + this.area + "\r\n\t media size " + this.mediaSize);
        return sb.toString();
    }

    public void addPrinterAttributeListener(PrinterAttributeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PrinterAttributeListener.class, listener);
    }

    public synchronized void removePrinterAttributeListener(PrinterAttributeListener listener) {
        this.listenerList.remove(PrinterAttributeListener.class, listener);
    }

    public void firePrintableAreaChanged(PrintableAreaChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PrinterAttributeListener.class) continue;
            ((PrinterAttributeListener)listeners[i + 1]).PrintableAreaChange(event);
        }
    }

    private void fireBodySizeChanged(BodySizeChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PrinterAttributeListener.class) continue;
            ((PrinterAttributeListener)listeners[i + 1]).BodySizeChanged(event);
        }
    }

    private void fireMediaSizeChanged(MediaSizeChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PrinterAttributeListener.class) continue;
            ((PrinterAttributeListener)listeners[i + 1]).MediaSizeChanged(event);
        }
        Rectangle rect = new Rectangle((int)this.getBodyX(), (int)this.getBodyY(), (int)this.getBodyW(), (int)this.getBodyH());
        this.fireBodySizeChanged(new BodySizeChangedEvent(this, rect));
    }

    private void fireOrientChanged(OrientChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PrinterAttributeListener.class) continue;
            ((PrinterAttributeListener)listeners[i + 1]).OrientChanged(event);
        }
    }

    public void setCurrentServiceByName(String name) {
        try {
            PrintService[] ps = this.getPrintServices();
            int posi = name.lastIndexOf(92);
            String suffix = name;
            if (posi > -1) {
                suffix = name.substring(posi);
            }
            for (int i = 0; i < ps.length; ++i) {
                String thename = ps[i].getName();
                if (!thename.equals(name) && !thename.endsWith(suffix)) continue;
                this.currentService = ps[i];
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCurrentServiceIndex() {
        PrintService[] ps;
        if (this.currentService == null) {
            return 0;
        }
        try {
            ps = this.getPrintServices();
        }
        catch (PrinterNotFoundException e) {
            return 0;
        }
        for (int i = 0; i < ps.length; ++i) {
            if (ps[i] != this.currentService) continue;
            return i;
        }
        return 0;
    }

    public float getScaleFactor() {
        PrintRequestAttributeSet attributes = this.getRequestAttrSet();
        ScaleFactor factor = (ScaleFactor)attributes.get(ScaleFactor.class);
        if (factor != null) {
            return factor.getFactor();
        }
        return 1.0f;
    }

    public String getTextCoding() {
        PrintRequestAttributeSet attributes = this.getRequestAttrSet();
        TextCoding coding = (TextCoding)attributes.get(TextCoding.class);
        if (coding != null) {
            return coding.getCoding();
        }
        return "AUTO";
    }

    static {
        defaultRequestAttrs = new Attribute[]{Chromaticity.MONOCHROME, new Copies(1), Finishings.NONE, new JobHoldUntil(new Date(0L)), new JobImpressions(1024), new JobKOctets(10240), new JobMediaSheets(100), new JobName("my printing", Locale.CHINA), new JobPriority(100), JobSheets.NONE, MultipleDocumentHandling.SINGLE_DOCUMENT, new NumberUp(1), OrientationRequested.PORTRAIT, new PageRanges(1, 50), PresentationDirection.TORIGHT_TOBOTTOM, new PrinterResolution(10000, 10000, 254), PrintQuality.NORMAL, new RequestingUserName(System.getProperty("user.name"), Locale.CHINA), SheetCollate.UNCOLLATED, Sides.ONE_SIDED};
    }

    class MyPRAttibuteSet
    extends PrintRequestAttrSetAdapter {
        MyPRAttibuteSet() {
        }

        @Override
        public boolean remove(Attribute att) {
            return super.remove(att);
        }

        @Override
        public boolean add(Attribute attribute) {
            if (!PrinterAttrManager.this.disableSpy) {
                if (attribute.getCategory() == OrientationRequested.class) {
                    PrinterAttrManager.this.setOrient((OrientationRequested)attribute);
                } else if (attribute.getCategory() == Media.class) {
                    if (attribute instanceof MediaSizeName) {
                        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)attribute);
                        PrinterAttrManager.this.setMediaSize(mediaSize);
                    }
                } else if (attribute.getCategory() == MediaPrintableArea.class) {
                    MediaPrintableArea areaNew = (MediaPrintableArea)attribute;
                    PrinterAttrManager.this.setMediaPrintableArea(areaNew);
                } else if (attribute.getCategory() == PageRanges.class) {
                    PrinterAttrManager.this.pageRanges = (PageRanges)attribute;
                }
            }
            return ((PrinterAttrManager)PrinterAttrManager.this).myAttrSet.attrset.add(attribute);
        }

        @Override
        public String toString() {
            return "setup:" + PrinterAttrManager.this.orient + ":" + PrinterAttrManager.this.mediaSize + "," + PrinterAttrManager.this.area;
        }

        @Override
        public boolean add2(Attribute attribute) {
            if (!PrinterAttrManager.this.disableSpy) {
                if (attribute.getCategory() == OrientationRequested.class) {
                    OrientationRequested old = PrinterAttrManager.this.orient;
                    PrinterAttrManager.this.orient = (OrientationRequested)attribute;
                    OrientChangedEvent oce = new OrientChangedEvent(this, PrinterAttrManager.this.orient, old);
                    PrinterAttrManager.this.fireOrientChanged(oce);
                } else if (attribute.getCategory() == Media.class) {
                    if (attribute instanceof MediaSizeName) {
                        MediaSize mediaSize2 = MediaSize.getMediaSizeForName((MediaSizeName)attribute);
                        PrinterAttrManager.this.mediaSize = mediaSize2;
                    }
                } else if (attribute.getCategory() == MediaPrintableArea.class) {
                    MediaPrintableArea areaNew = (MediaPrintableArea)attribute;
                    PrinterAttrManager.this.setMediaPrintableArea(areaNew);
                } else if (attribute.getCategory() == PageRanges.class) {
                    PrinterAttrManager.this.pageRanges = (PageRanges)attribute;
                }
                PrinterAttrManager.this.isDirty = true;
            }
            return ((PrinterAttrManager)PrinterAttrManager.this).myAttrSet.attrset.add(attribute);
        }

        @Override
        public boolean addAll(AttributeSet as) {
            boolean result = false;
            OrientationRequested or = (OrientationRequested)as.get(OrientationRequested.class);
            ScaleFactor sf = (ScaleFactor)as.get(ScaleFactor.class);
            if (sf != null) {
                result = this.add(sf) || result;
                as.remove(ScaleFactor.class);
            }
            Media size = (Media)as.get(Media.class);
            MediaPrintableArea mpa = (MediaPrintableArea)as.get(MediaPrintableArea.class);
            if (or != null) {
                if (or.equals(PrinterAttrManager.this.orient)) {
                    MediaSize ms = null;
                    if (size instanceof MediaSizeName) {
                        ms = MediaSize.getMediaSizeForName((MediaSizeName)size);
                    }
                    if (ms != null) {
                        float y;
                        float x = or.equals(OrientationRequested.PORTRAIT) ? ms.getX(1000) : ms.getY(1000);
                        float f = y = or.equals(OrientationRequested.LANDSCAPE) ? ms.getX(1000) : ms.getY(1000);
                        if (or.equals(OrientationRequested.LANDSCAPE) && mpa.getWidth(1000) < mpa.getHeight(1000)) {
                            result = this.add(new MediaPrintableArea(mpa.getX(1000), mpa.getY(1000), mpa.getWidth(1000) + x - y, mpa.getHeight(1000) - x + y, 1000)) || result;
                            as.remove(MediaPrintableArea.class);
                        }
                    }
                } else {
                    result = this.add(mpa) || result;
                    as.remove(mpa);
                    if (!or.equals(PrinterAttrManager.this.orient)) {
                        result = this.add(or) || result;
                    }
                }
                as.remove(OrientationRequested.class);
            }
            if (size != null) {
                result = this.add(size) || result;
                as.remove(Media.class);
            }
            Attribute[] attrs = as.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                result = this.add(attrs[i]) || result;
            }
            return result;
        }
    }
}

