/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs;

import com.kingdee.cosmic.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.print.ServiceDialog;

public class PrintConfigDialog2
extends KDDialog
implements ActionListener {
    private static final long serialVersionUID = -4073404562795790440L;
    private static final int PAGE_W = 423;
    private static final int TAB_W = 425;
    private static final int GAP = 10;
    private static final int SPACE = 3;
    public static final int CONFIG_COMPONENT_HEIGHT = 310;
    public static final int CONFIG_COMPONENT_WIDTH = 425;
    private ServiceDialog real;
    private KDTabbedPane tab;
    protected TabPage general;
    protected TabPage page;
    protected TabPage appr;
    protected KDButton okBtn;
    protected JButton _okBtn;

    public PrintConfigDialog2(Frame owner) {
        super(owner);
    }

    public PrintConfigDialog2(Dialog owner) {
        super(owner);
    }

    public void init(GraphicsConfiguration gc, int x, int y, PrintService[] services, int defaultIndex, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        this.spawnReal(gc, x, y, services, defaultIndex, flavor, attributes);
        this.initDialog();
    }

    private void initDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        if (this.real != null) {
            this.setTitle(this.real.getTitle());
        }
        KDTabbedPane tabPane = this.createTabbedPane();
        KDPanel appPane = this.createClosePanel();
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)tabPane);
        cp.add((Component)appPane);
        int tab_h = tabPane.getPreferredSize().height;
        int app_w = appPane.getPreferredSize().width;
        int app_h = appPane.getPreferredSize().height;
        int x = 10;
        int y = 10;
        tabPane.setBounds(x, y, 425, tab_h);
        appPane.setBounds(425 - app_w, y + tab_h + 10, app_w, appPane.getPreferredSize().height);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new CloseHandler());
        y = y + tab_h + 10 + app_h + 10;
        Dimension psize = new Dimension(445, y);
        cp.setPreferredSize(psize);
        this.pack();
        this.setResizable(false);
        this.tab = tabPane;
    }

    public KDTabbedPane getTabbedPane() {
        return this.tab;
    }

    private JTabbedPane getRealTabbedPane() {
        return (JTabbedPane)this.real.getContentPane().getComponent(0);
    }

    private void spawnReal(GraphicsConfiguration gc, int x, int y, PrintService[] services, int defaultIndex, DocFlavor flavor, PrintRequestAttributeSet attributes) {
    }

    protected KDTabbedPane createTabbedPane() {
        KDTabbedPane tabPane = new KDTabbedPane();
        this.general = new GeneralPane();
        this.page = new PageSetupPane();
        this.appr = new AppearancePane();
        tabPane.addTab(this.getRealTabbedPane().getTitleAt(0), (Component)((Object)this.general));
        tabPane.addTab(this.getRealTabbedPane().getTitleAt(1), (Component)((Object)this.page));
        tabPane.addTab(this.getRealTabbedPane().getTitleAt(2), (Component)((Object)this.appr));
        int w = this.max(this.general.getPreferredSize().width, this.page.getPreferredSize().width, this.appr.getPreferredSize().width);
        int h = this.max(this.general.getPreferredSize().height, this.page.getPreferredSize().height, this.appr.getPreferredSize().height);
        Dimension psize = new Dimension(w, h += 30);
        tabPane.setPreferredSize(psize);
        return tabPane;
    }

    private int max(int i, int j, int k) {
        if (i > j) {
            return i > k ? i : k;
        }
        return j > k ? j : k;
    }

    protected void commitPages() {
        this.general.commit();
        this.page.commit();
        this.appr.commit();
    }

    protected KDPanel createClosePanel() {
        KDPanel appPane = new KDPanel();
        JPanel _appPane = (JPanel)this.real.getContentPane().getComponent(1);
        JButton _ok = (JButton)_appPane.getComponent(0);
        JButton _cancel = (JButton)_appPane.getComponent(1);
        this.okBtn = new KDButton(_ok.getText());
        this.okBtn.setModel(_ok.getModel());
        KDButton cancelBtn = new KDButton(_cancel.getText());
        cancelBtn.setModel(_cancel.getModel());
        appPane.add((Component)this.okBtn);
        appPane.add((Component)cancelBtn);
        this.okBtn.addActionListener((ActionListener)this);
        cancelBtn.addActionListener((ActionListener)this);
        appPane.setLayout((LayoutManager)new FlowLayout(2, 3, 0));
        int w = this.okBtn.getPreferredSize().width + cancelBtn.getPreferredSize().width + 10;
        int h = cancelBtn.getPreferredSize().height;
        Dimension psize = new Dimension(w, h);
        appPane.setPreferredSize(psize);
        return appPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.commitPages();
            JPanel _appPane = (JPanel)this.real.getContentPane().getComponent(1);
            JButton _ok = (JButton)_appPane.getComponent(0);
            e = new ActionEvent(_ok, 1001, _ok.getActionCommand(), e.getWhen(), e.getModifiers());
            this.real.actionPerformed(e);
        }
        this.dispose();
    }

    private static Icon ICON(String key) {
        return (Icon)Resources.res.getObject(key);
    }

    private JComponent L(String t, JComponent c) {
        return new LinedLabel(t, c);
    }

    public PrintService getPrintService() {
        if (this.real != null) {
            return this.real.getPrintService();
        }
        return null;
    }

    public int getStatus() {
        if (this.real != null) {
            return this.real.getStatus();
        }
        return 2;
    }

    public PrintRequestAttributeSet getAttributes() {
        if (this.real != null) {
            return this.real.getAttributes();
        }
        return null;
    }

    private static class LinedLabel
    extends KDLabelContainer {
        private static final long serialVersionUID = -221589758251117690L;

        private LinedLabel(String labelText, JComponent editor) {
            super(LinedLabel.Normalize(labelText, editor), editor);
            if (!(editor instanceof JLabel)) {
                this.setBoundLabelUnderline(true);
            }
        }

        private static String Normalize(String realtext, JComponent editor) {
            if (!(editor instanceof JLabel)) {
                return realtext.replace('\uff1a', ' ') + "  ";
            }
            return realtext.replace('\uff1a', ':') + "  ";
        }
    }

    protected static class LineLayout
    implements LayoutManager {
        private static final int INSET_ADJUST = 4;
        public static final LineLayout LIGHTWEIGHT = new LineLayout();

        protected LineLayout() {
        }

        @Override
        public void layoutContainer(Container p) {
            JComponent child;
            JComponent parent = (JComponent)p;
            Insets insets = parent.getInsets();
            int temp = 0;
            int count = parent.getComponentCount();
            int w = parent.getWidth() - 20 - insets.left - insets.right + 4;
            int h = parent.getHeight() - 20 - insets.top - insets.bottom + 4;
            int y = insets.top - 4 + 10;
            for (int i = 0; i < count; ++i) {
                child = (JComponent)parent.getComponent(i);
                temp += child.getPreferredSize().height;
            }
            int space = 0;
            if (count <= 0) {
                return;
            }
            if (count == 1) {
                space = h - temp;
                y += space / 2;
            } else {
                space = (h - temp) / (count - 1);
                if (space > 3) {
                    space = (h - temp) / count;
                    y += space / 2;
                }
            }
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    y += space;
                }
                child = (JComponent)parent.getComponent(i);
                temp = child.getPreferredSize().height;
                child.setBounds(10 + insets.left - 2, y, w, temp);
                y += temp;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int count = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int h = insets.top + insets.bottom - 4;
            int w = 0;
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    h += 3;
                }
                Dimension psize = parent.getComponent(i).getPreferredSize();
                h += psize.height;
                w = w < psize.width ? psize.width : w;
            }
            return new Dimension(w += 20, h += 20);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private abstract class ServicePanel
    extends KDPanel {
        public ServicePanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
        }

        protected void setTitle(JComponent agent) {
            String str = ((TitledBorder)agent.getBorder()).getTitle();
            this.setBorder(new TitledBorder(str));
        }

        protected void setTitle(String title) {
            this.setBorder(new TitledBorder(title));
        }

        protected abstract JComponent getAgent();

        protected JComponent getAgent(int page, int section) {
            return (JComponent)((JComponent)PrintConfigDialog2.this.getRealTabbedPane().getComponent(page)).getComponent(section);
        }

        protected String getLabelText(JComponent agent, int index) {
            return ((JLabel)agent.getComponent(index)).getText();
        }

        protected JComponent getComponent(JComponent agent, int child) {
            return (JComponent)agent.getComponent(child);
        }

        protected JComponent getComponent(JComponent agent, int child, int childchild) {
            return (JComponent)((JComponent)agent.getComponent(child)).getComponent(childchild);
        }

        public abstract void update(boolean var1);
    }

    private static class FixedPanel
    extends JPanel {
        private static final long serialVersionUID = 3812691208262908287L;

        public FixedPanel() {
            this.setOpaque(false);
            this.setLayout(new FlowLayout(0, 3, 0));
        }
    }

    private abstract class TabPage
    extends KDPanel {
        public TabPage() {
            this.setLayout(null);
        }

        public abstract void commit();
    }

    private static class SizedFormattedTextField
    extends KDFormattedTextField {
        private static final long serialVersionUID = 783865497640855609L;
        private Dimension thisSize = null;

        private SizedFormattedTextField() {
        }

        public void setPreferredSize(Dimension size) {
            this.thisSize = size;
        }

        public Dimension getPreferredSize() {
            if (this.thisSize != null) {
                return this.thisSize;
            }
            return super.getPreferredSize();
        }
    }

    private static class IconRadioButton
    extends JPanel {
        private static final long serialVersionUID = -1691580872447017356L;

        public IconRadioButton(Icon icon, KDRadioButton radio) {
            JLabel label = new JLabel(icon);
            this.add(label);
            this.add((Component)radio);
            this.setOpaque(false);
            this.setLayout(new FlowLayout(0, 3, 0));
        }
    }

    private class JobAttrPane
    extends ServicePanel {
        private static final long serialVersionUID = 2463403320225385034L;
        KDTextField job;
        KDTextField usr;
        JComponent _agent = this.getAgent();

        public JobAttrPane() {
            JTextField _usr = (JTextField)this.getComponent(this._agent, 5);
            this.job = new KDTextField("Kingdee EAS Printing");
            this.usr = new KDTextField(_usr.getText());
            String str = this.getLabelText(this._agent, 2);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.job));
            str = this.getLabelText(this._agent, 4);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.usr));
            this.setTitle(this._agent);
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(2, 3);
        }

        @Override
        public void update(boolean updateui) {
            JTextField _job = (JTextField)this.getComponent(this._agent, 3);
            JTextField _usr = (JTextField)this.getComponent(this._agent, 5);
            if (updateui) {
                this.job.setText(_job.getText());
                this.usr.setText(_usr.getText());
            } else {
                _job.setText(this.job.getText());
                _usr.setText(this.usr.getText());
            }
        }
    }

    private class SidesPane
    extends ServicePanel {
        private static final long serialVersionUID = -3824129404445165153L;

        public SidesPane() {
            JComponent _agent = this.getAgent();
            JRadioButton _radio_single = (JRadioButton)this.getComponent(_agent, 0, 1);
            JRadioButton _radio_tumble = (JRadioButton)this.getComponent(_agent, 1, 1);
            JRadioButton _radio_duplex = (JRadioButton)this.getComponent(_agent, 2, 1);
            KDRadioButton radio_single = new KDRadioButton(_radio_single.getText());
            KDRadioButton radio_tumble = new KDRadioButton(_radio_tumble.getText());
            KDRadioButton radio_duplex = new KDRadioButton(_radio_duplex.getText());
            radio_single.setModel(_radio_single.getModel());
            radio_tumble.setModel(_radio_tumble.getModel());
            radio_duplex.setModel(_radio_duplex.getModel());
            IconRadioButton single = new IconRadioButton(PrintConfigDialog2.ICON("dialog.appearance.oneside"), radio_single);
            IconRadioButton tumble = new IconRadioButton(PrintConfigDialog2.ICON("dialog.appearance.tumble"), radio_tumble);
            IconRadioButton duplex = new IconRadioButton(PrintConfigDialog2.ICON("dialog.appearance.duplex"), radio_duplex);
            this.add(single);
            this.add(tumble);
            this.add(duplex);
            KDButtonGroup group = new KDButtonGroup();
            group.add((AbstractButton)radio_single);
            group.add((AbstractButton)radio_tumble);
            group.add((AbstractButton)radio_duplex);
            this.setTitle(_agent);
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(2, 2);
        }

        @Override
        public void update(boolean updateui) {
        }
    }

    private class QualityPane
    extends ServicePanel {
        private static final long serialVersionUID = -7168176795993262536L;

        public QualityPane() {
            JComponent _agent = this.getAgent();
            JRadioButton _draft = (JRadioButton)this.getComponent(_agent, 0);
            JRadioButton _normal = (JRadioButton)this.getComponent(_agent, 1);
            JRadioButton _high = (JRadioButton)this.getComponent(_agent, 2);
            KDRadioButton draft = new KDRadioButton(_draft.getText());
            KDRadioButton normal = new KDRadioButton(_normal.getText());
            KDRadioButton high = new KDRadioButton(_high.getText());
            draft.setModel(_draft.getModel());
            normal.setModel(_normal.getModel());
            high.setModel(_high.getModel());
            this.add((Component)draft);
            this.add((Component)normal);
            this.add((Component)high);
            KDButtonGroup group = new KDButtonGroup();
            group.add((AbstractButton)draft);
            group.add((AbstractButton)normal);
            group.add((AbstractButton)high);
            this.setTitle(_agent);
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(2, 1);
        }

        @Override
        public void update(boolean updateui) {
        }
    }

    private class ChromaticityPane
    extends ServicePanel {
        private static final long serialVersionUID = 7350628174089272199L;

        public ChromaticityPane() {
            JComponent _agent = this.getAgent();
            JRadioButton _mono = (JRadioButton)this.getComponent(_agent, 0);
            JRadioButton _color = (JRadioButton)this.getComponent(_agent, 1);
            KDRadioButton monochrome = new KDRadioButton(_mono.getText());
            KDRadioButton color = new KDRadioButton(_color.getText());
            monochrome.setModel(_mono.getModel());
            color.setModel(_color.getModel());
            this.add((Component)monochrome);
            this.add((Component)color);
            KDButtonGroup group = new KDButtonGroup();
            group.add((AbstractButton)monochrome);
            group.add((AbstractButton)color);
            this.setTitle(_agent);
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(2, 0);
        }

        @Override
        public void update(boolean updateui) {
        }
    }

    private class AppearancePane
    extends TabPage {
        private static final long serialVersionUID = -1726205435286795631L;
        JobAttrPane jobAttrPane;

        public AppearancePane() {
            ChromaticityPane chromaticityPane = new ChromaticityPane();
            QualityPane qualityPane = new QualityPane();
            SidesPane sidesPane = new SidesPane();
            this.jobAttrPane = new JobAttrPane();
            this.add((Component)((Object)chromaticityPane));
            this.add((Component)((Object)qualityPane));
            this.add((Component)((Object)sidesPane));
            this.add((Component)((Object)this.jobAttrPane));
            int x = 10;
            int y = 10;
            int w = 182;
            Dimension bound = qualityPane.getPreferredSize();
            chromaticityPane.setBounds(x, y, w, bound.height);
            qualityPane.setBounds(x + w + 10, y, 423 - w - 30, bound.height);
            y = y + bound.height + 10;
            bound = sidesPane.getPreferredSize();
            sidesPane.setBounds(x, y, w, bound.height);
            this.jobAttrPane.setBounds(x + w + 10, y, 423 - w - 30, bound.height);
            int h = y + bound.height + 10;
            bound.setSize(423, h);
            this.setPreferredSize(bound);
        }

        @Override
        public void commit() {
            this.jobAttrPane.update(false);
        }
    }

    private class MarginPane
    extends ServicePanel {
        private static final long serialVersionUID = 6883373477486234676L;
        KDFormattedTextField left;
        KDFormattedTextField right;
        KDFormattedTextField top;
        KDFormattedTextField bottom;
        JComponent _agent = this.getAgent();

        public MarginPane() {
            this.left = this.createFormattedTextField();
            this.right = this.createFormattedTextField();
            this.top = this.createFormattedTextField();
            this.bottom = this.createFormattedTextField();
            String str = this.getLabelText(this._agent, 0);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.left));
            str = this.getLabelText(this._agent, 1);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.right));
            str = this.getLabelText(this._agent, 5);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.top));
            str = this.getLabelText(this._agent, 6);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.bottom));
            this.setTitle(this._agent);
            this.update(true);
        }

        protected KDFormattedTextField createFormattedTextField() {
            KDFormattedTextField ftf = new KDFormattedTextField();
            ftf.setDataType(1);
            ftf.setPrecision(1);
            return ftf;
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(1, 2);
        }

        @Override
        public void update(boolean updateui) {
            JFormattedTextField _left = (JFormattedTextField)this._agent.getComponent(2);
            JFormattedTextField _right = (JFormattedTextField)this._agent.getComponent(3);
            JFormattedTextField _top = (JFormattedTextField)this._agent.getComponent(7);
            JFormattedTextField _bottom = (JFormattedTextField)this._agent.getComponent(8);
            if (updateui) {
                this.left.setValue(_left.getValue());
                this.right.setValue(_right.getValue());
                this.top.setValue(_top.getValue());
                this.bottom.setValue(_bottom.getValue());
            } else {
                _left.setValue(this.left.getNumberValue());
                _right.setValue(this.right.getNumberValue());
                _top.setValue(this.top.getNumberValue());
                _bottom.setValue(this.bottom.getNumberValue());
            }
        }
    }

    private class OrientPane
    extends ServicePanel {
        private static final long serialVersionUID = 5463175971070783626L;

        public OrientPane() {
            JComponent _agent = this.getAgent();
            JRadioButton _radio_v = (JRadioButton)this.getComponent(_agent, 0, 1);
            JRadioButton _radio_h = (JRadioButton)this.getComponent(_agent, 1, 1);
            KDRadioButton radio_v = new KDRadioButton(_radio_v.getText());
            radio_v.setModel(_radio_v.getModel());
            KDRadioButton radio_h = new KDRadioButton(_radio_h.getText());
            radio_h.setModel(_radio_h.getModel());
            IconRadioButton vertical = new IconRadioButton(PrintConfigDialog2.ICON("dialog.pagesetup.vertical"), radio_v);
            IconRadioButton horizontal = new IconRadioButton(PrintConfigDialog2.ICON("dialog.pagesetup.horizontal"), radio_h);
            this.add(vertical);
            this.add(horizontal);
            KDButtonGroup group = new KDButtonGroup();
            group.add((AbstractButton)radio_v);
            group.add((AbstractButton)radio_h);
            this.setTitle(_agent);
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(1, 1);
        }

        @Override
        public void update(boolean updateui) {
        }
    }

    private class MediaPane
    extends ServicePanel {
        private static final long serialVersionUID = -3941459160455940557L;

        public MediaPane() {
            JComponent _agent = this.getAgent();
            KDComboBox size = new KDComboBox();
            JComboBox _size = (JComboBox)_agent.getComponent(1);
            size.setModel(_size.getModel());
            KDComboBox origin = new KDComboBox();
            JComboBox _origin = (JComboBox)_agent.getComponent(3);
            origin.setModel(_origin.getModel());
            String str = this.getLabelText(_agent, 0);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)size));
            str = this.getLabelText(_agent, 2);
            this.add(PrintConfigDialog2.this.L(str, (JComponent)origin));
            this.setTitle(Resources.LOCAL_STR("PrintSetup.media.title", ((TitledBorder)_agent.getBorder()).getTitle()));
        }

        @Override
        protected JComponent getAgent() {
            return this.getAgent(1, 0);
        }

        @Override
        public void update(boolean updateui) {
        }
    }

    private class PageSetupPane
    extends TabPage {
        private static final long serialVersionUID = -1690253109978076780L;
        MarginPane marginPane;

        public PageSetupPane() {
            MediaPane mediaPane = new MediaPane();
            OrientPane orientPane = new OrientPane();
            this.marginPane = new MarginPane();
            this.add((Component)((Object)mediaPane));
            this.add((Component)((Object)orientPane));
            this.add((Component)((Object)this.marginPane));
            int x = 10;
            int y = 10;
            int w = 180;
            int h = this.marginPane.getPreferredSize().height;
            Dimension size = mediaPane.getPreferredSize();
            mediaPane.setBounds(x, y, 403, size.height);
            y = y + size.height + 10;
            orientPane.setBounds(x, y, w, h);
            this.marginPane.setBounds(x + w + 10, y, 423 - w - 30, h);
            h = y + h + 10;
            size.setSize(423, h);
            this.setPreferredSize(size);
        }

        @Override
        public void commit() {
            this.marginPane.update(false);
        }
    }

    private class CopiesPane
    extends ServicePanel
    implements ChangeListener {
        private static final long serialVersionUID = -6282422589193852196L;
        JComponent _agent = this.getAgent();
        KDSpinner copies = new KDSpinner();

        public CopiesPane() {
            String str = ((JLabel)this._agent.getComponent(0)).getText();
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.copies));
            this.setTitle(this._agent);
            this.update(true);
            this.copies.addChangeListener((ChangeListener)this);
        }

        @Override
        protected JComponent getAgent() {
            return (JComponent)((JComponent)PrintConfigDialog2.this.getRealTabbedPane().getComponent(0)).getComponent(2);
        }

        @Override
        public void update(boolean updateui) {
            JSpinner _copies = (JSpinner)this._agent.getComponent(1);
            if (updateui) {
                this.copies.setValue(_copies.getValue());
            } else {
                _copies.setValue(this.copies.getValue());
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update(false);
        }
    }

    private class PrintRangePane
    extends ServicePanel
    implements ActionListener {
        private static final long serialVersionUID = 1026288373153587056L;
        JComponent _agent = this.getAgent();
        KDRadioButton printAll;
        KDRadioButton pageRange;
        KDFormattedTextField from;
        KDFormattedTextField to;
        KDLabel labelTo;

        public PrintRangePane() {
            JRadioButton _printAll = (JRadioButton)this.getComponent(this._agent, 0, 0);
            JRadioButton _pageRange = (JRadioButton)this.getComponent(this._agent, 1, 0);
            JLabel _tolabel = (JLabel)this.getComponent(this._agent, 1, 2);
            this.printAll = new KDRadioButton();
            this.printAll.setModel(_printAll.getModel());
            this.printAll.setText(_printAll.getText());
            this.pageRange = new KDRadioButton();
            this.pageRange.setModel(_pageRange.getModel());
            this.pageRange.setText(_pageRange.getText());
            this.from = new SizedFormattedTextField();
            this.to = new SizedFormattedTextField();
            Dimension tfsize = new Dimension(44, this.from.getPreferredSize().height);
            this.from.setPreferredSize(tfsize);
            this.to.setPreferredSize(tfsize);
            String str = _tolabel.getText();
            this.labelTo = new KDLabel(str);
            KDButtonGroup group = new KDButtonGroup();
            group.add((AbstractButton)this.printAll);
            group.add((AbstractButton)this.pageRange);
            FixedPanel p0 = new FixedPanel();
            FixedPanel p1 = new FixedPanel();
            p0.add((Component)this.printAll);
            p1.add((Component)this.pageRange);
            p1.add((Component)this.from);
            p1.add((Component)this.labelTo);
            p1.add((Component)this.to);
            this.add(p0);
            this.add(p1);
            this.setTitle(this._agent);
            this.update(true);
            this.printAll.addActionListener((ActionListener)this);
            this.pageRange.addActionListener((ActionListener)this);
        }

        @Override
        protected JComponent getAgent() {
            return (JComponent)((JComponent)PrintConfigDialog2.this.getRealTabbedPane().getComponent(0)).getComponent(1);
        }

        @Override
        public void update(boolean updateui) {
            JFormattedTextField _from = (JFormattedTextField)this.getComponent(this._agent, 1, 1);
            JFormattedTextField _to = (JFormattedTextField)this.getComponent(this._agent, 1, 3);
            if (updateui) {
                if (this.pageRange.isSelected()) {
                    this.from.setEnabled(true);
                    this.to.setEnabled(true);
                    this.labelTo.setEnabled(true);
                    this.from.setValue(_from.getValue());
                    this.to.setValue(_to.getValue());
                } else {
                    this.from.setEnabled(false);
                    this.to.setEnabled(false);
                    this.labelTo.setEnabled(false);
                }
            } else if (this.pageRange.isSelected()) {
                _from.setValue(this.from.getNumberValue());
                _to.setValue(this.to.getNumberValue());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update(true);
        }
    }

    private class PrintServicePane
    extends ServicePanel
    implements ActionListener {
        private static final long serialVersionUID = 781666454055368808L;
        KDLabel status;
        KDLabel type;
        KDLabel info;
        JComponent _agent = this.getAgent();

        public PrintServicePane() {
            KDComboBox combo = new KDComboBox();
            String str = ((JLabel)this._agent.getComponent(0)).getText();
            this.add(PrintConfigDialog2.this.L(str, (JComponent)combo));
            JComboBox _combo = (JComboBox)this._agent.getComponent(1);
            combo.setModel(_combo.getModel());
            this.status = new KDLabel();
            str = ((JLabel)this._agent.getComponent(3)).getText();
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.status));
            str = ((JLabel)this._agent.getComponent(4)).getText();
            this.status.setText(str);
            this.type = new KDLabel();
            str = ((JLabel)this._agent.getComponent(5)).getText();
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.type));
            str = ((JLabel)this._agent.getComponent(6)).getText();
            this.type.setText(str);
            this.info = new KDLabel();
            str = ((JLabel)this._agent.getComponent(7)).getText();
            this.add(PrintConfigDialog2.this.L(str, (JComponent)this.info));
            str = ((JLabel)this._agent.getComponent(8)).getText();
            this.info.setText(str);
            this.setTitle(this._agent);
            combo.addActionListener((ActionListener)this);
        }

        @Override
        protected JComponent getAgent() {
            return (JComponent)((JComponent)PrintConfigDialog2.this.getRealTabbedPane().getComponent(0)).getComponent(0);
        }

        @Override
        public void update(boolean updateui) {
            if (updateui) {
                String str = ((JLabel)this._agent.getComponent(4)).getText();
                this.status.setText(str);
                str = ((JLabel)this._agent.getComponent(6)).getText();
                this.type.setText(str);
                str = ((JLabel)this._agent.getComponent(8)).getText();
                this.info.setText(str);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update(true);
        }
    }

    private class GeneralPane
    extends TabPage {
        private static final long serialVersionUID = -7662091928262777916L;
        PrintRangePane printRangePane;

        public GeneralPane() {
            PrintServicePane printServicePane = new PrintServicePane();
            this.printRangePane = new PrintRangePane();
            CopiesPane copiesPane = new CopiesPane();
            this.add((Component)((Object)printServicePane));
            this.add((Component)((Object)this.printRangePane));
            this.add((Component)((Object)copiesPane));
            int x = 10;
            int y = 10;
            int h = printServicePane.getPreferredSize().height;
            int w = 403;
            printServicePane.setBounds(x, y, w, h);
            y = y + h + 10;
            this.printRangePane.setBounds(x, y, 222, 86);
            copiesPane.setBounds(x + 222 + 10, y, w - 222 - 10, 86);
        }

        @Override
        public void commit() {
            this.printRangePane.update(false);
        }
    }

    private static class CloseHandler
    extends WindowAdapter {
        private CloseHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }
    }
}

