/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.kdpsetup;

import com.kingdee.cosmic.ctrl.common.LanguageManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLayout;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PageRanges;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SetupPane1
extends KDPanel {
    private static final long serialVersionUID = -4495953470993817247L;
    DocFlavor docFlavor;
    PrintRequestAttributeSet defAttrSet;
    KDComboBox cbServiceName = new KDComboBox();
    KDLabel lService = new KDLabel(SetupPane1.LOCAL_STR("Print Service", "Print Service"));
    KDLabel lMSize = new KDLabel(SetupPane1.LOCAL_STR("Media Size", "Media Size"));
    KDLabel lMSource = new KDLabel(SetupPane1.LOCAL_STR("Media Source", "Media Source"));
    KDComboBox cbMediaSize = new KDComboBox();
    KDComboBox cbMediaSource = new KDComboBox();
    KDSeparator sp1 = new KDSeparator();
    KDLabel lTo = new KDLabel(SetupPane1.LOCAL_STR("to", "to"));
    KDRadioButton rbAll = new KDRadioButton(SetupPane1.LOCAL_STR("All", "all"));
    KDRadioButton rbRange = new KDRadioButton(SetupPane1.LOCAL_STR("Range", "range"));
    ActionHandler actionHandler = new ActionHandler();
    PageRangeActionHandler pageRangeHandler = new PageRangeActionHandler();
    KDButtonGroup bgRange = new KDButtonGroup();
    KDFormattedTextField tfFrom;
    KDFormattedTextField tfTo;

    public SetupPane1(PrintService[] services, int defaultIndex, DocFlavor docFlavor, PrintRequestAttributeSet attributes) {
        this.bgRange.add((AbstractButton)this.rbAll);
        this.bgRange.add((AbstractButton)this.rbRange);
        this.tfFrom = new KDFormattedTextField(0);
        this.tfTo = new KDFormattedTextField(0);
        this.docFlavor = docFlavor;
        this.defAttrSet = attributes;
        this.initComponents();
        this.addActionHandler();
        this.update2UI(services, defaultIndex, docFlavor, attributes);
    }

    private static String LOCAL_STR(String key, String defaultVal) {
        return LanguageManager.getLangMessage((String)key, Resources.class, (String)defaultVal);
    }

    void initComponents() {
        this.setBackground(new Color(15000799));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 450, 340));
        this.setPreferredSize(new Dimension(350, 295));
        this.add((Component)this.cbServiceName);
        this.add((Component)this.lService);
        this.add((Component)this.sp1);
        this.add((Component)this.lMSize);
        this.add((Component)this.cbMediaSize);
        this.add((Component)this.cbMediaSource);
        this.add((Component)this.lMSource);
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(100, 25, 180, 21);
        cons.anchor = 5;
        this.cbServiceName.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(20, 25, 100, 21);
        cons.anchor = 5;
        this.lService.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(5, 80, 440, 2);
        cons.anchor = 13;
        this.sp1.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.sp1.setName("lll");
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(20, 105, 100, 21);
        cons.anchor = 5;
        this.lMSize.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(20, 135, 100, 21);
        cons.anchor = 5;
        this.lMSource.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(100, 105, 200, 21);
        cons.anchor = 5;
        this.cbMediaSize.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(100, 135, 200, 21);
        cons.anchor = 5;
        this.cbMediaSource.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        JPanel pRange = this.layoutPageRangePanel();
        this.add(pRange);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 175, 320, 100);
        cons.anchor = 5;
        pRange.putClientProperty("KDLayoutConstraints", cons);
    }

    JPanel layoutPageRangePanel() {
        KDPanel panel = new KDPanel();
        panel.setName(SetupPane1.LOCAL_STR("Page Range", "Page Range"));
        panel.setBackground(new Color(15000799));
        panel.setLayout((LayoutManager)new KDLayout());
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 300, 160));
        panel.setPreferredSize(new Dimension(300, 160));
        panel.setBorder((Border)BorderFactory.createTitledBorder(SetupPane1.LOCAL_STR("Page Range", "Page Range")));
        panel.add((Component)this.rbAll);
        panel.add((Component)this.rbAll);
        panel.add((Component)this.rbRange);
        panel.add((Component)this.tfFrom);
        panel.add((Component)this.tfTo);
        panel.add((Component)this.lTo);
        int ypos = 30;
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(20, ypos, 100, 21);
        cons.anchor = 5;
        this.rbAll.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(20, ypos + 30, 60, 21);
        cons.anchor = 5;
        this.rbRange.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(100, ypos + 30, 80, 21);
        cons.anchor = 5;
        this.tfFrom.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(220, ypos + 30, 80, 21);
        cons.anchor = 5;
        this.tfTo.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(190, ypos + 30, 40, 21);
        cons.anchor = 5;
        this.lTo.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        return panel;
    }

    void addActionHandler() {
        this.cbServiceName.addActionListener((ActionListener)this.actionHandler);
        this.cbMediaSize.addActionListener((ActionListener)this.actionHandler);
        this.cbMediaSource.addActionListener((ActionListener)this.actionHandler);
        this.rbAll.addActionListener((ActionListener)this.pageRangeHandler);
        this.rbRange.addActionListener((ActionListener)this.pageRangeHandler);
    }

    void update2UI(PrintService[] services, int defaultIndex, DocFlavor docFlavor, PrintRequestAttributeSet attributes) {
        this.cbServiceName.removeAllItems();
        this.cbServiceName.addItems((Object[])services);
        this.cbServiceName.setSelectedIndex(defaultIndex);
        this.updateMediaSize(services[defaultIndex], attributes);
        Object[] vals = (Object[])services[defaultIndex].getSupportedAttributeValues(PageRanges.class, docFlavor, attributes);
        if (new PageRanges(1, Integer.MAX_VALUE).equals(vals[0])) {
            this.rbAll.setSelected(true);
        } else {
            this.rbRange.setSelected(true);
            PageRanges pr = (PageRanges)vals[0];
            int[] firstRange = pr.getMembers()[0];
            this.tfFrom.setText(Integer.toString(firstRange[0]));
            this.tfTo.setText(Integer.toString(firstRange[1]));
        }
    }

    void updateMediaSize(PrintService service, PrintRequestAttributeSet defaultAttrs) {
        this.cbMediaSize.removeAllItems();
        this.cbMediaSource.removeAllItems();
        Object[] medias = (Object[])service.getSupportedAttributeValues(Media.class, this.docFlavor, defaultAttrs);
        for (int i = 0; i < medias.length; ++i) {
            if (medias[i] instanceof MediaSizeName) {
                this.cbMediaSize.addItem(medias[i]);
                continue;
            }
            if (!(medias[i] instanceof MediaTray)) continue;
            this.cbMediaSource.addItem(medias[i]);
        }
        Attribute attr = defaultAttrs.get(Media.class);
        this.cbMediaSize.setSelectedItem((Object)attr);
    }

    public PrintService getPrintService() {
        return (PrintService)this.cbServiceName.getSelectedItem();
    }

    public MediaSizeName getMediaSizeName() {
        return (MediaSizeName)this.cbMediaSize.getSelectedItem();
    }

    public PageRanges getPageRanges() {
        if (this.tfFrom.isEnabled()) {
            int from = Integer.parseInt(this.tfFrom.getText());
            int to = Integer.parseInt(this.tfTo.getText());
            return new PageRanges(from, to);
        }
        return new PageRanges(1, Integer.MAX_VALUE);
    }

    class PageRangeActionHandler
    implements ActionListener {
        PageRangeActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SetupPane1.this.rbAll) {
                SetupPane1.this.tfFrom.setEditable(false);
                SetupPane1.this.tfTo.setEditable(false);
            } else if (e.getSource() == SetupPane1.this.rbRange) {
                SetupPane1.this.tfFrom.setEditable(true);
                SetupPane1.this.tfTo.setEditable(true);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SetupPane1.this.cbServiceName) {
                SetupPane1.this.updateMediaSize((PrintService)SetupPane1.this.cbServiceName.getSelectedItem(), SetupPane1.this.defAttrSet);
            }
        }
    }
}

