/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.gui;

import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions.ExitAction;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.actions.OpenKDFAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.ActionInitializer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.CompositableAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.DoPrintAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.DoSetupPrintAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.GotoFirstPageAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.GotoLastPageAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.GotoNextPageAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.GotoPreviousPageAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.InitializableAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.StartMarginAdjustAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.ViewMultiPageAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.ZoomInAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.actions.ZoomOutAction;
import com.kingdee.cosmic.ctrl.kdf.printprovider.conf.ConfManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.conf.PrintProviderConfig;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.ContextEventListener;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.events.context.UpdateViewEvent;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.AbstractPreviewPane;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.StatusBar;
import com.kingdee.cosmic.ctrl.kdf.printprovider.gui.toolband.DefaultToolband;
import com.kingdee.cosmic.ctrl.kdf.printprovider.util.FloatingButtonEnabler;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDToggleButton;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.AncestorAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.log4j.Logger;

public class BaseComponent
extends JComponent {
    private static final Logger logger = LogUtil.getLogger(BaseComponent.class);
    private static final long serialVersionUID = -4614885496251589920L;
    private ConfManager confmgr;
    private AbstractPreviewPane previewPane;
    public static final float rate2screen = 2.8346457f;
    public static final float rate2printer = 0.35277778f;
    static final String BASE_RESOURCE_CLASS = "resources";
    public static final ResourceBundle resources = ResourceBundle.getBundle("resources");
    private StatusBar stausbar;
    private ToolBarManager toolbarmgr;
    private Accelerator accelerator;
    private PrintCompContainer coreContainer;
    private JPanel previewPaneHolder;
    private ActionInitializer actionInitializer;
    private DefaultToolband toolband;
    public JScrollPane scrollPane;
    public ArrayList compActions = new ArrayList();

    public BaseComponent(PrintCompContainer container) {
        this.coreContainer = container;
        this.previewPaneHolder = new JPanel();
    }

    public void setPreviewPane(AbstractPreviewPane ppane) {
        if (this.previewPane != null) {
            this.previewPaneHolder.remove(this.previewPane);
        }
        this.addComponentListener(ppane.getComponentListener());
        this.previewPaneHolder.add((Component)ppane, "Center");
        this.previewPane = ppane;
        this.addAncestorListener((AncestorListener)new AncestorAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                BaseComponent.this.previewPane.getContext().addContextEventListener(BaseComponent.this.toolbarmgr);
            }

            public void ancestorRemoved(AncestorEvent event) {
                BaseComponent.this.previewPane.getContext().removeContextEventListener(BaseComponent.this.toolbarmgr);
            }
        });
    }

    public AbstractPreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public ArrayList getCompositeActions() {
        return this.compActions;
    }

    private void createAccelerator() {
        this.accelerator = new Accelerator();
        this.addKeyListener(this.accelerator);
    }

    private void createToolBand() {
        this.toolbarmgr = new ToolBarManager();
        this.toolband = new DefaultToolband();
        JToolBar toolbar = this.toolbarmgr.createToolbar(null);
        JToolBar[] bars = this.toolbarmgr.createToolbars();
        JToolBar exitbar = this.toolbarmgr.createExitToolbar();
        TableLayout lay = TableLayout.splitCol((int)(bars.length + 2));
        lay.defaultStyle().setPriX(0);
        lay.cell(bars.length + 1).style().setPriX(1);
        this.toolband.setLayout((LayoutManager)lay);
        this.toolband.add(toolbar, lay.cell(0));
        for (int i = 0; i < bars.length; ++i) {
            this.toolband.add(bars[i], lay.cell(i + 1));
        }
        this.toolband.add(exitbar, lay.cell(bars.length + 1));
        this.add((Component)((Object)this.toolband), "North");
    }

    public void initialize() throws ServiceException {
        this.confmgr = ConfManager.getDefaultInstance();
        this.setLayout(new BorderLayout());
        this.createAccelerator();
        this.createToolBand();
        this.previewPaneHolder.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.previewPaneHolder, 20, 30);
        this.add((Component)this.scrollPane, "Center");
        this.stausbar = new StatusBar();
        this.add((Component)this.stausbar.getStatusPane(), "South");
        this.coreContainer.getPreviewContext().addContextEventListener(new StatusBarSyncer());
    }

    public JPanel getPreviewPaneHolder() {
        return this.previewPaneHolder;
    }

    public StatusBar getStausbar() {
        return this.stausbar;
    }

    public void setActionInitializer(ActionInitializer ai) {
        this.actionInitializer = ai;
        ArrayList btns = this.getToolbarManager().getManagedButtons();
        for (Object obj : btns) {
            if (!(obj instanceof AbstractButton) || !(((AbstractButton)obj).getAction() instanceof InitializableAction)) continue;
            this.actionInitializer.initializeObject((InitializableAction)((Object)((AbstractButton)obj).getAction()));
        }
    }

    public ToolBarManager getToolbarManager() {
        return this.toolbarmgr;
    }

    public DefaultToolband getToolband() {
        return this.toolband;
    }

    private static class Accelerator
    extends KeyAdapter {
        private Map actions = null;

        private Accelerator() {
        }

        public void addAccelerator(Object mnemonic, AbstractButton a) {
            if (this.actions == null) {
                this.actions = new HashMap();
            }
            this.actions.put(mnemonic, a);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            AbstractButton a;
            if ((e.isAltDown() || e.getKeyCode() == 27) && (a = (AbstractButton)this.actions.get(e.getKeyCode())) != null && a.isEnabled()) {
                ActionEvent evt = new ActionEvent(a, 0, null);
                a.getAction().actionPerformed(evt);
            }
        }
    }

    private class StatusBarSyncer
    implements ContextEventListener {
        private UIStateChangedEvent preState = new UIStateChangedEvent(null, 0);

        private StatusBarSyncer() {
        }

        @Override
        public void currentPageChanged(CurrentPageChangedEvent event) {
            if (event.getOldPageIndex() != event.getNewPageIndex()) {
                BaseComponent.this.getStausbar().setStatusTip(resources.getString("tip.isReady"));
            }
            String totalPage = event.getContext().isDataIncomplete() ? "..." : "" + event.getContext().getTotalPageCount();
            BaseComponent.this.getStausbar().setLeftInfo(resources.getString("tip.the") + (event.getContext().getCurrentPage() + 1) + resources.getString("tip.page/total") + totalPage + resources.getString("tip.page"));
        }

        @Override
        public void uiStateChanged(UIStateChangedEvent event) {
            String totalPage;
            String string = totalPage = event.getContext().isDataIncomplete() ? "..." : "" + event.getContext().getTotalPageCount();
            if (event.getState() == 1) {
                BaseComponent.this.getStausbar().setStatusTip(resources.getString("tip.isloading"));
                BaseComponent.this.getStausbar().setLeftInfo(resources.getString("tip.the") + (event.getContext().getCurrentPage() + 1) + resources.getString("tip.page/isload") + totalPage + resources.getString("tip.page"));
            } else if (event.getState() == 0) {
                if (this.preState.getState() == 1) {
                    BaseComponent.this.getStausbar().setStatusTip(resources.getString("tip.loadsucceed"));
                }
                BaseComponent.this.getStausbar().setLeftInfo(resources.getString("tip.the") + (event.getContext().getCurrentPage() + 1) + resources.getString("tip.page/total") + totalPage + resources.getString("tip.page"));
                if (this.preState.getState() == 1) {
                    BaseComponent.this.previewPane.doRepaint();
                }
            }
            this.preState = event;
        }

        @Override
        public void updateView(UpdateViewEvent e) {
        }
    }

    static class MenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 4547232535291321792L;
        Action parentAction;
        String cmdStr;

        public MenuAction(Action parentAction, String cmdStr) {
            this.parentAction = parentAction;
            this.cmdStr = cmdStr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parentAction.actionPerformed(new ActionEvent(this, 111, this.cmdStr));
        }
    }

    public class ToolBarManager
    implements ContextEventListener {
        FloatingButtonEnabler fbEnabler = new FloatingButtonEnabler();
        ArrayList theToolbars = new ArrayList();
        private HashMap buttonsOfType = new HashMap();
        private KDToolBar defaultToolbar;

        public JToolBar createToolbar(String catalog) {
            int i;
            PrintProviderConfig conf = BaseComponent.this.confmgr.getConf();
            Object[] actionNames = conf.getEnableActions();
            Component[] components = new Component[actionNames.length];
            for (i = 0; i < actionNames.length; ++i) {
                String clsname = actionNames[i].toString();
                components[i] = this.createButton(catalog, clsname);
            }
            this.defaultToolbar = new KDToolBar();
            this.defaultToolbar.setFloatable(true);
            this.defaultToolbar.setHasPoint(false);
            for (i = 0; i < components.length; ++i) {
                if (components[i] == null) continue;
                this.defaultToolbar.add(components[i]);
            }
            this.addManagedButton((JToolBar)this.defaultToolbar);
            return this.defaultToolbar;
        }

        public JToolBar createExitToolbar() {
            KDToolBar exitbar = new KDToolBar();
            ExitAction exitaction = new ExitAction();
            exitbar.add(this.createButton(null, exitaction));
            this.addManagedButton((JToolBar)exitbar);
            return exitbar;
        }

        private Component createButton(String catalog, String clsname) {
            try {
                AbstractAction action = (AbstractAction)Class.forName(clsname).newInstance();
                return this.createButton(catalog, action);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("\u627e\u4e0d\u5230\u914d\u7f6e\u7684\u6309\u952e\u7c7b:" + clsname + "\u8bf7\u4fee\u6539\u914d\u7f6e\u6587\u4ef6" + BaseComponent.this.confmgr.getConfigfile()));
            }
            catch (InstantiationException e) {
                logger.error((Object)("\u52a0\u8f7d\u914d\u7f6e\u7684\u6309\u952e\u7c7b:" + clsname + "\u5931\u8d25"));
            }
            catch (IllegalAccessException e) {
                logger.error((Object)("\u52a0\u8f7d\u914d\u7f6e\u7684\u6309\u952e\u7c7b:" + clsname + "\u5931\u8d25"));
            }
            return null;
        }

        private Component createButton(String catalog, Action action) {
            KDComboBox comp = null;
            action.putValue("Name", null);
            if (action instanceof CompositableAction) {
                ((CompositableAction)action).setCompContainer(BaseComponent.this.coreContainer);
                BaseComponent.this.compActions.add(action);
            }
            if (action instanceof InitializableAction && BaseComponent.this.actionInitializer != null) {
                BaseComponent.this.actionInitializer.initializeObject((InitializableAction)((Object)action));
            }
            Object cat = null;
            if (!(StringUtil.isEmptyString((String)catalog) || (cat = action.getValue("CATALOG")) != null && catalog.equalsIgnoreCase(cat.toString()))) {
                return null;
            }
            if ("COMBOBOX".equals(action.getValue("COMPONENT_TYPE"))) {
                ComboBoxModel model = (ComboBoxModel)action.getValue("COMBOXBOX_MODEL");
                KDComboBox cbx = new KDComboBox(model);
                cbx.setAction(action);
                cbx.setPreferredSize(new Dimension(90, cbx.getPreferredSize().height));
                cbx.setMaximumRowCount(13);
                cbx.setEditable(true);
                comp = cbx;
            } else {
                Icon icon = (Icon)action.getValue("ICON24");
                Object isToggle = action.getValue("ISTOGGLE");
                Object mnemonic = action.getValue("MnemonicKey");
                if (isToggle != null && ((Boolean)isToggle).booleanValue()) {
                    KDToggleButton button = new KDToggleButton(action);
                    button.setIcon(icon);
                    button.setMargin(new Insets(0, 0, 0, 0));
                    if (mnemonic != null) {
                        button.setMnemonic(((Integer)mnemonic).intValue());
                        BaseComponent.this.accelerator.addAccelerator(mnemonic, (AbstractButton)button);
                    }
                    this.fbEnabler.addButton((AbstractButton)button);
                    comp = button;
                } else {
                    KDWorkButton button = new KDWorkButton(action);
                    Object menuCommands = action.getValue("MENU_COMMANDS");
                    if (menuCommands != null) {
                        String[] cmds = ((String)menuCommands).split(";");
                        String actionName = "hah";
                        for (int i = 0; i < cmds.length; ++i) {
                            MenuAction act = new MenuAction(action, cmds[i]);
                            act.putValue("Name", actionName);
                            button.addAssistMenuItem((Action)act);
                        }
                    }
                    button.setIcon(icon);
                    this.fbEnabler.addButton((AbstractButton)button);
                    comp = button;
                }
            }
            Object isDefaultEnable = action.getValue("DEFAULT_ENABLE");
            if (isDefaultEnable != null) {
                comp.setEnabled((Boolean)isDefaultEnable);
            }
            return comp;
        }

        public JToolBar[] detachExtendToolbars() {
            JToolBar[] ret = new JToolBar[this.theToolbars.size()];
            for (int i = 0; i < this.theToolbars.size(); ++i) {
                JToolBar toolbar = (JToolBar)this.theToolbars.get(i);
                if (toolbar == this.defaultToolbar || toolbar.getParent() == null) continue;
                toolbar.getParent().remove(toolbar);
                ret[i] = toolbar;
            }
            return ret;
        }

        public JToolBar[] createToolbars() {
            this.theToolbars.clear();
            PrintProviderConfig conf = BaseComponent.this.confmgr.getConf();
            Object[] keys = conf.getToolbars().keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                KDToolBar tb = new KDToolBar();
                ArrayList btns = (ArrayList)conf.getToolbars().get(keys[i]);
                Iterator itr = btns.iterator();
                while (itr.hasNext()) {
                    String btnClsName = itr.next().toString();
                    Component comp = this.createButton(null, btnClsName);
                    if (comp == null) continue;
                    tb.add(comp);
                }
                this.theToolbars.add(tb);
                this.addManagedButton((JToolBar)tb);
            }
            JToolBar[] ret = new JToolBar[this.theToolbars.size()];
            this.theToolbars.toArray(ret);
            return ret;
        }

        public ArrayList getManagedButtons() {
            ArrayList result = new ArrayList();
            result.addAll(this.buttonsOfType.values());
            return result;
        }

        public Action getActionOf(Class cls) {
            Object button = this.buttonsOfType.get(cls);
            if (button instanceof AbstractButton) {
                return ((AbstractButton)button).getAction();
            }
            return null;
        }

        public void addActionToDefaultToolbar(Action action) {
            this.defaultToolbar.add(this.createButton(null, action));
        }

        private void addManagedButton(JToolBar toolbar) {
            Component[] comps = toolbar.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Action act;
                if (!(comps[i] instanceof AbstractButton) || (act = ((AbstractButton)comps[i]).getAction()) == null) continue;
                Class<?> type = act.getClass();
                this.buttonsOfType.put(type, comps[i]);
            }
        }

        @Override
        public void currentPageChanged(CurrentPageChangedEvent event) {
            this.updateView(event.getContext().getTheUpdateViewEvent());
        }

        public void disableButtonsExceptOpen() {
            for (Object btn : this.buttonsOfType.values()) {
                if (!(btn instanceof AbstractButton) || ((AbstractButton)btn).getAction() instanceof OpenKDFAction || ((AbstractButton)btn).getAction() instanceof ExitAction) continue;
                ((AbstractButton)btn).setEnabled(false);
            }
        }

        private void swapForwardButtonState(boolean enable) {
            AbstractButton nextButton = (AbstractButton)this.buttonsOfType.get(GotoNextPageAction.class);
            AbstractButton lastButton = (AbstractButton)this.buttonsOfType.get(GotoLastPageAction.class);
            if (nextButton != null) {
                nextButton.setEnabled(enable);
                lastButton.setEnabled(enable);
            }
        }

        public void updateZoomButton(int state) {
            AbstractButton zoomIn = (AbstractButton)this.buttonsOfType.get(ZoomInAction.class);
            AbstractButton zoomOut = (AbstractButton)this.buttonsOfType.get(ZoomOutAction.class);
            if (state == -1) {
                zoomIn.setEnabled(true);
                zoomOut.setEnabled(false);
            } else if (state == 1) {
                zoomIn.setEnabled(false);
                zoomOut.setEnabled(true);
            } else {
                zoomIn.setEnabled(true);
                zoomOut.setEnabled(true);
            }
        }

        private void swapBackwardButtonState(boolean enable) {
            AbstractButton previousButton = (AbstractButton)this.buttonsOfType.get(GotoPreviousPageAction.class);
            AbstractButton firstButton = (AbstractButton)this.buttonsOfType.get(GotoFirstPageAction.class);
            if (previousButton != null) {
                previousButton.setEnabled(enable);
            }
            if (firstButton != null) {
                firstButton.setEnabled(enable);
            }
        }

        private void whenUpdating(UIStateChangedEvent event) {
            Object a2 = this.buttonsOfType.get(DoPrintAction.class);
            Object a3 = this.buttonsOfType.get(DoSetupPrintAction.class);
            Object a5 = this.buttonsOfType.get(StartMarginAdjustAction.class);
            Object a6 = this.buttonsOfType.get(ZoomInAction.class);
            Object a7 = this.buttonsOfType.get(ZoomOutAction.class);
            boolean enable = false;
            if (event.getContext().isDataIncomplete()) {
                enable = true;
                if (a2 != null) {
                    ((AbstractButton)a2).setEnabled(enable);
                }
                if (a3 != null) {
                    ((AbstractButton)a3).setEnabled(enable);
                }
                if (a5 != null) {
                    ((AbstractButton)a5).setEnabled(enable);
                }
                if (a6 != null) {
                    ((AbstractButton)a6).setEnabled(enable);
                }
                if (a7 != null) {
                    ((AbstractButton)a7).setEnabled(enable);
                }
                ((AbstractButton)this.buttonsOfType.get(GotoLastPageAction.class)).setEnabled(false);
                if (this.buttonsOfType.get(ViewMultiPageAction.class) != null) {
                    ((AbstractButton)this.buttonsOfType.get(ViewMultiPageAction.class)).setEnabled(false);
                }
            } else {
                this.swapForwardButtonState(event.getContext().isNextViewAvailable());
            }
        }

        private void whenReady(UIStateChangedEvent event) {
            Object a2 = this.buttonsOfType.get(DoPrintAction.class);
            Object a3 = this.buttonsOfType.get(DoSetupPrintAction.class);
            Object a5 = this.buttonsOfType.get(StartMarginAdjustAction.class);
            Object a6 = this.buttonsOfType.get(ZoomInAction.class);
            Object a7 = this.buttonsOfType.get(ZoomOutAction.class);
            boolean enable = true;
            if (a2 != null) {
                ((AbstractButton)a2).setEnabled(enable);
            }
            if (a3 != null) {
                ((AbstractButton)a3).setEnabled(enable);
            }
            if (a5 != null) {
                ((AbstractButton)a5).setEnabled(enable);
            }
            if (a6 != null) {
                ((AbstractButton)a6).setEnabled(enable);
            }
            if (a7 != null) {
                ((AbstractButton)a7).setEnabled(enable);
            }
            if (this.buttonsOfType.get(ViewMultiPageAction.class) != null) {
                ((AbstractButton)this.buttonsOfType.get(ViewMultiPageAction.class)).setEnabled(enable);
            }
            if (a5 != null && event.getState() == 4) {
                ((JToggleButton)a5).setSelected(false);
            }
            this.swapForwardButtonState(event.getContext().isNextViewAvailable());
            if (event.getContext().getCurrentPage() > 0) {
                this.swapBackwardButtonState(true);
            } else {
                this.swapBackwardButtonState(false);
            }
        }

        @Override
        public void uiStateChanged(UIStateChangedEvent event) {
            Object a5;
            if (event.getState() == 1) {
                this.whenUpdating(event);
            } else if (event.getState() == 0 || event.getState() == 4) {
                this.whenReady(event);
            } else if (event.getState() == 3 && (a5 = this.buttonsOfType.get(StartMarginAdjustAction.class)) != null) {
                ((JToggleButton)a5).setSelected(true);
            }
        }

        @Override
        public void updateView(UpdateViewEvent event) {
            this.swapForwardButtonState(event.getContext().isNextViewAvailable());
            this.swapBackwardButtonState(event.getContext().isPreviousViewAvailable());
        }

        public void detachActionOf(Class cls) {
            Action act = this.getActionOf(cls);
            ArrayList btns = this.getManagedButtons();
            for (int i = 0; i < btns.size(); ++i) {
                Container p;
                AbstractButton btn;
                if (!(btns.get(i) instanceof AbstractButton) || act != (btn = (AbstractButton)btns.get(i)).getAction() || (p = btn.getParent()) == null) continue;
                p.remove(btn);
                if (!(act instanceof StartMarginAdjustAction)) continue;
                ((JComponent)p).setPreferredSize(new Dimension((int)(p.getPreferredSize().getWidth() + 30.0), p.getHeight()));
                p.invalidate();
            }
        }

        public JToolBar detachDefaultToolbar() {
            if (this.defaultToolbar.getParent() != null) {
                this.defaultToolbar.getParent().remove((Component)this.defaultToolbar);
            }
            return this.defaultToolbar;
        }

        public JToolBar getDefaultToolbar() {
            return this.defaultToolbar;
        }
    }
}

