/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.read;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.NumberUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.kds.ICells;
import com.kingdee.cosmic.ctrl.kdf.kds.IMerges;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.RecordFormatException;

public class POIXlsReader {
    private static final Logger logger = LogUtil.getPackageLogger(POIXlsxReader.class);
    private static final int nonLeapDay = 61;
    private static final int utcOffsetDays = 25569;
    private static final long msInADay = 86400000L;
    private static Map colors = HSSFColor.getIndexHash();
    public static final String NULL_FORMULA = "ATTR(semiVolatile)";
    public static final String EXPORT_FORMULA = "EXPORT_FORMULA";
    public static final String IMPORT_FORMAT = "IMPORT_FORMAT";
    public static final String IMPORT_STYLE = "IMPORT_STYLE";
    public static final String KD_SINGLE_COMMA = "\\\\'";
    public static final String KD_DOUBLE_COMMA = "'";
    public static final String KD_EXCHANGE_COMMA = "KD_EXCHANGE_COMMA";
    public static final String KD_FORMULA_SPLIT = "_@_";
    static HashSet extendDateFormat = new HashSet();

    public static KDSBook parse(String xlsfileName) {
        KDSBook book = null;
        try {
            book = POIXlsReader.parse2(xlsfileName);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        catch (Exception e) {
            book = null;
        }
        return book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KDSBook parse2(String xlsfileName) throws IOException {
        KDSBook book = null;
        try (FileInputStream stream = null;){
            stream = new FileInputStream(FilenameUtils.normalize((String)xlsfileName));
            book = POIXlsReader.parse2(stream);
        }
        return book;
    }

    public static KDSBook parse(String xlsfileName, HashMap parameter) {
        KDSBook book = null;
        try {
            book = POIXlsReader.parse2(xlsfileName, parameter);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        return book;
    }

    public static KDSBook parse2(String xlsfileName, HashMap parameter) throws IOException {
        KDSBook book = null;
        try (FileInputStream stream = null;){
            stream = new FileInputStream(FilenameUtils.normalize((String)xlsfileName));
            book = POIXlsReader.parse2(stream, parameter);
        }
        return book;
    }

    public static KDSBook parse(InputStream stream) {
        KDSBook book = null;
        try {
            book = POIXlsReader.parse2(stream);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        catch (Exception e) {
            book = null;
        }
        return book;
    }

    public static KDSBook parse2(InputStream stream) throws Exception {
        KDSBook book = null;
        HSSFWorkbook wb = null;
        POIFSFileSystem fs = new POIFSFileSystem(stream);
        wb = new HSSFWorkbook(fs);
        book = new KDSBook("aa");
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            HSSFSheet sheet = wb.getSheetAt(k);
            KDSSheet kdssheet = new KDSSheet(book, wb.getSheetName(k));
            try {
                book.addSheet(null, kdssheet);
            }
            catch (Exception e1) {
                logger.error((Object)"err", (Throwable)e1);
            }
            int lastCol = -1;
            int rows = sheet.getLastRowNum();
            for (int r = 0; r <= rows; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) {
                    kdssheet.getRows().setRowHeight(r, (float)(StyleUtil.ptToLom((double)(sheet.getDefaultRowHeight() / 20)) / 10.0));
                    continue;
                }
                kdssheet.getRows().setRowHeight(r, (float)(StyleUtil.ptToLom((double)(row.getHeight() / 20)) / 10.0));
                int cols = row.getLastCellNum() + 1;
                for (int c = 0; c < cols; ++c) {
                    HSSFCell cell = row.getCell((int)((short)c));
                    if (cell == null) continue;
                    if (c > lastCol) {
                        lastCol = c;
                    }
                    short type = 0;
                    Object value = null;
                    String formula = null;
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            if (POIXlsReader.isValidExcelDate(wb, cell)) {
                                value = cell.getDateCellValue();
                                Date dateValue = (Date)value;
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(dateValue);
                                value = cal;
                                type = 6;
                                break;
                            }
                            value = POIXlsReader.double2String(cell.getNumericCellValue());
                            value = NumberUtil.cutZero((String)((String)value));
                            type = 0;
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            type = 1;
                            break;
                        }
                        case FORMULA: {
                            value = cell.getCachedFormulaResultType() == CellType.STRING ? cell.getStringCellValue() : "";
                            if (StringUtil.isEmptyString((String)((String)value))) {
                                value = CellType.ERROR == cell.getCachedFormulaResultType() ? "" : (CellType.NUMERIC == cell.getCachedFormulaResultType() ? POIXlsReader.double2String(cell.getNumericCellValue()) : "");
                            }
                            try {
                                formula = cell.getCellFormula();
                            }
                            catch (RecordFormatException rfe) {
                                value = POIXlsReader.double2String(cell.getNumericCellValue());
                                value = NumberUtil.cutZero((String)((String)value));
                                if (value.equals("NaN")) {
                                    value = cell.getRichStringCellValue().toString();
                                }
                                type = 1;
                                break;
                            }
                            String[] returnValue = POIXlsReader.convertFormula(formula);
                            if (returnValue[1].equals("1")) {
                                value = returnValue[2];
                            }
                            formula = returnValue[0];
                            type = 2;
                            break;
                        }
                        case BOOLEAN: {
                            value = String.valueOf(cell.getBooleanCellValue());
                            type = 4;
                            break;
                        }
                        case ERROR: {
                            value = String.valueOf(cell.getErrorCellValue());
                            type = 1;
                            break;
                        }
                        default: {
                            value = cell.getStringCellValue();
                            type = 1;
                        }
                    }
                    ICells kdscells = kdssheet.getCells();
                    HSSFCellStyle hssfcellstyle = cell.getCellStyle();
                    StyleAttributes kdsa = POIXlsReader.hssfstyle2kdStyleAttribute(wb, hssfcellstyle, true, true);
                    KDSCell kdsCll = !kdsa.isEmpty() ? kdscells.setCell(r, cell.getColumnIndex(), value, formula, Styles.getSSA((StyleAttributes)kdsa)) : kdscells.setCellValue(r, cell.getColumnIndex(), value);
                    kdsCll.setType(type);
                    if (formula != null) {
                        kdssheet.getCell(r, cell.getColumnIndex(), true).setFormula(formula);
                    }
                    if (null == cell.getHyperlink()) continue;
                    HyperLink hyperLink = new HyperLink();
                    if (cell.getHyperlink().getAddress().indexOf("#") != -1) {
                        hyperLink.setLinkTo(cell.getHyperlink().getAddress());
                    } else {
                        hyperLink.setLinkTo("#" + cell.getHyperlink().getAddress());
                    }
                    hyperLink.setText(cell.getHyperlink().getLabel());
                    kdsCll.setHyperLink(hyperLink);
                }
            }
            POIXlsReader.parseMergeCell(sheet, kdssheet);
            for (int i = 0; i <= lastCol; ++i) {
                int tempWidth = sheet.getColumnWidth(i);
                if (tempWidth == 8) {
                    tempWidth = 2340;
                }
                kdssheet.setColumnWidth(i, (float)((double)tempWidth / 140.0));
            }
        }
        return book;
    }

    private static String double2String(double value) {
        return NumberUtil.double2String((double)value);
    }

    public static KDSBook parse(InputStream stream, HashMap parameter) {
        KDSBook book = null;
        try {
            POIXlsReader.parse2(stream, parameter);
        }
        catch (FileNotFoundException e) {
            book = null;
        }
        catch (IOException e) {
            book = null;
        }
        return book;
    }

    public static KDSBook parse2(InputStream stream, HashMap parameter) throws IOException {
        String sImportFormula = (String)parameter.get(EXPORT_FORMULA);
        boolean importFormula = true;
        if (!StringUtil.isEmptyString((String)sImportFormula)) {
            importFormula = Boolean.parseBoolean(sImportFormula);
        }
        String sImportFormat = (String)parameter.get(IMPORT_FORMAT);
        boolean importFormat = true;
        if (!StringUtil.isEmptyString((String)sImportFormat)) {
            importFormat = Boolean.parseBoolean(sImportFormat);
        }
        String sImportStyle = (String)parameter.get(IMPORT_STYLE);
        boolean importStyle = true;
        if (!StringUtil.isEmptyString((String)sImportStyle)) {
            importStyle = Boolean.parseBoolean(sImportStyle);
        }
        KDSBook book = null;
        HSSFWorkbook wb = null;
        POIFSFileSystem fs = new POIFSFileSystem(stream);
        wb = new HSSFWorkbook(fs, false);
        book = new KDSBook("aa");
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            HSSFSheet sheet = wb.getSheetAt(k);
            KDSSheet kdssheet = new KDSSheet(book, wb.getSheetName(k));
            try {
                book.addSheet(null, kdssheet);
            }
            catch (Exception e1) {
                logger.error((Object)"err", (Throwable)e1);
            }
            int lastCol = 0;
            int rows = sheet.getLastRowNum();
            for (int r = 0; r <= rows; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) {
                    kdssheet.getRows().setRowHeight(r, (float)(StyleUtil.ptToLom((double)(sheet.getDefaultRowHeight() / 20)) / 10.0));
                    continue;
                }
                kdssheet.getRows().setRowHeight(r, (float)(StyleUtil.ptToLom((double)(row.getHeight() / 20)) / 10.0));
                int cols = row.getLastCellNum() + 1;
                if (cols > lastCol) {
                    lastCol = cols;
                }
                for (int c = 0; c < cols; ++c) {
                    HSSFCell cell = row.getCell((int)((short)c));
                    if (cell == null) {
                        if (c != cols - 1) continue;
                        lastCol = cols - 1;
                        continue;
                    }
                    Object value = null;
                    String formula = null;
                    switch (cell.getCellType()) {
                        case NUMERIC: {
                            if (POIXlsReader.isValidExcelDate(wb, cell)) {
                                value = cell.getDateCellValue();
                                Date dateValue = (Date)value;
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(dateValue);
                                value = cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5);
                                if (cal.get(12) == 0 && cal.get(11) == 0) break;
                                value = value + " " + cal.get(11) + ":" + cal.get(12);
                                break;
                            }
                            Double d = new Double(cell.getNumericCellValue());
                            value = new BigDecimal(d.toString()).toString();
                            value = NumberUtil.cutZero((String)((String)value));
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            break;
                        }
                        case FORMULA: {
                            value = Double.isNaN(cell.getNumericCellValue()) ? (cell.getCachedFormulaResultType() == CellType.STRING ? cell.getStringCellValue() : "") : (cell.getCachedFormulaResultType() == CellType.NUMERIC ? String.valueOf(cell.getNumericCellValue()) : "");
                            formula = cell.getCellFormula();
                            String[] returnValue = POIXlsReader.convertFormula(formula);
                            if (returnValue[1].equals("1")) {
                                value = returnValue[2];
                            }
                            formula = returnValue[0];
                            break;
                        }
                        case BOOLEAN: {
                            value = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        default: {
                            value = cell.getStringCellValue();
                        }
                    }
                    ICells kdscells = kdssheet.getCells();
                    HSSFCellStyle hssfcellstyle = cell.getCellStyle();
                    StyleAttributes kdsa = POIXlsReader.hssfstyle2kdStyleAttribute(wb, hssfcellstyle, importFormat, importStyle);
                    if (!kdsa.isEmpty()) {
                        if (formula != null && importFormula) {
                            kdscells.setCell(r, cell.getColumnIndex(), value, formula, Styles.getSSA((StyleAttributes)kdsa));
                            continue;
                        }
                        kdscells.setCell(r, cell.getColumnIndex(), value, "", Styles.getSSA((StyleAttributes)kdsa));
                        continue;
                    }
                    if (formula != null && importFormula) {
                        kdssheet.getCell(r, cell.getColumnIndex(), true).setFormula(formula);
                    }
                    kdscells.setCellValue(r, cell.getColumnIndex(), value);
                }
            }
            POIXlsReader.parseMergeCell(sheet, kdssheet);
            for (int i = 0; i < lastCol; ++i) {
                int tempWidth = sheet.getColumnWidth(i);
                if (tempWidth == 8) {
                    tempWidth = 2340;
                }
                kdssheet.setColumnWidth(i, (float)((double)tempWidth / 140.0));
            }
        }
        return book;
    }

    public static String[] convertFormula(String formula) {
        int pos;
        String tmpFormula = formula;
        String[] returnValue = new String[3];
        returnValue[1] = "0";
        String formulaValue = "";
        int temp = tmpFormula.indexOf(KD_FORMULA_SPLIT);
        if (temp != -1) {
            int beginIndex = 5;
            int endIndex = temp;
            int valueIndex = tmpFormula.lastIndexOf(44);
            formulaValue = tmpFormula.substring(0, valueIndex - 1);
            valueIndex = formulaValue.lastIndexOf(44) - 1;
            formula = tmpFormula.substring(beginIndex, endIndex);
            String sValue = tmpFormula.substring(endIndex + KD_FORMULA_SPLIT.length(), valueIndex);
            formula = POIXlsReader.convertFormulaSpecialString(formula);
            sValue = POIXlsReader.convertFormulaSpecialString(sValue);
            returnValue[1] = "1";
            returnValue[2] = sValue;
        }
        int iNullIndex = formula.indexOf(NULL_FORMULA);
        int iNullLen = NULL_FORMULA.length();
        while (iNullIndex != -1) {
            formula = formula.substring(0, iNullIndex) + formula.substring(iNullIndex + iNullLen);
            iNullIndex = formula.indexOf(NULL_FORMULA);
        }
        if (formula != null && (pos = formula.indexOf(33)) > 0) {
            String sheetName = formula.substring(0, pos);
            try {
                Double.parseDouble(sheetName);
                formula = KD_DOUBLE_COMMA + sheetName + KD_DOUBLE_COMMA + formula.substring(pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        returnValue[0] = formula;
        return returnValue;
    }

    public static String convertFormulaSpecialString(String formula) {
        formula = formula.replaceAll(KD_SINGLE_COMMA, KD_EXCHANGE_COMMA);
        formula = formula.replaceAll(KD_DOUBLE_COMMA, "\"");
        formula = formula.replaceAll(KD_EXCHANGE_COMMA, KD_DOUBLE_COMMA);
        return formula;
    }

    private static boolean isValidExcelDate(HSSFWorkbook wb, HSSFCell cell) {
        boolean isValid = false;
        isValid = DateUtil.isCellDateFormatted((Cell)cell);
        HSSFCellStyle style = cell.getCellStyle();
        short i = style.getDataFormat();
        HSSFDataFormat workFormat = wb.createDataFormat();
        String formatStr = workFormat.getFormat(i);
        if (!isValid && extendDateFormat.contains(formatStr)) {
            isValid = true;
        }
        return isValid;
    }

    static void parseMergeCell(HSSFSheet sheet, KDSSheet kdssheet) {
        int merges = sheet.getNumMergedRegions();
        IMerges kdsmerges = kdssheet.getMerges();
        for (int i = 0; i < merges; ++i) {
            CellRangeAddress mergeRegion = sheet.getMergedRegion(i);
            int row = mergeRegion.getFirstRow();
            int col = mergeRegion.getFirstColumn();
            kdsmerges.addMerge(row, col, mergeRegion.getLastRow(), mergeRegion.getLastColumn());
            HSSFCell cell = sheet.getRow(row).getCell(col);
            if (null == cell.getHyperlink()) continue;
            HyperLink hyper = new HyperLink();
            if (cell.getHyperlink().getAddress().indexOf("#") != -1) {
                hyper.setLinkTo(cell.getHyperlink().getAddress());
            } else {
                hyper.setLinkTo("#" + cell.getHyperlink().getAddress());
            }
            kdssheet.getCell(row, col, false).setHyperLink(hyper);
        }
    }

    static StyleAttributes hssfstyle2kdStyleAttribute(HSSFWorkbook wb, HSSFCellStyle hssfstyle, boolean importFormat, boolean importStyle) {
        StyleAttributes sa = Styles.getEmptySA();
        ShareStyleAttributes defaultssa = Styles.getDefaultSSA();
        if (importStyle) {
            HSSFFont hssffont = wb.getFontAt(hssfstyle.getFontIndex());
            POIXlsReader.font2SA(defaultssa, sa, hssffont);
            POIXlsReader.alignment2SA(defaultssa, sa, hssfstyle);
            POIXlsReader.protection2SA(defaultssa, sa, hssfstyle);
            POIXlsReader.borders2SA(defaultssa, sa, hssfstyle);
            POIXlsReader.interior2SA(defaultssa, sa, hssfstyle);
        }
        if (importFormat && hssfstyle.getDataFormat() != 0) {
            try {
                HSSFDataFormat dataFormat = wb.createDataFormat();
                String format = dataFormat.getFormat(hssfstyle.getDataFormat());
                if (!StringUtil.isEmptyString((String)format) && format.indexOf(40) == 0 && format.indexOf("_);") != -1) {
                    format = format.substring(1);
                }
                sa.setNumberFormat(format);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sa;
    }

    private static void font2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, HSSFFont hssffont) {
        String fontName = hssffont.getFontName();
        if (!defaultssa.getFontName().equals(fontName)) {
            sa.setFontName(fontName);
        }
        short fontSize = hssffont.getFontHeightInPoints();
        sa.setFontSize((int)fontSize);
        Color awtclr = POIXlsReader.getAWTColor(hssffont.getColor(), Color.black);
        if (!defaultssa.getFontColor().equals(awtclr)) {
            sa.setFontColor(awtclr);
        }
        boolean bvalue = hssffont.getBold();
        if (defaultssa.isBold() != bvalue) {
            sa.setBold(bvalue);
        }
        bvalue = hssffont.getItalic();
        if (defaultssa.isItalic() != bvalue) {
            sa.setItalic(bvalue);
        }
        bvalue = hssffont.getStrikeout();
        if (defaultssa.isStrikeThrough() != bvalue) {
            sa.setStrikeThrough(bvalue);
        }
        boolean bl = bvalue = hssffont.getUnderline() != 0;
        if (defaultssa.isUnderline() != bvalue) {
            sa.setUnderline(bvalue);
        }
    }

    private static void alignment2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, HSSFCellStyle hssfstyle) {
        Styles.VerticalAlignment valign;
        Styles.HorizontalAlignment align;
        switch (hssfstyle.getAlignment()) {
            case LEFT: {
                align = Styles.HorizontalAlignment.LEFT;
                break;
            }
            case RIGHT: {
                align = Styles.HorizontalAlignment.RIGHT;
                break;
            }
            case CENTER: {
                align = Styles.HorizontalAlignment.CENTER;
                break;
            }
            default: {
                align = null;
            }
        }
        if (align != null) {
            sa.setHorizontalAlign(align);
        }
        switch (hssfstyle.getVerticalAlignment()) {
            case TOP: {
                valign = Styles.VerticalAlignment.TOP;
                break;
            }
            case CENTER: {
                valign = Styles.VerticalAlignment.MIDDLE;
                break;
            }
            case BOTTOM: {
                valign = Styles.VerticalAlignment.BOTTOM;
                break;
            }
            default: {
                valign = Styles.VerticalAlignment.BOTTOM;
            }
        }
        if (defaultssa.getVerticalAlign() != valign) {
            sa.setVerticalAlign(valign);
        }
        boolean bwraptext = hssfstyle.getWrapText();
        if (defaultssa.isWrapText() != bwraptext) {
            sa.setWrapText(bwraptext);
        }
        short roration = hssfstyle.getRotation();
        if (defaultssa.getRotation() != roration) {
            sa.setRotation((int)roration);
        }
    }

    private static void borders2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, HSSFCellStyle hssfstyle) {
        Color awtbordercolor = POIXlsReader.getAWTColor(hssfstyle.getLeftBorderColor(), Color.black);
        if (!defaultssa.getBorderColor(Styles.Position.LEFT).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.LEFT, awtbordercolor);
        }
        awtbordercolor = POIXlsReader.getAWTColor(hssfstyle.getRightBorderColor(), Color.black);
        if (!defaultssa.getBorderColor(Styles.Position.RIGHT).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.RIGHT, awtbordercolor);
        }
        awtbordercolor = POIXlsReader.getAWTColor(hssfstyle.getTopBorderColor(), Color.black);
        if (!defaultssa.getBorderColor(Styles.Position.TOP).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.TOP, awtbordercolor);
        }
        awtbordercolor = POIXlsReader.getAWTColor(hssfstyle.getBottomBorderColor(), Color.black);
        if (!defaultssa.getBorderColor(Styles.Position.BOTTOM).equals(awtbordercolor)) {
            sa.setBorderColor(Styles.Position.BOTTOM, awtbordercolor);
        }
        POIXlsReader.borderstyle2sa(sa, Styles.Position.BOTTOM, hssfstyle.getBorderBottom());
        POIXlsReader.borderstyle2sa(sa, Styles.Position.LEFT, hssfstyle.getBorderLeft());
        POIXlsReader.borderstyle2sa(sa, Styles.Position.RIGHT, hssfstyle.getBorderRight());
        POIXlsReader.borderstyle2sa(sa, Styles.Position.TOP, hssfstyle.getBorderTop());
    }

    static void borderstyle2sa(StyleAttributes sa, Styles.Position pos, BorderStyle hssfborder) {
        switch (hssfborder) {
            case NONE: {
                sa.setBorderLineStyle(pos, LineStyle.NULL_LINE);
                break;
            }
            case THIN: {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
                break;
            }
            case DASH_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case DASH_DOT_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case DASHED: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case DOTTED: {
                sa.setBorderPenStyle(pos, PenStyle.PS_CONTINUOUS);
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                break;
            }
            case MEDIUM: {
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            case MEDIUM_DASHED: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DOT);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            case MEDIUM_DASH_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOTDOT);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            case MEDIUM_DASH_DOT_DOT: {
                sa.setBorderPenStyle(pos, PenStyle.PS_DASHDOT);
                sa.setBorderLineStyle(pos, LineStyle.DOUBLE_LINE_B);
                break;
            }
            default: {
                sa.setBorderLineStyle(pos, LineStyle.SINGLE_LINE);
                sa.setBorderPenStyle(pos, PenStyle.PS_SOLID);
            }
        }
    }

    private static void protection2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, HSSFCellStyle hssfstyle) {
        boolean bLock = hssfstyle.getLocked();
        if (defaultssa.isLocked() != bLock) {
            sa.setLocked(bLock);
        }
        boolean bhide = hssfstyle.getHidden();
        if (defaultssa.isHided() != bhide) {
            sa.setHided(bhide);
        }
    }

    private static void interior2SA(ShareStyleAttributes defaultssa, StyleAttributes sa, HSSFCellStyle hssfstyle) {
        FillPatternType backmode = hssfstyle.getFillPattern();
        Pattern pn = POIXlsReader.getkdpattern(backmode);
        if (pn != Pattern.None) {
            if (pn == Pattern.Solid) {
                Color awtcolor = POIXlsReader.getAWTColor(hssfstyle.getFillForegroundColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
            } else {
                Color awtcolor = POIXlsReader.getAWTColor(hssfstyle.getFillBackgroundColor());
                if (!defaultssa.getBackground().equals(awtcolor)) {
                    sa.setBackground(awtcolor);
                }
                awtcolor = POIXlsReader.getAWTColor(hssfstyle.getFillForegroundColor(), Color.white);
                if (!defaultssa.getPatternColor().equals(awtcolor)) {
                    sa.setPatternColor(awtcolor);
                }
            }
        }
        sa.setPattern(pn);
    }

    private static Pattern getkdpattern(FillPatternType backmode) {
        Pattern pn;
        switch (backmode.getCode()) {
            case 1: {
                pn = Pattern.Solid;
                break;
            }
            case 2: {
                pn = Pattern.Percent50;
                break;
            }
            case 3: {
                pn = Pattern.Percent25;
                break;
            }
            case 4: {
                pn = Pattern.Percent70;
                break;
            }
            case 5: {
                pn = Pattern.DarkHorizontal;
                break;
            }
            case 6: {
                pn = Pattern.DarkVertical;
                break;
            }
            case 7: {
                pn = Pattern.DarkDownwardDiagonal;
                break;
            }
            case 8: {
                pn = Pattern.DarkUpwardDiagonal;
                break;
            }
            case 9: {
                pn = Pattern.SmallCheckerBoard;
                break;
            }
            case 10: {
                pn = Pattern.Trellis;
                break;
            }
            case 11: {
                pn = Pattern.Percent60;
                break;
            }
            case 12: {
                pn = Pattern.LightVertical;
                break;
            }
            case 13: {
                pn = Pattern.LightDownwardDiagonal;
                break;
            }
            case 14: {
                pn = Pattern.LightUpwardDiagonal;
                break;
            }
            case 15: {
                pn = Pattern.SmallGrid;
                break;
            }
            case 16: {
                pn = Pattern.Percent30;
                break;
            }
            case 17: {
                pn = Pattern.Percent20;
                break;
            }
            case 18: {
                pn = Pattern.Percent10;
                break;
            }
            default: {
                pn = Pattern.None;
            }
        }
        return pn;
    }

    private static final Color getAWTColor(HSSFColor clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    private static final Color getAWTColor(int index, Color deflt) {
        HSSFColor clr = (HSSFColor)colors.get(index);
        if (clr == null) {
            return deflt;
        }
        return POIXlsReader.getAWTColor(clr);
    }

    private static final Color getAWTColor(int index) {
        HSSFColor clr = (HSSFColor)colors.get(index);
        if (clr == null) {
            return null;
        }
        return POIXlsReader.getAWTColor(clr);
    }

    public static Date getDate(double numValue) {
        if (numValue < 61.0) {
            numValue += 1.0;
        }
        int offsetDays = 25569;
        double utcDays = numValue - (double)offsetDays;
        long utcValue = Math.round(utcDays * 8.64E7);
        return new Date(utcValue);
    }

    public static int getColumnNumber(HSSFRow row) {
        int colNum = 0;
        short tempColNum = 0;
        if (row != null && row.getCell((int)(tempColNum = (short)((colNum = (int)row.getLastCellNum()) + 1))) != null) {
            ++colNum;
        }
        return colNum;
    }

    static {
        extendDateFormat.add(String.format("yyyy\"%s\"m\"%s\"d\"%s\";@", CtrlKDFMessages.getMLS("dateFormat1", "\u5e74"), CtrlKDFMessages.getMLS("dateFormat2", "\u6708"), CtrlKDFMessages.getMLS("dateFormat3", "\u65e5")));
        extendDateFormat.add(String.format("yyyy\"%s\";@", CtrlKDFMessages.getMLS("dateFormat1", "\u5e74")));
        extendDateFormat.add(String.format("m\"%s\"d\"%s\";@", CtrlKDFMessages.getMLS("dateFormat2", "\u6708"), CtrlKDFMessages.getMLS("dateFormat3", "\u65e5")));
        extendDateFormat.add("yyyy/m/d;@");
        extendDateFormat.add("[$-409]yyyy/m/d\\ h:mm\\ AM/PM;@");
        extendDateFormat.add("yyyy/m/d\\ h:mm;@");
        extendDateFormat.add("yy/m/d;@");
        extendDateFormat.add("m/d;@");
        extendDateFormat.add("m/d/yy;@");
        extendDateFormat.add("mm/dd/yy;@");
        extendDateFormat.add("[$-F400]h:mm:ss\\ AM/PM");
        extendDateFormat.add("h:mm;@");
        extendDateFormat.add("[$-409]h:mm\\ AM/PM;@");
        extendDateFormat.add("h:mm:ss;@");
        extendDateFormat.add(String.format("h\"%s\"m\"%s\";@", CtrlKDFMessages.getMLS("timeFormat1", "\u65f6"), CtrlKDFMessages.getMLS("timeFormat2", "\u5206")));
        extendDateFormat.add(String.format("h\"%s\"m\"%s\"s\"%s\";@", CtrlKDFMessages.getMLS("timeFormat1", "\u65f6"), CtrlKDFMessages.getMLS("timeFormat2", "\u5206"), CtrlKDFMessages.getMLS("timeFormat3", "\u79d2")));
        extendDateFormat.add(String.format("\"%s\"h\"%s\"m\"%s\";@", CtrlKDFMessages.getMLS("timeFormat4", "\u4e0a\u5348/\u4e0b\u5348"), CtrlKDFMessages.getMLS("timeFormat1", "\u65f6"), CtrlKDFMessages.getMLS("timeFormat2", "\u5206")));
        extendDateFormat.add(String.format("\"%s\"h\"%s\"m\"%s\"s\"%s\";@", CtrlKDFMessages.getMLS("timeFormat4", "\u4e0a\u5348/\u4e0b\u5348"), CtrlKDFMessages.getMLS("timeFormat1", "\u65f6"), CtrlKDFMessages.getMLS("timeFormat2", "\u5206"), CtrlKDFMessages.getMLS("timeFormat3", "\u79d2")));
        extendDateFormat.add(String.format("[DBNum1][$-804]h\"%s\"m\"%s\";@", CtrlKDFMessages.getMLS("timeFormat1", "\u65f6"), CtrlKDFMessages.getMLS("timeFormat2", "\u5206")));
        extendDateFormat.add(String.format("[DBNum1][$-804]\"%s\"h\"%s\"m\"%s\";@", CtrlKDFMessages.getMLS("timeFormat4", "\u4e0a\u5348/\u4e0b\u5348"), CtrlKDFMessages.getMLS("timeFormat1", "\u65f6"), CtrlKDFMessages.getMLS("timeFormat2", "\u5206")));
    }
}

