/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util;

import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;

public class POIUtil {
    public static final XmlOptions DEFAULT_XML_OPTIONS = new XmlOptions();

    public static XmlOptions createDefaultXmlOptions() {
        return new XmlOptions(DEFAULT_XML_OPTIONS);
    }

    public static byte[] getRgbWithTint(XSSFColor xssfColor) {
        CTColor ctColor = xssfColor.getCTColor();
        byte[] rgb = xssfColor.getCTColor().getRgb();
        if (rgb != null) {
            if (rgb.length == 4) {
                byte[] tmp = new byte[3];
                System.arraycopy(rgb, 1, tmp, 0, 3);
                rgb = tmp;
            }
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = POIUtil.applyTint(rgb[i] & 0xFF, ctColor.getTint());
            }
        }
        return rgb;
    }

    private static byte applyTint(int lum, double tint) {
        if (tint > 0.0) {
            return (byte)((double)lum * (1.0 - tint) + 255.0 - 255.0 * (1.0 - tint));
        }
        if (tint < 0.0) {
            return (byte)((double)lum * (1.0 + tint));
        }
        return (byte)lum;
    }

    public static Object parseAlignment(boolean horizontal, ShareStyleAttributes ssa) {
        if (horizontal) {
            Styles.HorizontalAlignment align = ssa.getHorizontalAlign();
            HorizontalAlignment horizontalAlignment = align == Styles.HorizontalAlignment.LEFT ? HorizontalAlignment.LEFT : (align == Styles.HorizontalAlignment.CENTER ? HorizontalAlignment.CENTER : (align == Styles.HorizontalAlignment.RIGHT ? HorizontalAlignment.RIGHT : HorizontalAlignment.GENERAL));
            return horizontalAlignment;
        }
        Styles.VerticalAlignment align = ssa.getVerticalAlign();
        VerticalAlignment verticalAlignment = align == Styles.VerticalAlignment.TOP ? VerticalAlignment.TOP : (align == Styles.VerticalAlignment.MIDDLE ? VerticalAlignment.CENTER : (align == Styles.VerticalAlignment.BOTTOM ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    static {
        DEFAULT_XML_OPTIONS.setSaveOuter();
        DEFAULT_XML_OPTIONS.setUseDefaultNamespace();
        DEFAULT_XML_OPTIONS.setSaveAggressiveNamespaces();
        DEFAULT_XML_OPTIONS.setCharacterEncoding("UTF-8");
    }
}

