/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.printout;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrint;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IPrintOut;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import org.apache.log4j.Logger;

public class BookOutter
implements IPrintOut {
    private static final Logger logger = LogUtil.getPackageLogger(BookOutter.class);
    private KDPrint printer;
    private PrintableBook printableBook;

    public BookOutter(KDSBook book) {
        this.printableBook = new PrintableBook(book);
    }

    public BookOutter(KDSBook book, KDPrint printer) {
        this(book);
        this.printer = printer;
    }

    @Override
    public void preview() {
        try {
            KDPrint kdprint = this.getPrint();
            kdprint.setPrintableObject(this.getPrintableBook());
            kdprint.preview(false);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    private KDPrint getPrint() throws Exception {
        if (this.printer == null) {
            this.printer = new KDPrint();
        }
        return this.printer;
    }

    @Override
    public void print() {
        try {
            KDPrint kdprint = this.getPrint();
            kdprint.setPrintableObject(this.getPrintableBook());
            kdprint.print();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    @Override
    public void print(int[][] pageIndexes) {
        try {
            KDPrint kdprint = this.getPrint();
            kdprint.setPrintableObject(this.getPrintableBook());
            kdprint.print();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    public PrintableBook getPrintableBook() {
        return this.printableBook;
    }
}

