/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.printout;

import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.cosmic.ctrl.kdf.kds.IColumns;
import com.kingdee.cosmic.ctrl.kdf.kds.IMerges;
import com.kingdee.cosmic.ctrl.kdf.kds.IRows;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.util.printout.AbstractPagination;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IndexedPage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public final class HoldMergePagination
extends AbstractPagination {
    public HoldMergePagination(KDSBook book, double pageWidth, double pageHeight) {
        super(book, pageWidth, pageHeight);
    }

    @Override
    public ArrayList getIndexedPages() {
        ArrayList alPages = new ArrayList();
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            alPages.addAll(this.sheetPagination(this.book.getSheets().getSheet(i), this.pageWidth, this.pageHeight));
        }
        return alPages;
    }

    public ArrayList sheetPagination(KDSSheet sheet, double pageWidth, double pageHeight) {
        ArrayList<IndexedPage> alPages = new ArrayList<IndexedPage>();
        int[] alColDiv = this.getColDiv(sheet, pageWidth);
        int[] alRowDiv = this.getRowDiv(sheet, pageHeight);
        for (int i = 0; i < alRowDiv.length - 1; ++i) {
            for (int j = 0; j < alColDiv.length - 1; ++j) {
                IndexedPage ip = new IndexedPage(sheet, alRowDiv[i], alRowDiv[i + 1], alColDiv[j], alColDiv[j + 1]);
                alPages.add(ip);
            }
        }
        return alPages;
    }

    private int[] getRowDiv(KDSSheet sheet, double pageHeight) {
        int expandedRow = sheet.getSheet().getExpandedRows();
        ArrayList layer = sheet.getEmbedhLayer();
        int s = layer.size();
        for (int i = 0; i < s; i += 2) {
            Rectangle bounds = (Rectangle)layer.get(i + 1);
            expandedRow = Math.max(expandedRow, bounds.width);
        }
        IRows rowsNow = sheet.getSheet().getRows();
        ArrayList<Integer> alRowDiv = new ArrayList<Integer>();
        alRowDiv.add(0);
        double fHeight = 0.0;
        int iLast = 0;
        for (int i = 0; i <= expandedRow; ++i) {
            if (!((fHeight += (double)rowsNow.getRowHeight(i)) >= pageHeight + 0.1)) continue;
            if (i == iLast) {
                ++i;
            }
            iLast = i = this.adjustEndRow(sheet, iLast, i);
            alRowDiv.add(i);
            fHeight = rowsNow.getRowHeight(i);
        }
        alRowDiv.add(expandedRow + 1);
        Object[] objs = alRowDiv.toArray();
        int[] indexes = new int[objs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)objs[i];
        }
        return indexes;
    }

    private int[] getColDiv(KDSSheet sheet, double pageWidth) {
        int expandedCol = sheet.getSheet().getExpandedColumns();
        ArrayList layer = sheet.getEmbedhLayer();
        int s = layer.size();
        for (int i = 0; i < s; i += 2) {
            Rectangle bounds = (Rectangle)layer.get(i + 1);
            expandedCol = Math.max(expandedCol, bounds.height);
        }
        IColumns colsNow = sheet.getSheet().getColumns();
        ArrayList<Integer> alColDiv = new ArrayList<Integer>();
        double fWidth = 0.0;
        alColDiv.add(0);
        int iLast = 0;
        for (int i = 0; i <= expandedCol; ++i) {
            if (!((fWidth += (double)colsNow.getColumnWidth(i)) >= pageWidth + 0.1)) continue;
            if (i == iLast) {
                ++i;
            }
            iLast = i = this.adjustEndCol(sheet, iLast, i);
            alColDiv.add(i);
            fWidth = colsNow.getColumnWidth(i);
        }
        alColDiv.add(expandedCol + 1);
        Object[] objs = alColDiv.toArray();
        int[] indexes = new int[objs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)objs[i];
        }
        return indexes;
    }

    private int adjustEndRow(KDSSheet sheet, int begin, int end) {
        ArrayList al = this.getRowCrossedMerges(sheet, end);
        if (al.size() == 0) {
            return end;
        }
        int minRowIndex = end;
        for (int i = 0; i < al.size(); ++i) {
            KDSMergeBlock block = (KDSMergeBlock)al.get(i);
            int mergeRow = this.mergeRowAdjusting(sheet, end, block);
            if (mergeRow <= begin || mergeRow >= minRowIndex) continue;
            minRowIndex = mergeRow;
        }
        if (minRowIndex < begin || minRowIndex > end) {
            throw new RuntimeException(CtrlKDFMessages.getMLS("algorithmBug", "\u7b97\u6cd5\u6709Bug"));
        }
        if (minRowIndex == end) {
            return minRowIndex;
        }
        return this.adjustEndRow(sheet, begin, minRowIndex);
    }

    private int adjustEndCol(KDSSheet sheet, int begin, int end) {
        ArrayList al = this.getColCrossedMerges(sheet, end);
        if (al.size() == 0) {
            return end;
        }
        int minColIndex = end;
        for (int i = 0; i < al.size(); ++i) {
            KDSMergeBlock block = (KDSMergeBlock)al.get(i);
            int mergeCol = this.mergeColAdjusting(sheet, end, block);
            if (mergeCol <= begin || mergeCol >= minColIndex) continue;
            minColIndex = mergeCol;
        }
        if (minColIndex < begin || minColIndex > end) {
            throw new RuntimeException(CtrlKDFMessages.getMLS("yourAlgorithmIsBug", "SB\u4f60\u7684\u7b97\u6cd5\u6709bug"));
        }
        if (minColIndex == end) {
            return minColIndex;
        }
        return this.adjustEndCol(sheet, begin, minColIndex);
    }

    private int mergeRowAdjusting(KDSSheet sheet, int end, KDSMergeBlock merge) {
        double height = this.getMergeHeight(sheet, merge);
        if (height <= this.pageHeight) {
            return merge.row;
        }
        if (this.getHeightOfRows(sheet, merge.row, end) >= height % this.pageHeight) {
            return end;
        }
        return merge.row;
    }

    private int mergeColAdjusting(KDSSheet sheet, int end, KDSMergeBlock merge) {
        double width = this.getMergeWidth(sheet, merge);
        if (width <= this.pageWidth) {
            return merge.col;
        }
        if (this.getWidthOfCols(sheet, merge.col, end) >= width % this.pageWidth) {
            return end;
        }
        return merge.col;
    }

    private double getWidthOfCols(KDSSheet sheet, int beginCol, int endCol) {
        double width = 0.0;
        for (int i = beginCol; i < endCol; ++i) {
            width += (double)sheet.getColumnWidth(i);
        }
        return width;
    }

    private double getHeightOfRows(KDSSheet sheet, int beginRow, int endRow) {
        double height = 0.0;
        for (int i = beginRow; i < endRow; ++i) {
            height += (double)sheet.getRowHeight(i);
        }
        return height;
    }

    private double getMergeWidth(KDSSheet sheet, KDSMergeBlock merge) {
        IColumns columns = sheet.getColumns();
        double width = 0.0;
        for (int i = merge.col; i < merge.col + merge.getWidth(); ++i) {
            width += (double)columns.getColumnWidth(i);
        }
        return width;
    }

    private double getMergeHeight(KDSSheet sheet, KDSMergeBlock merge) {
        IRows rows = sheet.getRows();
        double height = 0.0;
        for (int i = merge.row; i < merge.row + merge.getHeight(); ++i) {
            height += (double)rows.getRowHeight(i);
        }
        return height;
    }

    private ArrayList getRowCrossedMerges(KDSSheet sheet, int row) {
        ArrayList<KDSMergeBlock> al = new ArrayList<KDSMergeBlock>();
        IMerges merges = sheet.getMerges();
        Iterator itMerge = merges.iterator();
        while (itMerge.hasNext()) {
            KDSMergeBlock block = (KDSMergeBlock)itMerge.next();
            if (block.row >= row || block.getRow2() < row) continue;
            al.add(block);
        }
        return al;
    }

    private ArrayList getColCrossedMerges(KDSSheet sheet, int col) {
        ArrayList<KDSMergeBlock> al = new ArrayList<KDSMergeBlock>();
        IMerges merges = sheet.getMerges();
        Iterator itMerge = merges.iterator();
        while (itMerge.hasNext()) {
            KDSMergeBlock block = (KDSMergeBlock)itMerge.next();
            if (block.col >= col || block.getCol2() < col) continue;
            al.add(block);
        }
        return al;
    }

    @Override
    public ArrayList getPages(PrintPage printPage) {
        return null;
    }
}

