/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.cosmic.ctrl.swing.plaf.themes.DiamonBlueTheme;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class IndividualizedThemeStore {
    private static Logger logger = LogUtil.getLogger(IndividualizedThemeStore.class);
    private static String[] keys = new String[]{"ProgressBar_Look_firstShadowColor", "ProgressBar_Look_secondShadowColor", "ProgressBar_Look_thirdShadowColor", "ProgressBar_Look_fourthShadowColor", "ProgressBar_Look_fifthsShadowColor", "ProgressBar_Look_background", "StatusBar_Look_firstShadowColor", "StatusBar_Look_secondShadowColor", "StatusBar_Look_thirdShadowColor", "StatusBar_Look_fourthShadowColor", "StatusBar_Look_fifthsShadowColor", "MenuBar_Look_firstShadowColor", "MenuBar_Look_secondShadowColor", "MenuBar_Look_thirdShadowColor", "MenuBar_Look_fourthShadowColor", "MenuBar_Look_fifthsShadowColor", "Menu_Look_rollverBgBegin", "Menu_Look_rollverBgEnd", "Menu_Look_pressBgBegin", "Menu_Look_borderShadowColor", "Menu_Look_pressBgEnd", "EAS_searchBox_border_highlight1", "EAS_searchBox_border_shadow2", "ToolBar_Look_topColor", "ToolBar_Look_firstShadowColor", "ToolBar_Look_secondShadowColor", "ToolBar_Look_thirdShadowColor", "ToolBar_Look_fourthShadowColor", "ToolBar_Look_fifthsShadowColor", "ToolBar_Look_dotColor", "ToolBar_Look_shadowDotColor", "ToolBar_Look_separatorShadow", "ToolBar_Look_separatorDarkShadow", "EAS_statusBar_background", "EAS_infoPanel_content_background", "EAS_infoPanel_title_background", "EAS_infoPanel_border_color", "ProgressBar_Look_bordercolorlight", "ProgressBar_Look_bordercolordark", "ProgressBar_Look_backStartColor", "ProgressBar_Look_backEndColor", "ProgressBar_Look_cellsDarkShadowColor", "ProgressBar_Look_cellsShadowColor", "ProgressBar_Look_cellscolor", "ProgressBar_Look_border", "TabbedPane_Look_tab1HeadShadow1", "TabbedPane_Look_tab1HeadShadow2", "TabbedPane_Look_tab1HeadShadow3", "TabbedPane_Look_tab1HeadShadow4", "TabbedPane_Look_tab1HeadShadow5", "TabbedPane_Look_tab1ContainerBackground", "TabbedPane_Look_tab2Tabbackground", "TabbedPane_Look_tab2HeadShadow1", "TabbedPane_Look_tab2HeadShadow2", "TabbedPane_Look_tab2HeadShadow3", "TabbedPane_Look_tab2HeadShadow4", "TabbedPane_Look_tab2HeadShadow5", "TabbedPane_Look_tab2ContainerBackground", "TabbedPane_Look_tab2ContainerBorderColor", "WorkButton_Look_initShadowBegin", "WorkButton_Look_initShadowEnd", "WorkButton_Look_initBorderColor", "WorkButton_Look_mouseoverShadowBegin", "WorkButton_Look_mouseoverShadowEnd", "WorkButton_Look_mouseoverBorderColor", "WorkButton_Look_mousedownShadowBegin", "WorkButton_Look_mousedownShadowEnd", "WorkButton_Look_mousedownBorderColor", "WorkButton_Look_disableShadowBegin", "WorkButton_Look_disableShadowEnd", "WorkButton_Look_disableBorderColor", "WorkButton_Look_arrowColor", "WorkButton_Look_toolbarMouseoverShadowBegin", "WorkButton_Look_toolbarMouseoverShadowEnd", "WorkButton_Look_toolbarMouseoverBorderColor", "WorkButton_Look_toolbarMousedownShadowBegin", "WorkButton_Look_toolbarMousedownShadowEnd", "WorkButton_Look_toolbarInitShadowBegin", "WorkButton_Look_toolbarInitShadowEnd", "WorkButton_Look_toolbarMousedownBorderColor", "WorkButton_Look_rolloverBackground", "WorkButton_Look_activeBackground", "DatePickerDownList_Look_topColorA", "DatePickerDownList_Look_topColorB", "DatePickerDownList_Look_topColorC", "DatePickerDownList_Look_botColorA", "DatePickerDownList_Look_botColorB", "DatePickerDownList_Look_botColorC", "DatePickerDownList_Look_borderColor", "DatePickerDownList_Look_background", "TextField_Look_initBorderColor", "TextField_Look_readonlyBorderColor", "TextField_Look_focusBorderColor", "TextField_Look_disableBorderColor", "TextField_Look_disableBackground", "TextField_Look_requiredBorderColor", "GroupBorder_Look_highlight", "GroupBorder_Look_shadow", "Label_Look_underlineColor", "Tree_Look_background", "Tree_Look_textBackground", "KDTable_Look_headVergeColor1", "KDTable_Look_headVergeColor2", "KDTable_Look_headVergeColor3", "KDTable_Look_headBackground", "KDTable_Look_headVergeColor4", "KDTable_Look_headVergeColor5", "KDTable_Look_indexColBackground", "KDTable_Look_gridLineColor", "KDTable_Look_splitBarColor1", "KDTable_Look_splitBarColor2", "KDTable_Look_splitBarColor3", "KDTable_Look_splitBarColor4", "KDTable_Look_splitBarColor5", "KDTable_Look_selectionBackground", "KDTable_Look_background", "Separator_Look_background", "Separator_Look_foreground", "KDContainer_Look_outerTopColor", "KDContainer_Look_innerTopColor", "KDContainer_Look_background", "KDContainer_Look_labelBackColor", "KDContainer_Look_innerBottomColor", "KDContainer_Look_outerBottomColor", "KDContainer_Look_borderColor", "KDContainer_Look_contentBackground", "Calculator_Look_bgColor1", "Calculator_Look_bgColor8", "Calculator_Look_bgColor2", "Calculator_Look_bgColor4", "Calculator_Look_bgColor6", "Calculator_Look_bgColor7", "Calculator_Look_bgColor5", "Calculator_Look_bgColor3", "MenuItem_Look_background", "MenuItem_Look_disabledBackground", "MenuItem_Look_leftBgShadow", "MenuItem_Look_leftBgDarkShadow", "MenuItem_Look_separatorShadow", "MenuItem_Look_separatorDarkShadow", "MenuItem_Look_leftRollBgShadow", "MenuItem_Look_leftRollBgDarkShadow", "MenuItem_Look_separatorRollShadow", "MenuItem_Look_separatorRollDarkShadow", "MenuItem_Look_separatorDisableShadow", "MenuItem_Look_separatorDisableDarkShadow", "MenuItem_Look_leftDisableShadow", "MenuItem_Look_leftDisableDarkShadow", "MenuBar_Look_background", "PopupMenu_Look_borderLineColor", "Menu_Look_background", "MenuItem_Look_selectionBackground", "Menu_Look_selectionBackground", "Panel_Look_background", "Slider_Look_background"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryOn(int deltaHue, int deltaSaturation, int deltaBrightness) {
        Properties properties;
        String path = DiamonBlueTheme.getDiamonBlueThemeFilePath();
        InputStream is = null;
        try {
            properties = new Properties();
            File propFile = new File(FilenameUtils.normalize((String)path));
            is = propFile.exists() ? new FileInputStream(propFile) : IndividualizedThemeStore.class.getResourceAsStream(path);
            properties.load(is);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        float hueUnitSpeedUp = 0.0027777778f;
        for (int i = 0; i < keys.length; ++i) {
            float newHue;
            String value = properties.getProperty(keys[i]);
            Color oldColor = Color.decode(value);
            int intValue = Integer.decode(value);
            int alphaMask = 255;
            if (intValue > 0xFFFFFF || intValue < 0) {
                alphaMask = intValue & 0xFF000000;
            }
            float[] hsvValues = Color.RGBtoHSB(oldColor.getRed(), oldColor.getGreen(), oldColor.getBlue(), null);
            float temp = hsvValues[0];
            hsvValues[0] = newHue = temp + hueUnitSpeedUp * (float)deltaHue;
            temp = hsvValues[1];
            float newSaturation = temp + (deltaSaturation < 0 ? temp / 100.0f * (float)deltaSaturation : (1.0f - temp) / 100.0f * (float)deltaSaturation);
            if (newSaturation > 1.0f) {
                newSaturation = 1.0f;
            }
            if (newSaturation < 0.0f) {
                newSaturation = 0.0f;
            }
            hsvValues[1] = newSaturation;
            temp = hsvValues[2];
            float newBrightness = temp + (deltaBrightness < 0 ? temp / 100.0f * (float)deltaBrightness : (1.0f - temp) / 100.0f * (float)deltaBrightness);
            if (newBrightness > 1.0f) {
                newBrightness = 1.0f;
            }
            if (newBrightness < 0.0f) {
                newBrightness = 0.0f;
            }
            hsvValues[2] = newBrightness;
            int rgbValue = Color.HSBtoRGB(hsvValues[0], hsvValues[1], hsvValues[2]);
            if (alphaMask != 255) {
                rgbValue = rgbValue & 0xFFFFFF | alphaMask;
            }
            UIManager.getDefaults().put(keys[i].replaceAll("_Look_", ".").replaceAll("_", "."), new Color(rgbValue, true));
            properties.setProperty(keys[i], "#" + Integer.toHexString(rgbValue));
        }
        UIManager.getDefaults().put("ToolBar.shadowOrientationWhenHorizontal", (Object)1);
        UIManager.getDefaults().put("ToolBar.shadowOrientationWhenVertical", (Object)2);
        properties.setProperty("ToolBar_Look_shadowOrientationWhenHorizontal", "HORIZONTAL");
        properties.setProperty("ToolBar_Look_shadowOrientationWhenVertical", "VERTICAL");
        UIManager.getDefaults().put("MenuBar.shadowOrientation", (Object)2);
        properties.setProperty("MenuBar_Look_shadowOrientation", "VERTICAL");
        KingdeeLookAndFeel.getCurrentTheme().getThemeXMLHandler().setCurrentThemeProperties(properties);
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            Window[] windows = frames[i].getOwnedWindows();
            for (int j = 0; j < windows.length; ++j) {
                final Window w = windows[j];
                SwingUtilities.updateComponentTreeUI(w);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        w.validate();
                    }
                });
            }
            final Frame f = frames[i];
            SwingUtilities.updateComponentTreeUI(f);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    f.validate();
                }
            });
        }
    }

    public static void haveIt() {
        Properties p = KingdeeLookAndFeel.getCurrentTheme().getThemeXMLHandler().getCurrentThemeProperties();
        String path = System.getProperty("EAS_HOME") + "/client/deploy/client/individualizedtheme.properties";
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(new File(FilenameUtils.normalize((String)path))));
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                String value = o.toString() + "=" + p.get(o);
                ps.println(value);
            }
            ps.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

