/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.util.SwingLogUtil;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.plaf.FontUIResource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlafUtilies {
    private static final Logger logger = LogUtil.getPackageLogger(PlafUtilies.class);
    private static HashMap cacheColorHash = new HashMap();
    private static HashMap cacheFontHash = new HashMap();
    private static HashMap cacheDefaults = new HashMap();
    private static HashMap cacheImage = new HashMap();
    private static HashMap cacheIconResource = new HashMap();
    public static boolean isCacheIconResource = true;
    private static boolean DEBUG = false;
    private static SelfImageIO selfImage = new SelfImageIO();

    public static void putCacheIconResource(String key, String path) {
        if (isCacheIconResource) {
            cacheIconResource.put(key, path);
        }
    }

    public static String getCacheiconResource(String key) {
        return (String)cacheIconResource.get(key);
    }

    public static String getElementValue(Properties prop, String propName) {
        String sValue = (String)prop.get(propName = propName.replace(':', '_'));
        if (sValue == null) {
            sValue = "";
        }
        return sValue;
    }

    public static String getElementValue(Node rootNode, String elementsName) {
        String[] splitNames = elementsName.split(":");
        Node currentNode = rootNode;
        try {
            for (int loop = 0; loop < splitNames.length; ++loop) {
                currentNode = PlafUtilies.getSubNode(currentNode, splitNames[loop]);
            }
        }
        catch (Exception ex) {
            currentNode = null;
            logger.error((Object)"err", (Throwable)ex);
        }
        try {
            if (currentNode != null) {
                Node grandChild = currentNode.getFirstChild();
                if (grandChild != null && grandChild.getNodeValue() != null) {
                    return grandChild.getNodeValue();
                }
                return "";
            }
            PlafUtilies.logErrors("[Theme:" + elementsName + " is not found in the XML File");
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    static void clearLargeHeap() {
        if (cacheColorHash != null) {
            cacheColorHash.clear();
        }
        if (cacheFontHash != null) {
            cacheFontHash.clear();
        }
        if (cacheDefaults != null) {
            cacheDefaults.clear();
        }
        if (cacheImage != null) {
            cacheImage.clear();
        }
    }

    public static String getTagValue(Element root, String tagName) {
        NodeList list = root.getElementsByTagName(tagName);
        for (int loop = 0; loop < list.getLength(); ++loop) {
            Node child;
            Node node = list.item(loop);
            if (node == null || (child = node.getFirstChild()) == null || child.getNodeValue() == null) continue;
            return child.getNodeValue();
        }
        return "";
    }

    public static Color getCacheColor(String colorValue) {
        return (Color)cacheColorHash.get(colorValue);
    }

    public static void putCacheColor(String colorValue, Color c) {
        cacheColorHash.put(colorValue, c);
    }

    public static FontUIResource getCacheFont(String colorValue) {
        return (FontUIResource)cacheFontHash.get(colorValue);
    }

    public static void putCacheFont(String colorValue, FontUIResource c) {
        cacheFontHash.put(colorValue, c);
    }

    public static void putCacheNode(String nodeName, String nodeValue) {
        cacheDefaults.put(nodeName, nodeValue);
    }

    public static String getCacheNode(String nodeName) {
        return (String)cacheDefaults.get(nodeName);
    }

    public static ImageIcon getCurrentDirectoryImageIcon(String imagePath) {
        Object obj;
        if (imagePath == null) {
            return null;
        }
        WeakReference weakRef = (WeakReference)cacheImage.get(imagePath);
        if (weakRef != null && (obj = weakRef.get()) != null) {
            return (ImageIcon)obj;
        }
        URL url = selfImage.getClass().getResource(imagePath);
        if (url != null) {
            ImageIcon imgIcon = new ImageIcon(url);
            WeakReference<ImageIcon> weak = new WeakReference<ImageIcon>(imgIcon);
            cacheImage.put(imagePath, weak);
            return imgIcon;
        }
        System.out.println("************Image Init Error Dump Start*************");
        System.out.println("Image Path:\t" + imagePath);
        System.out.println("Base Path:\t" + selfImage.getClass().getName());
        System.out.println("ClassLoader:\t" + selfImage.getClass().getClassLoader());
        System.out.println("************Image Init Error Dump End***************");
        return null;
    }

    public static ImageIcon getRootImageIcon(String imagePath) {
        Object obj;
        if (imagePath == null) {
            return null;
        }
        WeakReference weakRef = (WeakReference)cacheImage.get(imagePath);
        if (weakRef != null && (obj = weakRef.get()) != null) {
            return (ImageIcon)obj;
        }
        URL url = selfImage.getClass().getClassLoader().getResource(imagePath);
        if (url != null) {
            ImageIcon imgIcon = new ImageIcon(url);
            WeakReference<ImageIcon> weak = new WeakReference<ImageIcon>(imgIcon);
            cacheImage.put(imagePath, weak);
            return imgIcon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element loadXMLFile(URL url) {
        if (url == null) {
            throw new NullPointerException("the specify XML File can't be null.");
        }
        BufferedInputStream in = null;
        InputStream resource = null;
        try {
            resource = url.openStream();
            in = new BufferedInputStream(resource);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element element = builder.parse(in).getDocumentElement();
            return element;
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
            Element element = null;
            return element;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (resource != null) {
                    resource.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
    }

    public static String getAttributeValue(Node node, String attrName) {
        if (node instanceof Element) {
            return ((Element)node).getAttribute(attrName);
        }
        return "";
    }

    public static String getNodeValue(Node parentNode, String elementsName) {
        String[] splitNames = elementsName.split(":");
        Node currentNode = parentNode;
        try {
            for (int loop = 0; loop < splitNames.length; ++loop) {
                currentNode = PlafUtilies.getSubNode(currentNode, splitNames[loop]);
            }
        }
        catch (Exception ex) {
            currentNode = null;
            logger.error((Object)"err", (Throwable)ex);
        }
        if (currentNode != null) {
            Node tempNode = currentNode.getFirstChild();
            if (tempNode != null && tempNode.getNodeValue() != null) {
                return tempNode.getNodeValue();
            }
            return "";
        }
        return "";
    }

    public static Node getSubNode(Node pNode, String name) {
        NodeList nodeList;
        if (pNode != null && name != null && (nodeList = pNode.getChildNodes()) != null && nodeList.getLength() > 0) {
            int j = nodeList.getLength();
            for (int i = 0; i < j; ++i) {
                Node node = nodeList.item(i);
                if (node == null || node.getNodeName() == null || !node.getNodeName().equals(name)) continue;
                return node;
            }
        }
        return null;
    }

    private static void logErrors(String errInfo) {
        if (DEBUG) {
            SwingLogUtil.error(errInfo);
        }
    }

    static class SelfImageIO {
        SelfImageIO() {
        }
    }
}

